<?php
/*
Plugin Name: Quick Comments
Version: 0.1.1
Plugin URI: http://wppluginsj.sourceforge.jp/quick-comments/
Description: Post comments quickly without leaving or refreshing the page.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 jQuery blockUI plugin (http://malsup.com/jquery/block/)
  Version 2.08 (06/11/2008)
  Copyright (c) 2007-2008 M. Alsup
  Dual licensed under the MIT and GPL licenses:
*/

class QuickCommentsController {
  var $plugin_name  = 'quick-comments';
  var $plugin_ver   = '0.1.1';
  var $plugin_js    = 'js/quick-comments.min.js';

  var $blockUI      = 'js/jquery.blockUI.min.js';
  var $blockUI_ver  = '2.08';

  var $plugin_directory, $plugin_filename;
  var $admin_option, $admin_action;
  var $options_default, $options;
  var $option_name, $textdomain_name;
  var $note, $error;

  /*
  * Constructor
  */
  function QuickCommentsController() {
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_directory = $filename[count($filename) - 2];
    $this->plugin_filename  = $filename[count($filename) - 1];

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = $this->plugin_filename;
    $this->admin_action    = get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option;

    $this->textdomain_name = $this->plugin_name;
    load_plugin_textdomain($this->textdomain_name, 'wp-content/plugins/'.$this->plugin_directory);

    $this->options_default = array(
                              'form'    => '#commentform'
                             ,'list'    => '#commentlist'
                             ,'message' => __('Please wait', $this->textdomain_name).'...'
                             ,'loader'  => $this->getAbsoluteUrl().'/images/ajax-loader.gif'
                             );
    $this->option_name     = $this->plugin_name." Options";
    $this->options         = $this->getOptions();
  }

  function getAbsoluteUrl() {
    return get_option('siteurl')."/wp-content/plugins/".$this->plugin_directory;
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function initOptions($wk_options = '') {
    if (!is_array($wk_options)) $wk_options = array();
    if (!isset($wk_options['form']))    $wk_options['form']    = $this->options_default['form'];
    if (!isset($wk_options['list']))    $wk_options['list']    = $this->options_default['list'];
    if (!isset($wk_options['message'])) $wk_options['message'] = $this->options_default['message'];
    if (!isset($wk_options['loader']))  $wk_options['loader']  = $this->options_default['loader'];
    return $wk_options;
  }

  function getOptions(){
    return $this->initOptions(get_option($this->option_name));
  }

  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  function deleteOptions() {
    delete_option($this->option_name);
  }

  // regist script
  function addScripts() {
    if (is_single()) {
      wp_enqueue_script('jquery');
      wp_enqueue_script('jquery.blockUI', $this->getAbsoluteUrl().'/'.$this->blockUI, array('jquery'), $this->blockUI_ver);
    }
  }

  function addHead() {
    if (is_single()) {
      $out  = "<script type=\"text/javascript\">/*<![CDATA[ */\n";
      $out .= "var quickCommentsL10n = {";
      $out .= " form:\"".$this->options['form']."\"";
      $out .= ",list:\"".$this->options['list']."\"";
      $out .= ",message:\"".$this->options['message']."\"";
      $out .= ",loader:\"".$this->options['loader']."\"";
      $out .= "};\n";
      $out .= "/* ]]>*/</script>\n";
      echo $out;
    }
  }

  function addFooter() {
    if (is_single()) {
      $out  = "<script type=\"text/javascript\" src=\"".$this->getAbsoluteUrl().'/'.$this->plugin_js."\"></script>\n";
      echo $out;
    }
  }

  function addAdminMenu() {
    add_options_page( __('Quick Comments', $this->textdomain_name)
                     ,__('Quick Comments', $this->textdomain_name)
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    if(isset($_POST['ap_options_update'])) {
      // check referer
      check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['form']    = $_POST['ap_form'];
      $this->options['list']    = $_POST['ap_list'];
      $this->options['message'] = $_POST['ap_message'];
      $this->options['loader']  = $_POST['ap_loader'];
      $_POST = '';

      // options update
      $this->updateOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      // check referer
      check_admin_referer("delete_options", "_wpnonce_delete_options");

      // options delete
      $this->deleteOptions();
      $this->options = $this->initOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Quick Comments Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

    // Form
    $out .= "<tr>";
    $out .= "<td><strong>".__('Comment Form CSS Path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_form\" id=\"ap_form\" size=\"50\" value=\"".$this->options['form']."\" /></td>";
    $out .= "</tr>\n";

    // List
    $out .= "<tr>";
    $out .= "<td><strong>".__('Comment List CSS Path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_list\" id=\"ap_list\" size=\"50\" value=\"".$this->options['list']."\" /></td>";
    $out .= "</tr>\n";

    // Wait Message
    $out .= "<tr>";
    $out .= "<td><strong>".__('Wait Message', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_message\" id=\"ap_message\" size=\"50\" value=\"".$this->options['message']."\" /></td>";
    $out .= "</tr>\n";

    // Loading Image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Loading Image', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_loader\" id=\"ap_loader\" size=\"50\" value=\"".$this->options['loader']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "</tbody></table>";

    // Add Update Button
    $out .= "<p style=\"margin-top:1em\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
    $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

}//class

$QuickComments = new QuickCommentsController();

add_action('admin_menu', array(&$QuickComments,'addAdminMenu'));

add_action('wp_print_scripts', array(&$QuickComments,'addScripts'));
add_action('wp_head', array(&$QuickComments,'addHead'));
add_action('wp_footer', array(&$QuickComments,'addFooter'));

unset($QuickComments);
?>