<?php
/*
Plugin Name: WMD Editor
Plugin URI: http://wppluginsj.sourceforge.jp/wmd-editor/
Description: Adds the <a href="http://wmd-editor.com/">WMD Editor</a> to the comment field, to make life easier for your commenters.
Version: 1.0
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

This is a simple plugin that just adds the javascript call to your template.
You can gather more info on this project at http://code.google.com/p/wmd/

Includes:
 This plugin includes WMD Editor
 http://wmd-editor.com/
 The MIT License
 http://www.opensource.org/licenses/mit-license.php
 Copyright(c) 2007-2008 Attacklab
*/

class WMDEditorController {
  var $plugin_name   = 'wmd-editor';

  var $options_default = array(
        'buttons'    => 'bold italic | link blockquote code img | ol ul h1 hr'
      );

  var $plugin_js     = 'wmd/wmd.js';
  var $plugin_js_ver = '1.0.1';

  var $plugin_directory, $plugin_filename;
  var $admin_option,$admin_action;
  var $options,$option_name;
  var $textdomain_name;
  var $note,$error;

  /*
  * Constructor
  */
  function WMDEditorController() {
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_directory = $filename[count($filename) - 2];
    $this->plugin_filename  = $filename[count($filename) - 1];

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = basename(__FILE__);
    $this->admin_action    = get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option;

    $this->option_name     = $this->plugin_name." Options";
    $this->options         = $this->getOptions();

    $this->textdomain_name = $this->plugin_name;
    load_plugin_textdomain($this->textdomain_name, 'wp-content/plugins/'.$this->plugin_directory.'/language');
  }

  function getAbsoluteUrl() {
    return get_option('siteurl')."/wp-content/plugins/".$this->plugin_directory;
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function initOptions($wk_options = '') {
    if (!is_array($wk_options)) $wk_options = array();
    if (!isset($wk_options['buttons'])) $wk_options['buttons'] = $this->options_default['buttons'];
    return $wk_options;
  }

  function getOptions(){
    return $this->initOptions(get_option($this->option_name));
  }

  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  function deleteOptions() {
    delete_option($this->option_name);
  }

  function isDisplay() {
    return (is_single() && comments_open());
  }

  function addHead() {
    if ($this->isDisplay()) {
      $out  = "<script type=\"text/javascript\">/* <![CDATA[ */\n";
      $out .= str_replace("<" ,"<'+'"
               ,"var wmdL10n = {"
               ."wmdLink:{"
               ." href:'http://www.wmd-editor.com/'"
               .",title:'".__("WMD: The Wysiwym Markdown Editor", $this->textdomain_name)."'"
               ."}"
               .",description:{"
               ." bold:'".__("Strong <strong>", $this->textdomain_name)."'"
               .",italic:'".__("Emphasis <em>", $this->textdomain_name)."'"
               .",link:'".__("Hyperlink <a>", $this->textdomain_name)."'"
               .",undo:'".__("Undo", $this->textdomain_name)."'"
               .",redo:'".__("Redo", $this->textdomain_name)."'"
               .",blockquote:'".__("Blockquote <blockquote>", $this->textdomain_name)."'"
               .",code:'".__("Code Sample <pre><code>", $this->textdomain_name)."'"
               .",img:'".__("Image <img>", $this->textdomain_name)."'"
               .",ol:'".__("Numbered List <ol>", $this->textdomain_name)."'"
               .",ul:'".__("Bulleted List <ul>", $this->textdomain_name)."'"
               .",h1:'".__("Heading <h1>/<h2>", $this->textdomain_name)."'"
               .",hr:'".__("Horizontal Rule <hr>", $this->textdomain_name)."'"
               ."}"
               .",prompt:{"
               ." img:'".__("<b>Enter the image URL.</b></p><p>You can also add a title, which will be displayed as a tool tip.</p><p>Example:<br />http://wmd-editor.com/images/cloud1.jpg   \"Optional title\"", $this->textdomain_name)."'"
               .",link:'".__("<b>Enter the web address.</b></p><p>You can also add a title, which will be displayed as a tool tip.</p><p>Example:<br />http://wmd-editor.com/   \"Optional title\"", $this->textdomain_name)."'"
               ."}"
               .",selection:{"
               ." alt:'".__("alt text", $this->textdomain_name)."'"
               .",link:'".__("link text", $this->textdomain_name)."'"
               ."}"
               ."};\n");
      $out .= "var wmd_options = {buttons: '{$this->options['buttons']}'};\n";
      $out .= "/* ]]> */</script>\n";
      echo $out;
    }
  }

  function addFooter() {
    if ($this->isDisplay()) {
     $out  = "<script type=\"text/javascript\" src=\"".$this->getAbsoluteUrl().'/'.$this->plugin_js."\" charset=\"UTF-8\"></script>\n";
     echo $out;
    }
  }

  function addAdminMenu() {
    add_options_page( __('WMD Editor', $this->textdomain_name)
                     ,__('WMD Editor', $this->textdomain_name)
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    if(isset($_POST['ap_options_update'])) {
      // check referer
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['buttons']        = $_POST['ap_buttons'];
      $_POST = '';

      // options update
      $this->updateOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      // check referer
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // options delete
      $this->deleteOptions();
      $this->options = $this->initOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('WMD Editor Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

    // Buttons
    $out .= "<tr>";
    $out .= "<td style=\"width:60px;\"><strong>".__('Buttons', $this->textdomain_name)."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_buttons\" id=\"ap_buttons\" size=\"100\" value=\"".$this->options['buttons']."\" /><br />";
    $out .= "</td>";
    $out .= "</tr>\n";
    $out .= "</tbody></table>";


    $out .= "<table style=\"border:none;margin-top:1em;margin-left:10em;\"><tbody>";
    $out .= "<tr><th style=\"text-align:left;\">bold</th><td>".htmlspecialchars(__("Strong &lt;strong&gt;", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">italic</th><td>".htmlspecialchars(__("Emphasis <em>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">link</th><td>".htmlspecialchars(__("Hyperlink <a>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">blockquote</th><td>".htmlspecialchars(__("Blockquote <blockquote>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">code</th><td>".htmlspecialchars(__("Code Sample <pre><code>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">img</th><td>".htmlspecialchars(__("Image <img>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">ol</th><td>".htmlspecialchars(__("Numbered List <ol>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">ul</th><td>".htmlspecialchars(__("Bulleted List <ul>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">h1</th><td>".htmlspecialchars(__("Heading <h1>/<h2>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">hr</th><td>".htmlspecialchars(__("Horizontal Rule <hr>", $this->textdomain_name))."</td></tr>";
    $out .= "<tr><th style=\"text-align:left;\">|</th><td>".__("Delimiter", $this->textdomain_name)."</td></tr>";
    $out .= "</tbody></table>";

    // Add Update Button
    $out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

}//class

$WMDEditor = new WMDEditorController();

add_action('admin_menu', array(&$WMDEditor,'addAdminMenu'));
add_action('wp_head', array(&$WMDEditor,'addHead'));
add_action('wp_footer', array(&$WMDEditor,'addFooter'));

unset($WMDEditor);
?>