//************************************************************************************************************
// 共通処理
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// スクリプト初期処理
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_script_init() {
// 親変数複写
	insertyahoomap_url = window.opener.insertyahoomap_url;
	insertyahoomap_emojiurl = window.opener.insertyahoomap_emojiurl;
	insertyahoomap_appid = window.opener.insertyahoomap_appid;
	insertyahoomap_select_map_width = window.opener.insertyahoomap_select_map_width;
	insertyahoomap_select_map_height = window.opener.insertyahoomap_select_map_height;
	insertyahoomap_map_datum = window.opener.insertyahoomap_map_datum;
	insertyahoomap_map_pos = window.opener.insertyahoomap_map_pos;
	insertyahoomap_map_layer = window.opener.insertyahoomap_map_layer;
	insertyahoomap_map_width = window.opener.insertyahoomap_map_width;
	insertyahoomap_map_height = window.opener.insertyahoomap_map_height;
	insertyahoomap_default_category = window.opener.insertyahoomap_default_category;
	insertyahoomap_polyline_poss = window.opener.insertyahoomap_polyline_poss;
	insertyahoomap_polyline_id = window.opener.insertyahoomap_polyline_id;
	insertyahoomap_polygon_poss = window.opener.insertyahoomap_polygon_poss;
	insertyahoomap_polygon_id = window.opener.insertyahoomap_polygon_id;
	insertyahoomap_ymap = window.opener.insertyahoomap_ymap;
	insertyahoomap_categorys = window.opener.insertyahoomap_categorys;
	insertyahoomap_icons = window.opener.insertyahoomap_icons;
// 親スタイルシート複写
	var parentLink = window.opener.document.getElementsByTagName("link");
	for (var i = 0; i < parentLink.length; i++) {
		if (parentLink[i].href) {
			var link = document.createElement("link");
			link.setAttribute("rel","stylesheet");
			link.setAttribute("href",parentLink[i].href);
			link.setAttribute("type","text/css");
			document.getElementsByTagName("head")[0].appendChild(link);
		}
	}
// スタイルシート設定
	var link = document.createElement("link");
	link.setAttribute("rel","stylesheet");
	if (navigator.userAgent.indexOf("Firefox") != -1) {
		link.setAttribute("href",insertyahoomap_url + "css/insertyahoomapFirefox.css");
	} else if(navigator.userAgent.indexOf("MSIE") != -1) {
		link.setAttribute("href",insertyahoomap_url + "css/insertyahoomapMSIE.css");
	} else if(navigator.userAgent.indexOf("Opera") != -1){
		link.setAttribute("href",insertyahoomap_url + "css/insertyahoomapOpera.css");
	} else if(navigator.userAgent.indexOf("Safari") != -1){
		link.setAttribute("href",insertyahoomap_url + "css/insertyahoomapSafari.css");
	} else {
		link.setAttribute("href",insertyahoomap_url + "css/insertyahoomapOther.css");
	}
	link.setAttribute("type","text/css");
	document.getElementsByTagName("head")[0].appendChild(link);
}
//------------------------------------------------------------------------------------------------------------
// イベント設定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_observeEvent(element, name, observer) {
	if (element.addEventListener) {
		element.addEventListener(name, observer, false);
	} else if (element.attachEvent) {
		element.attachEvent("on" + name, observer);
	}
}
//------------------------------------------------------------------------------------------------------------
// 数字チェック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_isnumber(val) {
	return String(val).match(/\d+/) == String(val);
}
//------------------------------------------------------------------------------------------------------------
// 数字チェック（少数以下含む）
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_isnumeric(val) {
	return String(val).match(/^\d+(?:|\.\d+)$/) == String(val);
}
//------------------------------------------------------------------------------------------------------------
// 数字チェック（負数含む）
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_isnumberinnegative(val) {
	return String(val).match(/^[-]?\d+/) == String(val);
}
//------------------------------------------------------------------------------------------------------------
// エレメント取得
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_getelement(type,id) {
	var getelement = new Array();
	var elements = document.getElementsByTagName(type);
	for (var i=0;i<elements.length;i++) {
		if (elements[i].id.match(RegExp(id))) {
			getelement.push(elements[i]);
		}
	}
	return getelement;
}
//------------------------------------------------------------------------------------------------------------
// イベントターゲットエレメント取得
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_event_target(change_event) {
	if (change_event.target) {
		return change_event.target;
	} else {
		return change_event.srcElement;
	}
}
//************************************************************************************************************
// オプション初期カテゴリ処理
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// デフォルトカテゴリ設定開始
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_default_category_onload() {
// カテゴリー復元
	insertyahoomap_default_category_load("options",window.opener.document.getElementById("insertyahoomap_default_category").value);
}
//------------------------------------------------------------------------------------------------------------
// デフォルトカテゴリ決定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_default_category_enter() {
	var categorydata = '';
// カテゴリー
	var eleCategorys = insertyahoomap_getelement("input","^insertyahoomapcategoryid");
	for (var i=0;i<eleCategorys.length;i++) {
		if (categorydata) {
			categorydata += ',';
		}
// カテゴリＩＤ
		categorydata += escape(eleCategorys[i].value);
// カテゴリ画像
		var idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryimg");
		categorydata += ',' + escape(document.getElementById(idvalue).value);
// 画像スタイル幅
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamwidth");
		categorydata += ',' + escape(document.getElementById(idvalue).value);
// 画像スタイル高さ
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamheight");
		categorydata += ',' + escape(document.getElementById(idvalue).value);
// 画像スタイル基準横
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdx");
		categorydata += ',' + escape(document.getElementById(idvalue).value);
// 画像スタイル基準縦
		idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdy");
		categorydata += ',' + escape(document.getElementById(idvalue).value);
	}
	window.opener.document.getElementById("insertyahoomap_default_category").value = categorydata;
	insertyahoomap_default_category_close();
}
//------------------------------------------------------------------------------------------------------------
// デフォルトカテゴリ取消
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_default_category_cancel() {
	insertyahoomap_default_category_close();
}
//------------------------------------------------------------------------------------------------------------
// デフォルトカテゴリ設定終了
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_default_category_close() {
	window.close();
}
//************************************************************************************************************
// 地図作成
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// 地図作成開始
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_onload() {
// 初期データ設定
	document.getElementById("map").style.width = insertyahoomap_select_map_width;
	document.getElementById("map").style.height = insertyahoomap_select_map_height;
	document.getElementById("i_map_width").value = insertyahoomap_map_width;
	document.getElementById("i_map_height").value = insertyahoomap_map_height;
// 地図作成
	insertyahoomap_mapMake();
// 地図緯度経度表示
	insertyahoomap_mapDspPos();
// カテゴリー復元
	insertyahoomap_default_category_load("",insertyahoomap_default_category);
}
//------------------------------------------------------------------------------------------------------------
// 地図作成
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapMake() {
	if (insertyahoomap_map_datum == "YDatumType.WGS84") {
		ymap = new YahooMapsCtrl("map",insertyahoomap_map_pos,insertyahoomap_map_layer,YMapMode.MAP,YDatumType.WGS84);
	} else {
		ymap = new YahooMapsCtrl("map",insertyahoomap_map_pos,insertyahoomap_map_layer,YMapMode.MAP,YDatumType.TOKYO97);
	}
	ymap.setVisibleCentermarkButton(true);
	ymap.addEvent(YEventType.MAP_CLICK,insertyahoomap_mapclick);
	ymap.addEvent(YEventType.MAP_MOVING,insertyahoomap_mapDspPos);
	ymap.addEvent(YEventType.MAP_MOVED,insertyahoomap_mapDspPos);
}
//------------------------------------------------------------------------------------------------------------
// 地図緯度経度表示
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapDspPos() {
	document.getElementById("i_map_dsp_lat").value = ymap.getCenter().lat;
	document.getElementById("i_map_dsp_lon").value = ymap.getCenter().lon;
}
//------------------------------------------------------------------------------------------------------------
// デフォルトカテゴリ復元
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_default_category_load(calltype,categorydatas) {
	var categorydata = categorydatas.split(",");
	if (categorydata.length > 1
	||  categorydata[0]) {
		var j = 0;
		var id = 0;
		for (var i=0;i<categorydata.length;i++) {
			if (j == 0) {
				id = insertyahoomap_category_insert(calltype);
			}
			j++;
			switch (j) {
				case 1:
					document.getElementById("insertyahoomapcategoryid" + id).value = unescape(categorydata[i]);
					break;
				case 2:
					document.getElementById("insertyahoomapcategoryimg" + id).value = unescape(categorydata[i]);
					var link = new Array();
					link['imageurl'] = unescape(categorydata[i]);
					link['inputelement'] = document.getElementById("insertyahoomapcategoryimg" + id);
					insertyahoomap_category_img_change(link);
					break;
				case 3:
					document.getElementById("insertyahoomapcategoryparamwidth" + id).value = unescape(categorydata[i]);
					break;
				case 4:
					document.getElementById("insertyahoomapcategoryparamheight" + id).value = unescape(categorydata[i]);
					break;
				case 5:
					document.getElementById("insertyahoomapcategoryparamdx" + id).value = unescape(categorydata[i]);
					break;
				case 6:
					document.getElementById("insertyahoomapcategoryparamdy" + id).value = unescape(categorydata[i]);
					j = 0;
					break;
			}
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図クリック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapclick(pos) {
	if (focuselement.id == 'i_map_pos_lat'
	||  focuselement.id == 'i_map_pos_lon') {
		insertyahoomap_mapGetPos('i_map_pos',pos);
	}
	if (focuselement.id == 'i_map_home_lat'
	||  focuselement.id == 'i_map_home_lon') {
		insertyahoomap_mapGetPos('i_map_home',pos);
	}
	if (focuselement.id.match(/^insertyahoomapiconposlat/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomapiconposlat","insertyahoomapiconpos"),pos);
	}
	if (focuselement.id.match(/^insertyahoomapiconposlon/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomapiconposlon","insertyahoomapiconpos"),pos);
	}
	if (focuselement.id.match(/^insertyahoomappolylineposlat/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomappolylineposlat","insertyahoomappolylinepos"),pos);
	}
	if (focuselement.id.match(/^insertyahoomappolylineposlon/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomappolylineposlon","insertyahoomappolylinepos"),pos);
	}
	if (focuselement.id.match(/^insertyahoomappolygonposlat/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomappolygonposlat","insertyahoomappolygonpos"),pos);
	}
	if (focuselement.id.match(/^insertyahoomappolygonposlon/)) {
		insertyahoomap_mapGetPos(focuselement.id.replace("insertyahoomappolygonposlon","insertyahoomappolygonpos"),pos);
	}
}
//------------------------------------------------------------------------------------------------------------
// タイトルバー
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_titlebar(bartype) {
	if (document.getElementById("info" + bartype).innerHTML == "非表示") {
		document.getElementById("info" + bartype).innerHTML = "表示";
		document.getElementById(bartype).style.display = "none";
	} else {
		document.getElementById("info" + bartype).innerHTML = "非表示";
		document.getElementById(bartype).style.display = "block";
	}
}
//------------------------------------------------------------------------------------------------------------
// 選択枠処理
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapSelectBox(style) {
	if (parseInt(insertyahoomap_select_map_width) < parseInt(document.getElementById("i_map_width").value)) {
		document.getElementById("i_map_width").value = insertyahoomap_select_map_width;
	}
	if (parseInt(insertyahoomap_select_map_height) < parseInt(document.getElementById("i_map_height").value)) {
		document.getElementById("i_map_height").value = insertyahoomap_select_map_height;
	}
	var insertyahoomapselectdiv_left = document.getElementById("insertyahoomapdiv").offsetLeft + document.getElementById("map").offsetLeft
		+ Math.floor((insertyahoomap_select_map_width - parseInt(document.getElementById("i_map_width").value)) / 2);
	var insertyahoomapselectdiv_top = document.getElementById("insertyahoomapdiv").offsetTop + document.getElementById("map").offsetTop
		+ Math.floor((insertyahoomap_select_map_height - parseInt(document.getElementById("i_map_height").value)) / 2);
	document.getElementById("insertyahoomapselectdiv").style.left = insertyahoomapselectdiv_left;
	document.getElementById("insertyahoomapselectdiv").style.top = insertyahoomapselectdiv_top;
	document.getElementById("insertyahoomapselectdiv").style.width = document.getElementById("i_map_width").value + "px";
	document.getElementById("insertyahoomapselectdiv").style.height = document.getElementById("i_map_height").value + "px";
	if (style == "box") {
		if (document.getElementById("selectbox").innerHTML == "表示") {
			document.getElementById("selectbox").innerHTML = "非表示";
			document.getElementById("insertyahoomapselectdiv").style.display = "block";
		} else {
			document.getElementById("selectbox").innerHTML = "表示";
			document.getElementById("insertyahoomapselectdiv").style.display = "none";
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図表示緯度経度取得
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapGetPos(id,pos) {
	if (id == 'i_map_pos') {
		document.getElementById("i_map_pos_lat").value = pos.lat;
		document.getElementById("i_map_pos_lon").value = pos.lon;
	}
	if (id == 'i_map_home') {
		document.getElementById("i_map_home_lat").value = pos.lat;
		document.getElementById("i_map_home_lon").value = pos.lon;
	}
	if (id.match(/^insertyahoomapiconpos/)) {
		if (!document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconenable")).checked) {
			document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconposlat")).value = pos.lat;
			document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconposlon")).value = pos.lon;
		}
	}
	if (id.match(/^insertyahoomappolylinepos/)) {
		var i = id.replace("insertyahoomappolylinepos","").split("_");
		if (!document.getElementById("insertyahoomappolylineenable" + i[0]).checked) {
			document.getElementById(id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).value = pos.lat;
			document.getElementById(id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).value = pos.lon;
		}
	}
	if (id.match(/^insertyahoomappolygonpos/)) {
		var i = id.replace("insertyahoomappolygonpos","").split("_");
		if (!document.getElementById("insertyahoomappolygonenable" + i[0]).checked) {
			document.getElementById(id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).value = pos.lat;
			document.getElementById(id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).value = pos.lon;
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図表示位置変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_ymapSetPos(id) {
	insertyahoomap_mapSetPos(ymap,id);
}
//------------------------------------------------------------------------------------------------------------
// 地図表示位置設定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapSetPos(map,id) {
	var lat = "";
	var lon = "";
	if (id == 'i_map_pos') {
		var lat = document.getElementById("i_map_pos_lat").value;
		var lon = document.getElementById("i_map_pos_lon").value;
	}
	if (id == 'i_map_home') {
		var lat = document.getElementById("i_map_home_lat").value;
		var lon = document.getElementById("i_map_home_lon").value;
	}
	if (id.match(/^insertyahoomapiconpos/)) {
		var lat = document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconposlat")).value;
		var lon = document.getElementById(id.replace("insertyahoomapiconpos","insertyahoomapiconposlon")).value;
	}
	if (id.match(/^insertyahoomappolylinepos/)) {
		var lat = document.getElementById(id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).value;
		var lon = document.getElementById(id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).value;
	}
	if (id.match(/^insertyahoomappolygonpos/)) {
		var lat = document.getElementById(id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).value;
		var lon = document.getElementById(id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).value;
	}
	if (lat && lon) {
		map.moveTo(new YLLPoint(lat,lon));
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図縮尺変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapChangeSliderbar() {
	if (document.getElementById("i_map_sliderbar").value == "スライダーバー") {
		document.getElementById("i_map_sliderbar").value = "縮尺切り替えボタン";
		ymap.setVisibleSliderbar(false);
	} else {
		document.getElementById("i_map_sliderbar").value = "スライダーバー";
		ymap.setVisibleSliderbar(true);
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図中心点表示ボタン変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_mapChangeCentermarkButton() {
	if (document.getElementById("i_map_centermarkbutton").value == "表示ボタン有り") {
		document.getElementById("i_map_centermarkbutton").value = "表示ボタン無し";
		ymap.setVisibleCentermarkButton(false);
	} else {
		document.getElementById("i_map_centermarkbutton").value = "表示ボタン有り";
		ymap.setVisibleCentermarkButton(true);
	}
}
//------------------------------------------------------------------------------------------------------------
// 地図挿入
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_insert(inserttarget) {
	var insertyahoomapparam  = '';
// 地図横幅
	if (document.getElementById("i_map_width").value) {
		if (insertyahoomap_isnumber(document.getElementById("i_map_width").value)) {
			insertyahoomapparam += ' width="' + document.getElementById("i_map_width").value + 'px"';
		} else {
			alert('地図横幅が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' width="400px"';
	}
// 地図高幅
	if (document.getElementById("i_map_height").value) {
		if (insertyahoomap_isnumber(document.getElementById("i_map_height").value)) {
			insertyahoomapparam += ' height="' + document.getElementById("i_map_height").value + 'px"';
		} else {
			alert('地図縦幅が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' height="300px"';
	}
// ホーム緯度
	if (document.getElementById("i_map_home_lat").value) {
		if (insertyahoomap_isnumeric(document.getElementById("i_map_home_lat").value)) {
			insertyahoomapparam += ' home_lat="' + document.getElementById("i_map_home_lat").value + '"';
		} else {
			alert('初期緯度が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' home_lat="35.67832667"';
	}
// ホーム経度
	if (document.getElementById("i_map_home_lon").value) {
		if (insertyahoomap_isnumeric(document.getElementById("i_map_home_lon").value)) {
			insertyahoomapparam += ' home_lon="' + document.getElementById("i_map_home_lon").value + '"';
		} else {
			alert('初期経度が正しくありません。');
			return;
		}
	} else {
		insertyahoomapparam += ' home_lon="139.77044378"';
	}
// 初期表示位置
	if (document.getElementById("i_map_pos_lat").value
	&&  document.getElementById("i_map_pos_lon").value) {
// 初期表示位置緯度
		if (insertyahoomap_isnumeric(document.getElementById("i_map_pos_lat").value)) {
			insertyahoomapparam += ' pos_lat="' + document.getElementById("i_map_pos_lat").value + '"';
		} else {
			alert('表示緯度が正しくありません。');
			return;
		}
// 初期表示位置経度
		if (insertyahoomap_isnumeric(document.getElementById("i_map_pos_lon").value)) {
			insertyahoomapparam += ' pos_lon="' + document.getElementById("i_map_pos_lon").value + '"';
		} else {
			alert('表示経度が正しくありません。');
			return;
		}
	}
// 中心点
	insertyahoomapparam += ' centermark="' + ymap.getVisibleCentermark() + '"';
// 尺度
	insertyahoomapparam += ' currentlayer="' + ymap.getCurrentLayer() + '"';
// 地図種類
	insertyahoomapparam += ' currentmode="' + ymap.getCurrentMode() + '"';
// 測地系
	insertyahoomapparam += ' currentdatum="' + insertyahoomap_map_datum + '"';
// スライダーバー
	if (document.getElementById("i_map_sliderbar").value == "スライダーバー") {
		insertyahoomapparam += ' sliderbar="true"';
	} else {
		insertyahoomapparam += ' sliderbar="false"';
	}
// 中心点表示ボタン
	if (document.getElementById("i_map_centermarkbutton").value == "表示ボタン有り") {
		insertyahoomapparam += ' centermarkbutton="true"';
	} else {
		insertyahoomapparam += ' centermarkbutton="false"';
	}
// カテゴリー
	var eleCategorys = insertyahoomap_getelement("input","^insertyahoomapcategoryid");
	for (var i=0;i<eleCategorys.length;i++) {
		if (document.getElementById(eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked) {
// カテゴリＩＤ
			insertyahoomapparam += ' ' + eleCategorys[i].id + '="' + escape(eleCategorys[i].value) + '"';
// カテゴリ画像
			var idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryimg");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
// 画像スタイル幅
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamwidth");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 画像スタイル高さ
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamheight");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 画像スタイル基準横
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdx");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 画像スタイル基準縦
			idvalue = eleCategorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryparamdy");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
		}
	}
// アイコン
	var eleIcons = insertyahoomap_getelement("input","^insertyahoomapiconid");
	for (var i=0;i<eleIcons.length;i++) {
		if (document.getElementById(eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked) {
// アイコンＩＤ
			insertyahoomapparam += ' ' + eleIcons[i].id + '="' + escape(eleIcons[i].value) + '"';
// 緯度
			var idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconposlat");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 経度
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconposlon");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// カテゴリＩＤ
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapicontype");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
// 吹き出し
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconpopup");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
// ラベル
			idvalue = eleIcons[i].id.replace("insertyahoomapiconid","insertyahoomapiconlabel");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
		}
	}
// ポリライン
	var elePolylines = insertyahoomap_getelement("input","^insertyahoomappolylineid");
	for (var i=0;i<elePolylines.length;i++) {
		if (document.getElementById(elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylineenable")).checked) {
// オブジェクトＩＤ
			insertyahoomapparam += ' ' + elePolylines[i].id + '="' + escape(elePolylines[i].value) + '"';
// 座標
			var idvalue = elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylinepos") + '_';
			var elePolylineposs = insertyahoomap_getelement("tr","^" + idvalue);
			for (var j=0;j<elePolylineposs.length;j++) {
// 緯度
				idvalue = elePolylineposs[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat");
				insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 経度
				idvalue = elePolylineposs[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon");
				insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
			}
// 吹き出し
			idvalue = elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylinepopup");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
// 線スタイル太さ
			idvalue = elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylinestrokewidth");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 線スタイル色
			idvalue = elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylinestrokecolor");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 線スタイル透明度
			idvalue = elePolylines[i].id.replace("insertyahoomappolylineid","insertyahoomappolylinestrokeopacity");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
		}
	}
// ポリゴン
	var elePolygons = insertyahoomap_getelement("input","^insertyahoomappolygonid");
	for (var i=0;i<elePolygons.length;i++) {
		if (document.getElementById(elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonenable")).checked) {
// オブジェクトＩＤ
			insertyahoomapparam += ' ' + elePolygons[i].id + '="' + escape(elePolygons[i].value) + '"';
// 座標
			var idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonpos") + '_';
			var elePolygonposs = insertyahoomap_getelement("tr","^" + idvalue);
			for (var j=0;j<elePolygonposs.length;j++) {
// 緯度
				idvalue = elePolygonposs[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat");
				insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 経度
				idvalue = elePolygonposs[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon");
				insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
			}
// 吹き出し
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonpopup");
			insertyahoomapparam += ' ' + idvalue + '="' + escape(document.getElementById(idvalue).value) + '"';
// 線スタイル太さ
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonstrokewidth");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 線スタイル色
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonstrokecolor");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 線スタイル透明度
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonstrokeopacity");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 塗りつぶしスタイル色
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonfillcolor");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
// 塗りつぶしスタイル透明度
			idvalue = elePolygons[i].id.replace("insertyahoomappolygonid","insertyahoomappolygonfillopacity");
			insertyahoomapparam += ' ' + idvalue + '="' + document.getElementById(idvalue).value + '"';
		}
	}
	var insertyahoomap  = '[insertyahoomap';
	if (inserttarget == 'custom') {
		var id = Math.floor(Math.random()*10000000000);
		var meta_key = 'insertyahoomap' + id;
		window.opener.send_meta_value(meta_key,insertyahoomapparam);
		insertyahoomap += ' id="' + id + '"';
	} else {
		insertyahoomap += insertyahoomapparam;
	}
	insertyahoomap += ']';
	window.opener.send_to_editor(insertyahoomap);
	window.close();
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_category_insert(calltype) {
	var i = 1;
	while (document.getElementById("insertyahoomapcategory" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomapcategory");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomapcategory" + i;
	if (calltype != 'options') {
		var eleCell = eleRow.insertCell(-1);
		eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapcategoryenable' + i + '" onClick="javascript:insertyahoomap_category_enable_change(insertyahoomap_event_target(event));void(0);"/>';
	}
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryid' + i + '" value="category' + i + '" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryimg' + i + '" value="" onChange="javascript:insertyahoomap_category_img_onchange(event,\'' + i + '\');void(0);" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.id = "insertyahoomapcategoryimgsample" + i;
	eleCell.innerHTML = '　';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamwidth' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamheight' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamdx' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapcategoryparamdy' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_category_delete(' + i + ');void(0);" id="insertyahoomapcategorydeletebutton' + i + '">削除</a>';
	if (typeof(window.opener.emoji_window_show) == "function"
	||  typeof(window.opener.emoji_window_show) == "object") {
		eleCell.innerHTML += '<a href="javascript:void(0);" id="insertyahoomapcategoryemojibutton' + i + '" title="絵文字参照" style="vertical-align:middle;" onClick="javascript:insertyahoomap_emoji_onclick(event);void(0);"><img alt="絵文字参照" id="insertyahoomapcategoryemojibutton' + i + '" src="' + insertyahoomap_emojiurl + 'images/smile.gif"/></a>';
	}
	return i;
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー画像変更イベント
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_category_img_onchange(e,i) {
	var link = new Array();
	link['imageurl'] = document.getElementById("insertyahoomapcategoryimg" + i).value;
	link['event'] = e;
	link['inputelement'] = insertyahoomap_event_target(e);
	insertyahoomap_category_img_change(link);
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー画像絵文字イベント
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_emoji_onclick(e) {
	var link = new Array();
	link['calltype'] = "insertyahoomap";
	link['event'] = e;
	link['divelement'] = document.getElementById("insertyahoomapemojidiv");
	link['inputelement'] = document.getElementById(insertyahoomap_event_target(e).id.replace("insertyahoomapcategoryemojibutton","insertyahoomapcategoryimg"));
	link['onselect'] = insertyahoomap_category_img_change;
	window.opener.emoji_window_show(link);
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー画像変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_category_img_change(link) {
	var i = link['inputelement'].id.replace("insertyahoomapcategoryimg","");
	var sample_element = document.getElementById("insertyahoomapcategoryimgsample" + i);
	sample_element.innerHTML = '<img src="' + link['imageurl'] + '" width="14px" height="14px" alt="無" id="insertyahoomapcategoryimgsampleimg' + i + '" onLoad="javascript:insertyahoomap_imageExist(this);void(0);"/>';
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー適用変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_category_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomapcategoryenable","");
	ymap.removeCategory(document.getElementById("insertyahoomapcategoryid" + i).value);
	document.getElementById("insertyahoomapcategoryid" + i).readOnly = false;
	document.getElementById("insertyahoomapcategoryimg" + i).readOnly = false;
	document.getElementById("insertyahoomapcategoryparamwidth" + i).readOnly = false;
	document.getElementById("insertyahoomapcategoryparamheight" + i).readOnly = false;
	document.getElementById("insertyahoomapcategoryparamdx" + i).readOnly = false;
	document.getElementById("insertyahoomapcategoryparamdy" + i).readOnly = false;
	document.getElementById("insertyahoomapcategorydeletebutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomapcategoryemojibutton" + i).style.visibility = "visible";
	var id = document.getElementById("insertyahoomapcategoryid" + i).value;
	var eleIcontype = insertyahoomap_getelement("select","^insertyahoomapicontype");
	for (var j=0;j<eleIcontype.length;j++) {
		for (var k=0;k<eleIcontype[j].options.length;k++) {
			if (eleIcontype[j].options[k].value == id) {
				eleIcontype[j].remove(k);
			}
		}
	}
	if (change_element.checked) {
		if (id.length == 0) {
			alert('カテゴリIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		var eleCategorys = insertyahoomap_getelement("input","^insertyahoomapcategoryid");
		for (var j=0;j<eleCategorys.length;j++) {
			if (eleCategorys[j].id != ("insertyahoomapcategoryid" + i)
			&&  document.getElementById(eleCategorys[j].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked
			&&  eleCategorys[j].value == id) {
				alert('カテゴリIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		if (!change_element.checked) {
			return;
		}
		var img = document.getElementById("insertyahoomapcategoryimg" + i).value;
		if (!document.getElementById("insertyahoomapcategoryimgsampleimg" + i)
		||  document.getElementById("insertyahoomapcategoryimgsampleimg" + i).alt == "無") {
			alert('画像が存在しません。');
			change_element.checked = false;
			return;
		}
		var imgobj = new Image();
		imgobj.src = img;
		var paramwidth = document.getElementById("insertyahoomapcategoryparamwidth" + i).value;
		if (paramwidth.length == 0) {
			paramwidth = imgobj.width;
			document.getElementById("insertyahoomapcategoryparamwidth" + i).value = imgobj.width;
		}
		if (!insertyahoomap_isnumber(paramwidth)) {
			alert('画像スタイル幅が正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramheight = document.getElementById("insertyahoomapcategoryparamheight" + i).value;
		if (paramheight.length == 0) {
			paramheight = imgobj.height;
			document.getElementById("insertyahoomapcategoryparamheight" + i).value = imgobj.height;
		}
		if (!insertyahoomap_isnumber(paramheight)) {
			alert('画像スタイル高さが正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramdx = document.getElementById("insertyahoomapcategoryparamdx" + i).value;
		if (paramdx.length == 0) {
			paramdx = "0";
			document.getElementById("insertyahoomapcategoryparamdx" + i).value = "0";
		}
		if (!insertyahoomap_isnumberinnegative(paramdx)) {
			alert('基準横が正しくありません。');
			change_element.checked = false;
			return;
		}
		var paramdy = document.getElementById("insertyahoomapcategoryparamdy" + i).value;
		if (paramdy.length == 0) {
			paramdy = "0";
			document.getElementById("insertyahoomapcategoryparamdy" + i).value = "0";
		}
		if (!insertyahoomap_isnumberinnegative(paramdy)) {
			alert('基準縦が正しくありません。');
			change_element.checked = false;
			return;
		}
		var param = {"width":parseInt(paramwidth),"height":parseInt(paramheight),"dx":parseInt(paramdx),"dy":parseInt(paramdy)};
		ymap.addCategory(id,img,param);
		document.getElementById("insertyahoomapcategoryid" + i).readOnly = true;
		document.getElementById("insertyahoomapcategoryimg" + i).readOnly = true;
		document.getElementById("insertyahoomapcategoryparamwidth" + i).readOnly = true;
		document.getElementById("insertyahoomapcategoryparamheight" + i).readOnly = true;
		document.getElementById("insertyahoomapcategoryparamdx" + i).readOnly = true;
		document.getElementById("insertyahoomapcategoryparamdy" + i).readOnly = true;
		document.getElementById("insertyahoomapcategorydeletebutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomapcategoryemojibutton" + i).style.visibility = "hidden";
		for (var j=0;j<eleIcontype.length;j++) {
			eleIcontype[j].options[eleIcontype[j].length] = new Option(id,id);
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// アイコン画像存在設定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_imageExist(ele){
	ele.alt = "有";
}
//------------------------------------------------------------------------------------------------------------
// カテゴリー削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_category_delete(i) {
	var eleTable = document.getElementById("insertyahoomapcategory");
	var eleRow = document.getElementById("insertyahoomapcategory" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// アイコン追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_icon_insert() {
	var i = 1;
	while (document.getElementById("insertyahoomapicon" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomapicon");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomapicon" + i;
	var eleCell = eleRow.insertCell(-1);
	eleCell.rowSpan = '2';
	eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapiconenable' + i + '" onClick="javascript:insertyahoomap_icon_enable_change(insertyahoomap_event_target(event));void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconid' + i + '" value="icon' + i + '" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlat' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlon' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<select class="select" id="insertyahoomapicontype' + i + '"><option value="L1">L1<option value="L2">L2<option value="L3">L3<option value="L4">L4<option value="L5">L5<option value="S1">S1<option value="S2">S2<option value="S3">S3<option value="S4">S4<option value="S5">S5</select>';
	var eleCategorys = insertyahoomap_getelement("input","^insertyahoomapcategoryenable");
	for (var j=0;j<eleCategorys.length;j++) {
		if (eleCategorys[j].checked) {
			var id = document.getElementById(eleCategorys[j].id.replace("insertyahoomapcategoryenable","insertyahoomapcategoryid")).value;
			document.getElementById("insertyahoomapicontype" + i).options[document.getElementById("insertyahoomapicontype" + i).length] = new Option(id,id);
		}
	}
	eleCell = eleRow.insertCell(-1);
	eleCell.rowSpan = '2';
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_icon_delete(' + i + ');void(0);" id="insertyahoomapicondeletebutton' + i + '">削除</a><a class="button" href="javascript:insertyahoomap_mapGetPos(\'insertyahoomapiconpos' + i + '\',ymap.getCenter());void(0);" id="insertyahoomapiconposbutton' + i + '">取得</a><a class="button" href="javascript:insertyahoomap_ymapSetPos(\'insertyahoomapiconpos' + i + '\');void(0);">表示</a>';
	eleRow = eleTable.insertRow(-1);
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconpopup' + i + '" style="ime-mode:active;" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<input type="text" id="insertyahoomapiconlabel' + i + '" style="ime-mode:active;" value="" onfocus="javascript:focuselement=this;void(0);"/>';
}
//------------------------------------------------------------------------------------------------------------
// アイコン適用変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_icon_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomapiconenable","");
	ymap.removeIcon(document.getElementById("insertyahoomapiconid" + i).value);
	document.getElementById("insertyahoomapiconid" + i).readOnly = false;
	document.getElementById("insertyahoomapiconposlat" + i).readOnly = false;
	document.getElementById("insertyahoomapiconposlon" + i).readOnly = false;
	document.getElementById("insertyahoomapicontype" + i).disabled = false;
	document.getElementById("insertyahoomapiconpopup" + i).readOnly = false;
	document.getElementById("insertyahoomapiconlabel" + i).readOnly = false;
	document.getElementById("insertyahoomapicondeletebutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomapiconposbutton" + i).style.visibility = "visible";
	var type = document.getElementById("insertyahoomapicontype" + i).value;
	var eleCategorys = insertyahoomap_getelement("input","^insertyahoomapcategoryid");
	for (var j=0;j<eleCategorys.length;j++) {
		if (eleCategorys[j].value == type) {
			document.getElementById(eleCategorys[j].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).disabled = false;
		}
	}
	if (change_element.checked) {
		var id = document.getElementById("insertyahoomapiconid" + i).value;
		if (id.length == 0) {
			alert('アイコンIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		var eleIcons = insertyahoomap_getelement("input","^insertyahoomapiconid");
		for (var j=0;j<eleIcons.length;j++) {
			if (eleIcons[j].id != ("insertyahoomapiconid" + i)
			&&  document.getElementById(eleIcons[j].id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked
			&&  eleIcons[j].value == id) {
				alert('カテゴリIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		if (!change_element.checked) {
			return;
		}
		var poslat = document.getElementById("insertyahoomapiconposlat" + i).value;
		if (poslat.length == 0) {
			alert('緯度が設定されていません。');
			change_element.checked = false;
			return;
		}
		if (!insertyahoomap_isnumeric(poslat)) {
			alert('緯度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var poslon = document.getElementById("insertyahoomapiconposlon" + i).value;
		if (poslon.length == 0) {
			alert('経度が設定されていません。');
			change_element.checked = false;
			return;
		}
		if (!insertyahoomap_isnumeric(poslon)) {
			alert('経度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var pos = poslat + ',' + poslon;
		var popup = document.getElementById("insertyahoomapiconpopup" + i).value;
		var label = document.getElementById("insertyahoomapiconlabel" + i).value;
		ymap.addIcon(id,pos,popup,type,label);
		document.getElementById("insertyahoomapiconid" + i).readOnly = true;
		document.getElementById("insertyahoomapiconposlat" + i).readOnly = true;
		document.getElementById("insertyahoomapiconposlon" + i).readOnly = true;
		document.getElementById("insertyahoomapicontype" + i).disabled = true;
		document.getElementById("insertyahoomapiconpopup" + i).readOnly = true;
		document.getElementById("insertyahoomapiconlabel" + i).readOnly = true;
		document.getElementById("insertyahoomapicondeletebutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomapiconposbutton" + i).style.visibility = "hidden";
		for (var j=0;j<eleCategorys.length;j++) {
			if (eleCategorys[j].value == type) {
				document.getElementById(eleCategorys[j].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).disabled = true;
			}
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// アイコン削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_icon_delete(i) {
	var eleTable = document.getElementById("insertyahoomapicon");
	var eleRow = document.getElementById("insertyahoomapicon" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex + 1);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_insert() {
	var i = 1;
	while (document.getElementById("insertyahoomappolyline" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomappolyline");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomappolyline" + i;
	var eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomappolylineenable' + i + '" onClick="javascript:insertyahoomap_polyline_enable_change(insertyahoomap_event_target(event));void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylineid' + i + '" value="polyline' + i + '" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylinepopup' + i + '" style="ime-mode:active;" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylinestrokewidth' + i + '" value="3" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylinestrokecolor' + i + '" value="00ff00" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylinestrokeopacity' + i + '" value="1" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polyline_load(' + i + ');void(0);" id="insertyahoomappolylineaddbutton' + i + '">一括設定</a>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polyline_delete(' + i + ');void(0);" id="insertyahoomappolylinedeletebutton' + i + '">削除</a><a class="button" href="javascript:insertyahoomap_polyline_pos_insert(' + i + ');void(0);" id="insertyahoomappolylineposinsertbutton' + i + '">座標追加</a>';
	insertyahoomap_polyline_pos_insert(i);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_pos_insert(id) {
	var i = 1;
	while (document.getElementById("insertyahoomappolylineposlat" + id + "_" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomappolyline");
	var eleRow = document.getElementById("insertyahoomappolyline" + (id + 1));
	if (eleRow) {
		eleRow = eleTable.insertRow(eleRow.sectionRowIndex);
	} else {
		eleRow = eleTable.insertRow(-1);
	}
	eleRow.id = "insertyahoomappolylinepos" + id + '_' + i;
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '6';
	eleCell.innerHTML = '　';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylineposlat' + id + '_' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolylineposlon' + id + '_' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polyline_deletepos(' + id + ',' + i + ');void(0);" id="insertyahoomappolylinedeleteposbutton' + id + '_' + i + '">削除</a><a class="button" href="javascript:insertyahoomap_mapGetPos(\'insertyahoomappolylinepos' + id + '_' + i + '\',ymap.getCenter());void(0);" id="insertyahoomappolylineposbutton' + id + '_' + i + '">取得</a><a class="button" href="javascript:insertyahoomap_ymapSetPos(\'insertyahoomappolylinepos' + id + '_' + i + '\');void(0);">表示</a>';
}
//------------------------------------------------------------------------------------------------------------
// ポリライン適用変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomappolylineenable","");
	ymap.removeVectorObject(document.getElementById("insertyahoomappolylineid" + i).value);
	document.getElementById("insertyahoomappolylineid" + i).readOnly = false;
	document.getElementById("insertyahoomappolylinepopup" + i).readOnly = false;
	document.getElementById("insertyahoomappolylinestrokewidth" + i).readOnly = false;
	document.getElementById("insertyahoomappolylinestrokecolor" + i).readOnly = false;
	document.getElementById("insertyahoomappolylinestrokeopacity" + i).readOnly = false;
	document.getElementById("insertyahoomappolylineaddbutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomappolylinedeletebutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomappolylineposinsertbutton" + i).style.visibility = "visible";
// ポリライン座標
	var elePolylinepos = insertyahoomap_getelement("tr","^insertyahoomappolylinepos" + i + "_");
	for (var j=0;j<elePolylinepos.length;j++) {
		document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).readOnly = false;
		document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).readOnly = false;
		document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylinedeleteposbutton")).style.visibility = "visible";
		document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposbutton")).style.visibility = "visible";
	}
	if (change_element.checked) {
		var id = document.getElementById("insertyahoomappolylineid" + i).value;
		if (id.length == 0) {
			alert('オブジェクトIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		var elePolylines = insertyahoomap_getelement("input","^insertyahoomappolylineid");
		for (var j=0;j<elePolylines.length;j++) {
			if (elePolylines[j].id != ("insertyahoomappolylineid" + i)
			&&  document.getElementById(elePolylines[j].id.replace("insertyahoomappolylineid","insertyahoomappolylineenable")).checked
			&&  elePolylines[j].value == id) {
				alert('オブジェクトIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		var elePolygons = insertyahoomap_getelement("input","^insertyahoomappolygonid");
		for (var j=0;j<elePolygons.length;j++) {
			if (document.getElementById(elePolygons[j].id.replace("insertyahoomappolygonid","insertyahoomappolygonenable")).checked
			&&  elePolygons[j].value == id) {
				alert('オブジェクトIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		if (!change_element.checked) {
			return;
		}
		var popup = document.getElementById("insertyahoomappolylinepopup" + i).value;
		var strokewidth = document.getElementById("insertyahoomappolylinestrokewidth" + i).value;
		if (strokewidth.length == 0) {
			strokewidth = 3;
			document.getElementById("insertyahoomappolylinestrokewidth" + i).value = 3;
		}
		if (!insertyahoomap_isnumber(strokewidth)) {
			alert('線スタイル太さが正しくありません。');
			change_element.checked = false;
			return;
		}
		var strokecolor = document.getElementById("insertyahoomappolylinestrokecolor" + i).value;
		if (strokecolor.length == 0) {
			strokecolor = "00ff00";
			document.getElementById("insertyahoomappolylinestrokecolor" + i).value = "00ff00";
		}
		var strokeopacity = document.getElementById("insertyahoomappolylinestrokeopacity" + i).value;
		if (strokeopacity.length == 0) {
			strokeopacity = 1;
			document.getElementById("insertyahoomappolylinestrokeopacity" + i).value = 1;
		}
		if (!insertyahoomap_isnumeric(strokeopacity)) {
			alert('線スタイル透明度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var style = { "strokeWidth": parseInt(strokewidth), "strokeColor": strokecolor, "strokeOpacity": parseFloat(strokeopacity) };
// ポリライン座標
		var polylinepos = new Array();
		for (var j=0;j<elePolylinepos.length;j++) {
			var poslat = document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).value;
			if (poslat.length == 0) {
				alert('緯度が設定されていません。');
				change_element.checked = false;
				return;
			}
			if (!insertyahoomap_isnumeric(poslat)) {
				alert('緯度が正しくありません。');
				change_element.checked = false;
				return;
			}
			var poslon = document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).value;
			if (poslon.length == 0) {
				alert('経度が設定されていません。');
				change_element.checked = false;
				return;
			}
			if (!insertyahoomap_isnumeric(poslon)) {
				alert('経度が正しくありません。');
				change_element.checked = false;
				return;
			}
			polylinepos.push(new YLLPoint(poslat,poslon));
		}
		ymap.addPolyline(id,polylinepos,popup,style);
		document.getElementById("insertyahoomappolylineid" + i).readOnly = true;
		document.getElementById("insertyahoomappolylinepopup" + i).readOnly = true;
		document.getElementById("insertyahoomappolylinestrokewidth" + i).readOnly = true;
		document.getElementById("insertyahoomappolylinestrokecolor" + i).readOnly = true;
		document.getElementById("insertyahoomappolylinestrokeopacity" + i).readOnly = true;
		document.getElementById("insertyahoomappolylineaddbutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomappolylinedeletebutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomappolylineposinsertbutton" + i).style.visibility = "hidden";
// ポリライン座標
		for (var j=0;j<elePolylinepos.length;j++) {
			document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).readOnly = true;
			document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).readOnly = true;
			document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylinedeleteposbutton")).style.visibility = "hidden";
			document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposbutton")).style.visibility = "hidden";
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリライン削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_delete(i) {
// ポリライン座標全削除
	insertyahoomap_polyline_deleteposs(i);
	var eleTable = document.getElementById("insertyahoomappolyline");
	var eleRow = document.getElementById("insertyahoomappolyline" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標全削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_deleteposs(i) {
	var eleTable = document.getElementById("insertyahoomappolyline");
// ポリライン座標
	var elePolylinepos = insertyahoomap_getelement("tr","^insertyahoomappolylinepos" + i + "_");
	for (var j=0;j<elePolylinepos.length;j++) {
		var eleRow = document.getElementById(elePolylinepos[j].id);
		eleTable.deleteRow(eleRow.sectionRowIndex);
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_deletepos(i,j) {
	var eleTable = document.getElementById("insertyahoomappolyline");
	var eleRow = document.getElementById("insertyahoomappolylinepos" + i + "_" + j);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_load(i) {
// ポリライン座標一括設定用データ
	insertyahoomap_ymap = ymap;
	insertyahoomap_polyline_id = i;
	insertyahoomap_polyline_poss = "";
// ポリライン座標
	var elePolylinepos = insertyahoomap_getelement("tr","^insertyahoomappolylinepos" + i + "_");
	for (var j=0;j<elePolylinepos.length;j++) {
		if (document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).value
		&&  document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).value) {
			insertyahoomap_polyline_poss += document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlat")).value;
			insertyahoomap_polyline_poss += ",";
			insertyahoomap_polyline_poss += document.getElementById(elePolylinepos[j].id.replace("insertyahoomappolylinepos","insertyahoomappolylineposlon")).value;
			insertyahoomap_polyline_poss += "\n";
		}
	}
// ポリライン座標一括設定用画面作成
	var left = Math.round((screen.availWidth - 400) / 2);
	window.open(insertyahoomap_url + 'insertyahoomap-polyline.php','','top=200,left=' + left + ',width=400,height=300,toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes');
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_insert() {
	var i = 1;
	while (document.getElementById("insertyahoomappolygon" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomappolygon");
	var eleRow = eleTable.insertRow(-1);
	eleRow.id = "insertyahoomappolygon" + i;
	var eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomappolygonenable' + i + '" onClick="javascript:insertyahoomap_polygon_enable_change(insertyahoomap_event_target(event));void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonid' + i + '" value="polygon' + i + '" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonpopup' + i + '" style="ime-mode:active;" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonstrokewidth' + i + '" value="3" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonstrokecolor' + i + '" value="00ff00" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonstrokeopacity' + i + '" value="1" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonfillcolor' + i + '" value="0000ff" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonfillopacity' + i + '" value="0.5" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '2';
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polygon_load(' + i + ');void(0);" id="insertyahoomappolygonaddbutton' + i + '">一括設定</a>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polygon_delete(' + i + ');void(0);" id="insertyahoomappolygondeletebutton' + i + '">削除</a><a class="button" href="javascript:insertyahoomap_polygon_pos_insert(' + i + ');void(0);" id="insertyahoomappolygonposinsertbutton' + i + '">座標追加</a>';
	insertyahoomap_polygon_pos_insert(i);
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標追加
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_pos_insert(id) {
	var i = 1;
	while (document.getElementById("insertyahoomappolygonposlat" + id + "_" + i)) {
		i++;
	}
	var eleTable = document.getElementById("insertyahoomappolygon");
	var eleRow = document.getElementById("insertyahoomappolygon" + (id + 1));
	if (eleRow) {
		eleRow = eleTable.insertRow(eleRow.sectionRowIndex);
	} else {
		eleRow = eleTable.insertRow(-1);
	}
	eleRow.id = "insertyahoomappolygonpos" + id + '_' + i;
	eleCell = eleRow.insertCell(-1);
	eleCell.colSpan = '8';
	eleCell.innerHTML = '　';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonposlat' + id + '_' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<input type="text" id="insertyahoomappolygonposlon' + id + '_' + i + '" value="" onfocus="javascript:focuselement=this;void(0);"/>';
	eleCell = eleRow.insertCell(-1);
	eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polygon_deletepos(' + id + ',' + i + ');void(0);" id="insertyahoomappolygondeleteposbutton' + id + '_' + i + '">削除</a><a class="button" href="javascript:insertyahoomap_mapGetPos(\'insertyahoomappolygonpos' + id + '_' + i + '\',ymap.getCenter());void(0);" id="insertyahoomappolygonposbutton' + id + '_' + i + '">取得</a><a class="button" href="javascript:insertyahoomap_ymapSetPos(\'insertyahoomappolygonpos' + id + '_' + i + '\');void(0);">表示</a>';
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン適用変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_enable_change(change_element) {
	var i = change_element.id.replace("insertyahoomappolygonenable","");
	ymap.removeVectorObject(document.getElementById("insertyahoomappolygonid" + i).value);
	document.getElementById("insertyahoomappolygonid" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonpopup" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonstrokewidth" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonstrokecolor" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonstrokeopacity" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonfillcolor" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonfillopacity" + i).readOnly = false;
	document.getElementById("insertyahoomappolygonaddbutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomappolygondeletebutton" + i).style.visibility = "visible";
	document.getElementById("insertyahoomappolygonposinsertbutton" + i).style.visibility = "visible";
// ポリゴン座標
	var elePolygonpos = insertyahoomap_getelement("tr","^insertyahoomappolygonpos" + i + "_");
	for (var j=0;j<elePolygonpos.length;j++) {
		document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).readOnly = false;
		document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).readOnly = false;
		document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygondeleteposbutton")).style.visibility = "visible";
		document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposbutton")).style.visibility = "visible";
	}
	if (change_element.checked) {
		var id = document.getElementById("insertyahoomappolygonid" + i).value;
		if (id.length == 0) {
			alert('オブジェクトIDが設定されていません。');
			change_element.checked = false;
			return;
		}
		var elePolygons = insertyahoomap_getelement("input","^insertyahoomappolygonid");
		for (var j=0;j<elePolygons.length;j++) {
			if (elePolygons[j].id != ("insertyahoomappolygonid" + i)
			&&  document.getElementById(elePolygons[j].id.replace("insertyahoomappolygonid","insertyahoomappolygonenable")).checked
			&&  elePolygons[j].value == id) {
				alert('オブジェクトIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		var elePolylines = insertyahoomap_getelement("input","^insertyahoomappolylineid");
		for (var j=0;j<elePolylines.length;j++) {
			if (document.getElementById(elePolylines[j].id.replace("insertyahoomappolylineid","insertyahoomappolylineenable")).checked
			&&  elePolylines[j].value == id) {
				alert('オブジェクトIDが重複しています。');
				change_element.checked = false;
				return false;
			}
		}
		if (!change_element.checked) {
			return;
		}
		var popup = document.getElementById("insertyahoomappolygonpopup" + i).value;
		var strokewidth = document.getElementById("insertyahoomappolygonstrokewidth" + i).value;
		if (strokewidth.length == 0) {
			strokewidth = 3;
			document.getElementById("insertyahoomappolygonstrokewidth" + i).value = 3;
		}
		if (!insertyahoomap_isnumber(strokewidth)) {
			alert('線スタイル太さが正しくありません。');
			change_element.checked = false;
			return;
		}
		var strokecolor = document.getElementById("insertyahoomappolygonstrokecolor" + i).value;
		if (strokecolor.length == 0) {
			strokecolor = "00ff00";
			document.getElementById("insertyahoomappolygonstrokecolor" + i).value = "00ff00";
		}
		var strokeopacity = document.getElementById("insertyahoomappolygonstrokeopacity" + i).value;
		if (strokeopacity.length == 0) {
			strokeopacity = 1;
			document.getElementById("insertyahoomappolygonstrokeopacity" + i).value = 1;
		}
		if (!insertyahoomap_isnumeric(strokeopacity)) {
			alert('線スタイル透明度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var fillcolor = document.getElementById("insertyahoomappolygonfillcolor" + i).value;
		if (fillcolor.length == 0) {
			fillcolor = "0000ff";
			document.getElementById("insertyahoomappolygonfillcolor" + i).value = "0000ff";
		}
		var fillopacity = document.getElementById("insertyahoomappolygonfillopacity" + i).value;
		if (fillopacity.length == 0) {
			fillopacity = 0.5;
			document.getElementById("insertyahoomappolygonfillopacity" + i).value = 0.5;
		}
		if (!insertyahoomap_isnumeric(fillopacity)) {
			alert('塗りつぶしスタイル透明度が正しくありません。');
			change_element.checked = false;
			return;
		}
		var style = { "strokeWidth": parseInt(strokewidth), "strokeColor": strokecolor, "strokeOpacity": parseFloat(strokeopacity), "fillColor": fillcolor, "fillOpacity": parseFloat(fillopacity) };
// ポリゴン座標
		var polygonpos = new Array();
		for (var j=0;j<elePolygonpos.length;j++) {
			var poslat = document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).value;
			if (poslat.length == 0) {
				alert('緯度が設定されていません。');
				change_element.checked = false;
				return;
			}
			if (!insertyahoomap_isnumeric(poslat)) {
				alert('緯度が正しくありません。');
				change_element.checked = false;
				return;
			}
			var poslon = document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).value;
			if (poslon.length == 0) {
				alert('経度が設定されていません。');
				change_element.checked = false;
				return;
			}
			if (!insertyahoomap_isnumeric(poslon)) {
				alert('経度が正しくありません。');
				change_element.checked = false;
				return;
			}
			polygonpos.push(new YLLPoint(poslat,poslon));
		}
		ymap.addPolygon(id,polygonpos,popup,style);
		document.getElementById("insertyahoomappolygonid" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonpopup" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonstrokewidth" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonstrokecolor" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonstrokeopacity" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonfillcolor" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonfillopacity" + i).readOnly = true;
		document.getElementById("insertyahoomappolygonaddbutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomappolygondeletebutton" + i).style.visibility = "hidden";
		document.getElementById("insertyahoomappolygonposinsertbutton" + i).style.visibility = "hidden";
// ポリゴン座標
		for (var j=0;j<elePolygonpos.length;j++) {
			document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).readOnly = true;
			document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).readOnly = true;
			document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygondeleteposbutton")).style.visibility = "hidden";
			document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposbutton")).style.visibility = "hidden";
		}
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_delete(i) {
// ポリゴン座標全削除
	insertyahoomap_polygon_deleteposs(i);
	var eleTable = document.getElementById("insertyahoomappolygon");
	var eleRow = document.getElementById("insertyahoomappolygon" + i);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標全削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_deleteposs(i) {
	var eleTable = document.getElementById("insertyahoomappolygon");
// ポリゴン座標
	var elePolygonpos = insertyahoomap_getelement("tr","^insertyahoomappolygonpos" + i + "_");
	for (var j=0;j<elePolygonpos.length;j++) {
		var eleRow = document.getElementById(elePolygonpos[j].id);
		eleTable.deleteRow(eleRow.sectionRowIndex);
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標削除
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_deletepos(i,j) {
	var eleTable = document.getElementById("insertyahoomappolygon");
	var eleRow = document.getElementById("insertyahoomappolygonpos" + i + "_" + j);
	eleTable.deleteRow(eleRow.sectionRowIndex);
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_load(i) {
	insertyahoomap_ymap = ymap;
	insertyahoomap_polygon_id = i;
	insertyahoomap_polygon_poss = "";
// ポリゴン座標
	var elePolygonpos = insertyahoomap_getelement("tr","^insertyahoomappolygonpos" + i + "_");
	for (var j=0;j<elePolygonpos.length;j++) {
		if (document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).value
		&&  document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).value) {
			insertyahoomap_polygon_poss += document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlat")).value;
			insertyahoomap_polygon_poss += ",";
			insertyahoomap_polygon_poss += document.getElementById(elePolygonpos[j].id.replace("insertyahoomappolygonpos","insertyahoomappolygonposlon")).value;
			insertyahoomap_polygon_poss += "\n";
		}
	}
// ポリゴン座標一括設定用画面作成
	var left = Math.round((screen.availWidth - 400) / 2);
	window.open(insertyahoomap_url + 'insertyahoomap-polygon.php','','top=200,left=' + left + ',width=400,height=300,toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes');
}
//************************************************************************************************************
// ポリライン座標一括設定
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定初期処理
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_onload() {
	document.getElementById("insertyahoomappolylineposs").value = insertyahoomap_polyline_poss;
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定決定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_enter() {
// ポリライン非表示
	window.opener.insertyahoomap_titlebar("polylinebar");
// ポリライン座標全削除
	window.opener.insertyahoomap_polyline_deleteposs(insertyahoomap_polyline_id);
	var posdatas = document.getElementById("insertyahoomappolylineposs").value.split(/\r\n|\n/);
	for (var i=0;i<posdatas.length;i++) {
		if (posdatas[i]) {
			var posdata = posdatas[i].split(",");
			if (posdata[0]
			&&  posdata[1]
			&&  insertyahoomap_isnumeric(posdata[0])
			&&  insertyahoomap_isnumeric(posdata[1])) {
				window.opener.insertyahoomap_polyline_pos_insert(insertyahoomap_polyline_id);
				window.opener.document.getElementById("insertyahoomappolylineposlat" + insertyahoomap_polyline_id + "_" + (i + 1)).value = posdata[0];
				window.opener.document.getElementById("insertyahoomappolylineposlon" + insertyahoomap_polyline_id + "_" + (i + 1)).value = posdata[1];
			}
		}
	}
// ポリライン表示
	window.opener.insertyahoomap_titlebar("polylinebar");
// ポリライン座標一括設定終了
	insertyahoomap_polyline_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定取消
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_cancel() {
// ポリライン座標一括設定終了
	insertyahoomap_polyline_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定終了
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_close() {
	window.close();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン座標一括設定作成
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_make() {
// ポリライン座標一括設定作成用データ
	insertyahoomap_categorys = window.opener.insertyahoomap_getelement("input","^insertyahoomapcategoryid");
	insertyahoomap_icons = window.opener.insertyahoomap_getelement("input","^insertyahoomapiconid");
	insertyahoomap_polyline_poss = document.getElementById("insertyahoomappolylineposs").value;
// ポリライン座標一括設定作成用画面作成
	window.open(insertyahoomap_url + 'insertyahoomap-polyline_make.php?appid=' + insertyahoomap_appid,'','toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes');
}
//************************************************************************************************************
// ポリライン作成
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// ポリライン用地図読み込み
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_make_onload() {
// 地図作成
	polylineposs = new Array();
	polylineicons = new Array();
	if (insertyahoomap_map_datum == "YDatumType.WGS84") {
		polylineymap = new YahooMapsCtrl("polylinemap",insertyahoomap_ymap.getCenter(),insertyahoomap_ymap.getCurrentLayer(),insertyahoomap_ymap.getCurrentMode(),YDatumType.WGS84);
	} else {
		polylineymap = new YahooMapsCtrl("polylinemap",insertyahoomap_ymap.getCenter(),insertyahoomap_ymap.getCurrentLayer(),insertyahoomap_ymap.getCurrentMode(),YDatumType.TOKYO97);
	}
// カテゴリー
	for (var i=0;i<insertyahoomap_categorys.length;i++) {
		if (window.opener.opener.document.getElementById(insertyahoomap_categorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked) {
			var index = insertyahoomap_categorys[i].id.replace("insertyahoomapcategoryid","");
			var id = window.opener.opener.document.getElementById("insertyahoomapcategoryid" + index).value;
			var img = window.opener.opener.document.getElementById("insertyahoomapcategoryimg" + index).value;
			var paramwidth = window.opener.opener.document.getElementById("insertyahoomapcategoryparamwidth" + index).value;
			var paramheight = window.opener.opener.document.getElementById("insertyahoomapcategoryparamheight" + index).value;
			var paramdx = window.opener.opener.document.getElementById("insertyahoomapcategoryparamdx" + index).value;
			var paramdy = window.opener.opener.document.getElementById("insertyahoomapcategoryparamdy" + index).value;
			var param = {"width":parseInt(paramwidth),"height":parseInt(paramheight),"dx":parseInt(paramdx),"dy":parseInt(paramdy)};
			polylineymap.addCategory(id,img,param);
		}
	}
	polylineymap.addCategory("insertyahoomappolylinecategorypoint",document.location.pathname.replace("insertyahoomap-polyline_make.php","images/point.gif"),{"width":5,"height":5,"dx":0,"dy":0});
// アイコン
	var j = 0;
	for (var i=0;i<insertyahoomap_icons.length;i++) {
		if (window.opener.opener.document.getElementById(insertyahoomap_icons[i].id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked) {
			var index = insertyahoomap_icons[i].id.replace("insertyahoomapiconid","");
			var id = window.opener.opener.document.getElementById("insertyahoomapiconid" + index).value;
			var poslat = window.opener.opener.document.getElementById("insertyahoomapiconposlat" + index).value;
			var poslon = window.opener.opener.document.getElementById("insertyahoomapiconposlon" + index).value;
			var pos = poslat + ',' + poslon;
			var popup = window.opener.opener.document.getElementById("insertyahoomapiconpopup" + index).value;
			var type = window.opener.opener.document.getElementById("insertyahoomapicontype" + index).value;
			var label = window.opener.opener.document.getElementById("insertyahoomapiconlabel" + index).value;
			j++;
			var eleTable = document.getElementById("insertyahoomapicon");
			var eleRow = eleTable.insertRow(-1);
			eleRow.id = "insertyahoomapicon" + j;
			var eleCell = eleRow.insertCell(-1);
			eleCell.rowSpan = '2';
			eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapiconenable' + j + '" onClick="javascript:insertyahoomap_polylineicon_enable_change(insertyahoomap_event_target(event));void(0);"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconid' + j + '" value="' + id + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlat' + j + '" value="' + poslat + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlon' + j + '" value="' + poslon + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapicontype' + j + '" value="' + type + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.rowSpan = '2';
			eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polylinemapSetPos(\'insertyahoomapiconpos' + j + '\');void(0);">表示</a>';
			eleRow = eleTable.insertRow(-1);
			eleCell = eleRow.insertCell(-1);
			eleCell.colSpan = '2';
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconpopup' + j + '" value="' + popup + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.colSpan = '2';
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconlabel' + j + '" value="' + label + '" readonly="true"/>';
		}
	}
	polylineymap.setVisibleCentermark(false);
	polylineymap.setVisibleCentermarkButton(false);
	polylineymap.addEvent(YEventType.MAP_CLICK,insertyahoomap_polylinemapclick);
	polylineymap.addEvent(YEventType.ICON_CLICK,insertyahoomap_polylineiconclick);
	polylineymap.addEvent(YEventType.MOUSE_MOVE,insertyahoomap_polylinemousemove);
	polylineymap.addEvent(YEventType.MOUSE_OUT,insertyahoomap_polylinemouseout);
// 初期表示データ設定
	var posdatas = insertyahoomap_polyline_poss.split(/\r\n|\n/);
	for (var i=0;i<posdatas.length;i++) {
		if (posdatas[i]) {
			polylineposs.push(new YLLPoint(posdatas[i]));
		}
	}
// アイコン表示
	insertyahoomap_polylineicons();
// ポリライン表示
	insertyahoomap_polylinelines();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用アイコン表示変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylineicon_enable_change(target) {
	var i = target.id.replace("insertyahoomapiconenable","");
	polylineymap.removeIcon(document.getElementById("insertyahoomapiconid" + i).value);
	if (target.checked) {
		var id = document.getElementById("insertyahoomapiconid" + i).value;
		var poslat = document.getElementById("insertyahoomapiconposlat" + i).value;
		var poslon = document.getElementById("insertyahoomapiconposlon" + i).value;
		var pos = poslat + ',' + poslon;
		var popup = document.getElementById("insertyahoomapiconpopup" + i).value;
		var type = document.getElementById("insertyahoomapicontype" + i).value;
		var label = document.getElementById("insertyahoomapiconlabel" + i).value;
		polylineymap.addIcon(id,pos,popup,type,label);
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用地図表示位置変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinemapSetPos(id) {
	insertyahoomap_mapSetPos(polylineymap,id);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用地図クリック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinemapclick(pos) {
// 位置退避
	polylineposs.push(pos);
// アイコン表示
	insertyahoomap_polylineicons();
// ポリライン表示
	insertyahoomap_polylinelines();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用アイコン表示
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylineicons(){
// アイコン削除
	for (var i=0;i<polylineicons.length;i++) {
		polylineymap.removeIcon(polylineicons[i]);
	}
	polylineicons = new Array();
	var icons = new Array();
	for (var i=0;i<polylineposs.length;i++) {
		polylineicons.push("insertyahoomappolylineicon" + i);
		var icon = new Object();
		icon.id = "insertyahoomappolylineicon" + i;
		icon.pos = polylineposs[i];
		icon.popup = "";
		icon.type = "insertyahoomappolylinecategorypoint";
		icons.push(icon);
	}
	polylineymap.addIcons(icons);
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用ポリライン表示
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinelines(){
	polylineymap.clearVectorObject();
	polylineymap.addPolyline("line",polylineposs,"",insertyahoomap_polylinestyle());
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用スタイル作成
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinestyle(){
	var i = insertyahoomap_polyline_id;
	var strokewidth = window.opener.opener.document.getElementById("insertyahoomappolylinestrokewidth" + i).value;
	if (strokewidth.length == 0) {
		strokewidth = 3;
	}
	var strokecolor = window.opener.opener.document.getElementById("insertyahoomappolylinestrokecolor" + i).value;
	if (strokecolor.length == 0) {
		strokecolor = "00ff00";
	}
	var strokeopacity = window.opener.opener.document.getElementById("insertyahoomappolylinestrokeopacity" + i).value;
	if (strokeopacity.length == 0) {
		strokeopacity = 1;
	}
	return {"strokeWidth":parseInt(strokewidth),"strokeColor":strokecolor,"strokeOpacity":parseFloat(strokeopacity)};
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用アイコンクリック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylineiconclick(id) {
	polylineposs.splice(id.replace("insertyahoomappolylineicon",""),1);
// アイコン表示
	insertyahoomap_polylineicons();
// ポリライン表示
	insertyahoomap_polylinelines();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用マウス移動
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinemousemove(pos) {
	if (polylineposs.length > 0) {
		var makingpos = new Array(pos,polylineposs[polylineposs.length-1]);
		polylineymap.addPolyline("making",makingpos,"",insertyahoomap_polylinestyle());
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用マウスアウト
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polylinemouseout() {
	polylineymap.removeVectorObject("making");
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用決定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_make_enter() {
	var posdatas = "";
	for (var i=0;i<polylineposs.length;i++) {
		posdatas += polylineposs[i].lat;
		posdatas += ",";
		posdatas += polylineposs[i].lon;
		posdatas += "\n";
	}
	window.opener.document.getElementById("insertyahoomappolylineposs").value = posdatas;
// ポリライン用終了
	insertyahoomap_polyline_make_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用取消
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_make_cancel() {
// ポリライン用終了
	insertyahoomap_polyline_make_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリライン用終了
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polyline_make_close() {
	window.close();
}
//************************************************************************************************************
// ポリゴン座標一括設定
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定初期処理
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_onload() {
	document.getElementById("insertyahoomappolygonposs").value = insertyahoomap_polygon_poss;
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定決定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_enter() {
// ポリゴン非表示
	window.opener.insertyahoomap_titlebar("polygonbar");
// ポリゴン座標全削除
	window.opener.insertyahoomap_polygon_deleteposs(insertyahoomap_polygon_id);
	var posdatas = document.getElementById("insertyahoomappolygonposs").value.split(/\r\n|\n/);
	for (var i=0;i<posdatas.length;i++) {
		if (posdatas[i]) {
			var posdata = posdatas[i].split(",");
			if (posdata[0]
			&&  posdata[1]
			&&  insertyahoomap_isnumeric(posdata[0])
			&&  insertyahoomap_isnumeric(posdata[1])) {
				window.opener.insertyahoomap_polygon_pos_insert(insertyahoomap_polygon_id);
				window.opener.document.getElementById("insertyahoomappolygonposlat" + insertyahoomap_polygon_id + "_" + (i + 1)).value = posdata[0];
				window.opener.document.getElementById("insertyahoomappolygonposlon" + insertyahoomap_polygon_id + "_" + (i + 1)).value = posdata[1];
			}
		}
	}
// ポリゴン表示
	window.opener.insertyahoomap_titlebar("polygonbar");
// ポリゴン座標一括設定終了
	insertyahoomap_polygon_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定取消
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_cancel() {
// ポリゴン座標一括設定終了
	insertyahoomap_polygon_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定終了
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_close() {
	window.close();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン座標一括設定作成
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_make() {
// ポリゴン座標一括設定作成用データ
	insertyahoomap_categorys = window.opener.insertyahoomap_getelement("input","^insertyahoomapcategoryid");
	insertyahoomap_icons = window.opener.insertyahoomap_getelement("input","^insertyahoomapiconid");
	insertyahoomap_polygon_poss = document.getElementById("insertyahoomappolygonposs").value;
// ポリゴン座標一括設定作成用画面作成
	window.open(insertyahoomap_url + 'insertyahoomap-polygon_make.php?appid=' + insertyahoomap_appid,'','toolbar=no,location=no,directories=no,status=yes,menubar=no,scrollbars=yes,resizable=yes');
}
//************************************************************************************************************
// ポリゴン作成
//************************************************************************************************************
//------------------------------------------------------------------------------------------------------------
// ポリゴン用地図読み込み
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_make_onload() {
// 地図作成
	polygonposs = new Array();
	polygonicons = new Array();
	if (insertyahoomap_map_datum == "YDatumType.WGS84") {
		polygonymap = new YahooMapsCtrl("polygonmap",insertyahoomap_ymap.getCenter(),insertyahoomap_ymap.getCurrentLayer(),insertyahoomap_ymap.getCurrentMode(),YDatumType.WGS84);
	} else {
		polygonymap = new YahooMapsCtrl("polygonmap",insertyahoomap_ymap.getCenter(),insertyahoomap_ymap.getCurrentLayer(),insertyahoomap_ymap.getCurrentMode(),YDatumType.TOKYO97);
	}
// カテゴリー
	for (var i=0;i<insertyahoomap_categorys.length;i++) {
		if (window.opener.opener.document.getElementById(insertyahoomap_categorys[i].id.replace("insertyahoomapcategoryid","insertyahoomapcategoryenable")).checked) {
			var index = insertyahoomap_categorys[i].id.replace("insertyahoomapcategoryid","");
			var id = window.opener.opener.document.getElementById("insertyahoomapcategoryid" + index).value;
			var img = window.opener.opener.document.getElementById("insertyahoomapcategoryimg" + index).value;
			var paramwidth = window.opener.opener.document.getElementById("insertyahoomapcategoryparamwidth" + index).value;
			var paramheight = window.opener.opener.document.getElementById("insertyahoomapcategoryparamheight" + index).value;
			var paramdx = window.opener.opener.document.getElementById("insertyahoomapcategoryparamdx" + index).value;
			var paramdy = window.opener.opener.document.getElementById("insertyahoomapcategoryparamdy" + index).value;
			var param = {"width":parseInt(paramwidth),"height":parseInt(paramheight),"dx":parseInt(paramdx),"dy":parseInt(paramdy)};
			polygonymap.addCategory(id,img,param);
		}
	}
	polygonymap.addCategory("insertyahoomappolygoncategorypoint",document.location.pathname.replace("insertyahoomap-polygon_make.php","images/point.gif"),{"width":5,"height":5,"dx":0,"dy":0});
// アイコン
	var j = 0;
	for (var i=0;i<insertyahoomap_icons.length;i++) {
		if (window.opener.opener.document.getElementById(insertyahoomap_icons[i].id.replace("insertyahoomapiconid","insertyahoomapiconenable")).checked) {
			var index = insertyahoomap_icons[i].id.replace("insertyahoomapiconid","");
			var id = window.opener.opener.document.getElementById("insertyahoomapiconid" + index).value;
			var poslat = window.opener.opener.document.getElementById("insertyahoomapiconposlat" + index).value;
			var poslon = window.opener.opener.document.getElementById("insertyahoomapiconposlon" + index).value;
			var pos = poslat + ',' + poslon;
			var popup = window.opener.opener.document.getElementById("insertyahoomapiconpopup" + index).value;
			var type = window.opener.opener.document.getElementById("insertyahoomapicontype" + index).value;
			var label = window.opener.opener.document.getElementById("insertyahoomapiconlabel" + index).value;
			j++;
			var eleTable = document.getElementById("insertyahoomapicon");
			var eleRow = eleTable.insertRow(-1);
			eleRow.id = "insertyahoomapicon" + j;
			var eleCell = eleRow.insertCell(-1);
			eleCell.rowSpan = '2';
			eleCell.innerHTML = '<input class="inputcheckbox" type="checkbox" id="insertyahoomapiconenable' + j + '" onClick="javascript:insertyahoomap_polygonicon_enable_change(insertyahoomap_event_target(event));void(0);"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconid' + j + '" value="' + id + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlat' + j + '" value="' + poslat + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconposlon' + j + '" value="' + poslon + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.innerHTML = '<input type="text" id="insertyahoomapicontype' + j + '" value="' + type + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.rowSpan = '2';
			eleCell.innerHTML = '<a class="button" href="javascript:insertyahoomap_polygonmapSetPos(\'insertyahoomapiconpos' + j + '\');void(0);">表示</a>';
			eleRow = eleTable.insertRow(-1);
			eleCell = eleRow.insertCell(-1);
			eleCell.colSpan = '2';
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconpopup' + j + '" value="' + popup + '" readonly="true"/>';
			eleCell = eleRow.insertCell(-1);
			eleCell.colSpan = '2';
			eleCell.innerHTML = '<input type="text" id="insertyahoomapiconlabel' + j + '" value="' + label + '" readonly="true"/>';
		}
	}
	polygonymap.setVisibleCentermark(false);
	polygonymap.setVisibleCentermarkButton(false);
	polygonymap.addEvent(YEventType.MAP_CLICK,insertyahoomap_polygonmapclick);
	polygonymap.addEvent(YEventType.ICON_CLICK,insertyahoomap_polygoniconclick);
	polygonymap.addEvent(YEventType.MOUSE_MOVE,insertyahoomap_polygonmousemove);
	polygonymap.addEvent(YEventType.MOUSE_OUT,insertyahoomap_polygonmouseout);
// 初期表示データ設定
	var posdatas = insertyahoomap_polygon_poss.split(/\r\n|\n/);
	for (var i=0;i<posdatas.length;i++) {
		if (posdatas[i]) {
			polygonposs.push(new YLLPoint(posdatas[i]));
		}
	}
// アイコン表示
	insertyahoomap_polygonicons();
// ポリゴン表示
	insertyahoomap_polygonarea();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用アイコン表示変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonicon_enable_change(target) {
	var i = target.id.replace("insertyahoomapiconenable","");
	polygonymap.removeIcon(document.getElementById("insertyahoomapiconid" + i).value);
	if (target.checked) {
		var id = document.getElementById("insertyahoomapiconid" + i).value;
		var poslat = document.getElementById("insertyahoomapiconposlat" + i).value;
		var poslon = document.getElementById("insertyahoomapiconposlon" + i).value;
		var pos = poslat + ',' + poslon;
		var popup = document.getElementById("insertyahoomapiconpopup" + i).value;
		var type = document.getElementById("insertyahoomapicontype" + i).value;
		var label = document.getElementById("insertyahoomapiconlabel" + i).value;
		polygonymap.addIcon(id,pos,popup,type,label);
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用地図表示位置変更
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonmapSetPos(id) {
	insertyahoomap_mapSetPos(polygonymap,id);
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用地図クリック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonmapclick(pos) {
// 位置退避
	polygonposs.push(pos);
// アイコン表示
	insertyahoomap_polygonicons();
// ポリゴン表示
	insertyahoomap_polygonarea();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用アイコン表示
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonicons(){
// アイコン削除
	for (var i=0;i<polygonicons.length;i++) {
		polygonymap.removeIcon(polygonicons[i]);
	}
	polygonicons = new Array();
	var icons = new Array();
	for (var i=0;i<polygonposs.length;i++) {
		polygonicons.push("insertyahoomappolygonicon" + i);
		var icon = new Object();
		icon.id = "insertyahoomappolygonicon" + i;
		icon.pos = polygonposs[i];
		icon.popup = "";
		icon.type = "insertyahoomappolygoncategorypoint";
		icons.push(icon);
	}
	polygonymap.addIcons(icons);
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用ポリゴン表示
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonarea(){
	polygonymap.clearVectorObject();
	polygonymap.addPolygon("area",polygonposs,"",insertyahoomap_polygonstyle('area'));
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用スタイル作成
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonstyle(type){
	var i = insertyahoomap_polygon_id;
	var strokewidth = window.opener.opener.document.getElementById("insertyahoomappolygonstrokewidth" + i).value;
	if (strokewidth.length == 0) {
		strokewidth = 3;
	}
	var strokecolor = window.opener.opener.document.getElementById("insertyahoomappolygonstrokecolor" + i).value;
	if (strokecolor.length == 0) {
		strokecolor = "00ff00";
	}
	var strokeopacity = window.opener.opener.document.getElementById("insertyahoomappolygonstrokeopacity" + i).value;
	if (strokeopacity.length == 0) {
		strokeopacity = 1;
	}
	var fillcolor = window.opener.opener.document.getElementById("insertyahoomappolygonfillcolor" + i).value;
	if (fillcolor.length == 0) {
		fillcolor = "0000ff";
	}
	var fillopacity = window.opener.opener.document.getElementById("insertyahoomappolygonfillopacity" + i).value;
	if (fillopacity.length == 0) {
		fillopacity = 0.5;
	}
	if (type == "area") {
		return {"strokeWidth":parseInt(strokewidth),"strokeColor":strokecolor,"strokeOpacity":parseFloat(strokeopacity),"fillColor":fillcolor,"fillOpacity":parseFloat(fillopacity)};
	} else {
		return {"strokeWidth":parseInt(strokewidth),"strokeColor":strokecolor,"strokeOpacity":parseFloat(strokeopacity)};
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用アイコンクリック
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygoniconclick(id) {
	polygonposs.splice(id.replace("insertyahoomappolygonicon",""),1);
// アイコン表示
	insertyahoomap_polygonicons();
// ポリゴン表示
	insertyahoomap_polygonarea();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用マウス移動
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonmousemove(pos) {
	if (polygonposs.length == 1) {
		var makingpos = new Array(pos,polygonposs[polygonposs.length-1]);
		polygonymap.addPolyline("making",makingpos,"",insertyahoomap_polygonstyle('line'));
	}
	if (polygonposs.length >= 2) {
		var makingpos = new Array(polygonposs[0],pos,polygonposs[polygonposs.length-1]);
		polygonymap.addPolyline("making",makingpos,"",insertyahoomap_polygonstyle('line'));
	}
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用マウスアウト
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygonmouseout() {
	polygonymap.removeVectorObject("making");
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用決定
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_make_enter() {
	var posdatas = "";
	for (var i=0;i<polygonposs.length;i++) {
		posdatas += polygonposs[i].lat;
		posdatas += ",";
		posdatas += polygonposs[i].lon;
		posdatas += "\n";
	}
	window.opener.document.getElementById("insertyahoomappolygonposs").value = posdatas;
// ポリゴン用終了
	insertyahoomap_polygon_make_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用取消
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_make_cancel() {
// ポリゴン用終了
	insertyahoomap_polygon_make_close();
}
//------------------------------------------------------------------------------------------------------------
// ポリゴン用終了
//------------------------------------------------------------------------------------------------------------
function insertyahoomap_polygon_make_close() {
	window.close();
}
