/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import org.tanukisoftware.wrapper.WrapperActionServer;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.test.AbstractActionApp;

public class Main
extends AbstractActionApp
implements WrapperListener {
    private WrapperActionServer m_actionServer;
    private MainFrame m_frame;
    private ActionRunner m_actionRunner;
    private List m_listenerFlags;
    private TextField m_serviceName;
    private TextField m_childCommand;
    private Checkbox m_childDetached;

    private Main() {
    }

    public Integer start(String[] args) {
        String command;
        System.out.println("TestWrapper: start()");
        this.prepareSystemOutErr();
        if (args.length <= 0) {
            System.out.println("TestWrapper: An action was not specified.  Default to \"dialog\".  Use \"help\" for list of actions.");
            command = "dialog";
        } else {
            command = args[0];
        }
        if (command.equals("help")) {
            Main.printHelp(null);
            return null;
        }
        try {
            int port = 9999;
            this.m_actionServer = new WrapperActionServer(port);
            this.m_actionServer.enableShutdownAction(true);
            this.m_actionServer.enableHaltExpectedAction(true);
            this.m_actionServer.enableRestartAction(true);
            this.m_actionServer.enableThreadDumpAction(true);
            this.m_actionServer.enableHaltUnexpectedAction(true);
            this.m_actionServer.enableAccessViolationAction(true);
            this.m_actionServer.enableAppearHungAction(true);
            this.m_actionServer.start();
            System.out.println("TestWrapper: ActionServer Enabled. ");
            System.out.println("TestWrapper:   Telnet localhost 9999");
            System.out.println("TestWrapper:   Commands: ");
            System.out.println("TestWrapper:     S: Shutdown");
            System.out.println("TestWrapper:     H: Expected Halt");
            System.out.println("TestWrapper:     R: Restart");
            System.out.println("TestWrapper:     D: Thread Dump");
            System.out.println("TestWrapper:     U: Unexpected Halt (Simulate crash)");
            System.out.println("TestWrapper:     V: Access Violation (Actual crash)");
            System.out.println("TestWrapper:     G: Make the JVM appear to be hung.");
            System.out.println("TestWrapper:");
        }
        catch (IOException e) {
            System.out.println("TestWrapper: Unable to open the action server socket: " + e.getMessage());
            System.out.println("TestWrapper:");
            this.m_actionServer = null;
        }
        if (command.equals("dialog")) {
            System.out.println("TestWrapper: Showing dialog...");
            try {
                this.m_frame = new MainFrame();
                this.m_frame.setVisible(true);
            }
            catch (InternalError e) {
                System.out.println("TestWrapper: ");
                System.out.println("TestWrapper: ERROR - Unable to display the GUI:");
                System.out.println("TestWrapper:           " + e.toString());
                System.out.println("TestWrapper: ");
                System.out.println("TestWrapper: Fall back to the \"console\" action.");
                command = "console";
            }
            catch (AWTError e) {
                System.out.println("TestWrapper: ");
                System.out.println("TestWrapper: ERROR - Unable to display the GUI:");
                System.out.println("TestWrapper:           " + e.toString());
                System.out.println("TestWrapper: ");
                System.out.println("TestWrapper: Fall back to the \"console\" action.");
                command = "console";
            }
            catch (UnsupportedOperationException e) {
                if (e.getClass().getName().equals("java.awt.HeadlessException")) {
                    System.out.println("TestWrapper: ");
                    System.out.println("TestWrapper: ERROR - Unable to display the GUI:");
                    System.out.println("TestWrapper:           " + e.toString());
                    System.out.println("TestWrapper: ");
                    System.out.println("TestWrapper: Fall back to the \"console\" action.");
                    command = "console";
                }
                throw e;
            }
        }
        if (!command.equals("dialog")) {
            this.m_actionRunner = new ActionRunner(command);
            Thread actionThread = new Thread(this.m_actionRunner);
            actionThread.start();
        }
        return null;
    }

    public int stop(int exitCode) {
        System.out.println("TestWrapper: stop(" + exitCode + ")");
        if (this.m_actionServer != null) {
            try {
                this.m_actionServer.stop();
            }
            catch (Exception e) {
                System.out.println("TestWrapper: Unable to stop the action server: " + e.getMessage());
            }
        }
        if (this.m_frame != null) {
            if (!WrapperManager.hasShutdownHookBeenTriggered()) {
                this.m_frame.setVisible(false);
                this.m_frame.dispose();
            }
            this.m_frame = null;
        }
        if (this.isNestedExit()) {
            System.out.println("TestWrapper: calling System.exit(" + exitCode + ") within stop.");
            System.exit(exitCode);
        }
        return exitCode;
    }

    public void controlEvent(int event) {
        System.out.println("TestWrapper: controlEvent(" + event + ")");
        if (event == 202) {
            if (WrapperManager.isLaunchedAsService() || WrapperManager.isIgnoreUserLogoffs()) {
                System.out.println("TestWrapper:   Ignoring logoff event");
            } else if (!this.ignoreControlEvents()) {
                WrapperManager.stop((int)0);
            }
        } else if (event == 200) {
            if (!this.ignoreControlEvents() && this.m_actionRunner != null) {
                this.m_actionRunner.endThread();
            }
        } else if (!this.ignoreControlEvents()) {
            WrapperManager.stop((int)0);
        }
    }

    private static void printHelp(String errorMsg) {
        System.err.println("USAGE");
        System.err.println("");
        System.err.println("TestWrapper <action>");
        Main.printActions();
        System.err.println("  Interactive:");
        System.err.println("   dialog                   : Shows the dialog interface");
        System.err.println("[EXAMPLE]");
        System.err.println("   TestAction access_violation_native ");
        System.err.println("");
        if (errorMsg != null) {
            System.err.println("ERROR: " + errorMsg);
            System.err.println("");
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("TestWrapper: Initializing...");
        WrapperManager.start((WrapperListener)new Main(), (String[])args);
    }

    private class ActionRunner
    implements Runnable {
        private String m_action;
        private boolean m_alive;

        public ActionRunner(String action) {
            this.m_action = action;
            this.m_alive = true;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (!Main.this.doAction(this.m_action)) {
                Main.printHelp("\"" + this.m_action + "\" is an unknown action.");
                WrapperManager.stop((int)0);
                return;
            }
            while (this.m_alive) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void endThread() {
            this.m_alive = false;
        }
    }

    private class MainFrame
    extends Frame
    implements ActionListener,
    WindowListener {
        private static final long serialVersionUID = -3847376282833547574L;

        MainFrame() {
            super("Wrapper Test Application");
            this.init();
            this.setLocation(10, 10);
            this.setSize(750, 480);
            this.setResizable(true);
        }

        private void init() {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            Panel panel = new Panel();
            panel.setLayout(gridBag);
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.add(panel);
            scrollPane.getHAdjustable().setUnitIncrement(20);
            scrollPane.getVAdjustable().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.buildCommand(panel, gridBag, c, "Stop(0)", "stop0", "Calls WrapperManager.stop( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Stop(1)", "stop1", "Calls WrapperManager.stop( 1 ) to shutdown the JVM and Wrapper with a failure exit code.");
            this.buildCommand(panel, gridBag, c, "Exit(0)", "exit0", "Calls System.exit( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Exit(1)", "exit1", "Calls System.exit( 1 ) to shutdown the JVM and Wrapper with a failure exit code.");
            this.buildCommand(panel, gridBag, c, "StopImmediate(0)", "stopimmediate0", "Calls WrapperManager.stopImmediate( 0 ) to immediately shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "StopImmediate(1)", "stopimmediate1", "Calls WrapperManager.stopImmediate( 1 ) to immediately shutdown the JVM and Wrapper with a failure exir code.");
            this.buildCommand(panel, gridBag, c, "StopAndReturn(0)", "stopandreturn0", "Calls WrapperManager.stopAndReturn( 0 ) to shutdown the JVM and Wrapper with a success exit code.");
            this.buildCommand(panel, gridBag, c, "Nested Exit(1)", "nestedexit1", "Calls System.exit(1) within WrapperListener.stop(1) callback.");
            this.buildCommand(panel, gridBag, c, "Halt(0)", "halt0", "Calls Runtime.getRuntime().halt(0) to kill the JVM, the Wrapper will restart it.");
            this.buildCommand(panel, gridBag, c, "Halt(1)", "halt1", "Calls Runtime.getRuntime().halt(1) to kill the JVM, the Wrapper will restart it.");
            this.buildCommand(panel, gridBag, c, "Restart()", "restart", "Calls WrapperManager.restart() to shutdown the current JVM and start a new one.");
            this.buildCommand(panel, gridBag, c, "RestartAndReturn()", "restartandreturn", "Calls WrapperManager.restartAndReturn() to shutdown the current JVM and start a new one.");
            this.buildCommand(panel, gridBag, c, "Access Violation", "access_violation", "Attempts to cause an access violation within the JVM, relies on a JVM bug and may not work.");
            this.buildCommand(panel, gridBag, c, "Native Access Violation", "access_violation_native", "Causes an access violation using native code, the JVM will crash and be restarted.");
            this.buildCommand(panel, gridBag, c, "Simulate JVM Hang", "appear_hung", "Makes the JVM appear to be hung as viewed from the Wrapper, it will be killed and restarted.");
            this.buildCommand(panel, gridBag, c, "Simulate Wrapper Crash", "appear_orphan", "Makes the JVM appear to have been orphaned to simulate the case where the Wrapper has crashed.  The JVM will shut itself down.");
            this.buildCommand(panel, gridBag, c, "Ignore Control Events", "ignore_events", "Makes this application ignore control events.  It will not shutdown in response to CTRL-C.  The Wrapper will still respond.");
            this.buildCommand(panel, gridBag, c, "Request Thread Dump", "dump", "Calls WrapperManager.requestThreadDump() to cause the JVM to dump its current thread state.");
            this.buildCommand(panel, gridBag, c, "System.out Deadlock", "deadlock_out", "Simulates a failure mode where the System.out object has become deadlocked.");
            this.buildCommand(panel, gridBag, c, "Poll Users", "users", "Begins calling WrapperManager.getUser() and getInteractiveUser() to monitor the current and interactive users.");
            this.buildCommand(panel, gridBag, c, "Poll Users with Groups", "groups", "Same as above, but includes information about the user's groups.");
            this.buildCommand(panel, gridBag, c, "Console", "console", "Prompt for Actions in the console.");
            this.buildCommand(panel, gridBag, c, "Idle", "idle", "Run idly.");
            this.buildCommand(panel, gridBag, c, "Dump Properties", "properties", "Dumps all System Properties to the console.");
            this.buildCommand(panel, gridBag, c, "Dump Configuration", "configuration", "Dumps all Wrapper Configuration Properties to the console.");
            Main.this.m_listenerFlags = new List(2, true);
            Main.this.m_listenerFlags.add("Service");
            Main.this.m_listenerFlags.add("Control");
            Main.this.m_listenerFlags.add("Logging");
            Main.this.m_listenerFlags.add("Core");
            Panel flagPanel = new Panel();
            flagPanel.setLayout(new BorderLayout());
            flagPanel.add((Component)new Label("Event Flags: "), "West");
            flagPanel.add((Component)Main.this.m_listenerFlags, "Center");
            flagPanel.setSize(100, 10);
            Panel flagPanel2 = new Panel();
            flagPanel2.setLayout(new BorderLayout());
            flagPanel2.add((Component)flagPanel, "West");
            this.buildCommand(panel, gridBag, c, "Update Event Listener", "listener", flagPanel2);
            this.buildCommand(panel, gridBag, c, "Service List", "service_list", "Displays a list of registered services on Windows.");
            Main.this.m_serviceName = new TextField("testwrapper");
            Panel servicePanel = new Panel();
            servicePanel.setLayout(new BorderLayout());
            servicePanel.add((Component)new Label("Interrogate Service.  Service name: "), "West");
            servicePanel.add((Component)Main.this.m_serviceName, "Center");
            Panel servicePanel2 = new Panel();
            servicePanel2.setLayout(new BorderLayout());
            servicePanel2.add((Component)servicePanel, "West");
            this.buildCommand(panel, gridBag, c, "Service Interrogate", "service_interrogate", servicePanel2);
            this.buildCommand(panel, gridBag, c, "Service Start", "service_start", "Starts the above service.");
            this.buildCommand(panel, gridBag, c, "Service Stop", "service_stop", "Stops the above service.");
            this.buildCommand(panel, gridBag, c, "Service User Code", "service_user", "Sends a series of user codes to the above service.");
            Main.this.m_childCommand = new TextField("(Please enter command)");
            Main.this.m_childDetached = new Checkbox("Detached", false);
            Panel childPanel = new Panel();
            childPanel.setLayout(new BorderLayout());
            childPanel.add((Component)new Label("Command: "), "West");
            childPanel.add((Component)Main.this.m_childCommand, "Center");
            childPanel.add((Component)Main.this.m_childDetached, "East");
            Panel childPanel2 = new Panel();
            childPanel2.setLayout(new BorderLayout());
            childPanel2.add((Component)childPanel, "West");
            this.buildCommand(panel, gridBag, c, "Execute Child", "child_exec", childPanel2);
            this.buildCommand(panel, gridBag, c, "GC", "gc", "Performs a GC sweep.");
            this.buildCommand(panel, gridBag, c, "Is Professional?", "is_professional", "Prints true if this is a Professional Edition.");
            this.buildCommand(panel, gridBag, c, "Is Standard?", "is_standard", "Prints true if this is a Standard Edition.");
            this.addWindowListener(this);
        }

        private void buildCommand(Container container, GridBagLayout gridBag, GridBagConstraints c, String label, String command, Object description) {
            Button button = new Button(label);
            button.setActionCommand(command);
            c.fill = 1;
            c.gridwidth = 1;
            gridBag.setConstraints(button, c);
            container.add(button);
            button.addActionListener(this);
            c.gridwidth = 0;
            Component desc = description instanceof String ? new Label((String)description) : (description instanceof Component ? (Component)description : new Label(description.toString()));
            gridBag.setConstraints(desc, c);
            container.add(desc);
        }

        public void actionPerformed(ActionEvent event) {
            String action = event.getActionCommand();
            if (action.equals("listener")) {
                long mask = 0L;
                String[] flags = Main.this.m_listenerFlags.getSelectedItems();
                for (int i = 0; i < flags.length; ++i) {
                    String flag = flags[i];
                    if (flag.equals("Service")) {
                        mask |= 1L;
                        continue;
                    }
                    if (flag.equals("Control")) {
                        mask |= 2L;
                        continue;
                    }
                    if (flag.equals("Logging")) {
                        mask |= 4L;
                        continue;
                    }
                    if (!flag.equals("Core")) continue;
                    mask |= 0xF000000000000000L;
                }
                Main.this.setEventMask(mask);
            }
            Main.this.setServiceName(Main.this.m_serviceName.getText());
            Main.this.setChildParams(Main.this.m_childCommand.getText(), Main.this.m_childDetached.getState());
            Main.this.doAction(action);
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            WrapperManager.stopAndReturn((int)0);
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    }
}

