/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.test.DeadlockPrintStream;

public abstract class AbstractActionApp
implements WrapperEventListener {
    private DeadlockPrintStream m_out;
    private DeadlockPrintStream m_err;
    private Thread m_runner = new Thread("WrapperActionTest_Runner"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                if (AbstractActionApp.this.m_users) {
                    System.out.println("The current user is: " + WrapperManager.getUser((boolean)AbstractActionApp.this.m_groups));
                    System.out.println("The current interactive user is: " + WrapperManager.getInteractiveUser((boolean)AbstractActionApp.this.m_groups));
                }
                Class clazz = class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp;
                synchronized (clazz) {
                    try {
                        (class$org$tanukisoftware$wrapper$test$AbstractActionApp == null ? AbstractActionApp.class$("org.tanukisoftware.wrapper.test.AbstractActionApp") : class$org$tanukisoftware$wrapper$test$AbstractActionApp).wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    private Thread m_consoleRunner;
    private boolean m_ignoreControlEvents;
    private boolean m_users;
    private boolean m_groups;
    private boolean m_nestedExit;
    private long m_eventMask = -1L;
    private String m_serviceName = "testWrapper";
    private String m_childCommand = "ls";
    private boolean m_childDetached = true;

    protected AbstractActionApp() {
        this.m_runner.setDaemon(true);
        this.m_runner.start();
    }

    public void fired(WrapperEvent event) {
        System.out.println("Received event: " + event);
        if (event instanceof WrapperControlEvent) {
            System.out.println("  Consume and ignore.");
            ((WrapperControlEvent)event).consume();
        }
    }

    protected boolean ignoreControlEvents() {
        return this.m_ignoreControlEvents;
    }

    protected boolean isNestedExit() {
        return this.m_nestedExit;
    }

    protected void setEventMask(long eventMask) {
        this.m_eventMask = eventMask;
    }

    protected void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    protected void setChildParams(String childCommand, boolean childDetached) {
        this.m_childCommand = childCommand;
        this.m_childDetached = childDetached;
    }

    protected void prepareSystemOutErr() {
        this.m_out = new DeadlockPrintStream(System.out);
        System.setOut(this.m_out);
        this.m_err = new DeadlockPrintStream(System.err);
        System.setErr(this.m_err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAction(String action) {
        if (action.equals("stop0")) {
            WrapperManager.stop((int)0);
        } else if (action.equals("stop1")) {
            WrapperManager.stop((int)1);
        } else if (action.equals("exit0")) {
            System.exit(0);
        } else if (action.equals("exit1")) {
            System.exit(1);
        } else if (action.equals("nestedexit1")) {
            this.m_nestedExit = true;
            WrapperManager.stop((int)1);
        } else if (action.equals("stopimmediate0")) {
            WrapperManager.stopImmediate((int)0);
        } else if (action.equals("stopimmediate1")) {
            WrapperManager.stopImmediate((int)1);
        } else if (action.equals("stopandreturn0")) {
            WrapperManager.stopAndReturn((int)0);
        } else if (action.equals("halt0")) {
            Method haltMethod;
            try {
                haltMethod = Runtime.class.getMethod("halt", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                System.out.println("halt not supported by current JVM.");
                haltMethod = null;
            }
            if (haltMethod != null) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    haltMethod.invoke((Object)runtime, new Integer(0));
                }
                catch (IllegalAccessException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
            }
        } else if (action.equals("halt1")) {
            Method haltMethod;
            try {
                haltMethod = Runtime.class.getMethod("halt", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                System.out.println("halt not supported by current JVM.");
                haltMethod = null;
            }
            if (haltMethod != null) {
                Runtime runtime = Runtime.getRuntime();
                try {
                    haltMethod.invoke((Object)runtime, new Integer(1));
                }
                catch (IllegalAccessException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    System.out.println("Unable to call runitme.halt: " + e.getMessage());
                }
            }
        } else if (action.equals("restart")) {
            WrapperManager.restart();
        } else if (action.equals("restartandreturn")) {
            WrapperManager.restartAndReturn();
        } else if (action.equals("access_violation")) {
            WrapperManager.accessViolation();
        } else if (action.equals("access_violation_native")) {
            WrapperManager.accessViolationNative();
        } else if (action.equals("appear_hung")) {
            WrapperManager.appearHung();
        } else if (action.equals("appear_orphan")) {
            WrapperManager.appearOrphan();
        } else if (action.equals("ignore_events")) {
            this.m_ignoreControlEvents = true;
        } else if (action.equals("dump")) {
            WrapperManager.requestThreadDump();
        } else if (action.equals("deadlock_out")) {
            System.out.println("Deadlocking System.out and System.err ...");
            this.m_out.setDeadlock(true);
            this.m_err.setDeadlock(true);
        } else if (action.equals("users")) {
            if (!this.m_users) {
                System.out.println("Begin polling the current and interactive users.");
                this.m_users = true;
            } else if (this.m_groups) {
                System.out.println("Stop polling for group info.");
                this.m_groups = false;
            } else {
                System.out.println("Stop polling the current and interactive users.");
                this.m_users = false;
            }
            Class haltMethod = AbstractActionApp.class;
            synchronized (haltMethod) {
                AbstractActionApp.class.notifyAll();
            }
        } else if (action.equals("groups")) {
            if (!this.m_users || !this.m_groups) {
                System.out.println("Begin polling the current and interactive users with group info.");
                this.m_users = true;
                this.m_groups = true;
            } else {
                System.out.println("Stop polling for group info.");
                this.m_groups = false;
            }
            Class haltMethod = AbstractActionApp.class;
            synchronized (haltMethod) {
                AbstractActionApp.class.notifyAll();
            }
        } else if (action.equals("console")) {
            if (this.m_consoleRunner == null) {
                this.m_consoleRunner = new Thread("console-runner"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        System.out.println();
                        System.out.println("Start prompting for actions.");
                        try {
                            BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                            try {
                                while (true) {
                                    System.out.println("Input an action ('help' for a list of actions):");
                                    String line = r.readLine();
                                    if (line == null || line.equals("")) continue;
                                    System.out.println("Read action: " + line);
                                    if (AbstractActionApp.this.doAction(line)) continue;
                                    if (!line.equals("help")) {
                                        System.out.println("Unknown action: " + line);
                                    }
                                    AbstractActionApp.printActions();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                Object var5_4 = null;
                                System.out.println("Stop prompting for actions.");
                                System.out.println();
                                AbstractActionApp.this.m_consoleRunner = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            System.out.println("Stop prompting for actions.");
                            System.out.println();
                            AbstractActionApp.this.m_consoleRunner = null;
                            throw throwable;
                        }
                    }
                };
                this.m_consoleRunner.setDaemon(true);
                this.m_consoleRunner.start();
            }
        } else if (action.equals("idle")) {
            System.out.println("Run idle.");
            this.m_users = false;
            this.m_groups = false;
            Class haltMethod = AbstractActionApp.class;
            synchronized (haltMethod) {
                AbstractActionApp.class.notifyAll();
            }
        } else if (action.equals("properties")) {
            System.out.println("Dump System Properties:");
            Properties props = System.getProperties();
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                System.out.println("  " + name + "=" + props.getProperty(name));
            }
            System.out.println();
        } else if (action.equals("configuration")) {
            System.out.println("Dump Wrapper Properties:");
            Properties props = WrapperManager.getProperties();
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                System.out.println("  " + name + "=" + props.getProperty(name));
            }
            System.out.println();
        } else if (action.equals("listener")) {
            System.out.println("Updating Event Listeners:");
            WrapperManager.removeWrapperEventListener((WrapperEventListener)this);
            WrapperManager.addWrapperEventListener((WrapperEventListener)this, (long)this.m_eventMask);
        } else if (action.equals("service_list")) {
            WrapperWin32Service[] services = WrapperManager.listServices();
            if (services == null) {
                System.out.println("Services not supported by current platform.");
            } else {
                System.out.println("Registered Services:");
                for (int i = 0; i < services.length; ++i) {
                    System.out.println("  " + services[i]);
                }
            }
        } else if (action.equals("service_interrogate")) {
            try {
                WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)4);
                System.out.println("Service after interrogate: " + service);
            }
            catch (WrapperServiceException e) {
                e.printStackTrace();
            }
        } else if (action.equals("service_start")) {
            try {
                WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)65536);
                System.out.println("Service after start: " + service);
            }
            catch (WrapperServiceException e) {
                e.printStackTrace();
            }
        } else if (action.equals("service_stop")) {
            try {
                WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)1);
                System.out.println("Service after stop: " + service);
            }
            catch (WrapperServiceException e) {
                e.printStackTrace();
            }
        } else if (action.equals("service_user")) {
            try {
                for (int i = 128; i < 256; i += 10) {
                    WrapperWin32Service service = WrapperManager.sendServiceControlCode((String)this.m_serviceName, (int)i);
                    System.out.println("Service after user code " + i + ": " + service);
                }
            }
            catch (WrapperServiceException e) {
                e.printStackTrace();
            }
        } else if (action.equals("child_exec")) {
            Thread childRunner = new Thread(){

                public void run() {
                    try {
                        WrapperProcessConfig wpConfig = new WrapperProcessConfig();
                        wpConfig.setDetached(AbstractActionApp.this.m_childDetached);
                        WrapperProcess wProcess = WrapperManager.exec((String)AbstractActionApp.this.m_childCommand, (WrapperProcessConfig)wpConfig);
                        System.out.println("Launched child with PID=" + wProcess.getPID() + " : " + AbstractActionApp.this.m_childCommand);
                        Thread outRunner = new Thread(this, wProcess){
                            private final /* synthetic */ WrapperProcess val$wProcess;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$wProcess = val$wProcess;
                            }

                            public void run() {
                                try {
                                    String line;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(this.val$wProcess.getInputStream()));
                                    while ((line = br.readLine()) != null) {
                                        System.out.println(this.val$wProcess.getPID() + " out: " + line);
                                    }
                                    br.close();
                                    System.out.println(this.val$wProcess.getPID() + " out EOF");
                                }
                                catch (IOException e) {
                                    System.out.println(this.val$wProcess.getPID() + " read out failed:");
                                    e.printStackTrace();
                                }
                            }
                        };
                        Thread errRunner = new Thread(this, wProcess){
                            private final /* synthetic */ WrapperProcess val$wProcess;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$wProcess = val$wProcess;
                            }

                            public void run() {
                                try {
                                    String line;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(this.val$wProcess.getErrorStream()));
                                    while ((line = br.readLine()) != null) {
                                        System.out.println(this.val$wProcess.getPID() + " err: " + line);
                                    }
                                    br.close();
                                    System.out.println(this.val$wProcess.getPID() + " err EOF");
                                }
                                catch (IOException e) {
                                    System.out.println(this.val$wProcess.getPID() + " read err failed:");
                                    e.printStackTrace();
                                }
                            }
                        };
                        outRunner.start();
                        errRunner.start();
                        outRunner.join();
                        errRunner.join();
                        System.out.println("Child with PID=" + wProcess.getPID() + " terminated with exitCode=" + wProcess.waitFor() + " : " + AbstractActionApp.this.m_childCommand);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            };
            childRunner.start();
        } else if (action.equals("gc")) {
            System.out.println("Begin GC...");
            System.gc();
            System.out.println("GC complete.");
        } else if (action.equals("is_professional")) {
            System.out.println("Professional Edition: " + WrapperManager.isProfessionalEdition());
        } else if (action.equals("is_standard")) {
            System.out.println("Standard Edition: " + WrapperManager.isStandardEdition());
        } else {
            return false;
        }
        return true;
    }

    protected static void printActions() {
        System.err.println("");
        System.err.println("[ACTIONS]");
        System.err.println("   help                     : Shows this help message");
        System.err.println("  Actions which should cause the Wrapper to exit cleanly:");
        System.err.println("   stop0                    : Calls WrapperManager.stop(0)");
        System.err.println("   exit0                    : Calls System.exit(0)");
        System.err.println("   stopimmediate0           : Calls WrapperManager.stopImmediate(0)");
        System.err.println("   stopandreturn0           : Calls WrapperManager.stopAndReturn(0)");
        System.err.println("  Actions which should cause the Wrapper to exit in an error state:");
        System.err.println("   stop1                    : Calls WrapperManager.stop(1)");
        System.err.println("   exit1                    : Calls System.exit(1)");
        System.err.println("   nestedexit1              : Calls System.exit(1) within WrapperListener.stop(1) callback");
        System.err.println("   stopimmediate1           : Calls WrapperManager.stopImmediate(1)");
        System.err.println("  Actions which should cause the Wrapper to restart the JVM:");
        System.err.println("   access_violation         : Calls WrapperManager.accessViolation");
        System.err.println("   access_violation_native  : Calls WrapperManager.accessViolationNative()");
        System.err.println("   appear_hung              : Calls WrapperManager.appearHung()");
        System.err.println("   halt0                    : Calls Runtime.getRuntime().halt(0)");
        System.err.println("   halt1                    : Calls Runtime.getRuntime().halt(1)");
        System.err.println("   restart                  : Calls WrapperManager.restart()");
        System.err.println("   restartandreturn         : Calls WrapperManager.restartAndReturn()");
        System.err.println("  Additional Tests:");
        System.err.println("   ignore_events            : Makes this application ignore control events.");
        System.err.println("   dump                     : Calls WrapperManager.requestThreadDump()");
        System.err.println("   deadlock_out             : Deadlocks the JVM's System.out and err streams.");
        System.err.println("   users                    : Start polling the current and interactive users.");
        System.err.println("   groups                   : Start polling the current and interactive users with groups.");
        System.err.println("   console                  : Prompt for actions in the console.");
        System.err.println("   idle                     : Do nothing just run in idle mode.");
        System.err.println("   properties               : Dump all System Properties to the console.");
        System.err.println("   configuration            : Dump all Wrapper Configuration Properties to the console.");
        System.err.println("   gc                       : Perform a GC sweep.");
        System.err.println("");
    }
}

