/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.tanukisoftware.wrapper.demo.DemoApp;
import org.tanukisoftware.wrapper.demo.ExtensionFilter;

class CustomizeDialog
extends JDialog {
    private static final long serialVersionUID = -5258541969990785046L;
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JButton jButton1 = new JButton();
    private JButton jButton2 = new JButton();
    private JButton jButton3 = new JButton();
    private JButton jButton4 = new JButton();
    private JButton jButton5 = new JButton();
    private JTextField jTextField1 = new JTextField();
    private JTextField jTextField2 = new JTextField();
    private JTextField jTextField3 = new JTextField();
    private JSeparator jSeparator1 = new JSeparator();
    private String selectedSource;
    private String selectedIcon;
    private String selectedSplashScreen;
    private String selectedDestination;
    private int result;

    public int getResult() {
        return this.result;
    }

    public String getSelectedSource() {
        return this.selectedSource;
    }

    public String getSelectedIcon() {
        return this.selectedIcon;
    }

    public String getSelectedSplashScreen() {
        return this.selectedSplashScreen;
    }

    public String getSelectedDestination() {
        return this.selectedDestination;
    }

    protected CustomizeDialog() {
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(DemoApp.getRes().getString("Wrapper DemoApp: Customize"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(DemoApp.getRes().getString("Source Binary"));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints());
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(DemoApp.getRes().getString("Icon"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(DemoApp.getRes().getString("Splash screen"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fd = new JFileChooser();
                fd.setMultiSelectionEnabled(false);
                fd.setCurrentDirectory(new File("."));
                fd.setDialogTitle(DemoApp.getRes().getString("Select Executable for customization"));
                fd.setFileHidingEnabled(true);
                fd.setApproveButtonText(DemoApp.getRes().getString("Load Executable"));
                ExtensionFilter filter = new ExtensionFilter(DemoApp.getRes().getString("Wrapper Executable (*.exe)"), new String[]{"exe"});
                fd.setFileFilter(filter);
                int returnVal = fd.showOpenDialog(CustomizeDialog.this);
                if (returnVal == 0) {
                    try {
                        CustomizeDialog.this.selectedSource = fd.getSelectedFile().getCanonicalPath();
                        CustomizeDialog.this.jTextField1.setText(CustomizeDialog.this.selectedSource);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("...");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fd = new JFileChooser();
                fd.setMultiSelectionEnabled(false);
                fd.setCurrentDirectory(new File("."));
                fd.setDialogTitle(DemoApp.getRes().getString("Select Icon for customization"));
                fd.setFileHidingEnabled(true);
                fd.setApproveButtonText(DemoApp.getRes().getString("Load Icon"));
                ExtensionFilter filter = new ExtensionFilter(DemoApp.getRes().getString("Icon File (*.ico)"), new String[]{"ico"});
                fd.setFileFilter(filter);
                int returnVal = fd.showOpenDialog(CustomizeDialog.this);
                if (returnVal == 0) {
                    try {
                        CustomizeDialog.this.selectedIcon = fd.getSelectedFile().getCanonicalPath();
                        CustomizeDialog.this.jTextField2.setText(CustomizeDialog.this.selectedIcon);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton3.setText("...");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fd = new JFileChooser();
                fd.setMultiSelectionEnabled(false);
                fd.setCurrentDirectory(new File("."));
                fd.setDialogTitle(DemoApp.getRes().getString("Select splash screen for customization"));
                fd.setFileHidingEnabled(true);
                fd.setApproveButtonText(DemoApp.getRes().getString("Load splash screen"));
                ExtensionFilter filter = new ExtensionFilter(DemoApp.getRes().getString("Splash screen File (*.bmp)"), new String[]{"bmp"});
                fd.setFileFilter(filter);
                int returnVal = fd.showOpenDialog(CustomizeDialog.this);
                if (returnVal == 0) {
                    try {
                        CustomizeDialog.this.selectedSplashScreen = fd.getSelectedFile().getCanonicalPath();
                        CustomizeDialog.this.jTextField3.setText(CustomizeDialog.this.selectedSplashScreen);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        this.jPanel1.add((Component)this.jButton3, gridBagConstraints);
        this.jButton4.setText(DemoApp.getRes().getString("Customize"));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String errorMsg = "";
                if (CustomizeDialog.this.jTextField1.getText().length() == 0 || !new File(CustomizeDialog.this.jTextField1.getText()).exists()) {
                    CustomizeDialog.this.jTextField1.setBackground(Color.red);
                    errorMsg = errorMsg.concat(DemoApp.getRes().getString("No valid Source Binary Specified\n"));
                }
                if (CustomizeDialog.this.jTextField2.getText().length() != 0 && !new File(CustomizeDialog.this.jTextField2.getText()).exists()) {
                    CustomizeDialog.this.jTextField2.setBackground(Color.red);
                    errorMsg = errorMsg.concat(DemoApp.getRes().getString("No valid Icon File Specified\n"));
                }
                if (CustomizeDialog.this.jTextField3.getText().length() != 0 && !new File(CustomizeDialog.this.jTextField3.getText()).exists()) {
                    CustomizeDialog.this.jTextField3.setBackground(Color.red);
                    errorMsg = errorMsg.concat(DemoApp.getRes().getString("No valid Splash Screen File Specified\n"));
                }
                if (CustomizeDialog.this.jTextField2.getText().length() == 0 && CustomizeDialog.this.jTextField3.getText().length() == 0) {
                    errorMsg = errorMsg.concat(DemoApp.getRes().getString("Please select at least one Icon or Splash Screen File.\n"));
                    CustomizeDialog.this.jTextField2.setBackground(Color.yellow);
                    CustomizeDialog.this.jTextField3.setBackground(Color.yellow);
                }
                if (errorMsg.length() > 0) {
                    JOptionPane.showMessageDialog(CustomizeDialog.this, DemoApp.getRes().getString("See the following list of errors:\n") + errorMsg, DemoApp.getRes().getString("Error"), 0);
                    return;
                }
                JFileChooser fd = new JFileChooser();
                fd.setMultiSelectionEnabled(false);
                fd.setCurrentDirectory(new File("."));
                fd.setDialogTitle(DemoApp.getRes().getString("Select destination file of the customization"));
                fd.setFileHidingEnabled(true);
                fd.setApproveButtonText(DemoApp.getRes().getString("Custimize Binary"));
                ExtensionFilter filter = new ExtensionFilter(DemoApp.getRes().getString("Executable File (*.exe)"), new String[]{"exe"});
                fd.setFileFilter(filter);
                int returnVal = fd.showSaveDialog(CustomizeDialog.this);
                if (returnVal == 0) {
                    try {
                        CustomizeDialog.this.selectedDestination = fd.getSelectedFile().getCanonicalPath();
                        if (!CustomizeDialog.this.selectedDestination.toLowerCase().endsWith(".exe")) {
                            CustomizeDialog.this.selectedDestination = CustomizeDialog.this.selectedDestination.concat(".exe");
                        }
                        if (CustomizeDialog.this.selectedDestination.equals(CustomizeDialog.this.jTextField1.getText())) {
                            JOptionPane.showMessageDialog(CustomizeDialog.this, DemoApp.getRes().getString("You cannot set the Source and Destination to the same File"), DemoApp.getRes().getString("Error"), 0);
                            CustomizeDialog.this.selectedDestination = "";
                        } else {
                            CustomizeDialog.this.result = 1;
                            CustomizeDialog.this.setVisible(false);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.jPanel1.add((Component)this.jButton4, gridBagConstraints);
        this.jButton5.setText("Cancel");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeDialog.this.result = 0;
                CustomizeDialog.this.setVisible(false);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        this.jPanel1.add((Component)this.jButton5, gridBagConstraints);
        this.jTextField1.setColumns(20);
        this.jTextField1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        this.jTextField2.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jTextField2, gridBagConstraints);
        this.jTextField3.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.jTextField3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints());
        this.setLocation(this.getParent().getLocation());
        this.setResizable(false);
        this.setModal(true);
        this.pack();
        this.pack();
    }
}

