/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

public class Performance {
    private static void initialize() {
        System.out.println("Run some loops for a few seconds to give some time for the JVM to get up and running...");
        long now = System.currentTimeMillis();
        long count = 1000000000L;
        double total = 0.0;
        for (long i = 0L; i < count; ++i) {
            double x = 10.5 + (double)i;
            double y = 3.14159 * (double)i;
            double z = x * y;
            total += z;
        }
        long time = System.currentTimeMillis() - now;
        System.out.println("  Complete.  Total time=" + (double)time / 1000.0 + " seconds. (" + total + ")");
    }

    private static void dumpThreadGroup(ThreadGroup threadGroup, String indent) {
        System.out.println(indent + threadGroup.toString());
        Thread[] threads = new Thread[(int)Math.ceil((double)threadGroup.activeCount() * 1.2)];
        threadGroup.enumerate(threads, false);
        System.out.println(indent + "Threads:");
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            System.out.println(indent + "  " + threads[i]);
        }
        ThreadGroup[] threadGroups = new ThreadGroup[(int)Math.ceil((double)threadGroup.activeGroupCount() * 1.2)];
        threadGroup.enumerate(threadGroups, false);
        System.out.println(indent + "Thread Groups:");
        for (int i = 0; i < threadGroups.length; ++i) {
            if (threadGroups[i] == null) continue;
            Performance.dumpThreadGroup(threadGroups[i], indent + "  ");
        }
    }

    private static void dumpThreadInfo() {
        Thread thread = Thread.currentThread();
        System.out.println("Thread: " + thread);
        System.out.println("  Name: " + thread.getName());
        System.out.println("  Priority: " + thread.getPriority());
        System.out.println("  ThreadGroup Name: " + thread.getThreadGroup().getName());
        System.out.println("  isDaemon: " + thread.isDaemon());
        System.out.println("All Threads:");
        ThreadGroup topThreadGroup = thread.getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        Performance.dumpThreadGroup(topThreadGroup, "  ");
    }

    private static void inMemoryLoopsMath() {
        System.out.println("Starting in memory loop test (Math)...");
        long now = System.currentTimeMillis();
        long count = 10000000000L;
        double total = 0.0;
        for (long i = 0L; i < count; ++i) {
            double x = 10.5 + (double)i;
            double y = 3.14159 * (double)i;
            double z = x * y;
            total += z;
        }
        long time = System.currentTimeMillis() - now;
        System.out.println("  Complete.  Total time=" + (double)time / 1000.0 + " seconds.  (" + (double)time * 1000.0 / (double)count + " usec per cycle.) (" + total + ")");
    }

    private static void inMemoryLoopsString() {
        System.out.println("Starting in memory loop test (Strings)...");
        long now = System.currentTimeMillis();
        long count = 100000000L;
        double total = 0.0;
        for (long i = 0L; i < count; ++i) {
            String a = "This is a test.";
            String b = "This is the end.";
            String c = a + i + b;
            total += (double)c.length();
        }
        long time = System.currentTimeMillis() - now;
        System.out.println("  Complete.  Total time=" + (double)time / 1000.0 + " seconds.  (" + (double)time * 1000.0 / (double)count + " usec per cycle.) (" + total + ")");
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        System.out.println("This test will run a number of tests to check Java performance.  It should be run both with and without the Wrapper.");
        String fullVersion = System.getProperty("java.fullversion");
        String vendor = System.getProperty("java.vm.vendor", "");
        String os = System.getProperty("os.name", "").toLowerCase();
        if (fullVersion == null) {
            fullVersion = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        System.out.println("Java Version: " + fullVersion);
        Performance.initialize();
        Performance.dumpThreadInfo();
        Performance.inMemoryLoopsMath();
        Performance.inMemoryLoopsString();
        Thread runner = new Thread("runner"){

            public void run() {
                System.out.println("Do the same tests in a background thread...");
                Performance.dumpThreadInfo();
                Performance.inMemoryLoopsMath();
                Performance.inMemoryLoopsString();
                System.out.println("Background thread completed.");
            }
        };
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long time = System.currentTimeMillis() - now;
        System.out.println("Completed in " + (double)time / 1000.0 + " seconds.  Exiting.");
    }
}

