<?php
class fileAction extends adminAction
{
function dispatch(&$context)
{
	global $xoopsModuleConfig;
	
	$err = $this->checkPermission();
	if(!is_array($err) || count($err) > 0){
		$context->setAttributes('perm_error', $err);
		return "default";
	}
	
	$limit = 10;
	$start = $this->getIntRequest('s', APP_REQUEST_GET);
	if(!isset($start) || $start<0){
		$start = 0;
	}
	
	$criteria = new CriteriaCompo(NULL);
	$criteria->setLimit($limit);
	$criteria->setStart($start);
	$criteria->setSort('c_file_id');
	$criteria->setOrder('DESC');
	
	$file_handler =& CM_FileHandler::getInstance();
	$file_obj_list =& $file_handler->getObjects($criteria);
	$file_list = array();
	
	$user_handler =& xoops_gethandler('user');
	
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	$comment = array();
	
	foreach($file_obj_list as $file_obj){
		$file_id = $file_obj->getVar('c_file_id');
		$filename = $file_obj->getVar('filename');
		
		$file_path = $xoopsModuleConfig['file_upload_path']. '/'. $filename;
		$file_info = @stat($file_path);
		$author_obj =& $user_handler->get($file_obj->getVar('uid'));
		$author_name = ($author_obj) ? $author_obj->getVar('uname') : "";
		
		$page_url = "";
		
		$target = $file_obj->getVar('target');
		$target_id = $file_obj->getVar('target_id');
		
		if($target==1){
			$page_url = _CM_URL_COMMU.'?cid='.$target_id;
		}
		elseif($target==2){
			if(!isset($comment[$target_id])){
				$comment[$target_id] =& $comment_handler->get($target_id);
			}
			if(is_object($comment[$target_id])){
				$page_url = _CM_URL_TOPIC.'&tid='.$comment[$target_id]->getVar('c_commu_topic_id');
			}
		}
		
		$file_list[$file_id] = array(
			'id' => $file_id,
			'url' => _CM_FILE_LOAD_URL."?id=".$file_id,
			'ref_link' => empty($page_url) ? "-" : "<a href='".$page_url."' target='_blank'>URL</a>",
			'filename' => rawurldecode($file_obj->getVar('org_filename')),
			'author' => $author_name,
			'size' => number_format($file_info['size']),
			'date' => str_replace(" ", "<br>", date('Y-m-d H:i:s', $file_info['mtime'])),
			'active' => "checked",
		);
		unset($author_obj);
	}
	
	$pager = $this->getPageSelector('index.php?'.APP_ACTION_ARG.'=file', 
						$start, $limit, count($file_list), $file_handler->getCount(), "#FFCCCC");
	
	$context->setAttributes('file_list', $file_list);
	$context->setAttributes('pager', $pager);
}
//------------------------------------------------------------------------------

}
?>
