<?php
// $Id: edituser.php,v 1.5 2006/05/01 02:37:26 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //


class profileAction extends mypageAction
{

function dispatch(&$context)
{
	global $xoopsUser, $xoopsConfig;
	
	if($this->isGuest()){
		redirect_header(_CM_URL_MYPAGE, 2, _NOPERM);
	}
	
	$user_handler =& CM_UserHandler::getInstance();
	$user =& $user_handler->get($xoopsUser->getVar('uid'));
	if(!is_object($user)){
		redirect_header(APP_BASE_URL, 2, _NOPERM);
	}
	
	require_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';
	require_once XOOPS_ROOT_PATH.'/language/'.$xoopsConfig['language'].'/user.php';
	require_once XOOPS_ROOT_PATH.'/include/comment_constants.php';
	
	$config_handler =& xoops_gethandler('config');
	$xoopsConfigUser =& $config_handler->getConfigsByCat(XOOPS_CONF_USER);
	if(!isset($xoopsConfigUser['avatar_allow_upload'])){
		$xoopsConfigUser =& $config_handler->getConfigsByDirname('user');	// for XOOPS Cube Legacy 2.1
	}
	
	$form = new XoopsThemeForm(_US_EDITPROFILE, 'profileform', _CM_URL_MYPAGE);
	if(defined('_CM_DEMO_VERSION')){
		$form->addElement(new XoopsFormLabel("", _CM_DEMO_VERSION_DESC));
	}
	$uname_label = new XoopsFormLabel(_US_NICKNAME, $xoopsUser->getVar('uname'));
	$form->addElement($uname_label);
	
	$avatar_image = new XoopsFormLabel(_US_AVATAR, '<img src="'.XOOPS_UPLOAD_URL.'/'.$xoopsUser->getVar('user_avatar').'" alt="'.$xoopsUser->getVar('uname').'" /><br>[<a href="'._CM_URL_MYPAGE.'&'.APP_ACTION_ARG.'=profile_avatar_up'.'">'._CM_PROFILE_AVATAR_EDIT.'</a>]');
	$form->addElement($avatar_image);
	
	$name_text = new XoopsFormText(_US_REALNAME, 'name', 30, 60, $xoopsUser->getVar('name', 'E'));
	$form->addElement($name_text);
	$email_tray = new XoopsFormElementTray(_US_EMAIL, '<br>');
	if (@$xoopsConfigUser['allow_chgmail'] == 1) {
		$email_text = new XoopsFormText('', 'email', 30, 60, $xoopsUser->getVar('email'));
	} else {
		$email_text = new XoopsFormLabel('', $xoopsUser->getVar('email'));
	}
	$email_tray->addElement($email_text);
	$email_cbox_value = $xoopsUser->user_viewemail() ? 1 : 0;
	$email_cbox = new XoopsFormCheckBox('', 'user_viewemail', $email_cbox_value);
	$email_cbox->addOption(1, _US_ALLOWVIEWEMAIL);
	$email_tray->addElement($email_cbox);
	$form->addElement($email_tray);
	$url_text = new XoopsFormText(_US_WEBSITE, 'url', 60, 100, $xoopsUser->getVar('url', 'E'));
	$form->addElement($url_text);

	$timezone_select = new XoopsFormSelectTimezone(_US_TIMEZONE, 'timezone_offset', $xoopsUser->getVar('timezone_offset'));
	$icq_text = new XoopsFormText(_US_ICQ, 'user_icq', 15, 15, $xoopsUser->getVar('user_icq', 'E'));
	$aim_text = new XoopsFormText(_US_AIM, 'user_aim', 18, 18, $xoopsUser->getVar('user_aim', 'E'));
	$yim_text = new XoopsFormText(_US_YIM, 'user_yim', 25, 25, $xoopsUser->getVar('user_yim', 'E'));
	$msnm_text = new XoopsFormText(_US_MSNM, 'user_msnm', 30, 100, $xoopsUser->getVar('user_msnm', 'E'));
	$location_text = new XoopsFormText(_US_LOCATION, 'user_from', 30, 100, $xoopsUser->getVar('user_from', 'E'));
	$occupation_text = new XoopsFormText(_US_OCCUPATION, 'user_occ', 30, 100, $xoopsUser->getVar('user_occ', 'E'));
	$interest_text = new XoopsFormText(_US_INTEREST, 'user_intrest', 30, 150, $xoopsUser->getVar('user_intrest', 'E'));
	$sig_tray = new XoopsFormElementTray(_US_SIGNATURE, '<br>');
	require_once APP_TRUST_PATH.'/include/xoopscodes.php';
	$sig_tarea = new XoopsFormDhtmlTextArea('', 'user_sig', $xoopsUser->getVar('user_sig', 'E'));
	$sig_tray->addElement($sig_tarea);
	$sig_cbox_value = $xoopsUser->getVar('attachsig') ? 1 : 0;
	$sig_cbox = new XoopsFormCheckBox('', 'attachsig', $sig_cbox_value);
	$sig_cbox->addOption(1, _US_SHOWSIG);
	$sig_tray->addElement($sig_cbox);
	
	$umode_select = new XoopsFormSelect(_US_CDISPLAYMODE, 'umode', $xoopsUser->getVar('umode'));
	$umode_select->addOptionArray(array('nest'=>_NESTED, 'flat'=>_FLAT, 'thread'=>_THREADED));
	$uorder_select = new XoopsFormSelect(_US_CSORTORDER, 'uorder', $xoopsUser->getVar('uorder'));
	$uorder_select->addOptionArray(array(XOOPS_COMMENT_OLD1ST => _OLDESTFIRST, XOOPS_COMMENT_NEW1ST => _NEWESTFIRST));
	// RMV-NOTIFY
	// TODO: add this to admin user-edit functions...
	require_once XOOPS_ROOT_PATH . "/language/" . $xoopsConfig['language'] . '/notification.php';
	require_once XOOPS_ROOT_PATH . '/include/notification_constants.php';
	$notify_method_select = new XoopsFormSelect(_NOT_NOTIFYMETHOD, 'notify_method', $xoopsUser->getVar('notify_method'));
	$notify_method_select->addOptionArray(array(XOOPS_NOTIFICATION_METHOD_DISABLE=>_NOT_METHOD_DISABLE, XOOPS_NOTIFICATION_METHOD_PM=>_NOT_METHOD_PM, XOOPS_NOTIFICATION_METHOD_EMAIL=>_NOT_METHOD_EMAIL));
	$notify_mode_select = new XoopsFormSelect(_NOT_NOTIFYMODE, 'notify_mode', $xoopsUser->getVar('notify_mode'));
	$notify_mode_select->addOptionArray(array(XOOPS_NOTIFICATION_MODE_SENDALWAYS=>_NOT_MODE_SENDALWAYS, XOOPS_NOTIFICATION_MODE_SENDONCETHENDELETE=>_NOT_MODE_SENDONCE, XOOPS_NOTIFICATION_MODE_SENDONCETHENWAIT=>_NOT_MODE_SENDONCEPERLOGIN));
	$bio_tarea = new XoopsFormTextArea(_US_EXTRAINFO, 'bio', $xoopsUser->getVar('bio', 'E'));
	$cookie_radio_value = empty($_COOKIE[@$xoopsConfig['usercookie']]) ? 0 : 1;
	$cookie_radio = new XoopsFormRadioYN(_US_USECOOKIE, 'usecookie', $cookie_radio_value, _YES, _NO);
	
	$pwd_text = new XoopsFormPassword('', 'password', 10, 32);
	$pwd_text2 = new XoopsFormPassword('', 'vpass', 10, 32);
	$pwd_tray = new XoopsFormElementTray(_US_PASSWORD.'<br>'._US_TYPEPASSTWICE);
	$pwd_tray->addElement($pwd_text);
	$pwd_tray->addElement($pwd_text2);
	
	$mailok_radio = new XoopsFormRadioYN(_US_MAILOK, 'user_mailok', $xoopsUser->getVar('user_mailok'));
	$uid_hidden = new XoopsFormHidden('uid', $xoopsUser->getVar('uid'));
	$op_hidden = new XoopsFormHidden(APP_ACTION_ARG, 'profile_edit_exec');
	$token_handler =& new XoopsMultiTokenHandler();
	$token_hidden = new XoopsFormToken($token_handler->create('edituser'));
	$submit_button = new XoopsFormButton('', 'submit', _US_SAVECHANGES, 'submit');
	
	$form->addElement($timezone_select);
	$form->addElement($icq_text);
	$form->addElement($aim_text);
	$form->addElement($yim_text);
	$form->addElement($msnm_text);
	$form->addElement($location_text);
	$form->addElement($occupation_text);
	$form->addElement($interest_text);
	
	if(!defined('_CM_DEMO_VERSION')){
		$form->addElement($sig_tray);
		$form->addElement($umode_select);
		$form->addElement($uorder_select);
		$form->addElement($notify_method_select);
		$form->addElement($notify_mode_select);
		$form->addElement($bio_tarea);
		$form->addElement($pwd_tray);
		$form->addElement($cookie_radio);
		$form->addElement($mailok_radio);
	}
	
	$form->addElement($uid_hidden);
	$form->addElement($op_hidden);
	$form->addElement($token_hidden);
	$form->addElement($submit_button);
	if (@$xoopsConfigUser['allow_chgmail'] == 1) {
		$form->setRequired($email_text);
	}
	
	$context->setAttributes('user_menu', $user->getMyMenu());
	$context->setAttributes('form', $form);
}

}

?>