<?php
class edit_execAction extends topicAction
{

function dispatch(&$context)
{
	global $xoopsUser;
	
	if($this->isGuest() || !$this->validateToken('TOPIC_EDIT')){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$own_uid = $xoopsUser->getVar('uid');
	
	$tid = $this->getIntRequest('tid');
	if(!isset($tid)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$num = $this->getIntRequest('n');
	if(!isset($num) || $num == 0){
		$name = $this->getTextRequest('name');
		if(empty($name)){
			redirect_header(_CM_URL_TOPIC.'&tid='.$tid, 2, _CM_TOPIC_TITLE_NG);
		}
	}
	else{
		$name = NULL;
	}
	
	$body = $this->getTextRequest('body');
	if(!isset($body)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$commu_handler =& CM_CommunityHandler::getInstance();
	$topic_handler =& CM_TopicHandler::getInstance();
	$comment_handler =& CM_TopicCommentHandler::getInstance();
	
	// ȥԥåμ
	$topic =& $topic_handler->get($tid);
	if(!is_object($topic)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// ߥ˥ƥμ
	$community =& $commu_handler->get($topic->getVar('c_commu_id'));
	if(!is_object($community)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	$commu_auth = $community->getAuthority();
	if($commu_auth < _CM_AUTH_MEMBER){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	// Ȥμ
	$comment =& $comment_handler->getByNumber($tid, $num);
	if(!is_object($comment)){
		redirect_header(_CM_URL_COMMU, 2, _NOPERM);
	}
	
	$topic_uid = $topic->getVar('uid');
	$comment_uid = $comment->getVar('uid');
	
	if($comment_uid > 0
	   && ($own_uid == $topic_uid || $own_uid == $comment_uid || $commu_auth >= _CM_AUTH_SUB_ADMIN)){
		
		$r_datetime = date('Y-m-d H:i:s');
		$r_date = date('Y-m-d');
		
		$topic->setVar('name', $name);
		$topic->setVar('r_datetime', $r_datetime);
//		$topic->setVar('r_date', $r_date);
		
		if($topic_handler->insert($topic)){
			$tcid = $comment->getVar('c_commu_topic_comment_id');
			
			$image_handler =& CM_ImageHandler::getInstance();
			if($image_handler->uploadImageTemp('images')){
				$image_handler->uploadImage('t', 2, $tcid);
			}
			
			$file_handler =& CM_FileHandler::getInstance();
			if($file_handler->uploadFileTemp('files')){
				$file_handler->uploadFile('t', 2, $tcid);
			}
			
			$comment->setVar('body', $body);
			$comment->setVar('number', $num);
			$comment->setVar('r_datetime', $r_datetime);
//			$comment->setVar('r_date', $r_date);
			
			if($comment_handler->insert($comment)){
				$msg = ($num==0)? _CM_TOPIC_EDIT_OK : _CM_TOPIC_EDIT_RES_OK;
			}
			else{
				$msg = ($num==0)? _CM_TOPIC_EDIT_NG : _CM_TOPIC_EDIT_RES_NG;
			}
		}
		else{
			$msg = _CM_TOPIC_EDIT_NG;
		}
		redirect_header(_CM_URL_TOPIC.'&tid='.$tid, 2, $msg);
	}
	redirect_header(_CM_URL_COMMU, 2, _NOPERM);
}

}
?>
