<?php

require_once 'root.class.php';

//******************************************************************************

class CM_CategoryParent extends CM_Root
{
	
	//--------------------------------------------------------------------------
	
	function CM_CategoryParent()
	{
		// $key, $data_type, $default, $required, $size
		$this->initVar('c_commu_category_parent_id', XOBJ_DTYPE_INT);
		$this->initVar('name', XOBJ_DTYPE_TXTBOX);
		$this->initVar('sort_order', XOBJ_DTYPE_INT);
		$this->initVar('selector', XOBJ_DTYPE_TXTAREA);
	}
	
	//--------------------------------------------------------------------------
	
}

class CM_CategoryParentHandler extends CM_RootHandler
{
	
	//--------------------------------------------------------------------------
	
	function CM_CategoryParentHandler()
	{
		$this->CM_RootHandler();
		$this->obj_class = "CM_CategoryParent";
		$this->table_name = "c_commu_category_parent";
		$this->primary_key = "c_commu_category_parent_id";
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_CategoryParentHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
	function &getList()
	{
		$ret = array();
		$criteria = new CriteriaCompo(NULL);
		$criteria->setSort('sort_order');
		$obj_list =& $this->getObjects($criteria);
		if(is_array($obj_list)){
			foreach($obj_list as $obj){
				$ret[] = array(
					'c_commu_category_parent_id' => $obj->getVar('c_commu_category_parent_id'),
					'name' => $obj->getVar('name'),
					'selector' => $obj->getVar('selector', 'n'),	// allow HTML
				);
			}
		}
		return $ret;
	}
	
	//--------------------------------------------------------------------------
	
}

//******************************************************************************

?>
