/**
 * ŏ̒:: gDC[
 * |Wg:: $Id$
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _XERCESC_UTILS_CHAR2XMLCH_TRANSCODER_HPP_
#define _XERCESC_UTILS_CHAR2XMLCH_TRANSCODER_HPP_

#include <xercesc/util/TransService.hpp>
#include <xercesc/util/XMLString.hpp>

#include <xercesc_utils/XMLChPtr.hpp>

namespace xercesc_utils {

/**
 * w肵R[hchar*XMLCh*֕ϊ邽߂̃bp[NXłD
 * ̃NX͕ϊʂ̃obt@̊mہEbsO܂B
 */
class Char2XMLChTranscoder {
private:
  /**
   * gXR[_łB
   */
  xercesc::XMLTranscoder* transcoder_;

  /**
   * transcodeۂɎgpobt@̃TCYłB
   */
  unsigned int bufferSize_;

  /**
   * transcodeۂɕKvƂȂobt@łB
   */
  XMLCh* buffer_;
  unsigned char* charSizes_;

public:
  /**
   * gXR[_\z܂B
   *
   * @param encoding GR[fBOw肵܂B
   * @param bufferSize gXR[hۂɎgpobt@̃TCYw肵܂B
   */
  explicit Char2XMLChTranscoder(const char* encoding, int bufferSize = 1024) :
  bufferSize_(bufferSize), buffer_(new XMLCh[bufferSize+4]), charSizes_(new unsigned char[bufferSize]) {
    xercesc::XMLTransService::Codes failReason;
    transcoder_ = xercesc::XMLPlatformUtils::fgTransService->makeNewTranscoderFor(
      encoding, failReason, bufferSize_, xercesc::XMLPlatformUtils::fgMemoryManager
      );
  }

  /**
   * gXR[_j܂B
   */
  ~Char2XMLChTranscoder() {
    delete buffer_;
    delete transcoder_;
  }

private:
  // Rs[Ƒ֎~܂B
  explicit Char2XMLChTranscoder(const Char2XMLChTranscoder& transcoder);
  Char2XMLChTranscoder& operator=(const Char2XMLChTranscoder& transcoder);

public:
  /**
   * R[hϊ܂B
   */
  XMLChPtr transcode(const char* const toTranscode) const {
    const unsigned int count = xercesc::XMLString::stringLen(toTranscode);
    const XMLByte* srcPtr = (XMLByte*) toTranscode;
    const XMLByte* endPtr = (XMLByte*) toTranscode+count;
    XMLSize_t charsEaten;
    XMLChPtr result;

    while (srcPtr < endPtr) {
      const unsigned int srcCount = endPtr-srcPtr;
      const unsigned srcChars = srcCount > bufferSize_ ? bufferSize_ : srcCount;

      const unsigned int outBytes = transcoder_->transcodeFrom(
        srcPtr, srcChars, buffer_, bufferSize_, charsEaten, charSizes_
        );

      if (outBytes) {
        buffer_[outBytes] = buffer_[outBytes + 1] = buffer_[outBytes + 2] = buffer_[outBytes + 3] = 0;
      }

      srcPtr += charsEaten;
      result += buffer_;
    }

    return result;
  }

};

}  // namespace xercesc_utils

#endif
