/**
 * ŏ̒:: gDC[
 * |Wg:: $Id$
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _XERCESC_UTILS_CHAR_TO_XMLCH_HPP_
#define _XERCESC_UTILS_CHAR_TO_XMLCH_HPP_

#include <iostream>

#include <xercesc/util/XMLString.hpp>

namespace xercesc_utils {

/**
 * char*  XMLCh* ֕ϊ邽߂̃bp[NXłD
 * ̃NX͕ϊʂ̃obt@̊mہEbsO܂B
 */
class Char2XMLCh {
private:
  /**
   * ϊʂƂȂ镶obt@ւ̃|C^łD
   */
  XMLCh* buffer_;

public:
  /**
   * Char2XMLCh\z܂D
   *
   * @param buffer ϊƂȂ镶ւ̃|C^w肵܂D
   */
  explicit Char2XMLCh(const char* const buffer) {
    buffer_ = xercesc::XMLString::transcode(buffer);
  }

  /**
   * Char2XMLChj܂D
   */
  ~Char2XMLCh() {
    xercesc::XMLString::release(&buffer_);
  }

  /**
   * char*ւ̃LXgZqłB
   */
  operator const XMLCh* const () const {
    return buffer_;
  }

private:
  // Rs[Ƒ֎~܂B
  explicit Char2XMLCh(const Char2XMLCh& ch);
  Char2XMLCh& operator=(const Char2XMLCh& ch);
};

/**
 * Xg[֕o͂܂B
 */
inline std::ostream& operator<<(std::ostream& stream, const Char2XMLCh& buffer) {
  return stream << (const XMLCh* const) buffer;
}

}  // namespace xercesc_utils

#endif
