#include "xtext.h"

#define debug 0

static int XtextDrawString(	Display *disp,
			my_window_t win,
			char_data_t char_d,
			ITEXT_T *it,
			int x,
			int y		)
{
	GC gc;
	XFontSet fs;
	char text[3];
	int xpad,ypad;

	text[0] = it->c1;
	text[1] = it->c2;
	text[2] = '\0';

#if debug
fprintf(stderr,"Normal_String : %s   ",text);
#endif

	gc = win.gc;
	fs = win.fs;
	if(it->chu) gc = win.rubi_gc;
	if(it->small) fs = win.fs_s;
	xpad = it->x_off;
	ypad = it->y_off;

	XmbDrawString(disp,win.win,fs,gc,x+xpad,y+ypad,text,strlen(text));

#if debug
fprintf(stderr,"END\n");
#endif
	return 0;
}
static int XtextDrawAntiString(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
#if HAVE_LIBXFT

	XftFont *font;
	XftColor color;
	XGlyphInfo gi;
	int xoff;
	int xpad,ypad;

	font = win.font;
	color = win.fg_color;

	xpad = it->x_off;
	ypad = it->y_off;

	if(it->chu) color = win.rubi_color;
	if(it->small) font = win.font_s;

	XftTextExtentsUtf8(disp,font,it->utf8,strlen(it->utf8),&gi);
	if(it->small){
		xoff = (char_d.charSize_s - gi.xOff) / 2;
	}else{
		xoff = (char_d.charSize - gi.xOff) / 2;
	}
	

	XftDrawStringUtf8(win.draw,&color,font,x+xoff+xpad,y+ypad,it->utf8,strlen(it->utf8));
#else

	XtextDrawString(disp,win,char_d,it,x,y);

#endif

	return 0;
}
static int XtextDrawImageString(	Display *disp,
					my_window_t win,
					char_data_t char_d,
					ITEXT_T *it,
					int x0,
					int y0	)

{
	XImage *image_str = NULL;
	image_data_t *im;
	int x,y;
	int charSize;

	for(im=char_d.im_head;im!=NULL;im=im->next){
		if(im->c1 == it->c1 && im->c2 == it->c2 && im->chu == it->chu && im->small == it->small){
			image_str = im->char_image;
			break;
		}
	}
	if(image_str == NULL) return -1;

	charSize = char_d.charSize;
	/*if(it->ej = 0) charSize = char_d.charSize_e;*/
	if(it->small == 1) charSize = char_d.charSize_s;

	x = x0;
	y = y0 - char_d.charSize + 1;
	XPutImage(disp,win.win,win.gc,image_str,0,0,x,y,charSize,charSize);


	return 0;
}
static int XtextDrawRubiString(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	ITEXT_T *rb;
	unsigned char text[3];
	int k_len=0,r_len=0;
	int x,y;

	if(win.anti == 0){
		if(win.rubi_fs == NULL) return -1;
	}else{
#if HAVE_LIBXFT
		if(win.font_rubi == NULL) return -1;
#else
		if(win.rubi_fs == NULL) return -1;
#endif
	}

	for(rb=it;rb!=NULL;rb=rb->prev){
		if(!(rb->c1 >= 0xb0)) break;
		k_len = k_len + (char_d.charSize + char_d.ypad);
	}
	for(rb=it->rubi_head;rb!=NULL;rb=rb->next){
		r_len = r_len + char_d.charSize_r;
	}

	if(k_len >= r_len){
		y = y0;
	}else{
		if((y = y0 + ((r_len - k_len)/2)) > win.height-2) y = y0;
	}
	if(y - r_len < 0) y = r_len;

	x = x0;
	for(rb=it->rubi_tail;rb!=NULL;rb=rb->prev){
		text[0] = rb->c1;
		text[1] = rb->c2;
		text[2] = '\0';

		if(win.anti == 0){
			XmbDrawString(disp,win.win,win.rubi_fs,win.rubi_gc,x,y,text,2);
		}else{
#if HAVE_LIBXFT
			XftDrawStringUtf8(win.draw,&(win.rubi_color),win.font_rubi,x,y,rb->utf8,strlen(rb->utf8));
#else
			XmbDrawString(disp,win.win,win.rubi_fs,win.rubi_gc,x,y,text,2);
#endif
		}

		y = y - char_d.charSize_r;
	}

	return 0;
}
static int XtextDrawBoutenString(	Display *disp,
					my_window_t win,
					char_data_t char_d,
					unsigned char *text,
					int x0,
					int y0			)
{
	int ypad;

	if(win.rubi_fs == NULL) return -1;

	ypad = (char_d.charSize - char_d.charSize_r) / 2;
	XmbDrawString(disp,win.win,win.fs,win.gc,x0,y0-ypad,text,2);

	return 0;
}
static int _Draw_String(	Display *disp,
				my_window_t win,
				char_data_t char_d,
				ITEXT_T *it,
				int x,
				int y	)
{
	unsigned char bouten_text[3];

	bouten_text[0] = 0xa1;
	bouten_text[1] = 0xa6;
	bouten_text[2] = '\0';

	if(it->ej == 1){
		if(XtextDrawImageString(disp,win,char_d,it,x,y) < 0){

			if(win.anti == 0){
				XtextDrawString(disp,win,char_d,it,x,y);
			}else{
				XtextDrawAntiString(disp,win,char_d,it,x,y);
			}

			if(it->bouten == 1) XtextDrawBoutenString(disp,win,char_d,bouten_text,x+char_d.charSize-6,y+2);

			if(it->rubi_head != NULL) XtextDrawRubiString(disp,win,char_d,it,x+char_d.charSize-2,y);
			

		}
	}else{
		XtextDrawImageString(disp,win,char_d,it,x,y);
	}


	return 0;
}
static int _get_str_size(Display *disp,my_window_t win,char *euc_str,char *utf8_str,int *w,int *h,int font_type)
{
	XFontSet fs;

	fs = win.fs_s;
	if(font_type) fs = win.fs;

	if(win.anti == 0){
		XRectangle ink,log;

		*w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
	}else{
#if HAVE_LIBXFT
		XftFont *font;
		XGlyphInfo gi;

		font = win.font_s;
		if(font_type) font = win.font;

		XftTextExtentsUtf8(disp,font,utf8_str,strlen(utf8_str),&gi);

		*w = gi.width;
		*h = gi.height;
#else
		XRectangle ink,log;

		*w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
#endif
	}

	return 0;
}
static int _Draw_Page_Title_String(	Display *disp,
					my_window_t win,
					char *euc_str,
					char *utf8_str,
					int x,
					int y,
					int font_type		)
{
	XFontSet fs;
	GC gc;

	fs = win.fs_s;
	if(font_type) fs = win.fs;
	gc = win.rubi_gc;

	if(win.anti == 0){
		XmbDrawString(disp,win.win,fs,gc,x,y,euc_str,strlen(euc_str));

	}else{
#if HAVE_LIBXFT
		XftFont *font;

		font = win.font_s;
		if(font_type) font = win.font;

		XftDrawStringUtf8(win.draw,&(win.rubi_color),font,x,y,utf8_str,strlen(utf8_str));
#else
		XmbDrawString(disp,win.win,fs,gc,x,y,euc_str,strlen(euc_str));
#endif
	}

	return 0;
}
int xtext_Draw_Text(	Display *disp,
			my_window_t win,
			IBUF_T *l_head,
			char_data_t char_d,
			page_data_t *char_p	)
{
	IBUF_T *ib;
	ITEXT_T *it;

	char page_str[50];

	int sc = 0,flag = 0;
	int x,y,one_line,start_line,end_line,start_low,end_low;
	int h;
	int width,height;

	if(l_head == NULL) return -1;


	XClearWindow(disp,win.win);

	one_line = char_d.charSize + char_d.xpad + char_d.charSize_r;

	start_line = win.width - one_line;
	end_line = 0;

	start_low = char_d.charSize * 2;
	end_low = win.height - char_d.charSize;

	x = start_line;
	y = start_low;
#if debug
fprintf(stderr,"Draw Start\n");
#endif
	for(ib=l_head;ib!=NULL;ib=ib->next){
		for(it=ib->i_head;it!=NULL;it=it->next){
			if(sc++ >= char_p->char_no) flag = 1;

			if(flag){

				_Draw_String(disp,win,char_d,it,x,y);

				h = xtext_get_low_space(it,&char_d);

				if((y += h) > end_low && xtext_next_kuten(it)==0){
					if((x -= one_line) < end_line) goto _draw_end;
					y = start_low;
				}
			}
		}
		if(flag){
			if((x -= one_line) < end_line) goto _draw_end;
			y = start_low;
		}
	}
#if debug
fprintf(stderr,"Draw END\n");
#endif

_draw_end:
	sprintf(page_str,"(%d/%d)",char_p->page_no,char_d.book->total_page);
	_get_str_size(disp,win,page_str,page_str,&width,&height,0);
	_Draw_Page_Title_String(disp,win,page_str,page_str,(win.width-width)/2,win.height-2,0);

	if(win.title_on){
		_get_str_size(disp,win,char_d.book->book_title,char_d.book->book_title_utf8,&width,&height,0);
		_Draw_Page_Title_String(disp,win,char_d.book->book_title,char_d.book->book_title_utf8,2,height,0);
	}


	return char_p->char_no;
}
int xtext_Draw_Help(Display *disp,my_window_t win,xtext_conf_t xconf)
{
	iconv_t con;
	char *help_str = NULL,*help_utf8 = NULL;
	int x0,y0,width,height;
	int font_type;

	con = iconv_open("UTF-8","EUC-JP");
	help_str = (char *)malloc(256);

	font_type = 1;
	sprintf(help_str,"%s   Ver. %s",XTEXT_NAME,XTEXT_VERSION);
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win.width - width) / 2;
	y0 = height + 10;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	font_type = 0;
	strcpy(help_str,"Creater : aFterbrEaK");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win.width - width) / 2;
	y0 = y0 + height + 10;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"HomePage : http://xjp-text.sourceforge.jp/");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win.width - width) / 2;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"E-Mail : afterbreak@users.sourceforge.jp");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = x0;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);


	font_type = 1;
	strcpy(help_str," ˡ ");
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = 10;
	y0 = y0 + height + 20;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	font_type = 0;
	sprintf(help_str,"*޽::' %s '  *::' %s '  *ǧ::' %s '",xconf.menu,xconf.siori_menu,xconf.conf_page);
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = 10;
	y0 = y0 + height + 10;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	sprintf(help_str,"*ڡ::' %s '  *ڡ::' %s '  *XJP-TEXTλ::' %s '",xconf.page_next,xconf.page_prev,xconf.quit);
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = 10;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	sprintf(help_str,"*(֥åޡ)::' %s '   *ȥɽON-OFF::' %s '",xconf.book_mark,xconf.title_key);
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = 10;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	sprintf(help_str,"*޽¸DIR::' %s '",xconf.book_dir);
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = 10;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	font_type = 1;
	strcpy(help_str,"ޤϡ޽̤顢ɤ");
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = (win.width - width) / 2;
	y0 = y0 + height + 40;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);

	font_type = 0;
	strcpy(help_str,"޽̤ϡĤǤƤӽФȤޤ");
	help_utf8 = (char *)euc2utf8(con,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = (win.width - width) / 2;
	y0 = y0 + height + 10;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);
	if(help_utf8) free(help_utf8);



	if(help_str) free(help_str);
	iconv_close(con);
	return 0;
}




			


