#include "xtext.h"

#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <pwd.h>




static void * _siori_data_add(xtext_siori_t **head,xtext_siori_t **tail,xtext_siori_t *im)
{
	if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

        return NULL;
}

static int _siori_data_insert(unsigned char *buf,xtext_siori_t **head,xtext_siori_t **tail)
{
	unsigned char *p,temp[BUFSIZ];
	xtext_siori_t *si;

	int i,j;

	if((si = (xtext_siori_t *)malloc(sizeof(xtext_siori_t))) == NULL) return -1;

	i = 0;
	j = 0;
	for(p=buf;*p;p++){
		if(isspace(*p)){
			temp[i] = '\0';
			if(j == 0) strcpy(si->book_title,temp);
			if(j == 1) strcpy(si->book_path,temp);
			if(j == 2) strcpy(si->book_time,temp);
			if(j == 3) si->NPC = atoi(temp);

			i = 0;
			j++;
			continue;
		}

		temp[i++] = *p;
	}

	_siori_data_add(head,tail,si);

	return 0;
}
static int _get_siori_file(char *siori_file)
{
	DIR *dp;
	struct passwd *pwd;
	char dirname[256],filename[256];

	pwd = getpwuid(getuid());
	sprintf(dirname,"%s/%s",pwd->pw_dir,CONF_DIR_NAME);

	if((dp = opendir(dirname)) == NULL){
		if(mkdir(dirname,0755) < 0){
			fprintf(stderr,"False mkdir  %s\n",dirname);
			exit(1);
		}
		return -1;
	}
	closedir(dp);

	sprintf(siori_file,"%s/%s",dirname,SIORI_FILE_NAME);

	return 0;
}
int xtext_siori_data_read(xtext_siori_t **head,xtext_siori_t **tail)
{
	FILE *fp;
	char siori[256];
	unsigned char buf[BUFSIZ];

	if(_get_siori_file(siori) < 0) return -1;

	if((fp = fopen(siori,"r")) == NULL) return -1;

	while(fgets(buf,BUFSIZ,fp) != NULL){
		_siori_data_insert(buf,head,tail);
	}

	fclose(fp);

	return 0;
}
int xtext_siori_data_write(xtext_siori_t **head,xtext_siori_t **tail)
{
	xtext_siori_t *si;
	FILE *fp;
	char siori[256];

	if(_get_siori_file(siori) < 0) return -1;

	if((fp = fopen(siori,"w")) == NULL) return -1;

	for(si = *head;si != NULL;si = si->next){
		fprintf(fp,"%s %s %s %d\n",si->book_title,si->book_path,si->book_time,si->NPC);
	}

	fclose(fp);

	return 0;
}
static int _siori_data_new_insert(	xtext_siori_t **head,
					xtext_siori_t **tail,
					unsigned char *book_path,
					unsigned char *book_title,
					unsigned char *book_time,
					int NPC				)
{
	xtext_siori_t *si,*temp;

	if((si = (xtext_siori_t *)malloc(sizeof(xtext_siori_t))) == NULL) return -1;

	strcpy(si->book_path,book_path);
	strcpy(si->book_title,book_title);
	strcpy(si->book_time,book_time);
	si->NPC = NPC;
	si->next = NULL;
	si->prev = NULL;

	if(*head == NULL){
		*head = *tail = si;
	}else{
		temp = *head;
		temp->prev = si;

		si->prev = NULL;
		si->next = temp;

		*head = si;
	}

	return 0;
}
int xtext_siori_data_mark(	xtext_siori_t **head,
				xtext_siori_t **tail,
				unsigned char *book_path,
				unsigned char *book_title,
				int NPC				)
{
	xtext_siori_t *si;

	time_t nowTime;
	struct tm *tmval;

	char time_str[256];

	nowTime = time(NULL);
	tmval = localtime(&nowTime);
	strftime(time_str,sizeof(time_str),"%Yǯ%m%d(%H%Mʬ)",tmval);

	for(si = *head;si != NULL;si = si->next){
		if(strcmp(si->book_path,book_path) == 0 && strcmp(si->book_title,book_title) == 0){
			strcpy(si->book_time,time_str);
			si->NPC = NPC;
			break;
		}
	}

	if(si == NULL) 	_siori_data_new_insert(head,tail,book_path,book_title,time_str,NPC);

	return 0;
}


























