#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <iconv.h>

#include "xjp.h"


enum {
	ITEXT_EJ,
	ITEXT_CHU,
	ITEXT_RUB,
	ITEXT_JIS,
	ITEXT_TES,
	ITEXT_BTEN,
	ITEXT_BSEN,
	ITEXT_SMALL,
};
typedef struct ITEXT{
	unsigned int c1;
	unsigned int c2;

	char *chu_string;

	int x_off;
	int y_off;

	int flag;

	int ej;
	int chu;
	int rub;
	int jis;
	int tes;
	int bouten;
	int bousen;
	int small;

	struct ITEXT *rubi_head;
	struct ITEXT *rubi_tail;

	struct ITEXT *chu_head;
	struct ITEXT *chu_tail;

	struct ITEXT *next;
	struct ITEXT *prev;
}ITEXT_T;
typedef struct IBUF{
	int line;
	int total_line;

	ITEXT_T *i_head;
	ITEXT_T *i_tail;
	
	struct IBUF *next;
	struct IBUF *prev;
}IBUF_T;
typedef struct BOOKFILEDATA{
        char fullpath[256];
        char filename[256];
        char title[256];
        int size;
        int code;

	unsigned long fno;

        struct BOOKFILEDATA *next;
        struct BOOKFILEDATA *prev;
}IBOOK_T;
typedef struct BOOKLISTDATA{
	int  book_id;
	char *save_dir;
	char *person_id;
	char *person;
	char *title;
	char *type;
	char *person_h;
	char *person_i;
	char *stat;
	char *date;

	struct BOOKLISTDATA *next;
	struct BOOKLISTDATA *prev;
}ILIST_T;
typedef struct PBOOKLISTDATA{
	char *person;
	char *file_date;
	int total;

	ILIST_T *list_head;
	ILIST_T *list_tail;

	struct PBOOKLISTDATA *next;
	struct PBOOKLISTDATA *prev;
}PLIST_T;

typedef struct BOUTENDATA{
	char *name;
	unsigned int c1;
	unsigned int c2;
}BOUTEN_T;
typedef struct {
	char fname[128];
	char title[128];
	long c_size;
	long u_size;
}IINFO_T;
typedef struct TABLEDATA{
	char *name;
	char *data;
	int mall;

	struct TABLEDATA *head;
	struct TABLEDATA *tail;
	struct TABLEDATA *next;
	struct TABLEDATA *prev;
}itext_table_t;


int ibookGetFileData(IBOOK_T **,IBOOK_T **,char *);
int itextGetTextData(char *,IINFO_T *,IBUF_T **,IBUF_T **,int);
int itextUnZipFile(char *,char *,IINFO_T *);
int itextGetNetList(PLIST_T **,PLIST_T **,char *);
int itextGetTableData(itext_table_t **,itext_table_t **,char *,char *);
int itext_list_download(void *,int);
int itext_book_download(void *,int);
int itext_book_download_1(void *,int);


int itextDataInsert(ITEXT_T **,ITEXT_T **,unsigned int ,unsigned int,int,int,int);
int checkRubyString(int,ITEXT_T **,ITEXT_T **,int *);

void itext_data_free(ITEXT_T *);
void book_link_free(IBOOK_T **,IBOOK_T **);
void plist_data_free(PLIST_T **,PLIST_T **);
int _checkFileType(char *);

