#include "itext.h"

#include <sys/stat.h>
#include <time.h>
#include <pwd.h>
#include <wkf.h>

extern char *XJP_MESSAGE[];
extern char *CARD_FILE;

static char *CARD_URL = NULL;
static char *reffer = "http://www.aozora.gr.jp/";
static char *person = "http://www.aozora.gr.jp/index_pages/list_person_all.zip";
static char *pfile = ".list_person_all.zip";
static char *cfile = ".card.html";

static int _get_list_data(char **to,char *buf,int no)
{
	char *p,temp[BUFSIZ];
	int i,j;

	i = 0;
	j = 0;
	for(p=buf;*p;p++){
		if(*p == ','){
			temp[i] = '\0';
			if(j == no){
				*to = (char *)malloc(i + 2);
				strcpy(*to,temp);
				return 0;
			}
			i=0;
			j++;
			continue;
		}
		temp[i++] = *p;
	}
	return -1;
}
static void _plist_data_add(PLIST_T **start,PLIST_T **end,PLIST_T *mg)
{
	if(*end){
		mg->next = NULL;
	        mg->prev = *end;
		(*end)->next = mg;
                *end = mg;
	}else{
		mg->next = NULL;
	        mg->prev = NULL;
		*end = mg;
		*start = mg;
	}
}
static void _list_data_add(ILIST_T **start,ILIST_T **end,ILIST_T *mg)
{
	if(*end){
		mg->next = NULL;
	        mg->prev = *end;
		(*end)->next = mg;
                *end = mg;
	}else{
		mg->next = NULL;
	        mg->prev = NULL;
		*end = mg;
		*start = mg;
	}
}

static PLIST_T * _plist_data_alloc()
{
	PLIST_T *pl;

	pl = (PLIST_T *)malloc(sizeof(PLIST_T));
	pl->person = NULL;
	pl->total = 1;
	pl->file_date = NULL;
	pl->list_head = NULL;
	pl->list_tail = NULL;

	return pl;
}
static ILIST_T * _list_data_alloc()
{
	ILIST_T *il;

	il = (ILIST_T *)malloc(sizeof(ILIST_T));
	il->save_dir = NULL;
	il->person_id = NULL;
	il->person = NULL;
	il->title = NULL;
	il->type = NULL;
	il->person_h = NULL;
	il->person_i = NULL;
	il->stat = NULL;
	il->date = NULL;

	return il;
}
static void _list_data_free(ILIST_T **head,ILIST_T **tail)
{
	ILIST_T *il,*ill;

	for(il = *head;il!=NULL;il=ill){
		ill = il->next;

		if(il->person_id != NULL) free(il->person_id);
		if(il->person != NULL) free(il->person);
		if(il->title != NULL) free(il->title);
		if(il->type != NULL) free(il->type);
		if(il->person_h != NULL) free(il->person_h);
		if(il->person_i != NULL) free(il->person_i);
		if(il->stat != NULL) free(il->stat);
		if(il->date != NULL) free(il->date);

		free(il);
	}
	*head = NULL;
	*tail = NULL;
}
void plist_data_free(PLIST_T **head,PLIST_T **tail)
{
	PLIST_T *pl,*pll;

	for(pl = *head;pl!=NULL;pl=pll){
		pll = pl->next;
		if(pl->person != NULL) free(pl->person);
		if(pl->list_head != NULL) _list_data_free(&pl->list_head,&pl->list_tail);
	}
	*head = NULL;
	*tail = NULL;
}
static int _list_data_insert(ILIST_T **head,ILIST_T **tail,char *buf_euc,char *sdir)
{
	ILIST_T *il;
	char *temp;


	il = (ILIST_T *)_list_data_alloc();

	il->save_dir = sdir;

	_get_list_data(&(il->person_id),buf_euc,0);
	_get_list_data(&(il->person),buf_euc,1);

	_get_list_data(&temp,buf_euc,2);
	il->book_id = atoi(temp);
	free(temp);

	_get_list_data(&(il->title),buf_euc,3);
	_get_list_data(&(il->type),buf_euc,4);
	_get_list_data(&(il->person_h),buf_euc,5);
	_get_list_data(&(il->person_i),buf_euc,6);
	_get_list_data(&(il->stat),buf_euc,8);
	_get_list_data(&(il->date),buf_euc,9);

	_list_data_add(head,tail,il);

	return 0;
}
static PLIST_T * _check_plist_person(PLIST_T *head,PLIST_T *tail,char *person)
{
	PLIST_T *pl;

	if(head == NULL) return NULL;

	for(pl=head;pl!=NULL;pl=pl->next){
		if(strcmp(pl->person,person) == 0) return pl;
	}

	return NULL;
}
static int _get_book_list(PLIST_T **head,PLIST_T **tail,char *fname,char *fdate,char *sdir)
{
	PLIST_T *pl;
	ILIST_T *il;

	struct stat sbuf;
	int len = 0;

	FILE *fp;
	char buf[BUFSIZ],buf_euc[BUFSIZ],*person;
	
	stat(fname,&sbuf);

	if((fp = fopen(fname,"r")) == NULL) return -1;
	if(*head != NULL) plist_data_free(head,tail);

	xtext_usage(NULL,0);
	while(fgets(buf,BUFSIZ,fp) != NULL){
		len += strlen(buf);
		xtext_usage(XJP_MESSAGE[14],(double)len/sbuf.st_size);

		wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,buf_euc,BUFSIZ);
		_get_list_data(&person,buf_euc,1);

		if((pl = (PLIST_T *)_check_plist_person(*head,*tail,person)) == NULL){
			pl = (PLIST_T *)_plist_data_alloc();
			pl->person = person;
			pl->file_date = (char *)malloc(strlen(fdate)+2);
			strcpy(pl->file_date,fdate);

			_list_data_insert(&pl->list_head,&pl->list_tail,buf_euc,sdir);
			_plist_data_add(head,tail,pl);
		}else{
			pl->total += 1;
			_list_data_insert(&pl->list_head,&pl->list_tail,buf_euc,sdir);
		}
	}
	fclose(fp);
	xtext_usage(NULL,0);

	return 0;
}
static int _itext_mv(char *fname,char *tname)
{
	FILE *fp,*tp;
	size_t size;
	char buf[BUFSIZ];

	fp = fopen(fname,"r");
	tp = fopen(tname,"w");

	while((size = fread(buf,sizeof(char),BUFSIZ,fp)) > 0)
		fwrite(buf,sizeof(char),size,tp);

	fclose(fp);
	fclose(tp);

	return 0;
}
static char * _get_down_name(char *url)
{
	char *p;

	if(url == NULL) return NULL;

	for(p=url+(strlen(url)-1);*p;p--){
		if(*p == '/') break;
	}

	return p+1;
}
static int _check_td(itext_table_t *tr,char *key)
{
	itext_table_t *it;

	if(tr == NULL) return 0;

	for(it=tr->head;it!=NULL;it=it->next){
		if(strstr(it->name,key) != NULL) return 1;
	}
	return 0;
}
int itext_book_download(void *data0,int data1)
{
	ILIST_T *il;
	struct passwd *pwd;
	char c_url[256];

	if(data0 == NULL) return -1;

	il = (ILIST_T *)data0;
	if(il->person_id == NULL || il->book_id <= 0) return -1;
	pwd = getpwuid(getuid());
	if(CARD_FILE != NULL) free(CARD_FILE);
	CARD_FILE = (char *)malloc(strlen(pwd->pw_dir)+strlen(cfile)+10);
	sprintf(CARD_FILE,"%s/%s",pwd->pw_dir,cfile);

	if(CARD_URL != NULL) free(CARD_URL);
	CARD_URL = (char *)malloc(strlen(reffer) + strlen(il->person_id) + 20);
	sprintf(CARD_URL,"%scards/%s",reffer,il->person_id);

	sprintf(c_url,"%s/card%d.html",CARD_URL,il->book_id);
	if(idoGetNetworkData(c_url,idoGetUrlHost(c_url),reffer,CARD_FILE,XJP_MESSAGE[18])<0) return -5;

	return 1;
}
int itext_book_download_1(void *data0,int data1)
{
	itext_table_t *start,*ta,*tr,*td;
	char book_url[256],book_file[256],*save_dir;
	int i;

	if(data0 == NULL) return -1;
	if(CARD_URL == NULL) return -1;
	start = (itext_table_t *)data0;
	save_dir = (char *)start->data;

	for(ta=start;ta!=NULL;ta=ta->next){
		if(strcmp(ta->name,"ɥǡ") == 0){
			for(tr=ta->head;tr!=NULL;tr=tr->next){
				if(_check_td(tr,"ƥȥե(Ӥ)")) goto download;
			}
			for(tr=ta->head;tr!=NULL;tr=tr->next){
				if(_check_td(tr,"ƥȥե")) goto download;
			}
		}
	}
	return -7;

download:

	for(td=tr->head,i=0;td!=NULL;td=td->next,i++){
		if(i == 2) break;
	}
	if(td == NULL) return -7;

	sprintf(book_file,"%s/%s",save_dir,(char *)_get_down_name(td->data));
	if(strncmp(td->data,"http://",7) == 0)
		strcpy(book_url,td->data);
	else
		sprintf(book_url,"%s/%s",CARD_URL,td->data);

	if(idoGetNetworkData(book_url,idoGetUrlHost(book_url),reffer,book_file,XJP_MESSAGE[10]) < 0) return -5;

	if(CARD_URL != NULL) free(CARD_URL);
	CARD_URL = NULL;

	return 1;
}
int itext_list_download(void *data0,int data1)
{
	struct passwd *pwd;
	char *person_file_csv,person_file[128],person_file_csv_temp[128];


	pwd = getpwuid(getuid());
	sprintf(person_file,"%s/%s",pwd->pw_dir,pfile);
	if(idoGetNetworkData(person,idoGetUrlHost(person),reffer,person_file,XJP_MESSAGE[9])<0) return -5;

	if(data0 == NULL){
		person_file_csv = (char *)malloc(128);
		sprintf(person_file_csv,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,LIST_FILE_NAME);
	}else{
		person_file_csv = (char *)data0;
	}

	itextUnZipFile(person_file,person_file_csv_temp,NULL);
	_itext_mv(person_file_csv_temp,person_file_csv);

	unlink(person_file);
	unlink(person_file_csv_temp);

	return 1;
}
int itextNetBookList(PLIST_T **head,PLIST_T **tail,char *save_dir)
{
	char person_file[128],person_file_csv[128],person_file_csv_temp[128];
	char time_str[64];
	struct passwd *pwd;
	struct stat sbuf;
	struct tm *tmval;

	if(*head != NULL) plist_data_free(head,tail);

	pwd = getpwuid(getuid());
	sprintf(person_file_csv,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,LIST_FILE_NAME);

	if(stat(person_file_csv,&sbuf) < 0){
		if(itext_list_download((char *)person_file_csv,0) < 0) return -1;
	}

	tmval = localtime(&sbuf.st_ctime);
	strftime(time_str,sizeof(time_str),"%Yǯ%m%d(%H%Mʬ)",tmval);
	_get_book_list(head,tail,person_file_csv,time_str,save_dir);

	return 0;
}
static char * _itext_strstr(char *str0,char *str1)
{
	char *p,str[256];
	int i;

	i=0;
	for(p=str0;*p;p++){
		if(isspace(*p)) continue;
		str[i++] = *p;
	}
	str[i] = '\0';

	if((p = strstr(str,str1)) != NULL) return p;

	return NULL;
}
int itextMatchBookList(PLIST_T **phead,PLIST_T **ptail,PLIST_T *head,char *result)
{
	PLIST_T *pl,*pl_t;
	ILIST_T *li,*li_t;
	int list;

	if(head == NULL || result == NULL) return -1;

	for(pl=head;pl!=NULL;pl=pl->next){

		pl_t = NULL;
		list = 0;
		for(li=pl->list_head;li!=NULL;li=li->next){

			if(	_itext_strstr(li->person,result) != NULL	||
				_itext_strstr(li->title,result) != NULL	||
				_itext_strstr(li->person_h,result) != NULL	||
				_itext_strstr(li->person_i,result) != NULL	){

				li_t = (ILIST_T *)_list_data_alloc();
				li_t->book_id = li->book_id;
				li_t->save_dir = li->save_dir;
				li_t->person_id = li->person_id;
				li_t->person = li->person;
				li_t->title = li->title;
				li_t->type = li->type;
				li_t->person_h = li->person_h;
				li_t->person_i = li->person_i;
				li_t->stat = li->stat;
				li_t->date = li->date;

				if(pl_t == NULL){
					pl_t = (PLIST_T *)_plist_data_alloc();
					pl_t->person = pl->person;
					pl_t->file_date = pl->file_date;

					_list_data_add(&(pl_t->list_head),&(pl_t->list_tail),li_t);
				}else{
					_list_data_add(&(pl_t->list_head),&(pl_t->list_tail),li_t);
				}
				list++;
			}
		}
		if(pl_t == NULL) continue;

		pl_t->total = list;
		_plist_data_add(phead,ptail,pl_t);
	}
	if(*phead == NULL) return -1;

	return 0;
}

