#include "itext.h"

extern unsigned int CHU_KEY_C1;
extern unsigned int CHU_KEY_C2;
extern unsigned int SPACE;

static unsigned char *CHU_SMALL_STR0 = "";
static unsigned char *CHU_SMALL_STR1 = "";
static unsigned char *CHU_SMALL_STR2 = "";
static unsigned char *CHU_SMALL_STR3 = "";
static unsigned char *CHU_SMALL_STR3_1 = "";

static unsigned char *CHU_BOUTEN_STR = "˵";
static unsigned char *CHU_BOUSEN_STR = "˵";

static unsigned char *CHU_JI_STR0 = "Ϥ";
static unsigned char *CHU_JI_STR1 = "դ";
static unsigned char *CHU_JI_STR2 = "Ϥ";
static unsigned char *CHU_JI_STR3 = "";
static unsigned char *CHU_JI_STR4 = "·";

static unsigned char *CHU_TE_STR0 = "ŷ";

BOUTEN_T bouten_type[] = {
	{"˵",0xa1,0xf6},
	{"򥴥˵",0xa1,0xf6},
	{"˵",0xa1,0xfc},
	{"˵",0xa1,0xfb},
	{"˵",0xa2,0xa5},
	{"򻰳˵",0xa2,0xa4},
	{"Ŵ˵",0xa1,0xfd},
	{"ؤ˵",0xa1,0xfe}
};
BOUTEN_T bousen_type[] = {
	{"˵",0,0},
	{"",0,0},
	{"",0,0},
	{"",0,0},
	{"˵",0,0}
};

static int _check_jis_no(char *temp)
{
	unsigned int c1,c2;
	unsigned char *p,no[5];
	int i,flag;

	if(strstr(temp,CHU_JI_STR1) != NULL) return 0;

	if(	(p = (unsigned char *)strstr(temp,CHU_JI_STR0)) == NULL &&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR2)) == NULL	&&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR3)) == NULL &&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR4)) == NULL ){

		if((p = (unsigned char *)strstr(temp,CHU_TE_STR0)) == NULL) return -1;
	}


	flag = 0;
	i = 0;
	while(1){
		if(*p == '\0') break;
		if(!(*p & 0x80)) continue;
		c1 = *p++;
		c2 = *p++;

		if(c1 == 0xa3){
		       if(c2 >= 0xb0 && c2 <= 0xb9){
				flag++;
				switch(c2){
					case 0xb0:no[i++] = '0';break;
					case 0xb1:no[i++] = '1';break;
					case 0xb2:no[i++] = '2';break;
					case 0xb3:no[i++] = '3';break;
					case 0xb4:no[i++] = '4';break;
					case 0xb5:no[i++] = '5';break;
					case 0xb6:no[i++] = '6';break;
					case 0xb7:no[i++] = '7';break;
					case 0xb8:no[i++] = '8';break;
					case 0xb9:no[i++] = '9';break;
				}
		       }else{
			       if(flag) break;
		       }
		}else{
			if(flag) break;
		}
	}
	no[i] = '\0';

	if(i == 0) return -3;

	return atoi(no);
}
static int _check_bouten_type(char *temp)
{
	int i;

	for(i=0;i<sizeof(bouten_type)/sizeof(BOUTEN_T);i++){
		if(strstr(temp,bouten_type[i].name) != NULL) return i;
	}

	return 0;
}
static int _check_bousen_type(char *temp)
{
	int i;

	for(i=0;i<sizeof(bousen_type)/sizeof(BOUTEN_T);i++){
		if(strstr(temp,bousen_type[i].name) != NULL) return i;
	}

	return -1; 
}
int checkRubyString(int i,ITEXT_T **ihead,ITEXT_T **itail,int *small)
{
	ITEXT_T *chu,*it,*chu_head,*chu_tail;
	ITEXT_T *bt,*bouten_head = NULL, *bouten_tail = NULL;
	unsigned char temp[BUFSIZ];
	int a,flag,s_flag,btype;

	if(*itail == NULL) return i;
	chu_head = (*itail)->chu_head;

	a=0;
	for(chu=chu_head;chu!=NULL;chu=chu->next){
		temp[a++] = chu->c1;
		temp[a++] = chu->c2;
	}
	temp[a] = '\0';

	if(strstr(temp,CHU_BOUTEN_STR) != NULL || strstr(temp,CHU_BOUSEN_STR) != NULL){
		int tors;

		if(strstr(temp,CHU_BOUTEN_STR) != NULL){
			tors = 0;
			btype = _check_bouten_type(temp);
		}else if(strstr(temp,CHU_BOUSEN_STR) != NULL){
			tors = 1;
			btype = _check_bousen_type(temp);
		}

		flag = 0;
		s_flag = 0;
		for(chu=chu_head;chu!=NULL;chu=chu->next){

			if(chu->c1==0xa1 && chu->c2==0xd6 && flag == 0){
			       	flag = 1;
				continue;
			}
			if(chu->c1==0xa1 && chu->c2==0xd7 && flag == 1){
				break;
			}

			if(flag){
			       	itextDataInsert(&bouten_head,&bouten_tail,chu->c1,chu->c2,0,0,0);
			}
		}
		if(bouten_head == NULL) goto add_string;

		chu_tail = *itail;
		for(bt=bouten_tail;bt!=NULL;bt=bt->prev){
			for(chu=chu_tail;chu!=NULL;chu=chu->prev){
				if((bt->c1 == chu->c1) && (bt->c2 == chu->c2)){
					if(tors == 0)
						chu->bouten = btype;
					else if(tors == 1)
						chu->bousen = btype;

					break;
				}
			}
		}
		itext_data_free(bouten_head);
		return i;

	}else if((*itail)->c1 == CHU_KEY_C1 && (*itail)->c2 == CHU_KEY_C2){

			if(	strstr(temp,CHU_SMALL_STR0) != NULL && 
				strstr(temp,CHU_SMALL_STR1) != NULL 		){

				(*itail)->small = 1;
				*small = 1;
				return i;
			}
			if(	*small == 1 			&& 
				(strstr(temp,CHU_SMALL_STR3) != NULL ||
				 strstr(temp,CHU_SMALL_STR3_1) != NULL)
			){
			
				*small = 0;
				return i;
			}
			if(	strstr(temp,CHU_JI_STR0) != NULL	|| 
				strstr(temp,CHU_JI_STR1) != NULL	||
				strstr(temp,CHU_JI_STR2) != NULL	||
				strstr(temp,CHU_JI_STR3) != NULL	||
				strstr(temp,CHU_JI_STR4) != NULL	){

				(*itail)->jis = (int)_check_jis_no(temp);
				return i;
			}
			if(	strstr(temp,CHU_TE_STR0) != NULL	){
				(*itail)->tes = (int)_check_jis_no(temp);
				return i;
			}
	}else{
		(*itail)->chu_string = (char *)malloc(strlen(temp)+1);
		strcpy((*itail)->chu_string,temp);
		return i;
	}


add_string :
	for(chu=chu_head;chu!=NULL;chu=chu->next){
		itextDataInsert(ihead,itail,chu->c1,chu->c2,1,1,*small);
	}
	return i;
}
