/*****************************
 * 2002/8/10
 * **************************/

#include "ido_net.h"

#define PRINT_HEADER 0
#define PRINT_NETINFO 0

jmp_buf env;

static int net_tsize=0,net_psize=0,net_csize=0;

void tout(int sig){
	signal(sig,SIG_IGN);
        signal(sig,SIG_DFL);

	longjmp(env,1);
}
static int Net_Link(char *addres,int port)
{
	int sig;
	int fd;
	int connectcount;
	struct sockaddr_in addr;
	struct hostent *hp;

	signal(SIGALRM,tout);

	if((fd=socket(AF_INET,SOCK_STREAM,0)) < 0){
		return -1;
	}
	bzero((char *)&addr,sizeof(addr));

	if((hp=gethostbyname(addres))==NULL){
		return -2;
	}
	bcopy(hp->h_addr,&addr.sin_addr,hp->h_length);
	addr.sin_family=AF_INET;
	addr.sin_port=htons(port);


	if(setjmp(env)==0){
		alarm(10);
		if(connect(fd,(struct sockaddr *)&addr,sizeof(addr))<0){
			return -3;
		}
		alarm(0);
		return fd;
	}else{
		close(fd);
		alarm(0);
		return -4;
	}
			
}
static int get_chunk_size(unsigned char *str,int *size)
{
	char buf[100];
	char chunksize[100];
	char *p,*key = "\r\n";
	int keylen,a,b,k;

	keylen = strlen(key);

	a=0;
	b=0;
	k=0;
	for(p=str,a=0;*p,a<99;p++,a++){
		if(b > 0){
			if(*p == *(key+k)){
				k++;
			}else{
				k=0;
			}
			if(keylen == k){
				buf[b] = '\0';
				sprintf(chunksize,"0x%s",buf);

				*size = strtol(chunksize,NULL,16);
				return a+1;
			}
		}
		if(!isspace(*p))  buf[b++] = *p;
	}

	return 0;
}
static header_t *header_alloc()
{
	header_t *h;

	h = (header_t *)malloc(sizeof(header_t));
	h->http = NULL;
	h->date = NULL;
	h->server = NULL;
	h->lastmodified = NULL;
	h->etag = NULL;
	h->acceptranges = NULL;
	h->contentlength = NULL;
	h->keepalive = NULL;
	h->connection = NULL;
	h->contenttype = NULL;
	h->transferencoding = NULL;
	h->contentencoding = NULL;
	h->location = NULL;

	return h;
}
static int header_sep(char *str,char **buf,int no)
{
	char *p,temp[BUFSIZ];
	int a;

	*buf = (char *)malloc(strlen(str+no)+2);

	a=0;
	for(p=str+no;*p;p++){
		if(!(a==0 && isspace(*p))) temp[a++] = *p;
	}
	temp[a]='\0';

	strcpy(*buf,temp);


	return 0;
}
static int header_httpcode(char *str)
{
	char *p,temp[50];
	int a,b;

	a=0;
	b=0;
	for(p=str;*p;p++){
		if(isspace(*p)){
			if(b==0){
				b=1;
				continue;
			}
			if(b==1){
				temp[a] = '\0';
				return atoi(temp);
			}
		}
		if(b) temp[a++] = *p;
	}

	return 0;
}
static int header_app(char *str,header_t *header)
{
	char *sep = "\r\n\r\n";
	char *p,buf[200];
	int seplen,s,a;

	seplen = strlen(sep);

	s=0;
	a=0;
	for(p=str;*p;p++){
		if(*p == *(sep+s)){
			s++;
		}else{
			s=0;
		}
		if(s == seplen) break;

		if(*p == '\r' || *p == '\n'){
			buf[a] = '\0';

			if(strncmp(buf,"HTTP/",5)==0){
				header_sep(buf,&header->http,0);
				header->http_code = header_httpcode(buf);
			}else if(strncmp(buf,"Date:",5)==0){
				header_sep(buf,&header->date,5);
			}else if(strncmp(buf,"Server:",7)==0){
				header_sep(buf,&header->server,7);
			}else if(strncmp(buf,"Last-Modified:",14)==0){
				header_sep(buf,&header->lastmodified,14);
			}else if(strncmp(buf,"Last-modified:",14)==0){
				header_sep(buf,&header->lastmodified,14);
			}else if(strncmp(buf,"ETag:",5)==0){
				header_sep(buf,&header->etag,5);
			}else if(strncmp(buf,"Accept-Ranges:",14)==0){
				header_sep(buf,&header->acceptranges,14);
			}else if(strncmp(buf,"Accept-ranges:",14)==0){
				header_sep(buf,&header->acceptranges,14);
			}else if(strncmp(buf,"Content-Length:",15)==0){
				header_sep(buf,&header->contentlength,15);
			}else if(strncmp(buf,"Content-length:",15)==0){
				header_sep(buf,&header->contentlength,15);
			}else if(strncmp(buf,"Keep-Alive:",11)==0){
				header_sep(buf,&header->keepalive,11);
			}else if(strncmp(buf,"Keep-alive:",11)==0){
				header_sep(buf,&header->keepalive,11);
			}else if(strncmp(buf,"Connection:",11)==0){
				header_sep(buf,&header->connection,11);
			}else if(strncmp(buf,"Content-Type:",13)==0){
				header_sep(buf,&header->contenttype,13);
			}else if(strncmp(buf,"Content-type:",13)==0){
				header_sep(buf,&header->contenttype,13);
			}else if(strncmp(buf,"Transfer-Encoding:",18)==0){
				header_sep(buf,&header->transferencoding,18);
			}else if(strncmp(buf,"Transfer-encoding:",18)==0){
				header_sep(buf,&header->transferencoding,18);
			}else if(strncmp(buf,"Content-Encoding:",17)==0){
				header_sep(buf,&header->contentencoding,17);
			}else if(strncmp(buf,"Content-encoding:",17)==0){
				header_sep(buf,&header->contentencoding,17);
			}else if(strncmp(buf,"Location:",9)==0){
				header_sep(buf,&header->location,9);
			}
			a=0;
		}

		if(*p != '\r' && *p != '\n') buf[a++] = *p;
	}

	return 0;
}
static int get_header_body(char *str,char **header)
{
	char *p,*temp = NULL,*sep = "\r\n\r\n";
	int a,s,seplen;
	int size;

	if((*header = (char *)malloc(strlen(str))) == NULL) return -1;
	if((temp = (char *)malloc(strlen(str))) == NULL) return -1;
	seplen = strlen(sep);

	a=0;
	s=0;
	for(p=str;*p;p++){
		if(*p == *(sep+s)){
			s++;
		}else{
			s=0;
		}
		if(s==seplen){
			*(temp+(a++)) = '\n';
			*(temp+a) = '\0';
			strcpy(*header,temp);
#if PRINT_HEADER
printf("%s\n",*header);
#endif

			free(temp);
			return a;
		}
		*(temp+(a++)) = *p;
	}
	free(temp);

	return 0;
}
static int Put_Chunked_Body(char **recvmes,char *buf,int n)
{
	int len,after,total;
	char *p;
	char n2ch_mes[50];

	net_tsize += n;
#if PRINT_NETINFO
printf("RECIVE_SIZE(chunked):%d\n",net_tsize);
#endif

	*recvmes = (unsigned char *)realloc(*recvmes,net_tsize+2);

	if(n >= net_csize){
		total = n-net_csize;
		if(net_csize == 0){
			p=buf;
		}else{	
			memcpy(*recvmes+net_psize,buf,net_csize);
			net_psize += net_csize;
			p=buf+net_csize;

			if(total == 2  && *(p+0)=='\r' && *(p+1)=='\n'){
				net_csize = 0;
				return 0;
			}
		}
		while(1){
			if((after = get_chunk_size(p,&net_csize))==0){
				net_csize = 0;
				break;
			}
			if(net_csize == 0){
				return net_psize;
			}
			
			p = p+after;

			if((len = total-after) < net_csize){
				memcpy(*recvmes+net_psize,p,len);
				net_psize += len;
				net_csize -= len;
				break;
			}else{
				total = len - net_csize;
				memcpy(*recvmes+net_psize,p,net_csize);
				net_psize += net_csize;
				p = p+net_csize;
			}
		}
	}else{
		memcpy(*recvmes+net_psize,buf,n);
		net_psize += n;
		net_csize -= n;
	}

	return 0;
}
static int Put_Normal_Body(char **recvmes,char *buf,int bufn,int n,int csize)
{
	int osize;

	osize = net_psize;
	net_psize += bufn;
	net_tsize += n;

#if PRINT_NETINFO
printf("RECIVE_SIZE:%d:%d:%d\n",net_tsize,net_psize,csize);
#endif

	if((*recvmes = (unsigned char *)realloc(*recvmes,net_psize+1)) == NULL) return 1;
	memcpy(*recvmes+osize,buf,bufn);

	if(net_psize >= csize){ 
		return net_psize;
	}

	return 0;
}

static int _http_text_code(shtml_t *shtml,unsigned char *recvmes,unsigned long tsize)
{
	unsigned char *gzipmes;
	unsigned long gzip_size;
	int kerr;

	if(shtml->header->contentencoding != NULL){
#if PRINT_NETINFO
printf("2ch:Content-Encoding:%s:%s\n",shtml->header->contentencoding,shtml->header->transferencoding);
printf("2ch:Inflate Start\n");
#endif
		gzipmes = (unsigned char *)malloc(tsize * 5);
		if((gzip_size = gzip_decompress(recvmes,tsize,gzipmes,tsize * 5))!=0){
			*(gzipmes + gzip_size) = '\0';

#if PRINT_NETINFO
printf("2ch:Inflate End\n");
printf("2ch:Kanji decode Start(gzip)\n");
#endif
			shtml->recv_euc = (unsigned char *)malloc(gzip_size * 2);
			kerr = wkfConvertKanjiCodeOfString(KC_UNKNOWN,gzipmes,KC_EUC,shtml->recv_euc,gzip_size * 2);
			if(kerr <= 0){
				strcpy(shtml->recv_euc,recvmes);
			}
#if PRINT_NETINFO
printf("kanji_error:%d\n",kerr);
printf("2ch:Kanji decode End(gzip)\n");
#endif
		}else{
			shtml->recv_euc = (unsigned char *)malloc(20);
			strcpy(shtml->recv_euc,"No Message");
		}

		free(gzipmes);
	}else{
#if PRINT_NETINFO
printf("2ch:Kanji decode Start ooo : %d byte\n",tsize);
#endif
		shtml->recv_euc = (unsigned char *)malloc(tsize * 2);
		kerr = wkfConvertKanjiCodeOfString(KC_UNKNOWN,recvmes,KC_EUC,shtml->recv_euc,tsize * 2);
		if(kerr <= 0){
			strcpy(shtml->recv_euc,recvmes);
		}
#if PRINT_NETINFO
printf("kanji_error:%d\n",kerr);
printf("2ch:Kanji decode End\n");
#endif
	}
	
	shtml->euc_size = strlen(shtml->recv_euc);

	return 0;
}
static int _http_image_code(shtml_t *shtml,unsigned char *recvmes,unsigned long tsize)
{

	shtml->recv_euc = (unsigned char *)malloc(tsize+1);
	memcpy(shtml->recv_euc,recvmes,tsize);

	shtml->euc_size = tsize;

	return 0;
}
int HTTP_Data_Free(shtml_t *shtml)
{
	if(shtml == NULL) return 0;

	free(shtml->recv_euc);
	free(shtml->header);
	free(shtml);

	return 0;
}
int HTTP_Data_Session(shtml_t *shtml,char *message)
{
	int NORMAL_FLAG = 0;
	int CHUNKED_FLAG = 0;

	int fd;
	char *head = NULL;
	char *p,*recvmes = NULL;
	char sendstr[BUFSIZ];
        char buf[BUFSIZ];
        int n,after,header_count;
	long csize,tsize,hlen,nsize;


	sprintf(sendstr,"GET %s HTTP/1.0\r\n",shtml->target);
        sprintf(sendstr,"%sHOST: %s\r\n",sendstr,shtml->host);
        sprintf(sendstr,"%sUser-Agent: %s\r\n",sendstr,shtml->agent);
        sprintf(sendstr,"%sAccept: %s\r\n",sendstr,shtml->accept);
        sprintf(sendstr,"%sAccept-Language: %s\r\n",sendstr,shtml->accept_charset);
        sprintf(sendstr,"%sAccept-Encoding: %s\r\n",sendstr,shtml->accept_encoding);
        sprintf(sendstr,"%sReferer: %s\r\n",sendstr,shtml->refere);
        sprintf(sendstr,"%sConnection: %s\r\n",sendstr,shtml->connection);
        sprintf(sendstr,"%sTE: %s\r\n",sendstr,shtml->te);
        sprintf(sendstr,"%s\r\n",sendstr);

	if((fd = Net_Link(shtml->host,80)) < 0) return -1;

        send(fd,sendstr,strlen(sendstr),0);

	shtml->header = (header_t *)header_alloc();
	if((recvmes = (char *)malloc(10)) == NULL) return -1;
	*(recvmes + 0) = '\0';

	if(message != NULL) xtext_usage(NULL,0);

	net_psize = 0;
	net_tsize = 0;
	net_csize = 0;

	csize = 0;
	tsize = 0;
	nsize = 0;
	header_count = 0;

	while(1){
		if((n = recv(fd,buf,BUFSIZ,0))<=0){
			tsize = nsize;
		       	break;
		}
		/*n = recv(fd,buf,BUFSIZ,0);*/
		buf[n] = '\0';
		nsize += n;

		if(message != NULL) xtext_usage(message,(double)net_tsize/csize);

		if(shtml->header->http == NULL && header_count == 0){
			if((hlen = get_header_body(buf,&head)) < 0) return -1;
			header_app(head,shtml->header);
			header_count++;
		}

		if(CHUNKED_FLAG){
			if((tsize = Put_Chunked_Body(&recvmes,buf,n))>0) break;

		}else if(NORMAL_FLAG){
			if((tsize = Put_Normal_Body(&recvmes,buf,n,n,csize))>0) break;
		}else if(shtml->header->transferencoding != NULL){
			if(strcmp(shtml->header->transferencoding,"chunked")==0){
				CHUNKED_FLAG = 1;
				Put_Chunked_Body(&recvmes,buf+hlen,n-hlen);
			}
		}else{
			NORMAL_FLAG = 1;
			if(shtml->header->contentlength != NULL){
				csize = atoi(shtml->header->contentlength);
			}else{
				csize = 99999999;
			}
			if((tsize = Put_Normal_Body(&recvmes,buf+hlen,n-hlen,n,csize))>0) break;
		}

	}
	net_psize = 0;
	net_tsize = 0;
	net_csize = 0;
	close(fd);

	if(message != NULL) xtext_usage(NULL,0);

#if PRINT_NETINFO
printf("Date : %s\n",shtml->header->date);
printf("Content-Type:%s\n",shtml->header->contenttype);
printf("TSIZE:%d\n",tsize);
#endif

	if(strstr(shtml->header->contenttype,"text")!=NULL || strstr(shtml->header->contenttype,"html")!=NULL){
		_http_text_code(shtml,recvmes,tsize);

	}else if(strstr(shtml->header->contenttype,"image")!=NULL){
		_http_image_code(shtml,recvmes,tsize);

	}else{
		_http_image_code(shtml,recvmes,tsize);
	}
	if(recvmes != NULL) free(recvmes);

	return 0;
}

