#include "itext.h"

#include <X11/Intrinsic.h>
#include <X11/keysym.h>

#if HAVE_LIBXFT
#include <X11/Xft/Xft.h>
#include <X11/extensions/Xrender.h>
#endif

enum {
	XJP_NONE = -1,
	XJP_INT,
	XJP_CHA,
	XJP_STR,
	XJP_COL,
	XJP_FONT
};
enum {
	XJP_LEFT = -1,
	XJP_CENTER,
	XJP_RIGHT
};

typedef struct{
	int main_window_width;
	int main_window_height;
	char *main_window_img;
	char *main_window_color;
	char *main_font_color;
	char *main_shadow_color;
	char *rubi_font_color;
	char *menu_window_color;
	char *menu_font_color;
	char *select_window_color;
	char *select_font_color;
	char *select_font_background_color;
	char *main_font_j;
	char *main_font_s;
	char *main_font_e;
	char *book_dir;
	char *rubi_font;

	char page_next[10];
	char page_prev[10];
	char conf_page[10];
	char book_mark[10];
	char siori_menu[10];
	char quit[10];
	char menu[10];
	char title_key[10];
	char kinsc_key[10];
	char chuki_key[10];
	char page_key[10];
	char net_key[10];
	char cursor_key[10];

	int anti;
	int title_on;
	int ruby_on;
	int page_on;
	int kinsc;
	int cursor;
	int chuki;
	int line_space;
	int row_space;

}xtext_conf_t;
typedef struct{
	Window win;
	Window cwin;
	Window mwin;

	int width;
	int height;

	struct {
		Pixmap img;
		int width;
		int height;
		char *position;
	}image;

	GC gc;
	GC bgc;
	GC fgc,rfgc;
	GC rubi_gc;
	GC sgc;

	XFontSet fs;
	XFontSet fs_s;
	XFontSet fs_e;
	XFontSet rubi_fs;

	long fg_pixel;
	long bg_pixel;
	long menu_fg_pixel;
	long menu_bg_pixel;
	long rubi_fg_pixel;
	long rubi_bg_pixel;

#if HAVE_LIBXFT
	XftFont	*font;
	XftFont *font_s;
	XftFont *font_e;
	XftFont *font_rubi;

	XftDraw	*draw;

	XftColor fg_color;
	XftColor bg_color;
	XftColor rubi_color;
	XftColor menu_fg_color;
	XftColor menu_bg_color;
#endif

	Visual	*visual;
	Colormap cmap;

	int kinsc;
	int anti;
	int title_on;
	int page_on;
	int cursor;

}my_window_t;
typedef struct {
	Window parent_win;
	Window win;
	int x;
	int y;
	int width;
	int height;

	GC gc;
	GC bgc;
	GC fgc;
	GC rfgc;
	GC sgc;

	long fg_pixel;
	long bg_pixel;

	XFontSet fs;

#if HAVE_LIBXFT
	XftFont	*font;
	XftDraw	*draw;

	XftColor menu_fg_color;
	XftColor menu_bg_color;
#endif
	Visual	*visual;
	Colormap cmap;

}my_subwindow_t;
typedef struct CHARIMAGE{
	unsigned int c1;
	unsigned int c2;
	int chu;
	int small;

	XImage *char_image;

	struct CHARIMAGE *next;
	struct CHARIMAGE *prev;
}image_data_t;

typedef struct PAGEDATA{
	int char_no;
	int page_no;

	struct PAGEDATA *next;
	struct PAGEDATA *prev;
}page_data_t;

typedef struct {
	char book_path[256];
	char book_title[256];
	char book_title_utf8[256];
	int total_page;
}book_data_t;

typedef struct CHUDATA{
        char message[256];

        struct CHUDATA *next;
        struct CHUDATA *prev;
}chu_data_t;

typedef struct {

	int charSize;
	int charSize_s;
	int charSize_e;
	int charSize_r;
	int m_off;
	int s_off;
	int e_off;
	int xpad;
	int ypad;

	image_data_t *im_head;
	image_data_t *im_tail;

	page_data_t *head;
	page_data_t *tail;

	book_data_t *book;

}char_data_t;
typedef struct XOFFSET {
	char font[128];
	unsigned int c1;
	unsigned int c2;

	int anti;

	int x_off;
	int y_off;

	struct XOFFSET *next;
	struct XOFFSET *prev;
}offset_data_t;

typedef struct SUBWINDOWDATA{
	char *line_str;
	void *line_data;
	char *re_str;

	int (*func)();
	void *func_data0;
	int func_data1;

	int type;
	int line_no;
	int mall;

	struct SUBWINDOWDATA *next;
	struct SUBWINDOWDATA *prev;
}sub_window_t;
typedef struct CTRLWINDOWDATA{
	char *name;
	int xpos0;
	int xpos1;
	int ypos0;
	int ypos1;
	int (*func)();
	void *func_data0;

	struct CTRLWINDOWDATA *next;
	struct CTRLWINDOWDATA *prev;
}ctl_window_t;

typedef struct SIORIDATA{
	unsigned char book_path[256];
	unsigned char book_title[256];
	unsigned char book_time[256];

	int NPC;

	struct SIORIDATA *next;
	struct SIORIDATA *prev;

}xtext_siori_t;
typedef struct XJP_FONT_DATA {
        char name[100];

        struct XJP_FONT_DATA *head;
        struct XJP_FONT_DATA *tail;

        struct XJP_FONT_DATA *next;
        struct XJP_FONT_DATA *prev;

}xtext_font_t;
typedef struct XJP_EFONT_DATA{
	char name[50];

	struct XJP_EFONT_DATA *next;
	struct XJP_EFONT_DATA *prev;
}xtext_efont_t;


int xtext_Init_Text(Display *,my_window_t *,IBUF_T *,char_data_t *);
int xtext_Draw_Text(Display *,my_window_t *,IBUF_T *,char_data_t *,page_data_t *);

int xtext_Draw_Help(Display *,my_window_t *,xtext_conf_t *);
char *xtextSubWindow(Display *,my_window_t,sub_window_t *,sub_window_t *,int,int);
char *xtextInputWindow(Display *,my_window_t *,char *,char *,int);
int xtextSubWindow_Message(Display *,my_window_t,char *);


char * xtext_conf_data(xtext_conf_t *);
int xtext_next_kuten(ITEXT_T *,int);
int xtext_prev_kuten(ITEXT_T *,int);
int xtext_get_low_space(ITEXT_T *,char_data_t *);
int xtext_get_low_pos(ITEXT_T *,char_data_t *,int,int);
int xtextPersonData2Sub(sub_window_t **,sub_window_t **,PLIST_T *);
int xtextListData2Sub(sub_window_t **,sub_window_t **,ILIST_T *);
int xtextHelpData2Sub(sub_window_t **,sub_window_t **,xtext_conf_t *);
int xtextSioriData2Sub(sub_window_t **,sub_window_t **,xtext_siori_t *);
int xtextBookData2Sub(sub_window_t **,sub_window_t **,char *);
int xtextCardData2Sub(sub_window_t **,sub_window_t **,itext_table_t *);
int xtextClearChuMessage(Display *,my_window_t *);
int xtextDrawChuMessage(Display *,my_window_t *,char_data_t *);
int xtextChuMessage(Display *,my_window_t *,char_data_t *,char *);
int xtextCursorType(Display *,my_window_t *,char *);
int xtextDispPerson(void *,int);
int xtextDispList(void *,int);
int xtextSerchList(void *,int);
void xtext_usage(char *,double);
int xtext_conf_change(void *,int);
int xtext_conf_quit(void *,int);
int xtext_conf_save(void *,int);
char *xtext_Selector_Window(char *,int);
int xtext_font_J2E(char *,char *);
int parse_xlfd_No(char *,char *,int);
int xtext_offt_data(offset_data_t **,offset_data_t **);
int xtext_offt_set(offset_data_t *,offset_data_t *,xtext_conf_t,offset_data_t **,offset_data_t **);
int xtext_set_offset(IBUF_T *,IBUF_T *,offset_data_t *);
int _select_book_data(char *);
