#include "xtext.h"
#include <pwd.h>


static char *conf_d[] = {		"MAIN_WINDOW_WIDTH:",
					"MAIN_WINDOW_HEIGHT:",
					"MAIN_WINDOW_IMAGE:",
					"MAIN_WINDOW_COLOR:",
					"MAIN_FONT_COLOR:",
					"MAIN_SHADOW_COLOR:",
					"MENU_WINDOW_COLOR:",
					"MENU_FONT_COLOR:",
					"SELECT_WINDOW_COLOR:",
					"SELECT_FONT_COLOR:",
					"SELECT_FONT_BACKGROUND_COLOR:",
					"MAIN_FONT_J:",
					"MAIN_FONT_S:",
					"MAIN_FONT_E:",
					"LINE_SPACE:",
					"ROW_SPACE:",
					"TITLE_DISP:",
					"RUBY_DISP:",
					"PAGE_DISP:",
					"KINSC_DISP:",
					"CURS_DISP:",
					"CHUKI_DISP:",
					"BOOK_DIR:",
					"RUBI_FONT:",
					"XFT_FONT:",
					"RUBI_FONT_COLOR:",
					"PAGE_NEXT:",
					"PAGE_PREV:",
					"CONF_PAGE:",
					"BOOK_MARK:",
					"SIORI_MENU:",
					"QUIT:",
					"MENU:",
					"TITLE_KEY:",
					"KINSC_KEY:",
					"CURS_KEY:",
					"CHUKI_KEY:",
					"PAGE_KEY:",
					"NET_KEY:"		};

static int _get_data(char *s,char *t)
{
	char *p;
	int i = 0;
	int flag = 0;

	for(p=s;*p;p++){
		if(!isspace(*p)) flag = 1;
		if(*p == '\n'){
			*(t + i) = '\0';
			return 0;
		}
		if(flag) *(t + (i++)) = *p;
	}
	*(t + i) = '\0';

	return 0;
}
static int _init_xconf(xtext_conf_t *xconf)
{
	xconf->main_window_width = -1;
	xconf->main_window_height = -1;
	xconf->main_window_img = NULL;
	xconf->main_window_color = NULL;
	xconf->main_font_color = NULL;
	xconf->main_shadow_color = NULL;
	xconf->rubi_font_color = NULL;
	xconf->menu_window_color = NULL;
	xconf->menu_font_color = NULL;
	xconf->select_window_color = NULL;
	xconf->select_font_color = NULL;
	xconf->select_font_background_color = NULL;
	xconf->main_font_j = NULL;
	xconf->main_font_s = NULL;
	xconf->main_font_e = NULL;
	xconf->book_dir = NULL;
	xconf->rubi_font = NULL;
	xconf->anti = -1;
	xconf->title_on = -1;
	xconf->ruby_on = -1;
	xconf->page_on = -1;
	xconf->kinsc = -1;
	xconf->cursor = -1;
	xconf->chuki = -1;
	xconf->line_space = -1;
	xconf->row_space = -1;
	xconf->page_next[0] = '\0';
	xconf->page_prev[0] = '\0';
	xconf->conf_page[0] = '\0';
	xconf->book_mark[0] = '\0';
	xconf->siori_menu[0] = '\0';
	xconf->quit[0] = '\0';
	xconf->menu[0] = '\0';
	xconf->title_key[0] = '\0';
	xconf->kinsc_key[0] = '\0';
	xconf->chuki_key[0] = '\0';
	xconf->page_key[0] = '\0';
	xconf->net_key[0] = '\0';
	xconf->cursor_key[0] = '\0';

	return 0;
}
int _xconf_malloc(char **to,char *from)
{
	if(*to != NULL) free(*to);

	if((*to = (char *)malloc(strlen(from)+1)) != NULL)
		strcpy(*to,from);

	return 0;
}
char * xtext_conf_data(xtext_conf_t *xconf)
{
	FILE *fp;
	struct passwd *pwd;
	char *p,*help,buf[256],temp[256],conf_file_path[256];
	int i,len;

	_init_xconf(xconf);

	pwd = getpwuid(getuid());
	sprintf(conf_file_path,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,CONF_FILE_NAME);
	if((fp = fopen(conf_file_path,"r")) == NULL) goto xtext_def;

	while(fgets(buf,256,fp) != NULL){
		if(buf[0] == '\n' || buf[0] == '#') continue;
		for(i=0;i<sizeof(conf_d)/sizeof(char *);i++){
			len = strlen(conf_d[i]);
			if(strncmp(buf,conf_d[i],strlen(conf_d[i])) == 0){
				_get_data(buf+len,temp);

				switch(i){
					case 0:xconf->main_window_width = atoi(temp);break;
					case 1:xconf->main_window_height = atoi(temp);break;
					case 2:_xconf_malloc(&xconf->main_window_img,temp);break;
					case 3:_xconf_malloc(&xconf->main_window_color,temp);break;
					case 4:_xconf_malloc(&xconf->main_font_color,temp);break;
					case 5:_xconf_malloc(&xconf->main_shadow_color,temp);break;
					case 6:_xconf_malloc(&xconf->menu_window_color,temp);break;
					case 7:_xconf_malloc(&xconf->menu_font_color,temp);break;
					case 8:_xconf_malloc(&xconf->select_window_color,temp);break;
					case 9:_xconf_malloc(&xconf->select_font_color,temp);break;
					case 10:_xconf_malloc(&xconf->select_font_background_color,temp);break;
					case 11:_xconf_malloc(&xconf->main_font_j,temp);break;
					case 12:_xconf_malloc(&xconf->main_font_s,temp);break;
					case 13:_xconf_malloc(&xconf->main_font_e,temp);break;
					case 14:xconf->line_space = atoi(temp);break;
					case 15:xconf->row_space = atoi(temp);break;
					case 16:xconf->title_on = atoi(temp);break;
					case 17:xconf->ruby_on = atoi(temp);break;
					case 18:xconf->page_on = atoi(temp);break;
					case 19:xconf->kinsc = atoi(temp);break;
					case 20:xconf->cursor = atoi(temp);break;
					case 21:xconf->chuki = atoi(temp);break;
					case 22:_xconf_malloc(&xconf->book_dir,temp);break;
					case 23:_xconf_malloc(&xconf->rubi_font,temp);break;
					case 24:xconf->anti = atoi(temp);break;
					case 25:_xconf_malloc(&xconf->rubi_font_color,temp);break;
					case 26:strcpy(xconf->page_next,temp);break;
					case 27:strcpy(xconf->page_prev,temp);break;
					case 28:strcpy(xconf->conf_page,temp);break;
					case 29:strcpy(xconf->book_mark,temp);break;
					case 30:strcpy(xconf->siori_menu,temp);break;
					case 31:strcpy(xconf->quit,temp);break;
					case 32:strcpy(xconf->menu,temp);break;
					case 33:strcpy(xconf->title_key,temp);break;
					case 34:strcpy(xconf->kinsc_key,temp);break;
					case 35:strcpy(xconf->cursor_key,temp);break;
					case 36:strcpy(xconf->chuki_key,temp);break;
					case 37:strcpy(xconf->page_key,temp);break;
					case 38:strcpy(xconf->net_key,temp);break;
				}
				break;
			}
		}
	}
	fclose(fp);

xtext_def:
        if(xconf->main_window_width == -1) xconf->main_window_width=470;
        if(xconf->main_window_height == -1) xconf->main_window_height=530;
        if(xconf->main_window_img == NULL) _xconf_malloc(&xconf->main_window_img,"/home/bg.jpg");
        if(xconf->main_window_color == NULL) _xconf_malloc(&xconf->main_window_color,"DarkSlateGrey");
        if(xconf->main_font_color == NULL) _xconf_malloc(&xconf->main_font_color,"snow");
        if(xconf->main_shadow_color == NULL) _xconf_malloc(&xconf->main_shadow_color,"yellow");
        if(xconf->menu_window_color == NULL) _xconf_malloc(&xconf->menu_window_color,"dark sea green");
        if(xconf->menu_font_color == NULL) _xconf_malloc(&xconf->menu_font_color,"dark slate grey");
        if(xconf->rubi_font_color == NULL) _xconf_malloc(&xconf->rubi_font_color,"green yellow");
        if(xconf->select_window_color == NULL) _xconf_malloc(&xconf->select_window_color,"light slate grey");
        if(xconf->select_font_color == NULL) _xconf_malloc(&xconf->select_font_color,"snow");
        if(xconf->select_font_background_color == NULL) _xconf_malloc(&xconf->select_font_background_color,"medium blue");
        if(xconf->main_font_j == NULL) _xconf_malloc(&xconf->main_font_j,"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*");
        if(xconf->main_font_s == NULL) _xconf_malloc(&xconf->main_font_s,"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*");
        if(xconf->main_font_e == NULL) _xconf_malloc(&xconf->main_font_e,"-misc-fixed-*-*-*-*-16-*-*-*-*-*-iso8859-*");
        if(xconf->book_dir == NULL) _xconf_malloc(&xconf->book_dir,"/home/***/***/book/");
        if(xconf->rubi_font == NULL) _xconf_malloc(&xconf->rubi_font,"-misc-*-*-*-*-*-10-*-*-*-*-*-*-*");
        if(xconf->anti == -1) xconf->anti = 0;
        if(xconf->title_on == -1) xconf->title_on = 1;
        if(xconf->ruby_on == -1) xconf->ruby_on = 1;
        if(xconf->page_on == -1) xconf->page_on = 1;
        if(xconf->kinsc == -1) xconf->kinsc = 1;
        if(xconf->cursor == -1) xconf->cursor = 0;
        if(xconf->chuki == -1) xconf->chuki = 0;
        if(xconf->line_space == -1) xconf->line_space = 0;
        if(xconf->row_space == -1) xconf->row_space = 0;
        if(xconf->page_next[0] == '\0') strcpy(xconf->page_next,"Down");
        if(xconf->page_prev[0] == '\0') strcpy(xconf->page_prev,"Up");
        if(xconf->conf_page[0] == '\0') strcpy(xconf->conf_page,"h");
        if(xconf->book_mark[0] == '\0') strcpy(xconf->book_mark,"space");
        if(xconf->siori_menu[0] == '\0') strcpy(xconf->siori_menu,"s");
        if(xconf->quit[0] == '\0') strcpy(xconf->quit,"q");
        if(xconf->menu[0] == '\0') strcpy(xconf->menu,"f");
        if(xconf->title_key[0] == '\0') strcpy(xconf->title_key,"Tab");
        if(xconf->kinsc_key[0] == '\0') strcpy(xconf->kinsc_key,"k");
        if(xconf->cursor_key[0] == '\0') strcpy(xconf->cursor_key,"u");
        if(xconf->chuki_key[0] == '\0') strcpy(xconf->chuki_key,"c");
        if(xconf->page_key[0] == '\0') strcpy(xconf->page_key,"p");
        if(xconf->net_key[0] == '\0') strcpy(xconf->net_key,"n");

	help = (char *)malloc(2); *(help+0) = '\0'; len = 0;
	for(i=0;;i++){
		if(i==0){p=xconf->page_next;strcpy(temp,"ڡ");}
		if(i==1){p=xconf->page_prev;strcpy(temp,"ڡ");}
		if(i==2){p=xconf->conf_page;strcpy(temp,"ѹ");}
		if(i==3){p=xconf->book_mark;strcpy(temp,"");}
		if(i==4){p=xconf->siori_menu;strcpy(temp,"");}
		if(i==5){p=xconf->quit;strcpy(temp,"λ");}
		if(i==6){p=xconf->menu;strcpy(temp,"޽");}
		if(i==7){p=xconf->title_key;strcpy(temp,"Titleɽ");}
		if(i==8){p=xconf->kinsc_key;strcpy(temp,"");}
		if(i==9){p=xconf->cursor_key;strcpy(temp,"");}
		if(i==10){p=xconf->chuki_key;strcpy(temp,"ɽ");}
		if(i==11){p=xconf->page_key;strcpy(temp,"ڡɽ");}
		if(i==12){p=xconf->net_key;strcpy(temp,"DL");}

		sprintf(buf,"(%s) %s\n",p,temp);
		len += strlen(buf);
		help = (char *)realloc(help,len+1);
		sprintf(help,"%s%s",help,buf);

		if(i==12) break;
	}

	return help;
}
int xtext_conf_change(void * data0,int data1)
{

	xtext_Selector_Window(data0,data1);

	return 0;
}
int xtext_conf_quit(void *data0,int data1)
{
	if(data0 == NULL) return -1;

	if(strcmp((char *)data0,XJP_OK) == 0) return 1;

	return -1;
}	
static int _write_conf_data(FILE *fp,char *name,xtext_conf_t *xconf)
{
	char buf[256];

	if(xconf == NULL) return -1;

	if(strcmp("MAIN_WINDOW_WIDTH:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->main_window_width);
		fputs(buf,fp);
		return strlen(buf);

	}else if(strcmp("MAIN_WINDOW_HEIGHT:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->main_window_height);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_WINDOW_IMAGE:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_window_img);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_WINDOW_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_window_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_FONT_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_font_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_SHADOW_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_shadow_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MENU_WINDOW_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->menu_window_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MENU_FONT_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->menu_font_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("SELECT_WINDOW_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->select_window_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("SELECT_FONT_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->select_font_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("SELECT_FONT_BACKGROUND_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->select_font_background_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_FONT_J:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_font_j);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_FONT_S:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_font_s);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MAIN_FONT_E:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->main_font_e);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("LINE_SPACE:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->line_space);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("ROW_SPACE:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->row_space);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("TITLE_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->title_on);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("RUBY_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->ruby_on);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("PAGE_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->page_on);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("KINSC_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->kinsc);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("CURS_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->cursor);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("CHUKI_DISP:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->chuki);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("BOOK_DIR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->book_dir);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("RUBI_FONT:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->rubi_font);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("XFT_FONT:",name) == 0){
		sprintf(buf,"%s %d",name,xconf->anti);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("RUBI_FONT_COLOR:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->rubi_font_color);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("PAGE_NEXT:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->page_next);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("PAGE_PREV:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->page_prev);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("CONF_PAGE:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->conf_page);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("BOOK_MARK:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->book_mark);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("SIORI_MENU:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->siori_menu);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("QUIT:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->quit);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("MENU:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->menu);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("TITLE_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->title_key);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("KINSC_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->kinsc_key);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("CHUKI_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->chuki_key);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("PAGE_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->page_key);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("NET_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->net_key);
		fputs(buf,fp);
		return strlen(buf);
	}else if(strcmp("CURS_KEY:",name) == 0){
		sprintf(buf,"%s %s",name,xconf->cursor_key);
		fputs(buf,fp);
		return strlen(buf);
	}

	return 0;
}
int xtext_conf_save(void *data0,int data1)
{
	FILE *fp,*op;
	struct passwd *pwd;
	char conf_file_path[256],temp_file_path[256],buf[256];
	int i,flag;
	int CONF_MAX;

	xtext_conf_t *xconf;

	if((xconf = (xtext_conf_t *)data0) == NULL) return -2;

	CONF_MAX = sizeof(conf_d)/sizeof(char *);

	pwd = getpwuid(getuid());
	sprintf(conf_file_path,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,CONF_FILE_NAME);
	sprintf(temp_file_path,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,"xtext.conf.temp");

	if((fp = fopen(conf_file_path,"r")) == NULL){

		if((fp = fopen(conf_file_path,"w")) == NULL) return -3;

		for(i=0;i<CONF_MAX;i++){
			_write_conf_data(fp,conf_d[i],xconf);
			fputs("\n\n",fp);

		}
		fclose(fp);

	}else{
		if((op = fopen(temp_file_path,"w")) == NULL) return -3;

		while(fgets(buf,256,fp) != NULL){

			for(i=0;i<CONF_MAX;i++){
				if(strncmp(buf,conf_d[i],strlen(conf_d[i])) == 0){
					_write_conf_data(op,conf_d[i],xconf);
					fputs("\n",op);
					break;
				}

			}
			if(i == CONF_MAX) fputs(buf,op); 
		}
		fputs("\n",op);
		for(i=0;i<CONF_MAX;i++){
			fseek(fp,0L,SEEK_SET);
			flag=0;
			while(fgets(buf,256,fp) != NULL){
				if(strncmp(buf,conf_d[i],strlen(conf_d[i])) == 0){flag = 1;break;}
			}
			if(flag == 0){ _write_conf_data(op,conf_d[i],xconf);fputs("\n",op);}
		}
		fclose(fp);
		fclose(op);

		if(rename(temp_file_path,conf_file_path) < 0) return -4;
	}

	return 2;
}

