#include "xtext.h"
#include <time.h>

static int _day_of_week(int year,int mon,int day)
{
	int yo;

	if(mon < 3){
		year--;
		mon += 12;
	}
	yo = (year + year/4 - year/100 + year/400 + (13*mon + 8)/5 + day) % 7;

	return yo;
}
static int _day_of_month(int year,int mon)
{
	if(mon == 2 || mon == 4 || mon == 6 || mon == 9 || mon == 11){
		if(mon == 2){
			if(year % 400 == 0 || ((year % 4 == 0) && (year % 100 != 0))){
				return 29;
			}else{
				return 28;
			}
		}else{
			return 30;
		}
	}else{
		return 31;
	}
}

static Pixmap _mask_cursor(Display *disp,my_window_t *win,GC gc,Pixmap pix,int w,int h)
{
	XImage *im,*im1;
	Pixmap mask;
	int x,y;

	if(gc == 0 || pix == 0) return 0;

	if((im = XGetImage(disp,pix,0,0,w,h,AllPlanes,XYPixmap)) == NULL) return 0;
	if((im1 = XGetImage(disp,pix,0,0,w,h,AllPlanes,XYPixmap)) == NULL) return 0;

	for(x=0;x<w;x++){
		for(y=0;y<h;y++){
			if(XGetPixel(im,x,y) == 0x1){
				XPutPixel(im1,x,y,0x1);
			}else{
				XPutPixel(im1,x,y,0x0);
			}
		}
	}
	mask = XCreatePixmap(disp,win->win,w,h,1);
	XPutImage(disp,mask,gc,im1,0,0,0,0,w,h);

	XDestroyImage(im);
	XDestroyImage(im1);

	return mask;

}
static Pixmap _cale_cursor(Display *disp,my_window_t *win,GC *gc,int *w,int *h)
{
	Pixmap pix;
	XRectangle ink,log;
	char *base = "25",str[10];
	time_t cur_time;
	struct tm *tmval;
	int week,day;
	int i,len,x,y,xx,xp,yp,xpad,ypad;

	XmbTextExtents(win->rubi_fs,base,strlen(base),&ink,&log);

	*w = log.width * 7 + 30;
	*h = log.height * 7 + 10;

	pix = XCreatePixmap(disp,win->win,*w,*h,1);
	if(*gc == 0) *gc = XCreateGC(disp,pix,0,0);
	XSetForeground(disp,*gc,win->fg_pixel);
	XFillRectangle(disp,pix,*gc,0,0,*w,*h);
	XSetForeground(disp,*gc,win->bg_pixel);

	cur_time = time(NULL);
	tmval = localtime(&cur_time);
	week = _day_of_week(tmval->tm_year + 1900,tmval->tm_mon + 1,1);
	day = _day_of_month(tmval->tm_year + 1900,tmval->tm_mon + 1);

	xp = *w / 7;
	yp = *h / 7;
	xpad = xp/2;
	ypad = 5;

	x = xpad + (week * xp);
	y = yp + ypad;
	for(i=1;i<=day;i++){
		sprintf(str,"%d",i);
		len = strlen(str);

		xx = x;
		if(len == 2){
			XmbTextExtents(win->rubi_fs,str,len,&ink,&log);
			xx = x - ink.width / 2;
		}
		XmbDrawString(disp,pix,win->rubi_fs,*gc,xx,y,str,len);

		if((x += xp) >= (xp * 7)){
			x = xpad;
			y += yp;
		}
	}

	strftime(str,sizeof(str),"%y/%m",tmval);
	XmbTextExtents(win->rubi_fs,str,strlen(str),&ink,&log);
	x = *w - ink.width - 3;
	y = *h - 2;
	XmbDrawString(disp,pix,win->rubi_fs,*gc,x,y,str,strlen(str));

	return pix;
}
static Pixmap _help_cursor(Display *disp,my_window_t *win,GC *gc,int *w,int *h,char *help)
{
	Pixmap pix;
	XRectangle ink,log;
	char *p,temp[128];
	int i=0,line=0,height=0,width=0;

	if(help == NULL) return 0;

	for(p=help;*p;p++){
		if(*p == '\n'){
			temp[i] = '\0';
			XmbTextExtents(win->rubi_fs,temp,i,&ink,&log);
			if(width < log.width) width = log.width;
			if(height < log.height) height = log.height;
			i=0;
			line++;
			continue;
		}
		temp[i++] = *p;
	}
	*w = width + 10;
	*h = height * line + 10;

	pix = XCreatePixmap(disp,win->win,*w,*h,1);
	if(*gc == 0) *gc = XCreateGC(disp,pix,0,0);

	XSetForeground(disp,*gc,win->fg_pixel);
	XFillRectangle(disp,pix,*gc,0,0,*w,*h);
	XSetForeground(disp,*gc,win->bg_pixel);

	i=0;
	line = 0;
	for(p=help;*p;p++){
		if(*p == '\n'){
			temp[i] = '\0';
			XmbDrawString(disp,pix,win->rubi_fs,*gc,5,height*line+height+5,temp,i);
			i=0;
			line++;
			continue;
		}
		temp[i++] = *p;
	}

	return pix;
}
static Pixmap _time_cursor(Display *disp,my_window_t *win,GC *gc,int *w,int *h)
{
	time_t nowTime;
	struct tm *tmval;

	Pixmap pix;
	XRectangle ink,log;

	char str[50];

	nowTime = time(NULL);
	tmval = localtime(&nowTime);
	strftime(str,sizeof(str),"%Y/%m/%d %H:%M:%S",tmval);
	XmbTextExtents(win->rubi_fs,str,strlen(str),&ink,&log);
	*w = log.width + 10;
	*h = log.height + 10;

	pix = XCreatePixmap(disp,win->win,*w,*h,1);
	if(*gc == 0) *gc = XCreateGC(disp,pix,0,0);

	XSetForeground(disp,*gc,win->fg_pixel);
	XFillRectangle(disp,pix,*gc,0,0,*w,*h);
	XSetForeground(disp,*gc,win->bg_pixel);
	XmbDrawString(disp,pix,win->rubi_fs,*gc,5,*h-5,str,strlen(str));

	return pix;
}
static Pixmap _version_cursor(Display *disp,my_window_t *win,GC *gc,int *w,int *h)
{
	char str[50];
	Pixmap pix;
	XRectangle ink,log;

	sprintf(str,"%s %s",XTEXT_NAME,XTEXT_VERSION);
	XmbTextExtents(win->rubi_fs,str,strlen(str),&ink,&log);
	*w = log.width + 10;
	*h = log.height + 10;

	pix = XCreatePixmap(disp,win->win,*w,*h,1);
	if(*gc == 0) *gc = XCreateGC(disp,pix,0,0);

	XSetForeground(disp,*gc,win->fg_pixel);
	XFillRectangle(disp,pix,*gc,0,0,*w,*h);
	XSetForeground(disp,*gc,win->bg_pixel);
	XmbDrawString(disp,pix,win->rubi_fs,*gc,5,*h-5,str,strlen(str));

	return pix;
}
int xtextCursorType(Display *disp,my_window_t *win,char *help)
{
	static Cursor cursor;
	static GC gc;
	static int type;
	Pixmap pix=0,mask=0;
	int w,h;

	if(type != 0 && win->cursor == 0){
		XUndefineCursor(disp,win->win);
	}
	if(type == 1 && win->cursor == 1) return 0;
	if(type == 3 && win->cursor == 3) return 0;
	if(type == 4 && win->cursor == 4) return 0;

	type = win->cursor;
	switch(type){
		case 1:
			pix = (Pixmap)_version_cursor(disp,win,&gc,&w,&h);
		break;
		case 2:
			pix = (Pixmap)_time_cursor(disp,win,&gc,&w,&h);
		break;
		case 3:
			pix = (Pixmap)_cale_cursor(disp,win,&gc,&w,&h);
		break;
		case 4: 
			pix = (Pixmap)_help_cursor(disp,win,&gc,&w,&h,help);
		break;

		default:case 0:
			return 0;
		break;
	}
	if((mask = (Pixmap)_mask_cursor(disp,win,gc,pix,w,h)) > 0){ 
		XColor c0,c1;

		c0.pixel = win->rubi_fg_pixel;
		c1.pixel = win->rubi_bg_pixel;
		XQueryColor(disp,win->cmap,&c0);
		XQueryColor(disp,win->cmap,&c1);

		if(cursor) XFreeCursor(disp,cursor);
		cursor = XCreatePixmapCursor(disp,pix,mask,&c0,&c1,w/2,h/2);
		XDefineCursor(disp,win->win,cursor);

	}

	if(mask) XFreePixmap(disp,mask);
	if(pix) XFreePixmap(disp,pix);


	return 0;
}


