#include "xtext.h"

#define debug 0

extern iconv_t XJP_CONV;
extern char *XJP_MESSAGE[];
extern char *SEIKEI_LEVEL;
extern int CHAR_HEADER;
extern int CHAR_FOOTER;
extern BOUTEN_T bouten_type[];
extern BOUTEN_T bousen_type[];

static int CHU_NO = 0;
static int RUBY_YPOS = 0;


static int _get_str_size(Display *disp,my_window_t *win,char *euc_str,char *utf8_str,int *w,int *h,int font_type)
{
	XFontSet fs;

	fs = win->fs_s;
	if(font_type) fs = win->fs;

	if(win->anti == 0){
		XRectangle ink,log;

		*w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
	}else{
#if HAVE_LIBXFT
		XftFont *font;
		XGlyphInfo gi;

		font = win->font_s;
		if(font_type) font = win->font;

		XftTextExtentsUtf8(disp,font,utf8_str,strlen(utf8_str),&gi);

		*w = gi.width;
		*h = gi.height;
#else
		XRectangle ink,log;

		*w = XmbTextExtents(fs,euc_str,strlen(euc_str),&ink,&log) + 2;	
		*h = log.height + 2;
#endif
	}

	return 0;
}
static int _Draw_Page_Title_String(	Display *disp,
					my_window_t *win,
					char *euc_str,
					char *utf8_str,
					int x,
					int y,
					int font_type		)
{
	XFontSet fs;
	GC gc;

	fs = win->fs_s;
	if(font_type) fs = win->fs;
	gc = win->rubi_gc;

	if(win->anti == 0){
		XmbDrawString(disp,win->win,fs,gc,x,y,euc_str,strlen(euc_str));

	}else{
#if HAVE_LIBXFT
		XftFont *font;

		font = win->font_s;
		if(font_type) font = win->font;

		XftDrawStringUtf8(win->draw,&(win->rubi_color),font,x,y,utf8_str,strlen(utf8_str));
#else
		XmbDrawString(disp,win->win,fs,gc,x,y,euc_str,strlen(euc_str));
#endif
	}

	return 0;
}
static int XtextDrawString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
	GC gc;
	XFontSet fs;
	unsigned char text[3];
	int xpad,ypad;

	text[0] = it->c1;
	text[1] = it->c2;
	text[2] = '\0';

	gc = win->gc;
	fs = win->fs;
	if(it->chu) gc = win->rubi_gc;
	if(it->small) fs = win->fs_s;
	xpad = it->x_off;
	ypad = it->y_off;

	XmbDrawString(disp,win->win,fs,gc,x+xpad,y+ypad,text,strlen(text));

	return 0;
}
static int XtextDrawAntiString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y		)
{
#if HAVE_LIBXFT

	XftFont *font;
	XftColor color;
	XGlyphInfo gi;
	int xoff = 0;
	int yoff;
	int xpad,ypad;
	int charSize;
	char utf8[10];
	unsigned char temp[3];

	temp[0] = it->c1;
	temp[1] = it->c2;
	temp[2] = '\0';
	euc2utf8_c(XJP_CONV,utf8,temp,2);

	font = win->font;
	color = win->fg_color;
	charSize = char_d->charSize;
	if(it->chu) color = win->rubi_color;
	if(it->small){
		font = win->font_s;
		charSize = char_d->charSize_s;
	}

	xpad = it->x_off;
	ypad = it->y_off;

	/*
	XftTextExtentsUtf8(disp,font,utf8,strlen(utf8),&gi);
	xoff = (charSize - gi.xOff) / 2;
	xoff = (charSize - (gi.width - gi.x))/2;
	*/
	xoff = 0;
	yoff = 1;
	XftDrawStringUtf8(win->draw,&color,font,x+xoff+xpad,y+yoff+ypad,utf8,strlen(utf8));

#else

	XtextDrawString(disp,win,char_d,it,x,y);

#endif

	return 0;
}
static int XtextDrawImageString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					ITEXT_T *it,
					int x0,
					int y0	)

{
	XImage *image_str = NULL;
	image_data_t *im;
	int x,y;
	int charSize;

	for(im=char_d->im_head;im!=NULL;im=im->next){
		if(im->c1 == it->c1 && im->c2 == it->c2 && im->chu == it->chu && im->small == it->small){
			image_str = im->char_image;
			break;
		}
	}
	if(image_str == NULL) return -1;

	charSize = char_d->charSize;
	/*if(it->ej = 0) charSize = char_d.charSize_e;*/
	if(it->small == 1) charSize = char_d->charSize_s;

	x = x0;
	y = y0 - charSize + 2;

	XPutImage(disp,win->win,win->gc,image_str,0,0,x,y,image_str->width,image_str->height);


	return 0;
}
static int XtextDrawChuString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	XRectangle ink,log;
	char temp[256];
	int w,x,y;

	if(it == NULL) return -1;
	if(it->chu_string == NULL) return -1;

	sprintf(temp,"(%d)",++CHU_NO);
	w = XmbTextExtents(win->rubi_fs,temp,strlen(temp),&ink,&log);	

	x = x0 + (char_d->charSize - w)/2 + 1;
	y = y0 + char_d->charSize_r+1;

	XmbDrawString(disp,win->win,win->rubi_fs,win->sgc,x,y,temp,strlen(temp));

	sprintf(temp,"(%d) %s",CHU_NO,it->chu_string);
	xtextChuMessage(disp,win,char_d,temp);

	return 0;
}
static int XtextDrawRubiString(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x0,
				int y0	)
{
	ITEXT_T *rb;
	unsigned char text[3];
	char utf8[10];
	int k_len=0,r_len=0;
	int x,y,i,tail_y;


	if(win->anti == 0){
		if(win->rubi_fs == NULL) return -1;
	}else{
#if HAVE_LIBXFT
		if(win->font_rubi == NULL) return -1;
#else
		if(win->rubi_fs == NULL) return -1;
#endif
	}

	if(it->rub > 0){
		for(i=1;i<it->rub;i++){
			k_len = k_len + (char_d->charSize + char_d->ypad);
		}
	}else{
		for(rb=it;rb!=NULL;rb=rb->prev){
			if(!(rb->c1 >= 0xb0) && k_len != 0) break;
			k_len = k_len + (char_d->charSize + char_d->ypad);
		}
	}

	for(rb=it->rubi_head;rb!=NULL;rb=rb->next){
		r_len = r_len + char_d->charSize_r;
	}

	if(k_len >= r_len){
		y = y0;
	}else{
		if((y = y0 + ((r_len - k_len)/2)) > win->height-2) y = y0;
	}
	if(y - r_len < 0) y = r_len + char_d->charSize_r;

	if(y - r_len < RUBY_YPOS) y = RUBY_YPOS + r_len + char_d->charSize_r;
	RUBY_YPOS = y;

	x = x0 + char_d->charSize - 1;
	for(rb=it->rubi_tail;rb!=NULL;rb=rb->prev){
		text[0] = rb->c1;
		text[1] = rb->c2;
		text[2] = '\0';

		if(win->anti == 0){
			XmbDrawString(disp,win->win,win->rubi_fs,win->rubi_gc,x,y,text,strlen(text));
		}else{
#if HAVE_LIBXFT
			euc2utf8_c(XJP_CONV,utf8,text,2);
			XftDrawStringUtf8(win->draw,&(win->rubi_color),win->font_rubi,x,y,utf8,strlen(utf8));

#else
			XmbDrawString(disp,win->win,win->rubi_fs,win->rubi_gc,x,y,text,strlen(text));
#endif
		}
		y = y - char_d->charSize_r;
	}

	return 0;
}
static int XtextDrawBoutenString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					int btype,
					int x0,
					int y0			)
{
	int x,y,x1,y1;

	if(win == NULL) return -1;
	if(char_d == NULL) return -1;


	x = x0 + char_d->charSize;
	x1 = x + char_d->charSize_r;
	y = y0 - char_d->charSize;
	y1 = y0;

	xtextDrawArc(disp,win,x,y,x1,y1,btype);

	return 0;
}
static int XtextDrawBousenString(	Display *disp,
					my_window_t *win,
					char_data_t *char_d,
					int btype,
					int x0,
					int y0			)
{
	int x,y,x1,y1;

	if(win == NULL) return -1;
	if(char_d == NULL) return -1;

	x = x0 + char_d->charSize + 1;
	x1 = x;
	y = y0 - char_d->charSize + 2;
	y1 = y0 + 2;

	xtextDrawLine(disp,win,x,y,x1,y1,btype);

	return 0;
}
static int _Draw_String(	Display *disp,
				my_window_t *win,
				char_data_t *char_d,
				ITEXT_T *it,
				int x,
				int y	)
{

	if(it->ej == 1){
		if(XtextDrawImageString(disp,win,char_d,it,x,y) < 0){

			if(win->anti == 0){
				XtextDrawString(disp,win,char_d,it,x,y);
			}else{
				XtextDrawAntiString(disp,win,char_d,it,x,y);
			}

			if(win->page_on){

				if(it->bouten >= 0) XtextDrawBoutenString(disp,win,char_d,it->bouten,x,y);
				if(it->bousen >= 0) XtextDrawBousenString(disp,win,char_d,it->bousen,x,y);

				if(it->rubi_head != NULL) XtextDrawRubiString(disp,win,char_d,it,x,y);
			}
			

		}
	}else{
		XtextDrawImageString(disp,win,char_d,it,x,y);
	}

	if(it->chu_string != NULL) XtextDrawChuString(disp,win,char_d,it,x,y);


	return 0;
}
int xtext_Draw_Text(	Display *disp,
			my_window_t *win,
			IBUF_T *l_head,
			char_data_t *char_d,
			page_data_t *char_p	)
{
	IBUF_T *ib;
	ITEXT_T *it;

	char page_str[20];
	char level_str[2][20];

	int KINSOKU = 0;
	int sc = 0,flag = 0;
	int x,y,one_line,start_line,end_line,start_low,end_low;
	int h;
	int width,height;

	if(l_head == NULL) return -1;

	KINSOKU = win->kinsc;
	CHU_NO = 0;

	XClearWindow(disp,win->win);
	xtextClearChuWindow(disp,win,char_d);


	if(win->title_on){
		_get_str_size(disp,win,char_d->book->book_title,char_d->book->book_title_utf8,&width,&height,0);
		_Draw_Page_Title_String(disp,win,char_d->book->book_title,char_d->book->book_title_utf8,2,height,0);

		sprintf(level_str[0],"%s %d",XJP_MESSAGE[6],KINSOKU);
		sprintf(level_str[1],"%s %d",SEIKEI_LEVEL,KINSOKU);
		_get_str_size(disp,win,level_str[0],level_str[1],&width,&height,0);
		_Draw_Page_Title_String(disp,win,level_str[0],level_str[1],win->width-width-10,height,0);
	}

	one_line = char_d->charSize + char_d->xpad + char_d->charSize_r;

	start_line = win->width - one_line;
	end_line = 2;

	start_low = char_d->charSize * CHAR_HEADER;
	end_low = win->height - char_d->charSize * CHAR_FOOTER;

	x = start_line;
	y = start_low;
#if debug
fprintf(stderr,"Draw Start\n");
#endif
	for(ib=l_head;ib!=NULL;ib=ib->next){


		for(it=ib->i_head;it!=NULL;it=it->next){
			if(sc++ >= char_p->char_no) flag++;

			if(flag){
				if(it->jis >= 0 || it->tes >= 0) y = xtext_get_low_pos(it,char_d,start_low,end_low);
				_Draw_String(disp,win,char_d,it,x,y);
				h = xtext_get_low_space(it,char_d);

				if((y += h) > end_low){
					if(xtext_next_kuten(it,KINSOKU) == 0){
						if((x -= one_line) <= end_line) goto _draw_end;

						if(xtext_prev_kuten(it,KINSOKU) == 1){
					       		it = it->prev;
							XClearArea(disp,win->win,x+one_line,y-h*2,h+char_d->xpad+char_d->charSize_r+1,win->height,False);
						}
						y = start_low;
						RUBY_YPOS = 0;
					}
				}
			}
		}
		if(flag){
			if((x -= one_line) <= end_line) goto _draw_end;
			y = start_low;
			RUBY_YPOS = 0;
		}
	}
#if debug
fprintf(stderr,"Draw END\n");
#endif

_draw_end:
	if(win->page_on){
		sprintf(page_str,"(%d/%d)",char_p->page_no,char_d->book->total_page);
		_get_str_size(disp,win,page_str,page_str,&width,&height,0);
		_Draw_Page_Title_String(disp,win,page_str,page_str,(win->width-width)/2,win->height-2,0);
	}

	return char_p->char_no;
}
int xtext_Draw_Help(Display *disp,my_window_t *win,xtext_conf_t *xconf)
{
	char *help_str = NULL,*help_utf8 = NULL;
	int x0,y0,width,height;
	int font_type;

	help_str = (char *)malloc(256);

	font_type = 1;
	sprintf(help_str,"%s   Ver. %s",XTEXT_NAME,XTEXT_VERSION);
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win->width - width) / 2;
	y0 = win->height / 3;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	font_type = 0;
	strcpy(help_str,"Creater : aFterbrEaK,xGrEn,UtoSI");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win->width - width) / 2;
	y0 = y0 + height + 10;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"HomePage : http://xjp-text.sourceforge.jp/");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = (win->width - width) / 2;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"E-Mail : afterbreak@users.sourceforge.jp");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = x0;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"E-Mail : utosi@softhome.net");
	_get_str_size(disp,win,help_str,help_str,&width,&height,font_type);
	x0 = x0;
	y0 = y0 + height + 5;
	_Draw_Page_Title_String(disp,win,help_str,help_str,x0,y0,font_type);

	strcpy(help_str,"Ķʸ : http://www.aozora.gr.jp/");
	help_utf8 = (char *)euc2utf8(XJP_CONV,help_str,strlen(help_str));
	_get_str_size(disp,win,help_str,help_utf8,&width,&height,font_type);
	x0 = x0;
	y0 = y0 + height + 15;
	_Draw_Page_Title_String(disp,win,help_str,help_utf8,x0,y0,font_type);


	if(help_str != NULL) free(help_str);
	return 0;
}




			


