#include "xtext.h"
#include <X11/extensions/shape.h>
#include <Imlib.h>

static int _get_scale(int *width,int *height,int w0,int h0,int w1,int h1)
{
	if(w0 <= w1 && h0 <= h1){
		*width = w0;
		*height = h0;
		return 0;
	}
	if(w0 - w1 >= h0 - h1){
		*width = w1;
		*height = h1 * w0 / w1;
	}else{
		*width = w1 * h0 / h1;
		*height = h1;
	}
	return 0;
}
int xtextGetImage(Display *disp,my_window_t *win,char *fname)
{
	ImlibData *idata;
	ImlibImage *image;
	Pixmap pix;

	int width,height;

	if(win == NULL) return -1;
	if(fname == NULL) return -1;

	if((idata = Imlib_init(disp)) == NULL) return -1;
	if((image = Imlib_load_image(idata,fname)) == NULL) return -1;

	/*
	_get_scale(&width,&height,image->rgb_width,image->rgb_height,win->width,win->height);
	*/

	Imlib_render(idata,image,image->rgb_width,image->rgb_height);
	pix = Imlib_move_image(idata,image);

	win->image.img = pix;
	win->image.width = image->rgb_width;
	win->image.height = image->rgb_height;

	Imlib_destroy_image(idata,image);

	return 0;
}


