#include "xtext.h"

static char *base = "";
static int height;

static void _move_input_position(XIC xic,XFontSet fs,char *str,int slen,int h)
{
	XPoint spot;
	XVaNestedList list;

	spot.x = 5 + XmbTextEscapement(fs,str,slen);spot.y = h;
	list = XVaCreateNestedList(	0,
					XNSpotLocation,&spot,
					NULL			);
	XSetICValues(	xic,
			XNPreeditAttributes,list,
			NULL				);

	XFree(list);
}
static XIC _create_input_context(XIM xim,XIMStyle style,XFontSet fs,Window p,int h,long fg,long bg)
{
	XIC ic;
	XVaNestedList list;
	XPoint spot;

	spot.x = 5; spot.y = h;
	list = XVaCreateNestedList(	0,
					XNFontSet,fs,
					XNSpotLocation,&spot,
					XNForeground,fg,
					XNBackground,bg,
					NULL			);
	ic = XCreateIC(	xim,
			XNInputStyle,style,
			XNClientWindow,p,
			XNPreeditAttributes,list,
			XNStatusAttributes,list,
			NULL				);

	if(ic == NULL) return NULL;
	XFree(list);

	return ic;
}
static XIMStyle _select_input_style(XIM xim)
{
	static XIMStyle preedit[] = {	XIMPreeditPosition,
					XIMPreeditArea,
					XIMPreeditNothing,
					0			};
	static XIMStyle status[] = {	XIMStatusArea,	
					XIMStatusNothing,	
					XIMStatusNone,
					0			};

	XIMStyles *im_style;
	int i,j,k;

	XGetIMValues(xim,XNQueryInputStyle,&im_style,NULL);

	i = 0;
	while(preedit[i] != 0){
		j = 0;
		while(status[j] != 0){
			for(k=0;k<im_style->count_styles;k++){
				if((preedit[i] & im_style->supported_styles[k])	&&
				   (status[j] & im_style->supported_styles[k])	){

					return im_style->supported_styles[k];
				}
			}
			j++;
		}
		i++;
	}

	return 0;
}
static void _draw_input_window(		Display *disp,
					Window win,
					XFontSet fs,
					GC gc,
					int x,
					int y,
					char *str,
					int len		)
{
	if(str != NULL && len >= 0){
		XRectangle ink,log;
		int cx,cy;

		XClearWindow(disp,win);
		XmbDrawString(disp,win,fs,gc,x,y,str,len);

		XmbTextExtents(fs,str,len,&ink,&log);
		cx = x + log.width;
		cy = y - height + 2;
		XFillRectangle(disp,win,gc,cx,cy,3,height);
	}
}
char * xtextInputWindow(Display *disp,my_window_t *win,char *title,char *title2,int percent)
{
	Window pwin,iwin;
	XIM xim;
	XIC xic;
	XIMStyle xstyle;
	XEvent event;
	XRectangle ink,log;

	long mask;
	KeySym sym;
	Status st;

	char *buf,*result;
	int blen = 1024,len;
	char str[1024];
	int slen = 0;
	int i;

	int x,y,w,h;
	int x1,y1,w1,h1;

	if(XSetLocaleModifiers("") == NULL) return NULL;
	if((xim = XOpenIM(disp,NULL,NULL,NULL)) == NULL){
		fprintf(stderr,"XJP-TEXT:Can't Open Input Method. Why ?\n");
	       	return NULL;
	}

	XmbTextExtents(win->fs,base,strlen(base),&ink,&log);

	height = log.height;
	w = (win->width * percent) / 100;
	h = log.height * 4;
	x = (win->width - w) / 2;
	y = (win->height - h) / 2;
	pwin = XCreateSimpleWindow(disp,win->win,x,y,w,h,2,win->menu_fg_pixel,win->menu_bg_pixel);

	w1 = w/2;
	h1 = log.height + 10;
	x1 = 5;
	y1 = log.height + 15;
	iwin = XCreateSimpleWindow(disp,pwin,x1,y1,w1,h1,1,win->menu_fg_pixel,win->menu_bg_pixel);

	if((xstyle = _select_input_style(xim)) == 0){
		fprintf(stderr,"XJP-TEXT:Can't Input Style.");
		XDestroyWindow(disp,pwin);
		XDestroyWindow(disp,iwin);
		return NULL;
	}
	if((xic = _create_input_context(xim,xstyle,win->fs,pwin,h1-2,win->fg_pixel,win->bg_pixel)) == NULL){
		fprintf(stderr,"XJP-TEXT:Can't Input Context.");
		XDestroyWindow(disp,pwin);
		XDestroyWindow(disp,iwin);
		return NULL;
	}
	XGetICValues(xic,XNFilterEvents,&mask,NULL);

	XSelectInput(disp,iwin,ExposureMask|KeyPressMask|/*EnterWindowMask|LeaveWindowMask|*/mask);
	XSelectInput(disp,pwin,ExposureMask);

	XMapRaised(disp,pwin);
	XMapWindow(disp,iwin);

	XSetICValues(xic,XNFocusWindow,iwin,NULL);
	XSetICFocus(xic);
	if(xstyle & XIMPreeditPosition)
		_move_input_position(xic,win->fs,str,slen,h1-5);

	buf = (char *)malloc(blen);
	while(1){
		XNextEvent(disp,&event);
		if(XFilterEvent(&event,iwin)) continue;


		switch(event.type){
			/*
			case EnterNotify:
				XSetICValues(xic,XNFocusWindow,iwin,NULL);
				XSetICFocus(xic);
				if(xstyle & XIMPreeditPosition)
					_move_input_position(xic,win->fs,str,slen,h1-2);
			break;
			case LeaveNotify:
				XUnsetICFocus(xic);
			break;
			*/
			case KeyPress:
				len = XmbLookupString(xic,&event,buf,blen,&sym,&st);
				if(st == XBufferOverflow){
					buf = (char *)realloc(buf,len);
					blen = len;
					len = XmbLookupString(xic,&event,buf,blen,&sym,&st);
				}
				switch(st){
					case XLookupBoth:case XLookupChars:
						if(sym == XK_BackSpace){
							if(str[--slen] & 0x80)
								--slen;
							if(slen < 0) slen = 0;

						}else if(sym == XK_Return){
							if(slen > 0){
								str[slen] = '\0';
								result = (char *)malloc(slen + 2);
								strcpy(result,str);
							}else{
								result = NULL;
							}
							goto end;

						}else{
							for(i=0;i<len;i++) str[slen++] = buf[i];
						}

						if(xstyle & XIMPreeditPosition)
							_move_input_position(xic,win->fs,str,slen,h1-5);

						_draw_input_window(disp,iwin,win->fs,win->fgc,5,h1-5,str,slen);
					break;
				}
			break;
			case Expose:
				if(event.xexpose.count == 0)
					XmbDrawString(disp,pwin,win->fs,win->fgc,5,height+5,title,strlen(title));
					XmbDrawString(disp,pwin,win->fs,win->fgc,w/2+20,y1+height+5,title2,strlen(title2));
					_draw_input_window(disp,iwin,win->fs,win->fgc,5,h1-5,str,slen);

			break;
		}
	}

end:
	if(buf != NULL) free(buf);
	XDestroyWindow(disp,iwin);
	XDestroyWindow(disp,pwin);

	return result;
}

