#include "xtext.h"

extern int CHAR_HEADER;
extern int CHAR_FOOTER;

static int _end_char(ITEXT_T *it)
{
	if(it == NULL) return -1;

	if(it->c1 == 0xa1){
		if(	it->c2 == 0xa2 		||
		  	it->c2 == 0xa3 		|| 
			it->c2 == 0xd1		||
			it->c2 == 0xd3		||
			it->c2 == 0xd5		||
			it->c2 == 0xd7		||
			it->c2 == 0xd9		||
			it->c2 == 0xcb		||
			it->c2 == 0xcd		||
			it->c2 == 0xcf		){

			return 1;
		}
	}
	return 0;
}
static int _start_char(ITEXT_T *it)
{
	if(it == NULL) return -1;

        if(it->c1 == 0xa1){
		if(	it->c2 == 0xca		||
			it->c2 == 0xcc		||
			it->c2 == 0xce		||
			it->c2 == 0xd0		||
			it->c2 == 0xd2		||
			it->c2 == 0xd4		||
			it->c2 == 0xd6		||
			it->c2 == 0xd8		||
			it->c2 == 0xda		){

			return 1;
		}
	}

	return 0;
}
static int _k_char(ITEXT_T *it)
{
	if(it == NULL) return -1;

	if(it->c1 >= 0xb0) return 1;

	return 0;
}
static int _y_char(ITEXT_T *it)
{
	if(it == NULL) return -1;

	if(it->c1 == 0xa4 || it->c1 == 0xa5){
		if(	it->c2 == 0xa1		||
			it->c2 == 0xa3		||
			it->c2 == 0xa5		||
			it->c2 == 0xa7		||
			it->c2 == 0xa9		||
                        it->c2 == 0xc3		||
                        it->c2 == 0xe3		||
			it->c2 == 0xe5		||
			it->c2 == 0xe7		||
			it->c2 == 0xee		){

			return 1;
		}
	}

	return 0;
}
static int _h_char(ITEXT_T *it)
{
	if(it == NULL) return -1;

	if(it->c1 == 0xa1){
		if(	it->c2 == 0xc4		||
			it->c2 == 0xc5		){

			return 1;
		}
	}

	return 0;
}
int xtext_prev_kuten(ITEXT_T *it,int level)
{
        if(it == NULL) return -1;
	if(level == 0) return 0;

	if(level == 2){
		if(it->prev->c1 == 0xa1){
	       		if(	it->prev->c2 == 0xa2	||
				it->prev->c2 == 0xa3	){
			
				return 1;
	       		}
		}

		if(_k_char(it)){
			if(!_k_char(it->prev) && _k_char(it->next)) return 1;
		}
	}

	if(_start_char(it)) return 1;

        return 0;
}
int xtext_next_kuten(ITEXT_T *it,int level)
{
        ITEXT_T *n;
        int c;

        if(it->next == NULL) return -1;
	if(level == 0) return 0;

	if(_end_char(it)){
	       if(_end_char(it->next))
		       return 1;
	       else
		       return 0;
	}

	if(level == 2){
		if(_k_char(it)){
			for(n=it,c=0;n!=NULL;n=n->next,c++){
				if(!_k_char(n)) break;
			}
			if(c < CHAR_FOOTER) return 1;
		}
		if(_y_char(it)){
			for(n=it,c=0;n!=NULL;n=n->next,c++){
				if(!_y_char(n)) break;
			}
			if(c < CHAR_FOOTER) return 1;
		}
		/*
		if(_h_char(it)){
			for(n=it,c=0;n!=NULL;n=n->next,c++){
				if(!_h_char(n)) break;
			}
			if(c < CHAR_FOOTER) return 1;
		}
		*/
	}


        for(n=it,c=0;n!=NULL;n=n->next,c++){
		if(_end_char(n)) break;
	}
        if(c < CHAR_FOOTER) return 1;


        n = it->next;
        if(n->c1 == 0xa1){
                switch(n->c2){
			case 0xa0:case 0xa1:case 0xa2:
			case 0xa3:case 0xa4:case 0xa5:
			case 0xa6:case 0xa7:case 0xa8:
			case 0xa9:
                        case 0xb2:case 0xb3:case 0xb4:
			case 0xb5:case 0xb6:case 0xb7:
			case 0xb8:case 0xb9:case 0xba:
			case 0xbb:case 0xbc:case 0xbd:
			case 0xbe:case 0xbf:
                        case 0xc0:case 0xc1:case 0xc2:
			case 0xc3:case 0xc4:case 0xc5:
			case 0xc6:case 0xc7:case 0xc8:
			case 0xc9:case 0xcb:case 0xcd:
			case 0xcf:
                        case 0xd1:case 0xd3:case 0xd5:
			case 0xd7:case 0xd9:case 0xda:
			case 0xdb:case 0xdc:case 0xdd:
			case 0xde:case 0xdf:

	                         return 1;
                         break;
                 }
        }else if(n->c1 == 0xa4 || n->c1 == 0xa5){
                switch(n->c2){
                        case 0xa1:case 0xa3:case 0xa5:
			case 0xa7:case 0xa9:
                        case 0xc3:
                        case 0xe3:case 0xe5:case 0xe7:
			case 0xee:

                                return 1;
                        break;
                }
        }

        return 0;
}
int xtext_get_low_space(ITEXT_T *it,char_data_t *ct)
{
        int h;

        h = it->ej ? ct->charSize + ct->ypad : ct->charSize_e + ct->ypad;

	if(it->chu_string != NULL) h = h + ct->charSize_r;

        return h;
}
int xtext_get_low_pos(ITEXT_T *it,char_data_t *cd,int whead,int wtail)
{
	ITEXT_T *t;
	int i,y;

	if(it == NULL) return 0;

	if(it->jis >= 0){

		i = 0;
		for(t=it->next;t!=NULL;t=t->next)
			i++;

		y = wtail - (it->jis * cd->charSize) - (i * cd->charSize);

	}else if(it->tes >= 0){
		y = (it->tes + 1) * cd->charSize;
	}

	return y;
}

