#include "xtext.h"
#include <dirent.h>

extern iconv_t XJP_CONV;
extern char *XJP_MESSAGE[];

static unsigned char *base_str = "";

static int _get_line_str(char *line,sub_window_t *sw)
{
	if(sw == NULL) return -1;


	if(sw->line_data == NULL){
		strcpy(line,sw->line_str);
	}else{
		if(sw->type == XJP_INT){
			sprintf(line,"%s  (%d)",sw->line_str,*((int *)sw->line_data));
		}else{
			sprintf(line,"%s  (%s)",sw->line_str,(char *)sw->line_data);
		}
	}

	return 0;
}
static int _check_hilight_str(sub_window_t *sw)
{
	if(sw == NULL) return 0;

	if(sw->func==NULL && sw->func_data0==NULL && sw->func_data1==XJP_NONE) return 1;

	return 0;
}
/*
static int _xtextDrawStringUtf8(	Display *disp,	
					XftDraw *draw,
					XftColor fg,
					XftColor bg,
					XftFont *font,
					int x,
					int y,
					char *str,
					int str_len,
					int type		)
{
	char utf8[BUFSIZ];
	XGlyphInfo gi;

	euc2utf8_c(XJP_CONV,utf8,str,str_len);
	switch(type){
		case 0:
			XftDrawStringUtf8(draw,&fg,font,x,y,utf8,strlen(utf8));
		break;
		case 1:
			XftTextExtentsUtf8(disp,font,utf8,strlen(utf8),&gi);

			XftDrawRect(draw,&fg,x,y-gi.height,gi.width,gi.height);
			XftDrawStringUtf8(draw,&bg,font,x,y,utf8,strlen(utf8));
		break;
	}

	return 0;
}
*/
static int _Draw_SubWindow_Text(	Display *disp,
					my_subwindow_t swin,
					int fh,
					sub_window_t *head,
					sub_window_t *tail,
					sub_window_t *CSW,
					int PY,
					int PX,
					int center		)
{
	Drawable pwin;
	Pixmap pix;
	XRectangle ink,log;
	sub_window_t *psw,*nsw,*sw;
	char line_str[BUFSIZ];

	int i,x,y,CY;

	pwin = swin.win;
	XClearWindow(disp,pwin);

	x = PX;
	CY = PY * fh;

	if(_get_line_str(line_str,CSW) >= 0)
		if(center){
			XmbTextExtents(swin.fs,line_str,strlen(line_str),&ink,&log);
			x = (swin.width - ink.width) / 2;
		}
		XmbDrawImageString(disp,pwin,swin.fs,swin.rfgc,x,CY,line_str,strlen(line_str));

	for(sw=CSW->prev,i=1;sw!=NULL;sw=sw->prev,i++){
		if((y = CY - (i * fh)) < fh) break;
		if(_get_line_str(line_str,sw)>=0){
			if(center){
				XmbTextExtents(swin.fs,line_str,strlen(line_str),&ink,&log);
				x = (swin.width - ink.width) / 2;
			}
			if(_check_hilight_str(sw)){
				XmbDrawString(disp,pwin,swin.fs,swin.sgc,x,y,line_str,strlen(line_str));
			}else{
				XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,line_str,strlen(line_str));
			}
		}
	}
	for(sw=CSW->next,i=1;sw!=NULL;sw=sw->next,i++){
		if((y = CY + (i * fh)) > swin.height) break;
		if(_get_line_str(line_str,sw) >= 0){
			if(center){
				XmbTextExtents(swin.fs,line_str,strlen(line_str),&ink,&log);
				x = (swin.width - ink.width) / 2;
			}
			if(_check_hilight_str(sw)){
				XmbDrawString(disp,pwin,swin.fs,swin.sgc,x,y,line_str,strlen(line_str));
			}else{
				XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,line_str,strlen(line_str));
			}
		}
	}

	/*
	xtextDrawFrame(disp,swin.win,swin.gc,swin.width,swin.height,0);
	*/

	return 0;
}
char * xtextSubWindow(	Display *disp,
			my_window_t win,
			sub_window_t *head,
			sub_window_t *tail,
			int percent,
			int center		)
{
	sub_window_t *st;
	int line = 0,sh;

	char *result = NULL;

	my_subwindow_t swin;
	XEvent event;
	KeySym keysym;
	XRectangle ink,log;

	int x,y,loop = 1;

	int fh;

	sub_window_t *CSW;
	int PX,PY,H_LINE;

	if(head == NULL) return NULL;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;

	swin.visual = win.visual;
	swin.cmap = win.cmap;

	swin.parent_win = win.win;
	swin.width = (win.width * percent) / 100;
	swin.height = (win.height * percent) / 100;

	XmbTextExtents(swin.fs,base_str,strlen(base_str),&ink,&log);
	fh = log.height + 5;

	for(st=head;st!=NULL;st=st->next){
		line++;
	}
	sh = line * fh + 5;
	if(sh < swin.height) swin.height = sh;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,2,swin.fg_pixel,swin.bg_pixel);
	XSelectInput(disp,swin.win,ExposureMask|KeyPressMask);
	XMapRaised(disp,swin.win);

#if HAVE_LIBXFT
	swin.font = win.font;
	swin.menu_fg_color = win.menu_fg_color;
	swin.menu_bg_color = win.menu_bg_color;

	swin.draw = XftDrawCreate(disp,swin.win,swin.visual,swin.cmap);
#endif

	H_LINE = swin.height / fh;

	PX = 5;
	PY = 1;
	CSW = head;
	while(loop){
		usleep(500);
		while(XPending(disp)){
			XNextEvent(disp,&event);
			switch(event.type){
				case Expose:
					if(event.xexpose.count == 0)
						_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
				break;
				case KeyPress:
					keysym = XLookupKeysym(&event.xkey,0);
					switch(keysym){
						case XK_Return:
							if(CSW->func == NULL && CSW->re_str != NULL){
								result = CSW->re_str;
								loop = 0;

							}else if(CSW->func != NULL && CSW->re_str == NULL){

								switch(CSW->func(CSW->func_data0,CSW->func_data1)){
									case -7:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[13]);
										loop = 0;
									break;
									case -6:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[12]);
										loop = 0;
									break;
									case -5:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[11]);
										loop = 0;
									break;
									case -4:case -3:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[5]);
									break;
									case -2:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[4]);
									break;
									case -1:
								       		result = XJP_CANCEL;
								       		loop = 0;
									break;
									case 1:
									 	result = XJP_OK;
									 	loop = 0;
									break;
									case 2:
									 	xtextSubWindow_Message(disp,win,XJP_MESSAGE[3]);
									break;
								 }
								_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
							}
						break;
						case XK_q:
							result = XJP_CANCEL;
							loop = 0;
						break;
						case XK_Up:
							if(CSW->prev == NULL) break;
							CSW = CSW->prev;
							if(PY-- <= 1) PY = 1;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
						break;
						case XK_Down:
							if(CSW->next == NULL) break;
							CSW = CSW->next;
							if(PY++ >= H_LINE) PY = H_LINE;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
						break;
						case XK_Right:
							if(center) break;
							PX -= 20;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
						break;
						case XK_Left:
							if(center) break;
							if((PX += 20) >= 5) PX = 5;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY,PX,center);
						break;
							
					}
				break;
			}
		}
	}
	XDestroyWindow(disp,swin.win);
	_subwindow_data_free(&head,&tail);

	return result;
}
int xtextSubWindow_Message(Display *disp,my_window_t win,char *message)
{
	my_subwindow_t swin;
	XRectangle ink,log;

	int x,y;
	int message_len;

	if(message == NULL) return -1;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;
	swin.parent_win = win.win;

	message_len = strlen(message);
	XmbTextExtents(swin.fs,message,message_len,&ink,&log);

	swin.width = log.width + 4;
	swin.height = log.height + 4;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,1,swin.fg_pixel,swin.bg_pixel);
	XMapRaised(disp,swin.win);

	XmbDrawString(disp,swin.win,swin.fs,swin.fgc,2,log.height,message,message_len);
	XFlush(disp);


	sleep(2);


	XDestroyWindow(disp,swin.win);

	return 0;
}


	


















