#include "xtext.h"

#define debug 0

extern iconv_t XJP_CONV;
extern char *XJP_MESSAGE[];

XImage *bimg;

int CHAR_HEADER = 3;
int CHAR_FOOTER = 3;

static void * _page_data_free(page_data_t **start,page_data_t **end)
{
	page_data_t *pt,*ptt;

	for(pt = *start;pt!=NULL;pt=ptt){
		ptt = pt->next;
		free(pt);
	}

	*start = NULL;
	*end = NULL;

	return NULL;
}
static page_data_t * _page_data_alloc()
{
	page_data_t *pt;

	pt = (page_data_t *)malloc(sizeof(page_data_t));
	pt->char_no = 0;

	return pt;
}
static void *_page_data_add(page_data_t **start,page_data_t **end,page_data_t *mg)
{
        if(*end){
                mg->next = NULL;
                mg->prev = *end;

                (*end)->next = mg;
                *end = mg;
        }else{
                mg->next = NULL;
                mg->prev = NULL;

                *end = mg;
                *start = mg;
        }

	return NULL;
}
static void *_page_data_insert(page_data_t **start,page_data_t **end,int n,int np)
{
	page_data_t *pt;

	pt = (page_data_t *)_page_data_alloc();

	pt->char_no = n;
	pt->page_no = np+1;

	_page_data_add(start,end,pt);

	return NULL;
}
static int _check_image_data(ITEXT_T *it)
{
	if(it->ej == 0) return 1;

	if(it->c1 == 0xa1){
		switch(it->c2){
			case 0xa1:
			case 0xa7:case 0xa8:
			case 0xbc:case 0xbd:
			case 0xc1:case 0xc3:case 0xc4:case 0xc5:
			case 0xca:case 0xcb:
			case 0xcc:case 0xcd:
			case 0xce:case 0xcf:
			case 0xd0:case 0xd1:
			case 0xd2:case 0xd3:
			case 0xd4:case 0xd5:
			case 0xd6:case 0xd7:
			case 0xd8:case 0xd9:
			case 0xda:case 0xdb:
			case 0xdd:
				return 1;
			break;
			case 0xa2:case 0xa3:
			case 0xc6:case 0xc7:
				return 2;
			break;
			case 0xc8:case 0xc9:
				return 3;
			break;
			/*
			case 0xc8:
				return 4;
			break;
			*/
		}
	}else if(it->c1 == 0xa2){
		switch(it->c2){
			case 0xaa:case 0xab:case 0xac:case 0xad:
				return 1;
			break;
		}
	}else if(it->c1 == 0xa8){
		if(it->c2 >= 0xa0 && it->c2 <= 0xbc){
			return 1;
		}

	}else if(it->c1 == 0xa4){
		switch(it->c2){
			case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:
			case 0xe3:case 0xe5:case 0xe7:case 0xee:case 0xc3:
				return 5;
			break;
		}
	}else if(it->c1 == 0xa5){
		switch(it->c2){
			case 0xa1:case 0xa3:case 0xa5:case 0xa7:case 0xa9:
			case 0xc3:case 0xe3:case 0xee:case 0xe7:case 0xf5:case 0xf6:
				return 5;
			break;
		}
	}

	return 0;
}
static int _xtext_get_normalfont_size(my_window_t *win,int *charSize,int *charSize_s,int *charSize_e,int *charSize_r)
{
	char *str = "";
	char *str_e = "W";
	XRectangle ink,log;

	XmbTextExtents(win->fs,str,strlen(str),&ink,&log);
	*charSize = log.width >= log.height ? log.width+2 : log.height+2;

	XmbTextExtents(win->fs_s,str,strlen(str),&ink,&log);
	*charSize_s = log.width >= log.height ? log.width+2 : log.height+2;

	XmbTextExtents(win->fs_e,str_e,strlen(str_e),&ink,&log);
	*charSize_e = log.width+2;

	XmbTextExtents(win->rubi_fs,str,strlen(str),&ink,&log);
	*charSize_r = log.width >= log.height ? log.width : log.height;

	return 0;
}
static int _xtext_get_antifont_size(Display *disp,my_window_t *win,int *charSize,int *charSize_s,int *charSize_e,int *charSize_r)
{
#if HAVE_LIBXFT
	char *str = "";
	char *str_e = "W";

	XGlyphInfo gi;
	iconv_t con;
	char *utf8;

	utf8 = (char *)euc2utf8(XJP_CONV,str,strlen(str));

	XftTextExtentsUtf8(disp,win->font,utf8,strlen(utf8),&gi);
	*charSize = gi.width >= gi.height ? gi.width+2 : gi.height+2;

	XftTextExtentsUtf8(disp,win->font_s,utf8,strlen(utf8),&gi);
	*charSize_s = gi.width >= gi.height ? gi.width+2 : gi.height+2;

	XftTextExtents8(disp,win->font_e,str_e,strlen(str_e),&gi);
	*charSize_e = gi.width+2;

	if(utf8) free(utf8);

	utf8 = (char *)euc2utf8(XJP_CONV,str,strlen(str));
	XftTextExtentsUtf8(disp,win->font_rubi,utf8,strlen(utf8),&gi);
	*charSize_r = gi.width >= gi.height ? gi.width : gi.height;
	if(utf8) free(utf8);
#else

	_xtext_get_normalfont_size(win,charSize,charSize_s,charSize_e,charSize_r);

#endif

	return 0;
}
int xtext_Init_Text(Display *disp,my_window_t *win,IBUF_T *l_head,char_data_t *ct)
{
	IBUF_T *ib;
	ITEXT_T *it;

	int KINSOKU = 0;
	int charSize=0,charSize_s=0,charSize_e=0,charSize_r=0;
	int x,y,h,xpad;
	int page_char_no = 0;
	int total_page = 0;
	int one_line,start_line,end_line,start_low,end_low;
	int type;


	if(win->fs == NULL){
		fprintf(stderr,"ERROR : Font False\n");
		exit(1);
	}

	xtext_usage(NULL,0);

	KINSOKU = win->kinsc;


	if(win->anti == 0){
		_xtext_get_normalfont_size(win,&charSize,&charSize_s,&charSize_e,&charSize_r);

	}else{
		_xtext_get_antifont_size(disp,win,&charSize,&charSize_s,&charSize_e,&charSize_r);
	}

	ct->charSize = charSize;
	ct->charSize_s = charSize_s;
	ct->charSize_e = charSize_e;
	ct->charSize_r = charSize_r;

	if(ct->im_head != NULL) _image_data_free(&ct->im_head,&ct->im_tail);
	if(ct->head != NULL) _page_data_free(&ct->head,&ct->tail);

	if(bimg) XDestroyImage(bimg);
	bimg = (XImage *)xtext_get_bimage(disp,win,ct);

	xpad = ct->xpad;

	one_line = charSize + xpad + charSize_r;
	start_line = win->width - one_line;
	end_line = 2;

	start_low = charSize * CHAR_HEADER;
	end_low = win->height - charSize * CHAR_FOOTER;

	x = start_line;
	y = start_low;

	_page_data_insert(&ct->head,&ct->tail,0,total_page++);

	for(ib=l_head;ib!=NULL;ib=ib->next){
		xtext_usage(XJP_MESSAGE[8],(double)ib->line/l_head->total_line);

		for(it=ib->i_head;it!=NULL;it=it->next){

			if((type = _check_image_data(it)) > 0){
				xtext_image_data_insert(disp,win,ct,it,type);
			}

			if(it->jis >= 0 || it->tes >= 0) y = xtext_get_low_pos(it,ct,start_low,end_low);

			h = xtext_get_low_space(it,ct);
			page_char_no++;

			if((y += h) > end_low){
				if(xtext_next_kuten(it,KINSOKU) == 0){
					if((x -= one_line) <= end_line){
						_page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
						x = start_line;
					}
					if(xtext_prev_kuten(it,KINSOKU) == 1){
						it=it->prev;
						page_char_no--;
					}
					y = start_low;
				}
			}
		}
		if((x -= one_line) <= end_line){
			_page_data_insert(&ct->head,&ct->tail,page_char_no,total_page++);
			x = start_line;
		}
		y = start_low;
	}
	ct->book->total_page = total_page;

	xtext_usage(NULL,0);

	return total_page;
}
