#include "xtext.h"
#include <dirent.h>

extern char *XJP_MESSAGE[];

static sub_window_t * _subwindow_data_alloc()
{
	sub_window_t *sw;

	sw = (sub_window_t *)malloc(sizeof(sub_window_t));
	sw->line_str = NULL;
	sw->line_data = NULL;
	sw->re_str = NULL;
	sw->func = NULL;
	sw->func_data0 = NULL;
	sw->func_data1 = -1;
	sw->type = XJP_NONE;
	sw->line_no = -1;
	sw->mall = 0;

	return sw;
}
void * _subwindow_data_free(sub_window_t **head,sub_window_t **tail)
{
	sub_window_t *sw,*sww;

	if(*head == NULL) return NULL;

	for(sw = *head;sw!=NULL;sw=sww){
		sww = sw->next;

		if(sw->mall && sw->line_data != NULL) free(sw->line_data);
		free(sw);
	}

	*head = NULL;
	*tail = NULL;

	return NULL;
}
static void * _subwindow_data_add(sub_window_t **head,sub_window_t **tail,sub_window_t *im)
{
	if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

        return NULL;
}

static void _subwindow_data_insert(	sub_window_t **head,
					sub_window_t **tail,
					char *line_str,
					char *line_data,
					char *re_str,
					int (*func)(),
					void * data0,
					int data1,
					int type,
					int line_no	)
{
	sub_window_t *sw;

	sw = (sub_window_t *)_subwindow_data_alloc();

	if(line_str != NULL){
		sw->line_str=(char *)malloc(strlen(line_str)+1);
		strcpy(sw->line_str,line_str);
	}

	sw->line_data = line_data;

	if(re_str != NULL){
		sw->re_str = (char *)malloc(strlen(re_str)+1);
		strcpy(sw->re_str,re_str);
	}

	sw->func = func;
	sw->func_data0 = data0;
	sw->func_data1 = data1;
	sw->line_no = line_no;
	sw->type = type;

	_subwindow_data_add(head,tail,sw);

	return ;
}
int xtextHelpData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	char line_str[256];
	void *line_data,*data0;
	int data1;
	int type;
	int i = 1;

	if(*head != NULL) _subwindow_data_free(head,tail);

	strcpy(line_str,"-- [Up-Down R-L]ư [Enter]ѹ,¹ --");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"(λ:ѹȿǤ)");
	line_data = NULL;
	data0 = (char *)XJP_OK;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_quit,data0,data1,type,i++);

	strcpy(line_str,"(Cancel:ѹȿǤʤ)");
	line_data = NULL;
	data0 = (char *)XJP_CANCEL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_quit,data0,data1,type,i++);

	strcpy(line_str,"(¸:ߤ¸)");
	line_data = NULL;
	data0 = (xtext_conf_t *)xconf;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_save,data0,data1,type,i++);

	_subwindow_data_insert(head,tail,"-- ѹ-- ",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,i++);


       	strcpy(line_str,"¸ʸ:");
	line_data = xconf->book_dir;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"[]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ڡ:");
	line_data = xconf->page_next;
	data0 = (char *)xconf->page_next;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);


	strcpy(line_str,"ڡ:");
	line_data = xconf->page_prev;
	data0 = (char *)xconf->page_prev;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ڡ:");
	line_data = xconf->conf_page;
	data0 = (char *)xconf->conf_page;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ٵϿ:");
	line_data = xconf->book_mark;
	data0 = (char *)xconf->book_mark;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥˥塼:");
	line_data = xconf->siori_menu;
	data0 = (char *)xconf->siori_menu;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼:");
	line_data = xconf->menu;	
	data0 = (char *)xconf->menu;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"λ:");
	line_data = xconf->quit;
	data0 = (char *)xconf->quit;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ȥON-OFF:");
	line_data = xconf->title_key;
	data0 = (char *)xconf->title_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ǡɽON-OFF:");
	line_data = xconf->page_key;
	data0 = (char *)xconf->page_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥ѹ:");
	line_data = xconf->kinsc_key;
	data0 = (char *)xconf->kinsc_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ɥON-OFF:");
	line_data = xconf->chuki_key;
	data0 = (char *)xconf->chuki_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ɲ:");
	line_data = xconf->net_key;
	data0 = (char *)xconf->net_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ڴ:");
	line_data = xconf->cursor_key;
	data0 = (char *)xconf->cursor_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"[ɥ]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"ɥ: %d",xconf->main_window_width);
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"ɥ: %d",xconf->main_window_height);
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"طʿ:");
	line_data = xconf->main_window_color;
	data0 = (char *)xconf->main_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ᥤʸ:");
	line_data = xconf->main_font_color;
	data0 = (char *)xconf->main_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸ:");
	line_data = xconf->rubi_font_color;
	data0 = (char *)xconf->rubi_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼طʿ:");
	line_data = xconf->menu_window_color;
	data0 = (char *)xconf->menu_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼ʸ:");
	line_data = xconf->menu_font_color;
	data0 = (char *)xconf->menu_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸƿ:");
	line_data = xconf->main_shadow_color;
	data0 = (char *)xconf->main_shadow_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," طʿ:");
	line_data = xconf->select_window_color;
	data0 = (char *)xconf->select_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," ʸ:");
	line_data = xconf->select_font_color;
	data0 = (char *)xconf->select_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," :");
	line_data = xconf->select_font_background_color;
	data0 = (char *)xconf->select_font_background_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);
	strcpy(line_str,"[ե]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ե(J):");
	line_data = xconf->main_font_j;
	data0 = (char *)xconf->main_font_j;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ե(small):");
	line_data = xconf->main_font_s;
	data0 = (char *)xconf->main_font_s;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ե(E):");
	line_data = xconf->main_font_e;
	data0 = (char *)xconf->main_font_e;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ӥե:");
	line_data = xconf->rubi_font;
	data0 = (char *)xconf->rubi_font;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"Դ:");
	line_data = &(xconf->line_space);
	data0 = (int *)&xconf->line_space;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸ:");
	line_data = &(int)(xconf->row_space);
	data0 = (int *)&xconf->row_space;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"[]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ꥢ:");
	line_data = (int *)&xconf->anti;
	data0 = (int *)&xconf->anti;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ȥɽ:");
	line_data = (int *)&xconf->title_on;
	data0 = (int *)&xconf->title_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ǡɽ:");
	line_data = (int *)&xconf->page_on;
	data0 = (int *)&xconf->page_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥:");
	line_data = (int *)&xconf->kinsc;
	data0 = (int *)&xconf->kinsc;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ɥɽ:");
	line_data = (int *)&xconf->chuki;
	data0 = (int *)&xconf->chuki;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,":");
	line_data = (int *)&xconf->cursor;
	data0 = (int *)&xconf->cursor;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	/*
	strcpy(line_str,"ɽ:");
	line_data = (int *)&xconf->ruby_on;
	data0 = (int *)&xconf->ruby_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);
	*/

	return 0;
}
int xtextSioriData2Sub(sub_window_t **head,sub_window_t **tail,xtext_siori_t *s_head)
{
	sub_window_t *sw;
	xtext_siori_t *si;
	int i;

	if(s_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"----- [Up-Down R-L]ư [Enter] -----",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);
	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);
	_subwindow_data_insert(head,tail,"-- ١--",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,3);

	for(si=s_head,i=4;si!=NULL;si=si->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();

		sw->line_str = si->book_title;
		sw->line_data = si->book_time;
		sw->re_str = si->book_path;
		sw->func_data1 = XJP_STR;
		sw->line_no = i;

		_subwindow_data_add(head,tail,sw);
	}

	return 0;
}
int xtextPersonData2Sub(sub_window_t **head,sub_window_t **tail,PLIST_T *plist_head)
{
	sub_window_t *sw;
	PLIST_T *pl;
	char temp[128];
	int i;

	if(plist_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"--[q]󥻥 [Up-Down R-L]ư [Enter] --",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);
	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);

	sprintf(temp,"(ĶꥹȤι) [ %s]",plist_head->file_date);
	_subwindow_data_insert(head,tail,temp,NULL,NULL,itext_list_download,NULL,XJP_NONE,XJP_NONE,3);
	_subwindow_data_insert(head,tail,"(ñ) [̾ ̾ ϼ̾]",NULL,NULL,xtextSerchList,(PLIST_T *)plist_head,0,XJP_INT,4);

	_subwindow_data_insert(head,tail,"-- Ķʸ ȥꥹȡ--",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,5);
	for(pl=plist_head,i=6;pl!=NULL;pl=pl->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();

		sw->line_str = pl->person;
		sw->line_data = &pl->total;
		sw->re_str = NULL;
		sw->func = xtextDispList;
		sw->func_data0 = pl->list_head;
		sw->func_data1 = 0;
		sw->type = XJP_INT;
		sw->line_no = i;

		_subwindow_data_add(head,tail,sw);
	}

	return 0;
}
int xtextCardData2Sub(sub_window_t **head,sub_window_t **tail,itext_table_t *t_head)
{
	itext_table_t *ta,*tr,*td;
	char *p,*pp,str[BUFSIZ];
	int i,j,k,xpad,max,len;

	if(t_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"-- [q]󥻥 [Up-Down R-L]ư [Enter] --",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);
	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);
	_subwindow_data_insert(head,tail,"(ο޽)",NULL,NULL,itext_book_download_1,(itext_table_t *)t_head,0,XJP_INT,3);
	_subwindow_data_insert(head,tail,"-- Ķʸ ޽񥫡ɡ --",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,4);

	max = 0;
	for(ta=t_head;ta!=NULL;ta=ta->next){
		if(strcmp(ta->name,"ȥǡ") == 0	||
		   strcmp(ta->name,"ʥǡ") == 0		||
		   strcmp(ta->name,"ȥǡ") == 0		||
		   strcmp(ta->name,"ܥǡ") == 0		||
		   strcmp(ta->name,"ǡ") == 0		){

			for(tr=ta->head;tr!=NULL;tr=tr->next){
				for(td=tr->head;td!=NULL;td=td->next){
					if(td->name != NULL){
						len = strlen(td->name);
						if(max < len) max = len; 
						break;
					}
				}
			}
		}
	}

	i = 5;
	for(ta=t_head;ta!=NULL;ta=ta->next){
		if(strcmp(ta->name,"ȥǡ") == 0	||
		   strcmp(ta->name,"ʥǡ") == 0		||
		   strcmp(ta->name,"ȥǡ") == 0		||
		   strcmp(ta->name,"ܥǡ") == 0		||
		   strcmp(ta->name,"ǡ") == 0		){

			for(tr=ta->head;tr!=NULL;tr=tr->next){
				str[0] = '\0';
				xpad = 0;
				for(td=tr->head,j=0;td!=NULL;td=td->next,j++){
					if(td->name == NULL) continue;
					len = strlen(td->name);

					p = NULL;
					if(j == 0){
						xpad = max - len; 
						strcpy(str,td->name);
					}else{
						for(k=0;k<xpad;k++)
							sprintf(str,"%s ",str);

						if((p = strstr(td->name,"")) != NULL){
							*p = '\0';
							sprintf(str,"%s%s",str,td->name);
							_subwindow_data_insert(head,tail,str,NULL,NULL,NULL,XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
							pp = p+2;
							while((p=strstr(pp,"")) != NULL){
								*p = '\0';
								str[0] = '\0';
								for(k=0;k<max;k++)
									sprintf(str,"%s ",str);
								sprintf(str,"%s%s",str,pp);
								_subwindow_data_insert(head,tail,str,NULL,NULL,NULL,XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
								pp = p+2;
							}
							if(*pp != '\0'){
								str[0] = '\0';
								for(k=0;k<max;k++)
									sprintf(str,"%s ",str);
								sprintf(str,"%s%s",str,pp);
								_subwindow_data_insert(head,tail,str,NULL,NULL,NULL,XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
							}
							str[0] = '\0';
						}else{
							sprintf(str,"%s%s",str,td->name);
						}
						xpad = 0;
					}
				}
				if(str[0] != '\0')
					_subwindow_data_insert(head,tail,str,NULL,NULL,NULL,XJP_CANCEL,XJP_NONE,XJP_NONE,i++);
			}
		}
	}

	return 0;
}
int xtextListData2Sub(sub_window_t **head,sub_window_t **tail,ILIST_T *l_head)
{
	sub_window_t *sw;
	ILIST_T *il;
	char temp[256];
	int i;

	if(l_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"-- [q]󥻥 [Up-Down R-L]ư [Enter] --",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);

	_subwindow_data_insert(head,tail,"()",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);

	_subwindow_data_insert(head,tail,"-- Ķʸ ʥꥹȡ--",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,3);
	_subwindow_data_insert(head,tail,l_head->person,NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,4);

	for(il=l_head,i=5;il!=NULL;il=il->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();
		if(il->person == NULL || il->title == NULL) continue;

		sprintf(temp,"%s %s %s %s",il->stat,il->date,il->type,il->person_i);
		sw->line_data = (char *)malloc(strlen(temp)+2);

		sw->line_str = il->title;
		strcpy(sw->line_data,temp);
		sw->re_str = NULL;
		sw->func = itext_book_download;
		sw->func_data0 = (ILIST_T *)il;
		sw->line_no = i;
		sw->mall = 1;
		_subwindow_data_add(head,tail,sw);
	}

	return 0;
}
int xtextBookData2Sub(sub_window_t **head,sub_window_t **tail,char *dname)
{
	sub_window_t *sw;

	IBOOK_T *bhead = NULL, *btail = NULL;
	IBOOK_T *ib;

	int i,total;

	if(*head != NULL) _subwindow_data_free(head,tail);

	total = ibookGetFileData(&bhead,&btail,dname);

	_subwindow_data_insert(head,tail,"----- [Up-Down R-L]ư [Enter] -----",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);

	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);

	_subwindow_data_insert(head,tail,"-- ¸޽--",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,3);

	for(ib=bhead,i=4;ib!=NULL;ib=ib->next,i++){
		/*
		if(ib->code == -2){
			_subwindow_data_insert(head,tail,ib->title,NULL,NULL,_select_book_data,ib->fullpath,XJP_NONE,XJP_NONE,i);

		}else{
		*/
			sw = (sub_window_t *)_subwindow_data_alloc();
			sw->line_str = ib->title;
			sw->line_data = ib->filename;
			sw->re_str=ib->fullpath;
			sw->func_data1 = XJP_STR;
			sw->line_no = i;
			_subwindow_data_add(head,tail,sw);
		/*}*/
	}

	return 0;
}
int xtextQuitData2Sub(sub_window_t **head,sub_window_t **tail)
{
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"(XJP λ)",NULL,NULL,xtext_conf_quit,(char *)XJP_OK,XJP_NONE,XJP_NONE,0);
	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,1);

	return 0;
}

