/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.extractor.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public class BTreeSet
extends AbstractSet
implements Set {
    public BTreeNode root;
    private Comparator comparator = null;
    private int order;
    private int size = 0;

    public BTreeSet() {
        this(6);
    }

    public BTreeSet(Collection c) {
        this(6);
        this.addAll(c);
    }

    public BTreeSet(int order) {
        this(order, null);
    }

    public BTreeSet(int order, Comparator comparator) {
        this.order = order;
        this.comparator = comparator;
        this.root = new BTreeNode(null);
    }

    public boolean add(Object x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        return this.root.insert(x, -1);
    }

    public boolean contains(Object x) {
        return this.root.includes(x);
    }

    public boolean remove(Object x) {
        if (x == null) {
            return false;
        }
        return this.root.delete(x, -1);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.root = new BTreeNode(null);
        this.size = 0;
    }

    public java.util.Iterator iterator() {
        return new Iterator();
    }

    private int compare(Object x, Object y) {
        return this.comparator == null ? ((Comparable)x).compareTo(y) : this.comparator.compare(x, y);
    }

    public class BTreeNode {
        public Entry[] entries;
        public BTreeNode parent;
        private int nrElements = 0;
        private final int MIN = (BTreeSet.access$200(BTreeSet.this) - 1) / 2;

        BTreeNode(BTreeNode parent) {
            this.parent = parent;
            this.entries = new Entry[BTreeSet.this.order];
            this.entries[0] = new Entry();
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean insert(Object x, int parentIndex) {
            if (this.isFull()) {
                Object splitNode = this.entries[this.nrElements / 2].element;
                BTreeNode rightSibling = this.split();
                if (!this.isRoot()) {
                    this.parent.insertSplitNode(splitNode, this, rightSibling, parentIndex);
                    if (BTreeSet.this.compare(x, this.parent.entries[parentIndex].element) >= 0) return rightSibling.insert(x, parentIndex + 1);
                    return this.insert(x, parentIndex);
                }
                this.splitRoot(splitNode, this, rightSibling);
                if (BTreeSet.this.compare(x, BTreeSet.this.root.entries[0].element) < 0) {
                    this.insert(x, 0);
                    return false;
                }
                rightSibling.insert(x, 1);
                return false;
            }
            if (this.isLeaf()) {
                int insertAt = this.childToInsertAt(x, true);
                if (insertAt == -1) {
                    return false;
                }
                this.insertNewElement(x, insertAt);
                BTreeSet.this.size++;
                return true;
            }
            int insertAt = this.childToInsertAt(x, true);
            if (insertAt == -1) {
                return false;
            }
            boolean bl = this.entries[insertAt].child.insert(x, insertAt);
            return bl;
        }

        boolean includes(Object x) {
            int index = this.childToInsertAt(x, true);
            if (index == -1) {
                return true;
            }
            if (this.entries[index] == null || this.entries[index].child == null) {
                return false;
            }
            return this.entries[index].child.includes(x);
        }

        boolean delete(Object x, int parentIndex) {
            int i = this.childToInsertAt(x, true);
            int priorParentIndex = parentIndex;
            BTreeNode temp = this;
            if (i != -1) {
                do {
                    if (temp.entries[i] == null || temp.entries[i].child == null) {
                        return false;
                    }
                    temp = temp.entries[i].child;
                    priorParentIndex = parentIndex;
                    parentIndex = i;
                } while ((i = temp.childToInsertAt(x, true)) != -1);
            }
            if (temp.isLeaf()) {
                if (temp.nrElements > this.MIN) {
                    temp.deleteElement(x);
                    BTreeSet.this.size--;
                    return true;
                }
                temp.prepareForDeletion(parentIndex);
                temp.deleteElement(x);
                BTreeSet.this.size--;
                temp.fixAfterDeletion(priorParentIndex);
                return true;
            }
            temp.switchWithSuccessor(x);
            parentIndex = temp.childToInsertAt(x, false) + 1;
            return temp.entries[parentIndex].child.delete(x, parentIndex);
        }

        private boolean isFull() {
            return this.nrElements == BTreeSet.this.order - 1;
        }

        private boolean isLeaf() {
            return this.entries[0].child == null;
        }

        private boolean isRoot() {
            return this.parent == null;
        }

        private BTreeNode split() {
            BTreeNode rightSibling = new BTreeNode(this.parent);
            int index = this.nrElements / 2;
            this.entries[index++].element = null;
            int i = 0;
            int nr = this.nrElements;
            while (index <= nr) {
                rightSibling.entries[i] = this.entries[index];
                if (rightSibling.entries[i] != null && rightSibling.entries[i].child != null) {
                    rightSibling.entries[i].child.parent = rightSibling;
                }
                this.entries[index] = null;
                --this.nrElements;
                ++rightSibling.nrElements;
                ++i;
                ++index;
            }
            --rightSibling.nrElements;
            return rightSibling;
        }

        private void splitRoot(Object splitNode, BTreeNode left, BTreeNode right) {
            BTreeNode newRoot = new BTreeNode(null);
            newRoot.entries[0].element = splitNode;
            newRoot.entries[0].child = left;
            newRoot.entries[1] = new Entry();
            newRoot.entries[1].child = right;
            newRoot.nrElements = 1;
            left.parent = right.parent = newRoot;
            BTreeSet.this.root = newRoot;
        }

        private void insertSplitNode(Object splitNode, BTreeNode left, BTreeNode right, int insertAt) {
            int i = this.nrElements;
            while (i >= insertAt) {
                this.entries[i + 1] = this.entries[i];
                --i;
            }
            this.entries[insertAt] = new Entry();
            this.entries[insertAt].element = splitNode;
            this.entries[insertAt].child = left;
            this.entries[insertAt + 1].child = right;
            ++this.nrElements;
        }

        private void insertNewElement(Object x, int insertAt) {
            int i = this.nrElements;
            while (i > insertAt) {
                this.entries[i] = this.entries[i - 1];
                --i;
            }
            this.entries[insertAt] = new Entry();
            this.entries[insertAt].element = x;
            ++this.nrElements;
        }

        private int childToInsertAt(Object x, boolean position) {
            int index = this.nrElements / 2;
            if (this.entries[index] == null || this.entries[index].element == null) {
                return index;
            }
            int lo = 0;
            int hi = this.nrElements - 1;
            while (lo <= hi) {
                if (BTreeSet.this.compare(x, this.entries[index].element) > 0) {
                    lo = index + 1;
                    index = (hi + lo) / 2;
                    continue;
                }
                hi = index - 1;
                index = (hi + lo) / 2;
            }
            if (this.entries[++hi] == null || this.entries[hi].element == null) {
                return hi;
            }
            return !position ? hi : (BTreeSet.this.compare(x, this.entries[hi].element) == 0 ? -1 : hi);
        }

        private void deleteElement(Object x) {
            int index = this.childToInsertAt(x, false);
            while (index < this.nrElements - 1) {
                this.entries[index] = this.entries[index + 1];
                ++index;
            }
            this.entries[index] = this.nrElements == 1 ? new Entry() : null;
            --this.nrElements;
        }

        private void prepareForDeletion(int parentIndex) {
            if (this.isRoot()) {
                return;
            }
            if (parentIndex != 0 && this.parent.entries[parentIndex - 1].child.nrElements > this.MIN) {
                this.stealLeft(parentIndex);
                return;
            }
            if (parentIndex < this.entries.length && this.parent.entries[parentIndex + 1] != null && this.parent.entries[parentIndex + 1].child != null && this.parent.entries[parentIndex + 1].child.nrElements > this.MIN) {
                this.stealRight(parentIndex);
                return;
            }
            if (parentIndex != 0) {
                this.mergeLeft(parentIndex);
                return;
            }
            this.mergeRight(parentIndex);
        }

        private void fixAfterDeletion(int parentIndex) {
            if (this.isRoot() || this.parent.isRoot()) {
                return;
            }
            if (this.parent.nrElements < this.MIN) {
                BTreeNode temp = this.parent;
                temp.prepareForDeletion(parentIndex);
                if (temp.parent == null) {
                    return;
                }
                if (!temp.parent.isRoot() && temp.parent.nrElements < this.MIN) {
                    BTreeNode x = temp.parent.parent;
                    int i = 0;
                    while (i < this.entries.length) {
                        if (x.entries[i].child == temp.parent) break;
                        ++i;
                    }
                    temp.parent.fixAfterDeletion(i);
                }
            }
        }

        private void switchWithSuccessor(Object x) {
            int index = this.childToInsertAt(x, false);
            BTreeNode temp = this.entries[index + 1].child;
            while (temp.entries[0] != null && temp.entries[0].child != null) {
                temp = temp.entries[0].child;
            }
            Object successor = temp.entries[0].element;
            temp.entries[0].element = this.entries[index].element;
            this.entries[index].element = successor;
        }

        private void stealLeft(int parentIndex) {
            BTreeNode p = this.parent;
            BTreeNode ls = this.parent.entries[parentIndex - 1].child;
            if (this.isLeaf()) {
                int add = this.childToInsertAt(p.entries[parentIndex - 1].element, true);
                this.insertNewElement(p.entries[parentIndex - 1].element, add);
                p.entries[parentIndex - 1].element = ls.entries[ls.nrElements - 1].element;
                ls.entries[ls.nrElements - 1] = null;
                --ls.nrElements;
            } else {
                this.entries[0].element = p.entries[parentIndex - 1].element;
                p.entries[parentIndex - 1].element = ls.entries[ls.nrElements - 1].element;
                this.entries[0].child = ls.entries[ls.nrElements].child;
                this.entries[0].child.parent = this;
                ls.entries[ls.nrElements] = null;
                ls.entries[ls.nrElements - 1].element = null;
                ++this.nrElements;
                --ls.nrElements;
            }
        }

        private void stealRight(int parentIndex) {
            BTreeNode p = this.parent;
            BTreeNode rs = p.entries[parentIndex + 1].child;
            if (this.isLeaf()) {
                this.entries[this.nrElements] = new Entry();
                this.entries[this.nrElements].element = p.entries[parentIndex].element;
                p.entries[parentIndex].element = rs.entries[0].element;
                int i = 0;
                while (i < rs.nrElements) {
                    rs.entries[i] = rs.entries[i + 1];
                    ++i;
                }
                rs.entries[rs.nrElements - 1] = null;
                ++this.nrElements;
                --rs.nrElements;
            } else {
                int i = 0;
                while (i <= this.nrElements) {
                    this.entries[i] = this.entries[i + 1];
                    ++i;
                }
                this.entries[this.nrElements].element = p.entries[parentIndex].element;
                p.entries[parentIndex].element = rs.entries[0].element;
                this.entries[this.nrElements + 1] = new Entry();
                this.entries[this.nrElements + 1].child = rs.entries[0].child;
                this.entries[this.nrElements + 1].child.parent = this;
                int i2 = 0;
                while (i2 <= rs.nrElements) {
                    rs.entries[i2] = rs.entries[i2 + 1];
                    ++i2;
                }
                rs.entries[rs.nrElements] = null;
                ++this.nrElements;
                --rs.nrElements;
            }
        }

        private void mergeLeft(int parentIndex) {
            BTreeNode p = this.parent;
            BTreeNode ls = p.entries[parentIndex - 1].child;
            if (this.isLeaf()) {
                int add = this.childToInsertAt(p.entries[parentIndex - 1].element, true);
                this.insertNewElement(p.entries[parentIndex - 1].element, add);
                p.entries[parentIndex - 1].element = null;
                int i = this.nrElements - 1;
                int nr = ls.nrElements;
                while (i >= 0) {
                    this.entries[i + nr] = this.entries[i];
                    --i;
                }
                int i2 = ls.nrElements - 1;
                while (i2 >= 0) {
                    this.entries[i2] = ls.entries[i2];
                    ++this.nrElements;
                    --i2;
                }
                if (p.nrElements == this.MIN && p != BTreeSet.this.root) {
                    int x = parentIndex - 1;
                    int y = parentIndex - 2;
                    while (y >= 0) {
                        p.entries[x] = p.entries[y];
                        --x;
                        --y;
                    }
                    p.entries[0] = new Entry();
                    p.entries[0].child = ls;
                } else {
                    int x = parentIndex - 1;
                    int y = parentIndex;
                    while (y <= p.nrElements) {
                        p.entries[x] = p.entries[y];
                        ++x;
                        ++y;
                    }
                    p.entries[p.nrElements] = null;
                }
                --p.nrElements;
                if (p.isRoot() && p.nrElements == 0) {
                    BTreeSet.this.root = this;
                    this.parent = null;
                }
            } else {
                this.entries[0].element = p.entries[parentIndex - 1].element;
                this.entries[0].child = ls.entries[ls.nrElements].child;
                ++this.nrElements;
                int x = this.nrElements;
                int nr = ls.nrElements;
                while (x >= 0) {
                    this.entries[x + nr] = this.entries[x];
                    --x;
                }
                int x2 = ls.nrElements - 1;
                while (x2 >= 0) {
                    this.entries[x2] = ls.entries[x2];
                    this.entries[x2].child.parent = this;
                    ++this.nrElements;
                    --x2;
                }
                if (p.nrElements == this.MIN && p != BTreeSet.this.root) {
                    int x3 = parentIndex - 1;
                    int y = parentIndex - 2;
                    while (y >= 0) {
                        System.out.println(x3 + " " + y);
                        p.entries[x3] = p.entries[y];
                        ++x3;
                        ++y;
                    }
                    p.entries[0] = new Entry();
                } else {
                    int x4 = parentIndex - 1;
                    int y = parentIndex;
                    while (y <= p.nrElements) {
                        p.entries[x4] = p.entries[y];
                        ++x4;
                        ++y;
                    }
                    p.entries[p.nrElements] = null;
                }
                --p.nrElements;
                if (p.isRoot() && p.nrElements == 0) {
                    BTreeSet.this.root = this;
                    this.parent = null;
                }
            }
        }

        private void mergeRight(int parentIndex) {
            BTreeNode p = this.parent;
            BTreeNode rs = p.entries[parentIndex + 1].child;
            if (this.isLeaf()) {
                this.entries[this.nrElements] = new Entry();
                this.entries[this.nrElements].element = p.entries[parentIndex].element;
                ++this.nrElements;
                int i = 0;
                int nr = this.nrElements;
                while (i < rs.nrElements) {
                    this.entries[nr] = rs.entries[i];
                    ++this.nrElements;
                    ++i;
                    ++nr;
                }
                p.entries[parentIndex].element = p.entries[parentIndex + 1].element;
                if (p.nrElements == this.MIN && p != BTreeSet.this.root) {
                    int x = parentIndex + 1;
                    int y = parentIndex;
                    while (y >= 0) {
                        p.entries[x] = p.entries[y];
                        --x;
                        --y;
                    }
                    p.entries[0] = new Entry();
                    p.entries[0].child = rs;
                } else {
                    int x = parentIndex + 1;
                    int y = parentIndex + 2;
                    while (y <= p.nrElements) {
                        p.entries[x] = p.entries[y];
                        ++x;
                        ++y;
                    }
                    p.entries[p.nrElements] = null;
                }
                --p.nrElements;
                if (p.isRoot() && p.nrElements == 0) {
                    BTreeSet.this.root = this;
                    this.parent = null;
                }
            } else {
                this.entries[this.nrElements].element = p.entries[parentIndex].element;
                ++this.nrElements;
                int x = this.nrElements + 1;
                int y = 0;
                while (y <= rs.nrElements) {
                    this.entries[x] = rs.entries[y];
                    rs.entries[y].child.parent = this;
                    ++this.nrElements;
                    ++x;
                    ++y;
                }
                --this.nrElements;
                p.entries[++parentIndex].child = this;
                if (p.nrElements == this.MIN && p != BTreeSet.this.root) {
                    int x2 = parentIndex - 1;
                    int y2 = parentIndex - 2;
                    while (y2 >= 0) {
                        p.entries[x2] = p.entries[y2];
                        --x2;
                        --y2;
                    }
                    p.entries[0] = new Entry();
                } else {
                    int x3 = parentIndex - 1;
                    int y3 = parentIndex;
                    while (y3 <= p.nrElements) {
                        p.entries[x3] = p.entries[y3];
                        ++x3;
                        ++y3;
                    }
                    p.entries[p.nrElements] = null;
                }
                --p.nrElements;
                if (p.isRoot() && p.nrElements == 0) {
                    BTreeSet.this.root = this;
                    this.parent = null;
                }
            }
        }
    }

    public static class Entry {
        public Object element;
        public BTreeNode child;
    }

    private class Iterator
    implements java.util.Iterator {
        private int index = 0;
        private Stack parentIndex = new Stack();
        private Object lastReturned = null;
        private Object next;
        private BTreeNode currentNode = this.firstNode();

        Iterator() {
            this.next = this.nextElement();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.nextElement();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new NoSuchElementException();
            }
            BTreeSet.this.remove(this.lastReturned);
            this.lastReturned = null;
        }

        private BTreeNode firstNode() {
            BTreeNode temp = BTreeSet.this.root;
            while (temp.entries[0].child != null) {
                temp = temp.entries[0].child;
                this.parentIndex.push(new Integer(0));
            }
            return temp;
        }

        private Object nextElement() {
            if (this.currentNode.isLeaf()) {
                if (this.index < this.currentNode.nrElements) {
                    return this.currentNode.entries[this.index++].element;
                }
                if (!this.parentIndex.empty()) {
                    this.currentNode = this.currentNode.parent;
                    this.index = (Integer)this.parentIndex.pop();
                    while (this.index == this.currentNode.nrElements) {
                        if (this.parentIndex.empty()) break;
                        this.currentNode = this.currentNode.parent;
                        this.index = (Integer)this.parentIndex.pop();
                    }
                    if (this.index == this.currentNode.nrElements) {
                        return null;
                    }
                    return this.currentNode.entries[this.index++].element;
                }
                if (this.index == this.currentNode.nrElements) {
                    return null;
                }
                return this.currentNode.entries[this.index++].element;
            }
            this.currentNode = this.currentNode.entries[this.index].child;
            this.parentIndex.push(new Integer(this.index));
            while (this.currentNode.entries[0].child != null) {
                this.currentNode = this.currentNode.entries[0].child;
                this.parentIndex.push(new Integer(0));
            }
            this.index = 1;
            return this.currentNode.entries[0].element;
        }
    }
}

