/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal;

import org.eclipse.jface.internal.databinding.internal.BindingMessages;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangingListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IVetoableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.WritableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class ValueBinding
extends Binding {
    private final IObservableValue target;
    private final IObservableValue model;
    private IValidator targetValidator;
    private IConverter targetToModelConverter;
    private IConverter modelToTargetConverter;
    private IDomainValidator domainValidator;
    private boolean updating = false;
    private WritableValue partialValidationErrorObservable;
    private WritableValue validationErrorObservable;
    private final IValueChangingListener targetChangingListener;
    private final IValueChangeListener targetChangeListener;
    private IValueChangeListener modelChangeListener;
    static /* synthetic */ Class class$0;

    public ValueBinding(DataBindingContext context, IObservableValue target, IObservableValue model, BindSpec bindSpec) {
        super(context);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.internal.databinding.provisional.validation.ValidationError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.partialValidationErrorObservable = new WritableValue(clazz, null);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.internal.databinding.provisional.validation.ValidationError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.validationErrorObservable = new WritableValue(clazz2, null);
        this.targetChangingListener = new IValueChangingListener(){

            public boolean handleValueChanging(IVetoableValue source, ValueDiff diff) {
                if (ValueBinding.this.updating) {
                    return true;
                }
                Object value = diff.getNewValue();
                ValidationError partialValidationError = ValueBinding.this.targetValidator.isPartiallyValid(value);
                ValueBinding.this.partialValidationErrorObservable.setValue(partialValidationError);
                return partialValidationError == null;
            }
        };
        this.targetChangeListener = new IValueChangeListener(){

            public void handleValueChange(IObservableValue source, ValueDiff diff) {
                if (ValueBinding.this.updating) {
                    return;
                }
                ValueBinding.this.updateModelFromTarget(diff);
            }
        };
        this.modelChangeListener = new IValueChangeListener(){

            public void handleValueChange(IObservableValue source, ValueDiff diff) {
                if (ValueBinding.this.updating) {
                    return;
                }
                ValueBinding.this.doUpdateTargetFromModel(diff);
            }
        };
        this.target = target;
        this.model = model;
        if (bindSpec.updateTarget()) {
            this.modelToTargetConverter = bindSpec.getModelToTargetConverter();
            if (this.modelToTargetConverter == null) {
                throw new BindingException("Missing model to target converter from " + model.getValueType() + " to " + target.getValueType());
            }
            if (!context.isAssignableFromTo(model.getValueType(), this.modelToTargetConverter.getFromType())) {
                throw new BindingException("model to target converter does not convert from model type. Expected: " + model.getValueType() + ", actual: " + this.modelToTargetConverter.getFromType());
            }
            if (!context.isAssignableFromTo(this.modelToTargetConverter.getToType(), target.getValueType())) {
                throw new BindingException("model to target converter does convert to target type. Expected: " + target.getValueType() + ", actual: " + this.modelToTargetConverter.getToType());
            }
            model.addValueChangeListener(this.modelChangeListener);
        }
        if (bindSpec.updateModel()) {
            this.targetToModelConverter = bindSpec.getTargetToModelConverter();
            if (this.targetToModelConverter == null) {
                throw new BindingException("Missing target to model converter from " + target.getValueType() + " to " + model.getValueType());
            }
            if (!context.isAssignableFromTo(target.getValueType(), this.targetToModelConverter.getFromType())) {
                throw new BindingException("target to model converter does not convert from target type. Expected: " + target.getValueType() + ", actual: " + this.targetToModelConverter.getFromType());
            }
            if (!context.isAssignableFromTo(this.targetToModelConverter.getToType(), model.getValueType())) {
                throw new BindingException("target to model converter does convert to model type. Expected: " + model.getValueType() + ", actual: " + this.targetToModelConverter.getToType());
            }
            this.targetValidator = bindSpec.getTypeConversionValidator();
            if (this.targetValidator == null) {
                throw new BindingException("Missing validator");
            }
            this.domainValidator = bindSpec.getDomainValidator();
            target.addValueChangeListener(this.targetChangeListener);
            if (target instanceof IVetoableValue) {
                ((IVetoableValue)target).addValueChangingListener(this.targetChangingListener);
            }
        }
        this.updateTargetFromModel();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateModelFromTarget(ValueDiff diff) {
        BindingEvent e = new BindingEvent(this.model, this.target, diff, 1, 0){};
        e.originalValue = this.target.getValue();
        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
            return;
        }
        ValidationError validationError = this.doValidate(e.originalValue);
        if (validationError != null) {
            return;
        }
        e.pipelinePosition = 1;
        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
            return;
        }
        try {
            try {
                block13: {
                    block12: {
                        block11: {
                            this.updating = true;
                            e.convertedValue = this.targetToModelConverter.convert(e.originalValue);
                            e.pipelinePosition = 2;
                            if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block11;
                            break block12;
                        }
                        validationError = this.doDomainValidation(e.convertedValue);
                        if (validationError != null) break block12;
                        e.pipelinePosition = 3;
                        if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block13;
                    }
                    Object var5_4 = null;
                    this.updating = false;
                    return;
                }
                this.model.setValue(e.convertedValue);
                e.pipelinePosition = 4;
                this.fireBindingEvent(e);
            }
            catch (Exception exception) {
                ValidationError error = ValidationError.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"));
                this.validationErrorObservable.setValue(error);
            }
            Object var5_6 = null;
            this.updating = false;
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.updating = false;
            throw throwable;
        }
    }

    private ValidationError doDomainValidation(Object convertedValue) {
        if (this.domainValidator == null) {
            return null;
        }
        ValidationError validationError = this.domainValidator.isValid(convertedValue);
        return this.errMsg(validationError);
    }

    private ValidationError doValidate(Object value) {
        if (this.targetValidator == null) {
            return null;
        }
        ValidationError validationError = this.targetValidator.isValid(value);
        return this.errMsg(validationError);
    }

    private ValidationError errMsg(ValidationError validationError) {
        this.partialValidationErrorObservable.setValue(null);
        this.validationErrorObservable.setValue(validationError);
        return validationError;
    }

    private boolean failure(ValidationError errorMessage) {
        return errorMessage != null && errorMessage.status == 2;
    }

    public void updateTargetFromModel() {
        this.doUpdateTargetFromModel(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUpdateTargetFromModel(ValueDiff diff) {
        try {
            BindingEvent e;
            block7: {
                block6: {
                    block5: {
                        this.updating = true;
                        e = new BindingEvent(this.model, this.target, diff, 0, 0){};
                        e.originalValue = this.model.getValue();
                        if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block5;
                        break block6;
                    }
                    e.convertedValue = this.modelToTargetConverter.convert(e.originalValue);
                    e.pipelinePosition = 2;
                    if (this.failure(this.errMsg(this.fireBindingEvent(e)))) break block6;
                    this.target.setValue(e.convertedValue);
                    e.pipelinePosition = 4;
                    if (!this.failure(this.errMsg(this.fireBindingEvent(e)))) break block7;
                }
                Object var3_3 = null;
                this.updating = false;
                return;
            }
            this.doValidate(this.target.getValue());
            e.pipelinePosition = 1;
            this.fireBindingEvent(e);
            Object var3_5 = null;
            this.updating = false;
            return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.updating = false;
            throw throwable;
        }
    }

    public IObservableValue getValidationError() {
        return this.validationErrorObservable;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationErrorObservable;
    }

    public void updateModelFromTarget() {
        this.updateModelFromTarget(Diffs.createValueDiff(this.target.getValue(), this.target.getValue()));
    }
}

