/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    static RTFTransfer _instance = new RTFTransfer();
    static final String RTF = "RTF ";
    static final int RTFID = RTFTransfer.registerType("RTF ");

    RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -1;
        String string = (String)object;
        int count = string.length();
        char[] chars = new char[count];
        string.getChars(0, count, chars, 0);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, count);
        if (cfstring == 0) {
            return;
        }
        try {
            byte[] buffer;
            block10: {
                block8: {
                    int numChars;
                    int[] size;
                    int encoding;
                    CFRange range;
                    block9: {
                        range = new CFRange();
                        range.length = chars.length;
                        encoding = OS.CFStringGetSystemEncoding();
                        size = new int[1];
                        numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
                        if (numChars == 0) break block8;
                        if (size[0] != 0) break block9;
                        break block8;
                    }
                    buffer = new byte[size[0]];
                    numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
                    if (numChars != 0) break block10;
                }
                Object var12_11 = null;
                OS.CFRelease(cfstring);
                return;
            }
            transferData.data = new byte[1][];
            transferData.data[0] = buffer;
            transferData.result = 0;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            OS.CFRelease(cfstring);
            throw throwable;
        }
        OS.CFRelease(cfstring);
    }

    public Object nativeToJava(TransferData transferData) {
        int length;
        int cfstring;
        block6: {
            if (!this.isSupportedType(transferData) || transferData.data == null) {
                return null;
            }
            if (transferData.data.length == 0 || transferData.data[0].length == 0) {
                return null;
            }
            byte[] buffer = transferData.data[0];
            int encoding = OS.CFStringGetSystemEncoding();
            cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, true);
            if (cfstring == 0) {
                return null;
            }
            try {
                length = OS.CFStringGetLength(cfstring);
                if (length != 0) break block6;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                OS.CFRelease(cfstring);
                throw throwable;
            }
            OS.CFRelease(cfstring);
            return null;
        }
        char[] chars = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(cfstring, range, chars);
        String string = new String(chars);
        Object var8_7 = null;
        OS.CFRelease(cfstring);
        return string;
    }

    protected int[] getTypeIds() {
        return new int[]{RTFID};
    }

    protected String[] getTypeNames() {
        return new String[]{RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

