/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.menus.DynamicMenuProxy;
import org.eclipse.ui.internal.menus.IDynamicMenu;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.SActionSet;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SLayout;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SOrder;
import org.eclipse.ui.internal.menus.SPart;
import org.eclipse.ui.internal.menus.SPopup;
import org.eclipse.ui.internal.menus.SReference;
import org.eclipse.ui.internal.menus.SWidget;
import org.eclipse.ui.internal.menus.WidgetProxy;
import org.eclipse.ui.internal.services.RegistryPersistence;

final class MenuPersistence
extends RegistryPersistence {
    private static final int INDEX_ACTION_SETS = 0;
    private static final int INDEX_GROUPS = 1;
    private static final int INDEX_ITEMS = 2;
    private static final int INDEX_MENUS = 3;
    private static final int INDEX_WIDGETS = 4;
    private static final Collection menuContributions = new ArrayList();
    private final ICommandService commandService;
    private final IMenuService menuService;

    private static final void clearContributions(IMenuService menuService) {
        menuService.removeContributions(menuContributions);
        menuContributions.clear();
    }

    private static final void readActionSetsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IMenuService menuService) {
        SActionSet[] handleObjects = menuService.getDefinedActionSets();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String label;
            IConfigurationElement configurationElement = configurationElements[i];
            String id = MenuPersistence.readRequired(configurationElement, "id", warningsToLog, "Action sets need an id");
            if (id != null && (label = MenuPersistence.readRequired(configurationElement, "label", warningsToLog, "Action sets need a label")) != null) {
                String description = MenuPersistence.readOptional(configurationElement, "description");
                boolean visible = MenuPersistence.readBoolean(configurationElement, "visible", false);
                SReference[] references = MenuPersistence.readReferencesFromRegistry(configurationElement, id, warningsToLog);
                SActionSet actionSet = menuService.getActionSet(id);
                actionSet.define(label, description, visible, references);
            }
            ++i;
        }
        MenuPersistence.logWarnings(warningsToLog, "Warnings while parsing the action sets from the 'org.eclipse.ui.menus' extension point");
    }

    private static final SBar readBarFromRegistry(IConfigurationElement parentElement, List warningsToLog, String id) {
        IConfigurationElement[] barElements = parentElement.getChildren("bar");
        if (barElements.length > 0) {
            if (barElements.length > 1) {
                MenuPersistence.addWarning(warningsToLog, "Location elements should only have one bar element", parentElement, id);
                return null;
            }
            IConfigurationElement barElement = barElements[0];
            String type = MenuPersistence.readRequired(barElement, "type", warningsToLog, "Bar elements require a type element", id);
            if (!"menu".equals(type) && !"trim".equals(type)) {
                MenuPersistence.addWarning(warningsToLog, "The bar type was not understood", parentElement, id, "type", type);
                return null;
            }
            String path = MenuPersistence.readOptional(barElement, "path");
            return new SBar(type, path);
        }
        return null;
    }

    private static final IDynamicMenu readDynamicMenuFromRegistry(IConfigurationElement parentElement, String id, List warningsToLog) {
        IConfigurationElement[] dynamicMenuElements = parentElement.getChildren("dynamic");
        if (dynamicMenuElements.length > 0) {
            if (dynamicMenuElements.length > 1) {
                MenuPersistence.addWarning(warningsToLog, "Group and menu elements should only have one dynamic element", parentElement, id);
                return null;
            }
            IConfigurationElement dynamicMenuElement = dynamicMenuElements[0];
            if (!MenuPersistence.checkClass(dynamicMenuElement, warningsToLog, "Dynamic menu needs a class", id)) {
                return null;
            }
            return new DynamicMenuProxy(dynamicMenuElement, "class");
        }
        return null;
    }

    private static final void readGroupsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IMenuService menuService) {
        SGroup[] handleObjects = menuService.getDefinedGroups();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = MenuPersistence.readRequired(configurationElement, "id", warningsToLog, "Groups need an id");
            if (id != null) {
                boolean separatorsVisible = MenuPersistence.readBoolean(configurationElement, "separatorsVisible", true);
                Expression visibleWhenExpression = MenuPersistence.readWhenElement(configurationElement, "visibleWhen", id, warningsToLog);
                if (visibleWhenExpression != ERROR_EXPRESSION) {
                    SLocation[] locations = MenuPersistence.readLocationElementsFromRegistry(configurationElement, id, warningsToLog);
                    IDynamicMenu dynamicMenu = MenuPersistence.readDynamicMenuFromRegistry(configurationElement, id, warningsToLog);
                    SGroup group = menuService.getGroup(id);
                    group.define(separatorsVisible, locations, dynamicMenu);
                    menuContributions.add(menuService.contributeMenu(group, visibleWhenExpression));
                }
            }
            ++i;
        }
        MenuPersistence.logWarnings(warningsToLog, "Warnings while parsing the groups from the 'org.eclipse.ui.menus' extension point");
    }

    private static final void readItemsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IMenuService menuService, ICommandService commandService) {
        SItem[] handleObjects = menuService.getDefinedItems();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = MenuPersistence.readRequired(configurationElement, "id", warningsToLog, "Items need an id");
            if (id != null) {
                ParameterizedCommand command = MenuPersistence.readParameterizedCommand(configurationElement, commandService, warningsToLog, "Items need a command id", id);
                String menuId = MenuPersistence.readOptional(configurationElement, "menuId");
                Expression visibleWhenExpression = MenuPersistence.readWhenElement(configurationElement, "visibleWhen", id, warningsToLog);
                if (visibleWhenExpression != ERROR_EXPRESSION) {
                    SLocation[] locations = MenuPersistence.readLocationElementsFromRegistry(configurationElement, id, warningsToLog);
                    SItem item = menuService.getItem(id);
                    item.define(command, menuId, locations);
                    menuContributions.add(menuService.contributeMenu(item, visibleWhenExpression));
                }
            }
            ++i;
        }
        MenuPersistence.logWarnings(warningsToLog, "Warnings while parsing the items from the 'org.eclipse.ui.menus' extension point");
    }

    private static final SLayout readLayoutFromRegistry(IConfigurationElement parentElement, String id, List warningsToLog) {
        IConfigurationElement[] layoutElements = parentElement.getChildren("layout");
        if (layoutElements.length < 1) {
            return new SLayout();
        }
        IConfigurationElement layoutElement = layoutElements[0];
        if (layoutElements.length > 1) {
            MenuPersistence.addWarning(warningsToLog, "There should only be a single layout element for a widget", parentElement, id);
        }
        boolean fillMajor = MenuPersistence.readBoolean(layoutElement, "fillMajor", false);
        boolean fillMinor = MenuPersistence.readBoolean(layoutElement, "fillMinor", false);
        return new SLayout(fillMajor, fillMinor);
    }

    private static final SLocation[] readLocationElementsFromRegistry(IConfigurationElement parentElement, String id, List warningsToLog) {
        IConfigurationElement[] locationElements = parentElement.getChildren("location");
        if (locationElements.length < 1) {
            return null;
        }
        ArrayList<SLocation> locations = new ArrayList<SLocation>(locationElements.length);
        int i = 0;
        while (i < locationElements.length) {
            char mnemonicChar;
            IConfigurationElement locationElement = locationElements[i];
            String mnemonic = MenuPersistence.readOptional(locationElement, "mnemonic");
            if (mnemonic == null) {
                mnemonicChar = '\u0000';
            } else if (mnemonic.length() != 1) {
                MenuPersistence.addWarning(warningsToLog, "The mnemonic should only be one character", parentElement, id, "mnemonic", mnemonic);
                mnemonicChar = '\u0000';
            } else {
                mnemonicChar = mnemonic.charAt(0);
            }
            String imageStyle = MenuPersistence.readOptional(locationElement, "imageStyle");
            SOrder ordering = MenuPersistence.readOrderingFromRegistry(locationElement, id, warningsToLog);
            LocationElement menuLocation = MenuPersistence.readMenuLocationFromRegistry(locationElement, warningsToLog, id);
            if (menuLocation != null) {
                SLocation location = new SLocation(menuLocation, ordering, mnemonicChar, imageStyle);
                locations.add(location);
            }
            ++i;
        }
        return locations.toArray(new SLocation[locations.size()]);
    }

    private static final LocationElement readMenuLocationFromRegistry(IConfigurationElement parentElement, List warningsToLog, String id) {
        LocationElement locationElement = null;
        locationElement = MenuPersistence.readBarFromRegistry(parentElement, warningsToLog, id);
        if (locationElement == null && (locationElement = MenuPersistence.readPartFromRegistry(parentElement, warningsToLog, id)) == null) {
            locationElement = MenuPersistence.readPopupFromRegistry(parentElement, warningsToLog, id);
        }
        if (locationElement == null) {
            MenuPersistence.addWarning(warningsToLog, "A bar, part or popup element is required", parentElement, id);
        }
        return locationElement;
    }

    private static final void readMenusFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IMenuService menuService) {
        SMenu[] handleObjects = menuService.getDefinedMenus();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = MenuPersistence.readRequired(configurationElement, "id", warningsToLog, "Menus need an id");
            if (id != null) {
                String label = MenuPersistence.readOptional(configurationElement, "label");
                Expression visibleWhenExpression = MenuPersistence.readWhenElement(configurationElement, "visibleWhen", id, warningsToLog);
                if (visibleWhenExpression != ERROR_EXPRESSION) {
                    SLocation[] locations = MenuPersistence.readLocationElementsFromRegistry(configurationElement, id, warningsToLog);
                    IDynamicMenu dynamicMenu = MenuPersistence.readDynamicMenuFromRegistry(configurationElement, id, warningsToLog);
                    SMenu menu = menuService.getMenu(id);
                    menu.define(label, locations, dynamicMenu);
                    menuContributions.add(menuService.contributeMenu(menu, visibleWhenExpression));
                }
            }
            ++i;
        }
        MenuPersistence.logWarnings(warningsToLog, "Warnings while parsing the menus from the 'org.eclipse.ui.menus' extension point");
    }

    private static final SOrder readOrderingFromRegistry(IConfigurationElement parentElement, String id, List warningsToLog) {
        int positionInteger;
        IConfigurationElement orderingElement;
        String position;
        IConfigurationElement[] orderingElements = parentElement.getChildren("order");
        int length = orderingElements.length;
        if (length < 1) {
            return null;
        }
        if (length > 1) {
            MenuPersistence.addWarning(warningsToLog, "There can only be one ordering constraint", parentElement, id);
        }
        if ("after".equals(position = MenuPersistence.readRequired(orderingElement = orderingElements[0], "position", warningsToLog, "Order elements require a position element", id))) {
            positionInteger = 3;
        } else if ("before".equals(position)) {
            positionInteger = 2;
        } else if ("start".equals(position)) {
            positionInteger = 0;
        } else if ("end".equals(position)) {
            positionInteger = 1;
        } else {
            MenuPersistence.addWarning(warningsToLog, "The position was not understood", parentElement, id, "position", position);
            return null;
        }
        String relativeTo = null;
        if (positionInteger == 3 || positionInteger == 2) {
            relativeTo = MenuPersistence.readRequired(orderingElement, "relativeTo", warningsToLog, "A relativeTo attribute is required if the position is 'after' or 'before'", id);
            if (relativeTo == null) {
                return null;
            }
        } else {
            relativeTo = MenuPersistence.readOptional(orderingElement, "relativeTo");
            if (relativeTo != null) {
                MenuPersistence.addWarning(warningsToLog, "relativeTo should not be specified unless the position is before or after", parentElement, id, "relativeTo", relativeTo);
                return null;
            }
        }
        SOrder order = new SOrder(positionInteger, relativeTo);
        return order;
    }

    private static final SPart readPartFromRegistry(IConfigurationElement parentElement, List warningsToLog, String id) {
        IConfigurationElement[] partElements = parentElement.getChildren("bar");
        if (partElements.length > 0) {
            if (partElements.length > 1) {
                MenuPersistence.addWarning(warningsToLog, "Location elements should only have one part element", parentElement, id);
                return null;
            }
            IConfigurationElement partElement = partElements[0];
            LeafLocationElement leafLocationElement = null;
            leafLocationElement = MenuPersistence.readBarFromRegistry(parentElement, warningsToLog, id);
            if (leafLocationElement == null) {
                leafLocationElement = MenuPersistence.readPopupFromRegistry(parentElement, warningsToLog, id);
            }
            if (leafLocationElement == null) {
                MenuPersistence.addWarning(warningsToLog, "A bar or popup element is required", parentElement, id);
                return null;
            }
            String partId = MenuPersistence.readOptional(partElement, "id");
            String clazz = MenuPersistence.readOptional(partElement, "class");
            if (partId == null && clazz == null) {
                MenuPersistence.addWarning(warningsToLog, "A part id or a part class is required", parentElement, id);
                return null;
            }
            if (partId != null && clazz != null) {
                MenuPersistence.addWarning(warningsToLog, "Only a part id or a part class is allowed, not both", parentElement, id);
                return null;
            }
            if (partId != null) {
                return new SPart(partId, 1, leafLocationElement);
            }
            return new SPart(clazz, 0, leafLocationElement);
        }
        return null;
    }

    private static final SPopup readPopupFromRegistry(IConfigurationElement parentElement, List warningsToLog, String id) {
        IConfigurationElement[] popupElements = parentElement.getChildren("bar");
        if (popupElements.length > 0) {
            if (popupElements.length > 1) {
                MenuPersistence.addWarning(warningsToLog, "Location elements should only have one popup element", parentElement, id);
                return null;
            }
            IConfigurationElement popupElement = popupElements[0];
            String popupId = MenuPersistence.readOptional(popupElement, "id");
            String path = MenuPersistence.readOptional(popupElement, "path");
            return new SPopup(popupId, path);
        }
        return null;
    }

    private static final SReference[] readReferencesFromRegistry(IConfigurationElement parentElement, String id, List warningsToLog) {
        IConfigurationElement[] referenceElements = parentElement.getChildren("reference");
        if (referenceElements.length < 1) {
            return null;
        }
        ArrayList<SReference> references = new ArrayList<SReference>(referenceElements.length);
        int i = 0;
        while (i < referenceElements.length) {
            IConfigurationElement referenceElement = referenceElements[i];
            String referenceId = MenuPersistence.readRequired(referenceElement, "id", warningsToLog, "References are required", id);
            if (referenceId != null) {
                int typeInteger;
                String type = MenuPersistence.readRequired(referenceElement, "type", warningsToLog, "Reference elements require a type", id);
                if ("item".equals(type)) {
                    typeInteger = 3;
                } else if ("menu".equals(type)) {
                    typeInteger = 1;
                } else if ("group".equals(type)) {
                    typeInteger = 2;
                } else if ("widget".equals(type)) {
                    typeInteger = 4;
                } else {
                    MenuPersistence.addWarning(warningsToLog, "The reference type was not understood", parentElement, id, "type", type);
                    return null;
                }
                SReference reference = new SReference(typeInteger, referenceId);
                references.add(reference);
            }
            ++i;
        }
        return references.toArray(new SReference[references.size()]);
    }

    private static final void readWidgetsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, IMenuService menuService) {
        SWidget[] handleObjects = menuService.getDefinedWidgets();
        if (handleObjects != null) {
            int i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = MenuPersistence.readRequired(configurationElement, "id", warningsToLog, "Widgets need an id");
            if (id != null && MenuPersistence.checkClass(configurationElement, warningsToLog, "Widget needs a class", id)) {
                WidgetProxy widgetClass = new WidgetProxy(configurationElement, "class");
                Expression visibleWhenExpression = MenuPersistence.readWhenElement(configurationElement, "visibleWhen", id, warningsToLog);
                if (visibleWhenExpression != ERROR_EXPRESSION) {
                    SLocation[] locations = MenuPersistence.readLocationElementsFromRegistry(configurationElement, id, warningsToLog);
                    SLayout layout = MenuPersistence.readLayoutFromRegistry(configurationElement, id, warningsToLog);
                    SWidget widget = menuService.getWidget(id);
                    widget.define(widgetClass, locations, layout);
                    menuContributions.add(menuService.contributeMenu(widget, visibleWhenExpression));
                }
            }
            ++i;
        }
        MenuPersistence.logWarnings(warningsToLog, "Warnings while parsing the items from the 'org.eclipse.ui.menus' extension point");
    }

    MenuPersistence(IMenuService menuService, ICommandService commandService) {
        if (menuService == null) {
            throw new NullPointerException("The menu service cannot be null");
        }
        if (commandService == null) {
            throw new NullPointerException("The command service cannot be null");
        }
        this.commandService = commandService;
        this.menuService = menuService;
    }

    public final void dispose() {
        super.dispose();
        MenuPersistence.clearContributions(this.menuService);
    }

    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        IExtensionDelta[] menuDeltas = event.getExtensionDeltas("org.eclipse.ui", "menus");
        return menuDeltas.length != 0;
    }

    protected final void read() {
        super.read();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int itemCount = 0;
        int menuCount = 0;
        int groupCount = 0;
        int widgetCount = 0;
        int actionSetCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[5][];
        IConfigurationElement[] menusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int i = 0;
        while (i < menusExtensionPoint.length) {
            IConfigurationElement configurationElement = menusExtensionPoint[i];
            String name = configurationElement.getName();
            if ("item".equals(name)) {
                MenuPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, itemCount++);
            } else if ("menu".equals(name)) {
                MenuPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 3, menuCount++);
            } else if ("group".equals(name)) {
                MenuPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, groupCount++);
            } else if ("widget".equals(name)) {
                MenuPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 4, widgetCount++);
            } else if ("actionSet".equals(name)) {
                MenuPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, actionSetCount++);
            }
            ++i;
        }
        MenuPersistence.clearContributions(this.menuService);
        MenuPersistence.readItemsFromRegistry(indexedConfigurationElements[2], itemCount, this.menuService, this.commandService);
        MenuPersistence.readMenusFromRegistry(indexedConfigurationElements[3], menuCount, this.menuService);
        MenuPersistence.readGroupsFromRegistry(indexedConfigurationElements[1], groupCount, this.menuService);
        MenuPersistence.readWidgetsFromRegistry(indexedConfigurationElements[4], widgetCount, this.menuService);
        MenuPersistence.readActionSetsFromRegistry(indexedConfigurationElements[0], actionSetCount, this.menuService);
    }
}

