/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.commands.ICommandService;

public class SlaveCommandService
implements ICommandService {
    private Collection fExecutionListeners = new ArrayList();
    private ICommandService fParentService;

    public SlaveCommandService(ICommandService parent) {
        if (parent == null) {
            throw new NullPointerException("The parent command service must not be null");
        }
        this.fParentService = parent;
    }

    public void addExecutionListener(IExecutionListener listener) {
        if (!this.fExecutionListeners.contains(listener)) {
            this.fExecutionListeners.add(listener);
        }
        this.fParentService.addExecutionListener(listener);
    }

    public void defineUncategorizedCategory(String name, String description) {
        this.fParentService.defineUncategorizedCategory(name, description);
    }

    public ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
        return this.fParentService.deserialize(serializedParameterizedCommand);
    }

    public void dispose() {
        if (!this.fExecutionListeners.isEmpty()) {
            Object[] array = this.fExecutionListeners.toArray();
            int i = 0;
            while (i < array.length) {
                this.removeExecutionListener((IExecutionListener)array[i]);
                ++i;
            }
            this.fExecutionListeners.clear();
        }
    }

    public Category getCategory(String categoryId) {
        return this.fParentService.getCategory(categoryId);
    }

    public Command getCommand(String commandId) {
        return this.fParentService.getCommand(commandId);
    }

    public Category[] getDefinedCategories() {
        return this.fParentService.getDefinedCategories();
    }

    public Collection getDefinedCategoryIds() {
        return this.fParentService.getDefinedCategoryIds();
    }

    public Collection getDefinedCommandIds() {
        return this.fParentService.getDefinedCommandIds();
    }

    public Command[] getDefinedCommands() {
        return this.fParentService.getDefinedCommands();
    }

    public Collection getDefinedParameterTypeIds() {
        return this.fParentService.getDefinedParameterTypeIds();
    }

    public ParameterType[] getDefinedParameterTypes() {
        return this.fParentService.getDefinedParameterTypes();
    }

    public final String getHelpContextId(Command command) throws NotDefinedException {
        return this.fParentService.getHelpContextId(command);
    }

    public final String getHelpContextId(String commandId) throws NotDefinedException {
        return this.fParentService.getHelpContextId(commandId);
    }

    public ParameterType getParameterType(String parameterTypeId) {
        return this.fParentService.getParameterType(parameterTypeId);
    }

    public void readRegistry() {
        this.fParentService.readRegistry();
    }

    public void removeExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.remove(listener);
        this.fParentService.removeExecutionListener(listener);
    }

    public final void setHelpContextId(IHandler handler, String helpContextId) {
        this.fParentService.setHelpContextId(handler, helpContextId);
    }
}

