/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.factories;

import org.eclipse.jface.internal.databinding.internal.ListBinding;
import org.eclipse.jface.internal.databinding.internal.ValueBinding;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.factories.IBindingFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;

public class DefaultBindingFactory
implements IBindingFactory {
    public Binding createBinding(DataBindingContext dataBindingContext, IObservable targetObservable, IObservable modelObservable, BindSpec bindSpec) {
        if (bindSpec == null) {
            bindSpec = new BindSpec(null, null, null, null);
        }
        if (targetObservable instanceof IObservableValue) {
            if (modelObservable instanceof IObservableValue) {
                IObservableValue target = (IObservableValue)targetObservable;
                IObservableValue model = (IObservableValue)modelObservable;
                dataBindingContext.fillBindSpecDefaults(dataBindingContext, bindSpec, target.getValueType(), model.getValueType());
                ValueBinding binding = new ValueBinding(dataBindingContext, target, model, bindSpec);
                return binding;
            }
            throw new BindingException("incompatible observables: target is value, model is " + modelObservable.getClass().getName());
        }
        if (targetObservable instanceof IObservableList) {
            if (modelObservable instanceof IObservableList) {
                IObservableList target = (IObservableList)targetObservable;
                IObservableList model = (IObservableList)modelObservable;
                dataBindingContext.fillBindSpecDefaults(dataBindingContext, bindSpec, target.getElementType(), model.getElementType());
                ListBinding binding = new ListBinding(dataBindingContext, target, model, bindSpec);
                return binding;
            }
            throw new BindingException("incompatible observable: target is list, model is " + modelObservable.getClass().getName());
        }
        return null;
    }
}

