/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.set;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IMappingChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.IObservableMapping;
import org.eclipse.jface.internal.databinding.provisional.observable.mapping.MappingDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.set.IObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ISetChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.set.ObservableSet;
import org.eclipse.jface.internal.databinding.provisional.observable.set.SetDiff;

public class MappedSet
extends ObservableSet {
    private final IObservableMapping wrappedMapping;
    private Map valueCounts = new HashMap();
    private ISetChangeListener domainListener = new ISetChangeListener(){

        public void handleSetChange(IObservableSet source, SetDiff diff) {
            HashSet<Object> additions = new HashSet<Object>();
            Iterator it = diff.getAdditions().iterator();
            while (it.hasNext()) {
                Object added = it.next();
                Object mappingValue = MappedSet.this.wrappedMapping.getMappingValue(added);
                if (!MappedSet.this.handleAddition(mappingValue)) continue;
                additions.add(mappingValue);
            }
            HashSet<Object> removals = new HashSet<Object>();
            Iterator it2 = diff.getRemovals().iterator();
            while (it2.hasNext()) {
                Object removed = it2.next();
                Object mappingValue = MappedSet.this.wrappedMapping.getMappingValue(removed);
                if (!MappedSet.this.handleRemoval(mappingValue)) continue;
                removals.add(mappingValue);
            }
            MappedSet.this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    };
    private IMappingChangeListener mappingChangeListener = new IMappingChangeListener(){

        public void handleMappingValueChange(IObservable source, MappingDiff diff) {
            Set affectedElements = diff.getElements();
            HashSet<Object[]> additions = new HashSet<Object[]>();
            HashSet<Object> removals = new HashSet<Object>();
            Iterator it = affectedElements.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                Object oldFunctionValue = diff.getOldMappingValues(element, new int[1])[0];
                Object[] newFunctionValue = diff.getNewMappingValues(element, new int[1]);
                if (MappedSet.this.handleRemoval(oldFunctionValue)) {
                    removals.add(oldFunctionValue);
                }
                if (!MappedSet.this.handleAddition(newFunctionValue)) continue;
                additions.add(newFunctionValue);
            }
            MappedSet.this.fireSetChange(Diffs.createSetDiff(additions, removals));
        }
    };
    private IObservableSet input;

    public MappedSet(IObservableSet input, IObservableMapping mapping) {
        super(Collections.EMPTY_SET, mapping.getValueType());
        this.setWrappedSet(this.valueCounts.keySet());
        this.wrappedMapping = mapping;
        this.input = input;
        Iterator it = input.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            Object functionValue = this.wrappedMapping.getMappingValue(element);
            this.handleAddition(functionValue);
        }
        input.addSetChangeListener(this.domainListener);
        mapping.addMappingChangeListener(this.mappingChangeListener);
    }

    protected boolean handleAddition(Object mappingValue) {
        Integer count = (Integer)this.valueCounts.get(mappingValue);
        if (count == null) {
            this.valueCounts.put(mappingValue, new Integer(1));
            return true;
        }
        this.valueCounts.put(mappingValue, new Integer(count + 1));
        return false;
    }

    protected boolean handleRemoval(Object mappingValue) {
        Integer count = (Integer)this.valueCounts.get(mappingValue);
        if (count <= 1) {
            this.valueCounts.remove(mappingValue);
            return true;
        }
        this.valueCounts.put(mappingValue, new Integer(count - 1));
        return false;
    }

    public void dispose() {
        this.wrappedMapping.removeMappingChangeListener(this.mappingChangeListener);
        this.input.removeSetChangeListener(this.domainListener);
    }

    public Object getElementType() {
        return this.wrappedMapping.getValueType();
    }
}

