/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ChangeVetoException;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangingListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IVetoableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;

public abstract class AbstractVetoableValue
extends AbstractObservableValue
implements IVetoableValue {
    private Collection valueChangingListeners = null;

    public void setValue(Object value) {
        Object currentValue = this.doGetValue();
        ValueDiff diff = Diffs.createValueDiff(currentValue, value);
        boolean okToProceed = this.fireValueChanging(diff);
        if (!okToProceed) {
            throw new ChangeVetoException("Change not permitted");
        }
        this.doSetValue(value);
        this.fireValueChange(diff);
    }

    public void addValueChangingListener(IValueChangingListener listener) {
        if (this.valueChangingListeners == null) {
            boolean hadListeners = this.hasListeners();
            this.valueChangingListeners = new ArrayList();
            this.valueChangingListeners.add(listener);
            if (!hadListeners) {
                this.firstListenerAdded();
            }
        } else if (this.valueChangingListeners.size() > 16) {
            HashSet listenerList = new HashSet();
            listenerList.addAll(this.valueChangingListeners);
            this.valueChangingListeners = listenerList;
            this.valueChangingListeners.add(listener);
        }
    }

    public void removeValueChangingListener(IValueChangingListener listener) {
        this.valueChangingListeners.remove(listener);
        if (this.valueChangingListeners.size() == 0) {
            this.valueChangingListeners = null;
        }
        if (!this.hasListeners()) {
            this.lastListenerRemoved();
        }
    }

    protected boolean fireValueChanging(ValueDiff diff) {
        if (this.valueChangingListeners != null) {
            IValueChangingListener[] listeners = this.valueChangingListeners.toArray(new IValueChangingListener[this.valueChangingListeners.size()]);
            int i = 0;
            while (i < listeners.length) {
                boolean okToProceed = listeners[i].handleValueChanging(this, diff);
                if (!okToProceed) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected abstract void doSetValue(Object var1);

    protected boolean hasListeners() {
        return super.hasListeners();
    }

    public void dispose() {
        super.dispose();
    }
}

