/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * XOOPS&Platform桼ΤΥ饹
 * 
 * $Revision: 1.9 $
 * $Log: account.cc,v $
 * Revision 1.9  2005/08/29 02:02:56  aga4096
 * valgrindǥ顼ФΤ.
 *
 * Revision 1.8  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.7  2005/02/25 07:00:37  tani
 * item_number_limit, index_number_limit, item_storage_limitɲ.
 *
 * Revision 1.6  2005/02/09 07:23:50  aga
 * URL to My Personal Archive DBALä.
 *
 * Revision 1.5  2005/01/15 05:31:16  youi
 * userid_tȤä.
 *
 * Revision 1.4  2005/01/14 10:33:37  aga
 * int privateIndexIDɲ.
 *
 * Revision 1.3  2004/12/01 10:28:58  youi
 * DB̾ѹȼ
 *     institute -> division
 *     organizaion -> company_name
 *
 * Revision 1.2  2004/11/25 08:57:01  youi
 * 󥹥ȥ饯char*Υѿ0ǽ.
 * getϴؿconst.
 *
 * Revision 1.1  2004/11/22 08:25:16  youi
 * initial version.
 *
 * 
 */
#include <time.h>
#include <string.h>

#include "account.h"
#include "common.h"

account::account()
{
    // charݥ󥿤0ǽ
    address = 0;
    division = 0;
    tel = 0;
    company_name = 0;
    country = 0;
    zipcode = 0;
    fax = 0;
    uname = 0;
    name = 0;
    email = 0;
    url = 0;
    user_avatar = 0;
    user_icq = 0;
    user_from = 0;
    user_sig = 0;
    actkey = 0;
    user_aim = 0;
    user_yim = 0;
    user_msnm = 0;
    pass = 0;
    theme = 0;
    umode = 0;
    user_occ = 0;
    bio = 0;
    user_intrest = 0;
    itemStorageLimit = 0;

    uid = 0;
    activate = false;
    setValue( &address, "" );
    setValue( &division, "" );
    setValue( &tel, "" );
    setValue( &company_name, "" );
    setValue( &country, "" );
    setValue( &zipcode, "" );
    setValue( &fax, "" );
    noticeMail = 1;
    noticeMailSince = 0;
    privateIndexID = 0;

    setValue( &uname, "" );
    setValue( &name, "" );
    setValue( &email, "" );
    setValue( &url, "" );
    setValue( &user_avatar, "" );
    user_regdate = 0;
    setValue( &user_icq, "" );
    setValue( &user_from, "" );
    setValue( &user_sig, "" );
    user_viewemail = 0;
    setValue( &actkey, "" );
    setValue( &user_aim, "" );
    setValue( &user_yim, "" );
    setValue( &user_msnm, "" );
    setValue( &pass, "" );
    posts = 0;
    attachsig = 0;
    rank = 0;
    level = 0;
    setValue( &theme, "" );
    timezone_offset = 0.0;
    last_login = 0;
    setValue( &umode, "" );
    uorder = 0;
    notify_method = 0;
    notify_mode = 0;
    setValue( &user_occ, "" );
    setValue( &bio, "" );
    setValue( &user_intrest, "" );
    user_mailok = 0;
}

account::~account()
{
    if( address != 0 ) delete[] address;
    if( division != 0 ) delete[] division;
    if( tel != 0 ) delete[] tel;
    if( company_name != 0 ) delete[] company_name;
    if( country != 0 ) delete[] country;
    if( zipcode != 0 ) delete[] zipcode;
    if( fax != 0 ) delete[] fax;

    if( uname != 0 ) delete[] uname;
    if( name != 0 ) delete[] name;
    if( email != 0 ) delete[] email;
    if( url != 0 ) delete[] url;
    if( user_avatar != 0 ) delete[] user_avatar;
    if( user_icq != 0 ) delete[] user_icq;
    if( user_from != 0 ) delete[] user_from;
    if( user_sig != 0 ) delete[] user_sig;
    if( actkey != 0 ) delete[] actkey;
    if( user_aim != 0 ) delete[] user_aim;
    if( user_yim != 0 ) delete[] user_yim;
    if( user_msnm != 0 ) delete[] user_msnm;
    if( pass != 0 ) delete[] pass;
    if( theme != 0 ) delete[] theme;
    if( umode != 0 ) delete[] umode;
    if( user_occ != 0 ) delete[] user_occ;
    if( bio != 0 ) delete[] bio;
    if( user_intrest != 0 ) delete[] user_intrest;
}

userid_t account::getUID() const { return uid; }

bool account::getActivate() const { return activate; }

const char * account::getAddress() const { return address; }

const char * account::getDivision() const { return division; }

const char * account::getTel() const { return tel; }

const char * account::getCompanyName() const { return company_name; }

const char * account::getCountry() const { return country; }

const char * account::getZipcode() const { return zipcode; }

const char * account::getFax() const { return fax; }

int account::getNoticeMail() const { return noticeMail; }

time_t account::getNoticeMailSince() const { return noticeMailSince; }

int account::getPrivateIndexID() const { return privateIndexID; }

int account::getItemNumberLimit() const { return itemNumberLimit; }

int account::getIndexNumberLimit() const { return indexNumberLimit; }

double account::getItemStorageLimit() const { return itemStorageLimit; }

// xoops_user
const char* account::getUname( ) const { return uname; }

const char* account::getName( ) const { return name; }

const char* account::getEmail( ) const { return email; }

const char* account::getURL( ) const { return url; }

const char* account::getUserAvatar( ) const { return user_avatar; }

int account::getUserRegdate( ) const { return user_regdate; }

const char* account::getUserIcq( ) const { return user_icq; }

const char* account::getUserFrom( ) const { return user_from; }

const char* account::getUserSig( ) const { return user_sig; }

int account::getUserViewemail( ) const { return user_viewemail; }

const char* account::getActkey( ) const { return actkey; }

const char* account::getUserAim( ) const { return user_aim; }

const char* account::getUserYim( ) const { return user_yim; }

const char* account::getUserMsnm( ) const { return user_msnm; }

const char* account::getPass( ) const { return pass; }

int account::getPosts( ) const { return posts; }

int account::getAttachsig( ) const { return attachsig; }

int account::getRank( ) const { return rank; }

int account::getLevel( ) const { return level; }

const char* account::getTheme( ) const { return theme; }

double account::getTimezoneOffset( ) const { return timezone_offset; }

int account::getLastLogin( ) const { return last_login; }

const char* account::getUmode( ) const { return umode; }

int account::getUorder( ) const { return uorder; }

int account::getNotifyMethod( ) const { return notify_method; }

int account::getNotifyMode( ) const { return notify_mode; }

const char* account::getUserOcc( ) const { return user_occ; }

const char* account::getBio( ) const { return bio; }

const char* account::getUserIntrest( ) const { return user_intrest; }

int account::getUserMailok( ) const { return user_mailok; }


//
void account::setUID(userid_t uid){ this -> uid = uid; }

void account::setActivate(bool activate){ this -> activate = activate; }

void account::setAddress( const char* address)
{
    setValue( &this -> address, address );
}

void account::setDivision( const char* division)
{
    setValue( &this -> division, division );
}

void account::setTel( const char* tel)
{
    setValue( &this -> tel, tel );
}

void account::setCompanyName( const char* company_name)
{
    setValue( &this -> company_name, company_name );
}

void account::setCountry( const char* country)
{
    setValue( &this -> country, country );
}

void account::setZipcode( const char* zipcode)
{
    setValue( &this -> zipcode, zipcode );
}

void account::setFax( const char* fax)
{
    setValue( &this -> fax, fax );
}

void account::setNoticeMail(int noticeMail){ this -> noticeMail = noticeMail; }

void account::setNoticeMailSince(time_t noticeMailSince){ this -> noticeMailSince = noticeMailSince; }

void account::setPrivateIndexID(int xid){ this -> privateIndexID = xid; }

void account::setItemNumberLimit( int x ){ itemNumberLimit = x; }

void account::setIndexNumberLimit( int x ){ indexNumberLimit = x; }

void account::setItemStorageLimit( double x ){ itemStorageLimit = x; }

// xoops_user
void account::setUname( const char* uname )
{
    setValue( &this -> uname, uname );
}

void account::setName( const char* name )
{
    setValue( &this -> name, name );
}

void account::setEmail( const char* email )
{
    setValue( &this -> email, email );
}

void account::setURL( const char* url )
{
    setValue( &this -> url, url );
}

void account::setUserAvatar( const char* user_avatar )
{
    setValue( &this -> user_avatar, user_avatar );
}

void account::setUserRegdate( int user_regdate ){ this -> user_regdate = user_regdate; }

void account::setUserIcq( const char* user_icq )
{
    setValue( &this -> user_icq, user_icq );
}

void account::setUserFrom( const char* user_from )
{
    setValue( &this -> user_from, user_from );
}

void account::setUserSig( const char* user_sig )
{
    setValue( &this -> user_sig, user_sig );
}

void account::setUserViewemail( int user_viewemail ){ this -> user_viewemail = user_viewemail; }

void account::setActkey( const char* actkey )
{
    setValue( &this -> actkey, actkey );
}

void account::setUserAim( const char* user_aim )
{
    setValue( &this -> user_aim, user_aim );
}

void account::setUserYim( const char* user_yim )
{
    setValue( &this -> user_yim, user_yim );
}

void account::setUserMsnm( const char* user_msnm )
{
    setValue( &this -> user_msnm, user_msnm );
}


void account::setPass( const char* pass )
{
    setValue( &this -> pass, pass );
}

void account::setPosts( int posts ){ this -> posts = posts; }

void account::setAttachsig( int attachsig ){ this -> attachsig = attachsig; }

void account::setRank( int rank ){ this -> rank = rank; }

void account::setLevel( int level ){ this -> level = level; }

void account::setTheme( const char* theme )
{
    setValue( &this -> theme, theme );
}

void account::setTimezoneOffset( double timezone_offset ){ this -> timezone_offset = timezone_offset; }

void account::setLastLogin( int last_login ){ this -> last_login = last_login; }

void account::setUmode( const char* umode )
{
    setValue( &this -> umode, umode );
}

void account::setUorder( int uorder ){ this -> uorder = uorder; }

void account::setNotifyMethod( int notify_method ){ this -> notify_method = notify_method; }

void account::setNotifyMode( int notify_mode ){ this -> notify_mode = notify_mode; }

void account::setUserOcc( const char* user_occ )
{
    setValue( &this -> user_occ, user_occ );
}


void account::setBio( const char* bio )
{
    setValue( &this -> bio, bio );
}

void account::setUserIntrest( const char* user_intrest )
{
    setValue( &this->user_intrest, user_intrest );
}

void account::setUserMailok( int user_mailok ){ this -> user_mailok = user_mailok; }





