/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * XOOPS&Platform桼ΤΥ饹
 * 
 * $Revision: 1.11 $
 * $Log: account.h,v $
 * Revision 1.11  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.10  2005/02/25 07:00:37  tani
 * item_number_limit, index_number_limit, item_storage_limitɲ.
 *
 * Revision 1.9  2005/02/09 07:23:50  aga
 * URL to My Personal Archive DBALä.
 *
 * Revision 1.8  2005/01/22 00:18:33  aga
 * indexID  unsigned ˤ.
 *
 * Revision 1.7  2005/01/19 10:06:19  aga
 * account::UID_GUEST=0.
 *
 * Revision 1.6  2005/01/15 05:31:16  youi
 * userid_tȤä.
 *
 * Revision 1.5  2005/01/14 10:33:37  aga
 * int privateIndexIDɲ.
 *
 * Revision 1.4  2004/12/01 10:28:58  youi
 * DB̾ѹȼ
 *     institute -> division
 *     organizaion -> company_name
 *
 * Revision 1.3  2004/11/25 08:57:15  youi
 * getϴؿconst.
 * 
 * Revision 1.2  2004/11/25 04:11:43  youi
 * typedefɲ.
 * 
 * Revision 1.1  2004/11/22 08:25:16  youi
 * initial version.
 *
 * 
 */
#if !defined( ACCOUNT_H )
#define ACCOUNT_H

/*
 * Visiome Platform Abstract Layer 
 * Account饹
 * 
 * 
 */

typedef unsigned int userid_t;
class account{
private:
    userid_t uid;	//< 桼
    bool activate;	//< ǥ졼ˤ뾵ǧե饰
    char* address;	//< 
    char* division;	//< °
    char* tel;	//< ֹ
    char* company_name;	//< ع/̾
    char* country;	//< ̾
    char* zipcode;	//< ͹ֹ
    char* fax;	//< եåֹ
    int noticeMail;	//< 奢ƥΥ᡼ֳ
    time_t noticeMailSince;	//< 奢ƥΥ᡼ֳϿ
    unsigned int privateIndexID; //private indexID
    int itemNumberLimit;
    int indexNumberLimit;
    double itemStorageLimit;
    
    char* uname;
    char* name;
    char* email;
    char* url;
    char* user_avatar;
    int user_regdate;
    char* user_icq;
    char* user_from;
    char* user_sig;
    int user_viewemail;
    char* actkey;
    char* user_aim;
    char* user_yim;
    char* user_msnm;
    char* pass;
    int posts;
    int attachsig;
    int rank;
    int level;
    char* theme;
    double timezone_offset;
    int last_login;
    char* umode;
    int uorder;
    int notify_method;
    int notify_mode;
    char* user_occ;
    char* bio;
    char* user_intrest;
    int user_mailok;
    
public:
    // reserved uid
    static const userid_t UID_GUEST = 0;
    
    account();
    ~account();

    // ----
    userid_t getUID() const;
    bool getActivate() const;
    const char *getAddress() const;
    const char *getDivision() const;
    const char *getTel() const;
    const char *getCompanyName() const;
    const char *getCountry() const;
    const char *getZipcode() const;
    const char *getFax() const;
    int getNoticeMail() const;
    time_t getNoticeMailSince() const;
    int getPrivateIndexID() const;
    int getItemNumberLimit( ) const;
    int getIndexNumberLimit( ) const;
    double getItemStorageLimit( ) const;
    // ----
    const char* getUname( ) const;
    const char* getName( ) const;
    const char* getEmail( ) const;
    const char* getURL( ) const;
    const char* getUserAvatar( ) const;
    int getUserRegdate( ) const;
    const char* getUserIcq( ) const;
    const char* getUserFrom( ) const;
    const char* getUserSig( ) const;
    int getUserViewemail( ) const;
    const char* getActkey( ) const;
    const char* getUserAim( ) const;
    const char* getUserYim( ) const;
    const char* getUserMsnm( ) const;
    const char* getPass( ) const;
    int getPosts( ) const;
    int getAttachsig( ) const;
    int getRank( ) const;
    int getLevel( ) const;
    const char* getTheme( ) const;
    double getTimezoneOffset( ) const;
    int getLastLogin( ) const;
    const char* getUmode( ) const;
    int getUorder( ) const;
    int getNotifyMethod( ) const;
    int getNotifyMode( ) const;
    const char* getUserOcc( ) const;
    const char* getBio( ) const;
    const char* getUserIntrest( ) const;
    int getUserMailok( ) const;
    
    // ----
    void setUID(userid_t uid);
    void setActivate(bool activate);
    void setAddress(const char *address);
    void setDivision(const char *division);
    void setTel(const char *tel);
    void setCompanyName(const char *company_name);
    void setCountry(const char *country);
    void setZipcode(const char *zipcode);
    void setFax(const char *fax);
    void setNoticeMail(int noticeMail);
    void setNoticeMailSince( time_t noticeMailSince);
    void setPrivateIndexID(int xid);
    void setItemNumberLimit( int );
    void setIndexNumberLimit( int );
    void setItemStorageLimit( double );
    // ----
    void setUname( const char* uname );
    void setName( const char* name );
    void setEmail( const char* email );
    void setURL( const char* url );
    void setUserAvatar( const char* user_avatar );
    void setUserRegdate( int user_regdate);
    void setUserIcq( const char* user_icq );
    void setUserFrom( const char* user_from );
    void setUserSig( const char* user_sig );
    void setUserViewemail( int user_viewemail );
    void setActkey( const char* actkey );
    void setUserAim( const char* user_aim );
    void setUserYim( const char* user_yim );
    void setUserMsnm( const char* user_msnm );
    void setPass( const char* pass );
    void setPosts( int posts );
    void setAttachsig( int attachsig );
    void setRank( int rank );
    void setLevel( int level );
    void setTheme( const char* theme );
    void setTimezoneOffset( double timezone_offset );
    void setLastLogin( int last_login );
    void setUmode( const char* umode );
    void setUorder( int uorder );
    void setNotifyMethod( int notify_method );
    void setNotifyMode( int notify_mode );
    void setUserOcc( const char* user_occ );
    void setBio( const char* bio );
    void setUserIntrest( const char* user_intrest );
    void setUserMailok( int user_mailok );
};

typedef account account_t;

#endif
