/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.2 $
 */

#include "amazonbook.h"
#include "common.h"

amazonbook::amazonbook()
{
    title=0; setValue( &title, "" );
    author=0; setValue( &author, "" );
    publisher=0; setValue( &publisher, "" );
    isbn=0; setValue( &isbn, "" );
    url=0; setValue( &url, "" );
    yearOfPublication = 0;
}

amazonbook::~amazonbook()
{
    delete[] title;
    delete[] author;
    delete[] publisher;
    delete[] isbn;
    delete[] url;
}

const char* amazonbook::getTitle( ) const { return title; }
const char* amazonbook::getAuthor( ) const { return author; }
const char* amazonbook::getPublisher( ) const { return publisher; }
const char* amazonbook::getISBN( ) const { return isbn; }
const char* amazonbook::getURL( ) const { return url; }
int amazonbook::getYearOfPublication( ) const { return yearOfPublication; }

void amazonbook::setTitle( const char* x ){ setValue( &title, x ); }
void amazonbook::setAuthor( const char* x ){ setValue( &author, x ); }
void amazonbook::setPublisher( const char* x ){ setValue( &publisher, x ); }
void amazonbook::setISBN( const char* x ){ setValue( &isbn, x ); }
void amazonbook::setURL( const char* x ){ setValue( &url, x ); }
void amazonbook::setYearOfPublication( int x ){ this -> yearOfPublication = x; }
