/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * $Revision: 1.4 $
 * 
 */

#if !defined( CHANGELOG_H )
#define CHANGELOG_H

#include "common.h"
#include "item.h"

#define XNP_CHANGELOG_LOG_LEN 65535

typedef unsigned int changelogid_t;
class changelog{
private:
    changelogid_t logid;
    time_t date;
    char* log;
    itemid_t item_id;
public:
    changelog();
    changelog( changelogid_t, time_t, const char* );
    ~changelog();
    
    changelogid_t getChangelogID() const;
    time_t getDate() const;
    itemid_t getItemID() const;
    const char* getLog() const;
    
    void setChangelogID( changelogid_t );
    void setDate( time_t );
    void setItemID( itemid_t );
    void setLog( const char* );
};
typedef changelog changelog_t;

#endif
