/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * Abstract LayerγƵǽ褯Ȥؿ򤳤롥
 * 
 * $Revision: 1.7 $
 * $Log: common.cc,v $
 * Revision 1.7  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.6  2005/02/25 07:42:57  tani
 * doubleToStringɲ.
 *
 * Revision 1.5  2005/01/22 05:38:03  youi
 * md5str.
 *
 * Revision 1.4  2005/01/06 07:17:15  youi
 * VC toolkitѻsnprintf_fltusedɲ.
 *
 * Revision 1.3  2004/11/26 05:13:40  aga
 * userid_t, groupid_tunsigned int ˽.
 * unsignedIntToString().
 *
 * Revision 1.2  2004/11/26 03:29:43  aga
 * intToString().
 *
 * Revision 1.1  2004/11/22 08:25:16  youi
 * initial version.
 *
 * 
 */

#include <stdio.h>
#include <string.h>
#include "common.h"

/**
 * 
 * dataMD5ϥåͤᡤʸѴꤵ줿ʸХåե
 * str˽񤭹.
 * 
 * 
 * 
 */
char* md5str( char str[MD5_DIGEST_STRING_LENGTH], unsigned char* data, int len )
{
    MD5_CTX c;
    unsigned char buf[MD5_DIGEST_LENGTH];
    static const char hexdigit[]="0123456789abcdef";
    
    MD5_Init( &c );
    MD5_Update( &c, data, len );
    MD5_Final( buf, &c );
    
    for( int i = 0 ; i < MD5_DIGEST_LENGTH ; i++ ){
        str[i*2] = hexdigit[buf[i]>>4];
        str[i*2+1] = hexdigit[buf[i] & 0x0f];
    }
    str[MD5_DIGEST_LENGTH*2] = '\0';
    return str;
}

/**
 * 
 * Ϳ줿ʸʣΥɥ쥹֤
 * 
 * @param text 
 * @return ʣʸΥɥ쥹
 * @return 0 ʣ˼
 * 
 */
char* str_dup( const char* text )
{
    if( text == 0 ) return 0;
    char* ptr = new char[ strlen( text ) + 1 ];
    if( ptr == 0 ) return 0;
    strcpy( ptr , text );
    return ptr;
}

/**
 * 
 * newtextǻꤵ줿ʸʣΥɥ쥹*dstptr.<br>
 * 顤ޤ*dstptrȤƤΰ.<br>
 * ǼԤ*dstptrƤϽ񤭴ʤ<br>
 * newtext==0ΤȤϡ*dstptrȤΰʸ򿷵˺ƤΥɥ쥹*dstptr.<br>
 * 
 * @param newtext *dstptrʸ
 * @param dstptr ʣnewtextΥɥ쥹ݥѿؤΥݥ
 * @return dstptrɥ쥹 ԻϽdstptr
 * 
 */
char* setValue( char** dstptr, const char* newtext )
{
    char* ptr;
    
    // newtext0ʤ顤*dstptrȤΰ
    // *dstptrˤϿʸΥɥ쥹
    if( newtext == 0 ){
        ptr = str_dup( "" );
    }else{
        ptr = str_dup( newtext );
    }
    if( ptr != 0 ){
        if( *dstptr != 0 ) delete[] *dstptr;
        *dstptr = ptr;
    }
    return *dstptr;
}

/**
 * 
 * intʸѴ
 * 
 * @param i Ѵ٤
 * @return Ѵʸ
 * 
 */
string intToString( int i ){
	char buf[sizeof(int)*3+1+1+1]; // nХȤʤ3n+1ʲ1塢\01
	snprintf( buf, sizeof(buf), "%d", i );
	string s( buf );
	return s;
}

/**
 * 
 * unsigned intʸѴ
 * 
 * @param i Ѵ٤
 * @return Ѵʸ
 * 
 */
string unsignedIntToString( unsigned int i ){
	char buf[sizeof(int)*3+1+1]; // nХȤʤ3n+1ʲ\01
	snprintf( buf, sizeof(buf), "%u", i );
	string s( buf );
	return s;
}




/**
 * 
 * unsigned intʸѴ
 * 
 * @param i Ѵ٤
 * @return Ѵʸ
 * 
 */
string doubleToString( double d ){
	char buf[256];
	snprintf( buf, sizeof(buf), "%lf", d );
	string s( buf );
	return s;
}

