/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.18.4.1 $ 
 */
#if !defined( COMMON_H )
#define COMMON_H


#if defined(__BORLANDC__)
#define PROTOTYPES 1
#include "md5/global.h"
#ifdef __cplusplus
extern "C" {
#endif
#include "md5/md5.h"
#ifdef __cplusplus
}
#endif

#define MD5_Init MD5Init
#define MD5_Update MD5Update
#define MD5_Final MD5Final

#define snprintf _snprintf

#else
#include <sys/types.h>
#include <openssl/md5.h>
#endif
#include<string>

using namespace std;
typedef enum {
    RES_OK = 0,
    RES_ERROR,
    RES_DB_NOT_INITIALIZED,
    RES_LOGIN_FAILURE,
    RES_NO_SUCH_SESSION,
    RES_NO_SUCH_USER,
    RES_NO_SUCH_GROUP,
    RES_DB_QUERY_ERROR,
    RES_DB_CONNECT_ERROR,
    RES_DB_INITIALIZE_ERROR,
    RES_NO_SUCH_ITEM,
    RES_NO_WRITE_ACCESS_RIGHT,
    RES_NO_READ_ACCESS_RIGHT,
    RES_GROUPNAME_ALREADY_EXISTS,
    
    RES_PHP_NONREF=1000
} result_t;

typedef enum {
    DBTYPE_MYSQL = 1,
    DBTYPE_SQLITE = 2
} dbtype_t;

char* str_dup( const char* );
char* setValue( char** , const char* );
string intToString( int i );
string unsignedIntToString( unsigned int i );
string doubleToString( double d );

#define MD5_DIGEST_STRING_LENGTH (MD5_DIGEST_LENGTH*2+1)

char* md5str( char str[MD5_DIGEST_STRING_LENGTH], unsigned char* data, int len );

#endif


