/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * $Revision: 1.44 $ 
 */
#if !defined( COMMONAL_H )
#define COMMONAL_H

#include "common.h"
#include "session.h"
#include "account.h"
#include "group.h"
#include "item.h"
#include "changelog.h"
#include "criteria.h"
#include "item.h"
#include "index.h"
#include "changelog.h"
#include "pubmed.h"
#include "amazonbook.h"
#include "event.h"

#if defined( WIN32 )
#define EXPORTDLL extern "C" __declspec(dllexport) 
#else
#define EXPORTDLL
#endif

#define SESSION_TIMEOUT_SEC 3600 /* <-> xoonips2/xoonips/condefs.php */

#define PUBMED_EFETCH_URL_BASE "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=pubmed&retmode=xml&id="
#define PUBMED_ESEARCH_URL_BASE "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=journals&term="
#define PUBMED_ESUMMARY_URL_BASE "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/esummary.fcgi?db=journals&id="

#define ACCOUNT_UNAME_LEN 25
#define ACCOUNT_NAME_LEN 60
#define ACCOUNT_EMAIL_LEN 60
#define ACCOUNT_URL_LEN 100
#define ACCOUNT_USER_AVATAR_LEN 30
#define ACCOUNT_USER_ICQ_LEN 15
#define ACCOUNT_USER_FROM_LEN 100
#define ACCOUNT_USER_SIG_LEN 255
#define ACCOUNT_ACTKEY_LEN 8
#define ACCOUNT_USER_AIM_LEN 18
#define ACCOUNT_USER_YIM_LEN 25
#define ACCOUNT_USER_MSNM_LEN 100
#define ACCOUNT_PASS_LEN 32
#define ACCOUNT_THEME_LEN 100
#define ACCOUNT_UMODE_LEN 10
#define ACCOUNT_USER_OCC_LEN 100
#define ACCOUNT_BIO_LEN 255
#define ACCOUNT_USER_INTREST_LEN 150

//maximum length for each columns defined in DB tables 'xnpaccount_user'
#define XNP_ACCOUNT_ADDRESS_LEN 255
#define XNP_ACCOUNT_DIVISION_LEN 255
#define XNP_ACCOUNT_TEL_LEN 32
#define XNP_ACCOUNT_COMPANY_NAME_LEN 255
#define XNP_ACCOUNT_COUNTRY_LEN 255
#define XNP_ACCOUNT_ZIPCODE_LEN 32
#define XNP_ACCOUNT_FAX_LEN 32
#define XNP_ACCOUNT_BASE_URL_LEN 255

#define XNP_GROUP_GNAME_LEN 255
#define XNP_GROUP_GDESC_LEN 255

#define XNP_CONFIG_NAME_LEN 255

#define XNP_CONFIG_CERTIFY_ITEM_KEY  "certify_item"
#define XNP_CONFIG_CERTIFY_ITEM_AUTO "auto"
#define XNP_CONFIG_CERTIFY_ITEM_ON   "on"
#define XNP_CONFIG_CERTIFY_ITEM_OFF  "off"

#define XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_KEY  "public_item_target_user"
#define XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_PLATFORM  "platform"
#define XNP_CONFIG_PUBLIC_ITEM_TARGET_USER_ALL  "all"

#define XNP_CONFIG_REPOSITORY_NIJC_CODE  "repository_nijc_code"

#define XNP_PRIVATE_INDEX_TITLE "Private"

typedef enum {
    ME_CREATED = 1,
    ME_MODIFIED,
    ME_DELETED
} metadataevent_t;

//\ dateNULLȂ0
typedef struct{
    time_t createdTimestamp;
    time_t modifiedTimestamp;
    time_t deletedTimestamp;
    int isDeleted;
} itemstatus_t;

EXPORTDLL result_t initializeDB( const char* host, const char* user, const char* password, const char* dbname, const char* prefix, dbtype_t type );
EXPORTDLL result_t uninitializeDB();
EXPORTDLL bool isActivated( sessionid_t sid, userid_t uid );
EXPORTDLL result_t activate( sessionid_t sid, userid_t uid, bool activate );
EXPORTDLL int getAccountCount( sessionid_t sid );
EXPORTDLL result_t deleteAccount( sessionid_t sid, userid_t uid );
EXPORTDLL result_t getAccount( sessionid_t sid, userid_t uid, const account_t** );
EXPORTDLL result_t getAccounts( sessionid_t sid, const userid_t* uids, int uidsLen, criteria_t* cri, const account_t** accounts, int* accountsLen );
EXPORTDLL result_t insertAccount( sessionid_t sid, const account_t* account, userid_t* uid );
EXPORTDLL result_t updateAccount( sessionid_t sid, const account_t* account );
EXPORTDLL result_t dumpUids( sessionid_t sid, criteria_t* cri, userid_t** uids, int* uidsLen );
EXPORTDLL int getGroupCount( sessionid_t sid );
EXPORTDLL result_t getGroupsByUid( sessionid_t sid, userid_t uid, criteria_t* cri, groupid_t** gids, int* gidsLen );
EXPORTDLL bool isGroupAdmin( sessionid_t sid, groupid_t gid, userid_t uid );
EXPORTDLL result_t dumpGids( sessionid_t sid, criteria_t* cri, groupid_t** gids, int* gidsLen );
EXPORTDLL result_t dumpGroupAdmins( sessionid_t sid, groupid_t gid, criteria_t* cri, userid_t** uids, int* uidsLen );
EXPORTDLL result_t deleteMember( sessionid_t sid, groupid_t gid, userid_t uid );
EXPORTDLL result_t insertMember( sessionid_t sid, groupid_t gid, userid_t uid, bool admin );
EXPORTDLL result_t getMembers( sessionid_t sid, groupid_t gid, criteria_t* cri, userid_t** uids, int* uidsLen );
EXPORTDLL result_t deleteGroup( sessionid_t sid, groupid_t gid );
EXPORTDLL result_t insertGroup( sessionid_t sid, const group_t* group, groupid_t* gid );
EXPORTDLL result_t updateGroup( sessionid_t sid, const group_t* group );
EXPORTDLL result_t getGroup( sessionid_t sid, groupid_t gid, const group_t** group );
EXPORTDLL result_t getGroups( sessionid_t sid, groupid_t* gids, int gidsLen, criteria_t* cri, const group_t** groups, int* groupsLen );
EXPORTDLL bool isModerator( sessionid_t sid, userid_t uid );
EXPORTDLL result_t getUid( const char* uname, userid_t* uid );
EXPORTDLL result_t loginUser(const char* uname, const char* passwd, sessionid_t* sessions );
EXPORTDLL void logoutUser( sessionid_t sid );
EXPORTDLL result_t createSession( const char* sessionid, userid_t uid, sessionid_t* sessions );
EXPORTDLL result_t getSession( sessionid_t sess_id, const session_t** session );

EXPORTDLL result_t insertItem( sessionid_t, const item_t*, itemid_t* );
EXPORTDLL result_t insertItemDirect( sessionid_t, const item_t*, itemid_t* );
EXPORTDLL result_t getItem( sessionid_t, itemid_t, const item_t** );
EXPORTDLL result_t getItems( sessionid_t, const itemid_t*, int, criteria_t*, const item_t**, int* );
EXPORTDLL unsigned int getItemCount( sessionid_t sid );
EXPORTDLL result_t dumpItemID( sessionid_t sid, criteria_t* c, const itemid_t** iids, int* iidsLen );

EXPORTDLL result_t updateItem( sessionid_t, const item_t* );
EXPORTDLL result_t deleteItem( sessionid_t, itemid_t );

EXPORTDLL result_t getItemIDByIndexID( sessionid_t sid, indexid_t xid, criteria_t* cri, const itemid_t** iids, int* iidsLen );
EXPORTDLL result_t getUncertifiedLink( sessionid_t sid, const itemid_t** xids, const itemid_t** iids, int* iidsLen );
EXPORTDLL result_t getPrivateItemID( sessionid_t sid, userid_t uid, const itemid_t** iids, int* iidsLen );
EXPORTDLL result_t getGroupItemID( sessionid_t sid, groupid_t gid, const itemid_t** iids, int* iidsLen );

EXPORTDLL result_t getCertifyState( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t* certify );
EXPORTDLL result_t setCertifyState( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t state );
EXPORTDLL bool getCertifyPermission( sessionid_t sid, indexid_t xid, itemid_t iid, certify_t state ); 
EXPORTDLL result_t getOverlappedItems( sessionid_t sid, indexid_t xid, item_t* item, itemid_t** iids, int* iidsLen );
EXPORTDLL result_t registerItem( sessionid_t sid, indexid_t xid, itemid_t iid );
EXPORTDLL result_t unregisterItem( sessionid_t sid, indexid_t xid, itemid_t iid );

EXPORTDLL bool getItemPermission( sessionid_t sid, itemid_t iid, itemop_t op );
EXPORTDLL bool getIndexPermission( sessionid_t sid, indexid_t xid, indexop_t op );

EXPORTDLL bool isValidSessionID( sessionid_t sess_id );

EXPORTDLL result_t getAllIndexes( sessionid_t sess_id, criteria_t *cri, const index_t **indexes, int *indexesLen );
EXPORTDLL result_t getIndexes( sessionid_t sid, indexid_t parentXID, criteria_t *cri, const index_t **indexes, int *indexesLen );
EXPORTDLL result_t insertIndex( sessionid_t sid, index_t *index, indexid_t *xid );
EXPORTDLL result_t updateIndex( sessionid_t sid,  index_t *index );
EXPORTDLL result_t deleteIndex( sessionid_t sid,  indexid_t xid);
EXPORTDLL result_t getIndex( sessionid_t sid,  indexid_t xid, const index_t **index );
EXPORTDLL bool isIndexReadable( sessionid_t sid,  indexid_t xid );
EXPORTDLL bool isIndexWritable( sessionid_t sid,  indexid_t xid );
EXPORTDLL result_t swapIndexSortNumber( sessionid_t sid, indexid_t xid1, indexid_t xid2 );

EXPORTDLL result_t getConfigValue( const char* key, char** value );
EXPORTDLL result_t setConfigValue( const char* key, const char* value );

EXPORTDLL result_t pubmedComplete( pubmedid_t pmid, const pubmed_t** pubmed );
EXPORTDLL result_t amazonComplete( const char* url, const amazonbook_t** pubmed );

EXPORTDLL void freeAccount( const account_t* );
EXPORTDLL void freeGroup( const group_t* );
EXPORTDLL void freeSession( const session_t* );
EXPORTDLL void freeUID( const userid_t* );
EXPORTDLL void freeGID( const groupid_t* );
EXPORTDLL void freeItem( const item_t* );
EXPORTDLL void freeItemType( const itemtype_t* );
EXPORTDLL void freeItemID( const itemid_t* );
EXPORTDLL void freeIndex( const index_t* ptr );
EXPORTDLL void freeIndexID( const indexid_t* ptr );
EXPORTDLL void freeString( char* ptr );
EXPORTDLL void freeStringArray( char** strs, int len );
EXPORTDLL void freeChangeLog( const changelog_t* ptr );
EXPORTDLL void freePubmed( const pubmed_t* ptr );
EXPORTDLL void freeInt( const int* );

EXPORTDLL const char* getLastErrorString();

EXPORTDLL result_t getChangeLogs( sessionid_t sid, itemid_t itemid, const changelog_t** logs, int* logsLen );
EXPORTDLL result_t insertChangeLog( sessionid_t sid, itemid_t itemid, const char* log );

EXPORTDLL result_t getItemIDByBinderID( sessionid_t sid, itemid_t binderid, criteria_t* cri, const itemid_t** iids, int* iidsLen );
EXPORTDLL result_t registerBinderItem( sessionid_t sid, itemid_t binderid, itemid_t iid );
EXPORTDLL result_t unregisterBinderItem( sessionid_t sid, itemid_t binderid, itemid_t iid );

EXPORTDLL result_t getItemTypes( const itemtype_t** types, int* len );

EXPORTDLL result_t getIndexIDByItemID( sessionid_t sid, itemid_t itemid, const indexid_t**, int* );
EXPORTDLL result_t getOwnPublicItemID( sessionid_t sid, userid_t uid, const itemid_t** iids, int* iidsLen );

EXPORTDLL result_t getItemCountGroupByIndex( sessionid_t sid, indexid_t **xids, int *xidsLen, int **counts );
EXPORTDLL result_t zipCreate( char* zippath, char** files, int filesLen );

EXPORTDLL result_t extractPublicItemId(sessionid_t sid, const itemid_t* iids, int iidsLen, itemid_t **pubilcIids, int* publicIidsLen );
EXPORTDLL result_t extractNonbinderItemId(sessionid_t sid, const itemid_t* iids, int iidsLen, itemid_t **nonbinderIids, int* nonbinderIidsLen );
EXPORTDLL result_t insertEvent( sessionid_t sid, event_t *ev);
EXPORTDLL result_t getEvents( sessionid_t sid, event_t** events, int* eventsLen, time_t startTime, time_t endTime );
EXPORTDLL result_t getEventsForRSS(sessionid_t sid, event_t** events, int* eventsLen, int max );
EXPORTDLL bool isAdmin( userid_t );
EXPORTDLL result_t updateItemStatus();
EXPORTDLL result_t refreshItemStatus();
EXPORTDLL result_t selectiveHarvesting( time_t from, time_t until, int startIID, int limit, char ***iids, int *iidsLen );
EXPORTDLL result_t getMetadataEvent( itemid_t iid, itemstatus_t *status );

EXPORTDLL void useSyslog( bool useSyslogFlag );

EXPORTDLL result_t insertRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t itemid );
EXPORTDLL result_t deleteRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t itemid );
EXPORTDLL result_t getRelatedTo( sessionid_t sid, itemid_t parentid, itemid_t** itemids, int* itemidsLen );


#endif
