/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ٥ȥѥ饹
 * 
 * $Revision: 1.3.4.1 $
 */

#include <time.h>
#include <string.h>

#include "common.h"
#include "event.h"

const int event::validFields[][10] =
{
    // timestamp, exec_uid, remote_host, index_id, file_id, uid, gid, search_keyword, additional_info
        { 0,0,0,0,0,0,0,0,0,0}, //(dummy)
        { 1,1,1,0,0,0,0,0,0,1}, //LOGIN_FAILURE         
        { 1,1,1,0,0,0,0,0,0,0}, //LOGIN_SUCCESS         
        { 1,1,1,0,0,0,0,0,0,0}, //LOGOUT                
        { 1,1,1,0,1,0,0,0,0,0}, //INSERT_ITEM           
        { 1,1,1,0,1,0,0,0,0,0}, //UPDATE_ITEM           
        { 1,1,1,0,1,0,0,0,0,0}, //DELETE_ITEM           
        { 1,1,1,0,1,0,0,0,0,0}, //VIEW_ITEM             
        { 1,1,1,0,1,1,0,0,0,0}, //DOWNLOAD_FILE         
        { 1,1,1,1,1,0,0,0,0,0}, //REQUEST_CERTIFY_ITEM  
        { 1,1,1,1,0,0,0,0,0,0}, //INSERT_INDEX          
        { 1,1,1,1,0,0,0,0,0,0}, //UPDATE_INDEX          
        { 1,1,1,1,0,0,0,0,0,0}, //DELETE_INDEX          
        { 1,1,1,1,1,0,0,0,0,0}, //CERTIFY_ITEM          
        { 1,1,1,1,1,0,0,0,0,0}, //REJECT_ITEM           
        { 1,0,1,0,0,0,1,0,0,0}, //REQUEST_INSERT_ACCOUNT
        { 1,1,1,0,0,0,1,0,0,0}, //CERTIFY_ACCOUNT       
        { 1,1,1,0,0,0,0,1,0,0}, //INSERT_GROUP          
        { 1,1,1,0,0,0,0,1,0,0}, //UPDATE_GROUP          
        { 1,1,1,0,0,0,0,1,0,0}, //DELETE_GROUP          
        { 1,1,1,0,0,0,1,1,0,0}, //INSERT_GROUP_MEMBER   
        { 1,1,1,0,0,0,1,1,0,0}, //DELETE_GROUP_MEMBER   
        { 1,1,1,0,0,0,0,0,0,0}, //VIEW_TOP_PAGE         
        { 1,1,1,0,0,0,0,0,1,0}, //QUICK_SEARCH          
        { 1,1,1,0,0,0,0,0,1,0}  //ADVANCED_SEARCH       
};

event::event()
{
    eventID       = 0;
    eventTypeID   = ETID_INVALID_ETID;
    timestamp     = 0;
    execUID       = 0;
    indexID       = 0;
    itemID        = 0;
    fileID        = 0;
    uid           = 0;
    gid           = 0;
    remoteHost    = 0; setValue( &this -> remoteHost    , "" );
    searchKeyword = 0; setValue( &this -> searchKeyword , "" );
    additionalInfo= 0; setValue( &this -> additionalInfo, "" );
}

event::~event(){
    if ( remoteHost    != 0 ) delete[] remoteHost    ;
    if ( searchKeyword != 0 ) delete[] searchKeyword ;
    if ( additionalInfo!= 0 ) delete[] additionalInfo;

}

eventid_t     event::getEventID       () const { return eventID       ; }
eventtypeid_t event::getEventTypeID   () const { return eventTypeID   ; }
time_t        event::getTimestamp     () const { return timestamp     ; }
userid_t      event::getExecUID       () const { return execUID       ; }
indexid_t     event::getIndexID       () const { return indexID       ; }
itemid_t      event::getItemID        () const { return itemID        ; }
fileid_t      event::getFileID        () const { return fileID        ; }
userid_t      event::getUID           () const { return uid           ; }
groupid_t     event::getGID           () const { return gid           ; }
const char*   event::getRemoteHost    () const { return remoteHost    ; }
const char*   event::getSearchKeyword () const { return searchKeyword ; }
const char*   event::getAdditionalInfo() const { return additionalInfo; }

void event::setEventID       ( eventid_t     x ) { eventID     = x; }
void event::setEventTypeID   ( eventtypeid_t x ) { if ( ETID_INVALID_ETID < x && x <= ETID_MAX ) eventTypeID     = x;}
void event::setTimestamp     ( time_t        x ) { timestamp   = x; }
void event::setExecUID       ( userid_t      x ) { execUID     = x; }
void event::setIndexID       ( indexid_t     x ) { indexID     = x; }
void event::setItemID        ( itemid_t      x ) { itemID      = x; }
void event::setFileID        ( fileid_t      x ) { fileID      = x; }
void event::setUID           ( userid_t      x ) { uid         = x; }
void event::setGID           ( groupid_t     x ) { gid         = x; }
void event::setRemoteHost    ( const char*   x ) { setValue( &this -> remoteHost    , x ); }
void event::setSearchKeyword ( const char*   x ) { setValue( &this -> searchKeyword , x ); }
void event::setAdditionalInfo( const char*   x ) { setValue( &this -> additionalInfo, x ); }

bool event::isValidTimestamp     () const { return (bool)validFields[eventTypeID][0]; }
bool event::isValidExecUID       () const { return (bool)validFields[eventTypeID][1]; }
bool event::isValidIndexID       () const { return (bool)validFields[eventTypeID][3]; }
bool event::isValidItemID        () const { return (bool)validFields[eventTypeID][4]; }
bool event::isValidFileID        () const { return (bool)validFields[eventTypeID][5]; }
bool event::isValidUID           () const { return (bool)validFields[eventTypeID][6]; }
bool event::isValidGID           () const { return (bool)validFields[eventTypeID][7]; }
bool event::isValidRemoteHost    () const { return (bool)validFields[eventTypeID][2]; }
bool event::isValidSearchKeyword () const { return (bool)validFields[eventTypeID][8]; }
bool event::isValidAdditionalInfo() const { return (bool)validFields[eventTypeID][9]; }

