/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ٥ȥѥ饹
 * 
 * $Revision: 1.2 $
 */

#if !defined( EVENT_H )
#define EVENT_H

#include "common.h"
#include "account.h"
#include "group.h"
#include "item.h"
#include "index.h"

typedef unsigned int eventid_t;
typedef unsigned int eventtypeid_t;
typedef unsigned int fileid_t;

class event {
private:
    eventid_t     eventID       ;
    eventtypeid_t eventTypeID   ;
    time_t        timestamp     ;
    userid_t      execUID       ;
    indexid_t     indexID       ;
    itemid_t      itemID        ;
    fileid_t      fileID        ;
    userid_t      uid           ;
    groupid_t     gid           ;
    char*         remoteHost    ;
    char*         searchKeyword ;
    char*         additionalInfo;
    const static int validFields[][10];
public:
    const static eventtypeid_t ETID_INVALID_ETID           =  0;
    const static eventtypeid_t ETID_LOGIN_FAILURE          =  1;
    const static eventtypeid_t ETID_LOGIN_SUCCESS          =  2;
    const static eventtypeid_t ETID_LOGOUT                 =  3;
    const static eventtypeid_t ETID_INSERT_ITEM            =  4;
    const static eventtypeid_t ETID_UPDATE_ITEM            =  5;
    const static eventtypeid_t ETID_DELETE_ITEM            =  6;
    const static eventtypeid_t ETID_VIEW_ITEM              =  7;
    const static eventtypeid_t ETID_DOWNLOAD_FILE          =  8;
    const static eventtypeid_t ETID_REQUEST_CERTIFY_ITEM   =  9;
    const static eventtypeid_t ETID_INSERT_INDEX           = 10;
    const static eventtypeid_t ETID_UPDATE_INDEX           = 11;
    const static eventtypeid_t ETID_DELETE_INDEX           = 12;
    const static eventtypeid_t ETID_CERTIFY_ITEM           = 13;
    const static eventtypeid_t ETID_REJECT_ITEM            = 14;
    const static eventtypeid_t ETID_REQUEST_INSERT_ACCOUNT = 15;
    const static eventtypeid_t ETID_CERTIFY_ACCOUNT        = 16;
    const static eventtypeid_t ETID_INSERT_GROUP           = 17;
    const static eventtypeid_t ETID_UPDATE_GROUP           = 18;
    const static eventtypeid_t ETID_DELETE_GROUP           = 19;
    const static eventtypeid_t ETID_INSERT_GROUP_MEMBER    = 20;
    const static eventtypeid_t ETID_DELETE_GROUP_MEMBER    = 21;
    const static eventtypeid_t ETID_VIEW_TOP_PAGE          = 22;
    const static eventtypeid_t ETID_QUICK_SEARCH           = 23;
    const static eventtypeid_t ETID_ADVANCED_SEARCH        = 24;
    const static eventtypeid_t ETID_MAX                    = 24;
    
    event();
    ~event();
    
    eventid_t     getEventID       () const;
    eventtypeid_t getEventTypeID   () const;
    time_t        getTimestamp     () const;
    userid_t      getExecUID       () const;
    indexid_t     getIndexID       () const;
    itemid_t      getItemID        () const;
    fileid_t      getFileID        () const;
    userid_t      getUID           () const;
    groupid_t     getGID           () const;
    const char*   getRemoteHost    () const;
    const char*   getSearchKeyword () const;
    const char*   getAdditionalInfo() const;
    
    void setEventID       ( eventid_t     x );
    void setEventTypeID   ( eventtypeid_t x );
    void setTimestamp     ( time_t        x );
    void setExecUID       ( userid_t      x );
    void setIndexID       ( indexid_t     x );
    void setItemID        ( itemid_t      x );
    void setFileID        ( fileid_t      x );
    void setUID           ( userid_t      x );
    void setGID           ( groupid_t     x );
    void setRemoteHost    ( const char*   x );
    void setSearchKeyword ( const char*   x );
    void setAdditionalInfo( const char*   x );
    
    // eventTypeID򸫤ơƥबNULLɤ֤
    bool isValidTimestamp     () const;
    bool isValidExecUID       () const;
    bool isValidIndexID       () const;
    bool isValidItemID        () const;
    bool isValidFileID        () const;
    bool isValidUID           () const;
    bool isValidGID           () const;
    bool isValidRemoteHost    () const;
    bool isValidSearchKeyword () const;
    bool isValidAdditionalInfo() const;
};

typedef class event event_t;

#endif
