/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * Platform롼״ΤΥ饹
 * 
 * $Revision: 1.9 $
 * $Log: group.h,v $
 * Revision 1.9  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.8  2005/02/25 07:00:37  tani
 * item_number_limit, index_number_limit, item_storage_limitɲ.
 *
 * Revision 1.7  2005/02/03 12:03:10  youi
 * Υǡ.
 *
 * Revision 1.6  2005/01/22 00:18:33  aga
 * indexID  unsigned ˤ.
 *
 * Revision 1.5  2005/01/15 05:31:43  youi
 * groupid_tȤä.
 *
 * Revision 1.4  2005/01/14 10:33:53  aga
 * int groupIndexIDɲ.
 *
 * Revision 1.3  2004/11/30 02:29:54  aga
 * getXxxx()constˤ.
 *
 * Revision 1.2  2004/11/25 04:12:14  youi
 * typedefɲ.
 *
 * Revision 1.1  2004/11/22 08:25:16  youi
 * initial version.
 *
 * 
 */
#if !defined( GROUP_H )
#define GROUP_H

typedef unsigned int groupid_t;
class group{
private:
    groupid_t gid;	//롼ץ
    char* gname;	//롼̾
    char* desc;	//롼פ
    unsigned int groupIndexID; 
    int itemNumberLimit;
    int indexNumberLimit;
    double itemStorageLimit;
public:
    const static groupid_t GID_DEFAULT = 1;
    
    group();
    group( groupid_t gid, const char* gname, const char* desc );
    ~group();

    groupid_t getGID() const;
    const char *getGname() const;
    const char *getDesc() const;
    int getGroupIndexID() const;
    int getItemNumberLimit( ) const;
    int getIndexNumberLimit( ) const;
    double getItemStorageLimit( ) const;

    void setGID( groupid_t gid );
    void setGname( const char *gname );
    void setDesc( const char *desc );
    void setGroupIndexID( int xid );
    void setItemNumberLimit( int );
    void setIndexNumberLimit( int );
    void setItemStorageLimit( double );
};

typedef group group_t;

#endif
