/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ǥåɴѥ饹
 * 
 * $Revision $
 * 
 */


#include <time.h>
#include "index.h"

index::index()
{
    parentXID = 0;
    ownerUID = 0;
    ownerGID = 0;
    openLevel = 0;
    sortNumber = 0;
}

index::~index(){}


indexid_t index::getIndexID() const { return getItemID(); }
indexid_t index::getParentIndexID() const { return parentXID; }
unsigned int index::getOwnerUID() const { return ownerUID; }
unsigned int index::getOwnerGID() const { return ownerGID; }
openlevel_t index::getOpenLevel() const { return openLevel; }
unsigned int index::getSortNumber() const { return sortNumber; }

bool index::isPublic() const { return openLevel == OL_PUBLIC; }
bool index::isGroupOnly() const { return openLevel == OL_GROUP_ONLY; }
bool index::isPrivate() const { return openLevel == OL_PRIVATE; }

void index::setIndexID(indexid_t indexID_){ setItemID( indexID_ ); }
void index::setParentIndexID(indexid_t parentXID_){ parentXID = parentXID_; }
void index::setOwnerUID(unsigned int ownerUID_){ ownerUID = ownerUID_; }
void index::setOwnerGID(unsigned int ownerGID_){ ownerGID = ownerGID_; }
void index::setOpenLevel(openlevel_t openLevel_){ openLevel = openLevel_; }
void index::setSortNumber(unsigned int sortNumber_){ sortNumber = sortNumber_; }


