/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * ƥ(BasicInformation)ѥ饹
 * 
 * $Revision: 1.9 $
 */

#include <stdlib.h>
#include <time.h>

#include "item.h"
#include "common.h"

item::item()
{
    iid = 0;
    itemTypeID = 0;
    contributorUID = 0;
    title = 0; setValue( &title, "" );
    keywords = 0; setValue( &keywords, "" );
    description = 0; setValue( &description, "" );
    doi = 0; setValue( &doi, "" );
    strncpy( ( char* )lang, "eng", XNP_ITEM_LANG_LEN + 1);
    lastUpdateDate = 0;
    creationDate = 0;
}

item::~item()
{
    if( title != 0 ) delete[] title;
    if( keywords != 0 ) delete[] keywords;
    if( description != 0 ) delete[] description;
    if( doi != 0 ) delete[] doi;
}

itemid_t item::getItemID() const { return iid; }
itemtypeid_t item::getItemTypeID() const { return itemTypeID; }
userid_t item::getContributorUID() const { return contributorUID; }
const char *item::getTitle() const { return title; }
const char *item::getKeywords() const { return keywords; }
const char *item::getDescription() const { return description; }
const char* item::getDOI() const { return doi; }
time_t item::getLastUpdateDate() const { return lastUpdateDate; }
time_t item::getCreationDate() const { return creationDate; }
unsigned int item::getPublicationYear() const { return publicationYear; }
unsigned int item::getPublicationMonth() const { return publicationMonth; }
unsigned int item::getPublicationMday() const { return publicationMday; }
const char* item::getLang() const { return lang; }

void item::setItemID(itemid_t iid_){ iid = iid_; }
void item::setItemTypeID(itemtypeid_t itemTypeID_){ itemTypeID = itemTypeID_; }
void item::setContributorUID(userid_t contributorUID_){ contributorUID = contributorUID_; }
void item::setTitle(const char* title_){ setValue( &this -> title, title_ ); }
void item::setKeywords(const char* keywords_){ setValue( &this -> keywords, keywords_ ); }
void item::setDescription(const char* description_){ setValue( &this -> description, description_ ); }
void item::setDOI( const char* doi_ ){ setValue( &this -> doi, doi_ ); }
void item::setLastUpdateDate(time_t lastUpdateDate_){ lastUpdateDate = lastUpdateDate_; }
void item::setCreationDate(time_t creationDate_){ creationDate = creationDate_; }
void item::setPublicationYear(unsigned int publicationYear_){ publicationYear = publicationYear_; }
void item::setPublicationMonth(unsigned int publicationMonth_){ publicationMonth = publicationMonth_; }
void item::setPublicationMday(unsigned int publicationMday_){ publicationMday = publicationMday_; }
void item::setLang( const char* lang_ ){ strncpy( ( char* )lang, lang_, XNP_ITEM_LANG_LEN + 1 ); lang[ XNP_ITEM_LANG_LEN ] = '\0'; }
