/*
 * --------------------------------------------------------------------------  
 * XooNiPs Xoops modules for Neuroinformatics Platforms                        
 * Copyright (C) 2005 RIKEN, Japan. All rights reserved.                       
 * http://sourceforge.jp/projects/xoonips/                                     
 * --------------------------------------------------------------------------  
 * This program is free software; you can redistribute it and/or               
 * modify it under the terms of the GNU General Public License                 
 * as published by the Free Software Foundation; either version 2              
 * of the License, or (at your option) any later version.                      
 *                                                                             
 * This program is distributed in the hope that it will be useful,             
 * but WITHOUT ANY WARRANTY; without even the implied warranty of              
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               
 * GNU General Public License for more details.                                
 *                                                                             
 * You should have received a copy of the GNU General Public License           
 * along with this program; if not, write to the Free Software                 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
 * --------------------------------------------------------------------------  
 * 
 * 
 * $Revision: 1.4 $
 * $Log: itemtype.cc,v $
 * Revision 1.4  2005/05/18 10:00:17  aga4096
 * ⥸塼б.
 *
 * Revision 1.3  2005/03/15 04:49:40  tani
 * 饤ʸɲ.
 *
 * Revision 1.2  2005/01/24 10:51:11  youi
 * ⥸塼IDƥॿɽ̾ΰɲä.
 *
 * Revision 1.1  2005/01/14 04:28:07  youi
 * initial version
 *
 * 
 */
#include <string.h>

#include "common.h"
#include "itemtype.h"


itemtype::itemtype()
{
    item_type_id = 0;
    mid = 0;
    memset( name, '\0', XNP_ITEMTYPE_NAME_LEN + 1 );
    memset( display_name, '\0', XNP_ITEMTYPE_DISPLAY_NAME_LEN + 1 );
    memset( viewphp, '\0', XNP_ITEMTYPE_VIEWPHP_LEN + 1 );
}

itemtype::~itemtype(){}

itemtypeid_t itemtype::getItemTypeID() const { return item_type_id; }
const char* itemtype::getName() const { return name; }
const char* itemtype::getDisplayName() const { return display_name; }
const char* itemtype::getViewphp() const { return viewphp; }
itemtypeid_t itemtype::getModuleID() const { return mid; }

void itemtype::setItemTypeID( itemtypeid_t x ){ this -> item_type_id = x; }
void itemtype::setName( const char* x )
{
    strncpy( this -> name, x, XNP_ITEMTYPE_NAME_LEN );
    this -> name[ XNP_ITEMTYPE_NAME_LEN ] = '\0';
}
void itemtype::setDisplayName( const char* x )
{
    strncpy( this -> display_name, x, XNP_ITEMTYPE_DISPLAY_NAME_LEN );
    this -> display_name[ XNP_ITEMTYPE_DISPLAY_NAME_LEN ] = '\0';
}
void itemtype::setViewphp( const char* x )
{
    strncpy( this -> viewphp, x, XNP_ITEMTYPE_VIEWPHP_LEN );
    this -> viewphp[ XNP_ITEMTYPE_VIEWPHP_LEN ] = '\0';
}
void itemtype::setModuleID( unsigned int x ){ this -> mid = x; }
